/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.workspace;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.FeatureState;
import org.rust.cargo.project.workspace.PackageFeature;
import org.rust.cargo.project.workspace.PackageOrigin;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"Lorg/rust/cargo/project/workspace/MissingCargoFeaturesUtil;", "", "<init>", "()V", "collectMissingFeatureForTarget", "", "Lorg/rust/cargo/project/workspace/PackageFeature;", "target", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "collectMissingFeaturesForPackage", "", "pkg", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "missingFeatures", "", "intellij.rustrover.core"})
public final class MissingCargoFeaturesUtil {
    @NotNull
    public static final MissingCargoFeaturesUtil INSTANCE = new MissingCargoFeaturesUtil();

    private MissingCargoFeaturesUtil() {
    }

    @NotNull
    public final Set<PackageFeature> collectMissingFeatureForTarget(@NotNull CargoWorkspace.Target target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Set missingFeatures = new LinkedHashSet();
        this.collectMissingFeaturesForPackage(target.getPkg(), missingFeatures);
        CargoWorkspace.Target libTarget = target.getPkg().getLibTarget();
        if (libTarget != null && !Intrinsics.areEqual((Object)target, (Object)libTarget)) {
            for (String requiredFeature : target.getRequiredFeatures()) {
                if (target.getPkg().getFeatureState().get(requiredFeature) != FeatureState.Disabled) continue;
                ((Collection)missingFeatures).add(new PackageFeature(target.getPkg(), requiredFeature));
            }
        }
        return missingFeatures;
    }

    private final void collectMissingFeaturesForPackage(CargoWorkspace.Package pkg, Set<PackageFeature> missingFeatures) {
        for (CargoWorkspace.Dependency dep : pkg.getDependencies()) {
            if (dep.getPkg().getOrigin() != PackageOrigin.WORKSPACE) continue;
            for (String requiredFeature : dep.getRequiredFeatures()) {
                if (dep.getPkg().getFeatureState().get(requiredFeature) != FeatureState.Disabled) continue;
                ((Collection)missingFeatures).add(new PackageFeature(dep.getPkg(), requiredFeature));
            }
        }
    }

    @NotNull
    public final Set<PackageFeature> collectMissingFeaturesForPackage(@NotNull CargoWorkspace.Package pkg) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Set missingFeatures = new LinkedHashSet();
        this.collectMissingFeaturesForPackage(pkg, missingFeatures);
        return missingFeatures;
    }
}

