/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.workspace;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.workspace.FeatureState;
import org.rust.cargo.project.workspace.PackageFeature;
import org.rust.lang.utils.Edge;
import org.rust.lang.utils.Node;
import org.rust.lang.utils.PresentableGraph;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015BE\b\u0002\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\tj\u0002`\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ7\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u001b\u0010\u0010\u001a\u0017\u0012\b\u0012\u00060\u0012R\u00020\u0000\u0012\u0004\u0012\u00020\u00050\u0011\u00a2\u0006\u0002\b\u0013R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\tj\u0002`\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/rust/cargo/project/workspace/FeatureGraph;", "", "graph", "Lorg/rust/lang/utils/PresentableGraph;", "Lorg/rust/cargo/project/workspace/PackageFeature;", "", "Lorg/rust/cargo/project/workspace/FeaturesGraphInner;", "featureToNode", "", "Lorg/rust/lang/utils/Node;", "Lorg/rust/cargo/project/workspace/FeatureNode;", "<init>", "(Lorg/rust/lang/utils/PresentableGraph;Ljava/util/Map;)V", "apply", "Lorg/rust/cargo/project/workspace/FeatureState;", "defaultState", "f", "Lkotlin/Function1;", "Lorg/rust/cargo/project/workspace/FeatureGraph$FeaturesView;", "Lkotlin/ExtensionFunctionType;", "FeaturesView", "Companion", "intellij.rustrover.core"})
public final class FeatureGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PresentableGraph<PackageFeature, Unit> graph;
    @NotNull
    private final Map<PackageFeature, Node<PackageFeature, Unit>> featureToNode;

    private FeatureGraph(PresentableGraph<PackageFeature, Unit> graph, Map<PackageFeature, Node<PackageFeature, Unit>> featureToNode) {
        this.graph = graph;
        this.featureToNode = featureToNode;
    }

    @NotNull
    public final Map<PackageFeature, FeatureState> apply(@NotNull FeatureState defaultState, @NotNull Function1<? super FeaturesView, Unit> f) {
        Intrinsics.checkNotNullParameter((Object)((Object)defaultState), (String)"defaultState");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        FeaturesView featuresView = new FeaturesView(defaultState);
        f.invoke((Object)featuresView);
        return featuresView.getState();
    }

    public /* synthetic */ FeatureGraph(PresentableGraph graph, Map featureToNode, DefaultConstructorMarker $constructor_marker) {
        this(graph, featureToNode);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/rust/cargo/project/workspace/FeatureGraph$Companion;", "", "<init>", "()V", "buildFor", "Lorg/rust/cargo/project/workspace/FeatureGraph;", "features", "", "Lorg/rust/cargo/project/workspace/PackageFeature;", "", "Empty", "getEmpty", "()Lorg/rust/cargo/project/workspace/FeatureGraph;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FeatureGraph buildFor(@NotNull Map<PackageFeature, ? extends List<PackageFeature>> features) {
            Intrinsics.checkNotNullParameter(features, (String)"features");
            PresentableGraph<PackageFeature, Unit> graph = new PresentableGraph<PackageFeature, Unit>();
            HashMap<PackageFeature, Node<PackageFeature, Unit>> featureToNode = new HashMap<PackageFeature, Node<PackageFeature, Unit>>();
            for (PackageFeature entry2 : features.keySet()) {
                org.rust.cargo.project.workspace.FeatureGraph$Companion.buildFor$addFeatureIfNeeded(featureToNode, graph, entry2);
            }
            for (Map.Entry entry2 : features.entrySet()) {
                PackageFeature feature = (PackageFeature)entry2.getKey();
                List dependencies = (List)entry2.getValue();
                if (featureToNode.get(feature) == null) {
                    if (!UtilsKt.isUnitTestMode()) continue;
                    throw new IllegalStateException(("Unknown feature " + feature).toString());
                }
                for (PackageFeature dependency : dependencies) {
                    Node<PackageFeature, Unit> targetNode;
                    Node<PackageFeature, Unit> sourceNode;
                    if (featureToNode.get(dependency) == null) {
                        if (!UtilsKt.isUnitTestMode()) continue;
                        throw new IllegalStateException(("Unknown feature " + dependency + " (dependency of " + feature + ")").toString());
                    }
                    graph.addEdge(sourceNode, targetNode, Unit.INSTANCE);
                }
            }
            return new FeatureGraph(graph, featureToNode, null);
        }

        @NotNull
        public final FeatureGraph getEmpty() {
            return new FeatureGraph(new PresentableGraph(), MapsKt.emptyMap(), null);
        }

        private static final void buildFor$addFeatureIfNeeded(HashMap<PackageFeature, Node<PackageFeature, Unit>> featureToNode, PresentableGraph<PackageFeature, Unit> graph, PackageFeature feature) {
            if (((Map)featureToNode).containsKey(feature)) {
                return;
            }
            Node newNode = graph.addNode(feature);
            ((Map)featureToNode).put(feature, newNode);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eJ\u0014\u0010\u000f\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\bJ \u0010\u0013\u001a\u00020\f2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0015j\u0002`\u0016H\u0002J \u0010\u0017\u001a\u00020\f2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0015j\u0002`\u0016H\u0002R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/rust/cargo/project/workspace/FeatureGraph$FeaturesView;", "", "defaultState", "Lorg/rust/cargo/project/workspace/FeatureState;", "<init>", "(Lorg/rust/cargo/project/workspace/FeatureGraph;Lorg/rust/cargo/project/workspace/FeatureState;)V", "state", "", "Lorg/rust/cargo/project/workspace/PackageFeature;", "getState", "()Ljava/util/Map;", "enableAll", "", "features", "", "disableAll", "enable", "feature", "disable", "enableFeatureTransitively", "node", "Lorg/rust/lang/utils/Node;", "Lorg/rust/cargo/project/workspace/FeatureNode;", "disableFeatureTransitively", "intellij.rustrover.core"})
    public final class FeaturesView {
        @NotNull
        private final Map<PackageFeature, FeatureState> state;

        public FeaturesView(FeatureState defaultState) {
            Intrinsics.checkNotNullParameter((Object)((Object)defaultState), (String)"defaultState");
            this.state = new HashMap();
            for (PackageFeature feature : FeatureGraph.this.featureToNode.keySet()) {
                this.state.put(feature, defaultState);
            }
        }

        @NotNull
        public final Map<PackageFeature, FeatureState> getState() {
            return this.state;
        }

        public final void enableAll(@NotNull Iterable<PackageFeature> features) {
            Intrinsics.checkNotNullParameter(features, (String)"features");
            for (PackageFeature feature : features) {
                this.enable(feature);
            }
        }

        public final void disableAll(@NotNull Iterable<PackageFeature> features) {
            Intrinsics.checkNotNullParameter(features, (String)"features");
            for (PackageFeature feature : features) {
                this.disable(feature);
            }
        }

        public final void enable(@NotNull PackageFeature feature) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Node node = (Node)FeatureGraph.this.featureToNode.get(feature);
            if (node == null) {
                return;
            }
            Node node2 = node;
            this.enableFeatureTransitively(node2);
        }

        public final void disable(@NotNull PackageFeature feature) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Node node = (Node)FeatureGraph.this.featureToNode.get(feature);
            if (node == null) {
                return;
            }
            Node node2 = node;
            this.disableFeatureTransitively(node2);
        }

        private final void enableFeatureTransitively(Node<PackageFeature, Unit> node) {
            if (this.state.get(node.getData()) == FeatureState.Enabled) {
                return;
            }
            this.state.put(node.getData(), FeatureState.Enabled);
            for (Edge edge : FeatureGraph.this.graph.incomingEdges(node)) {
                Node<PackageFeature, Unit> dependency = edge.getSource();
                this.enableFeatureTransitively(dependency);
            }
        }

        private final void disableFeatureTransitively(Node<PackageFeature, Unit> node) {
            if (this.state.get(node.getData()) == FeatureState.Disabled) {
                return;
            }
            this.state.put(node.getData(), FeatureState.Disabled);
            for (Edge edge : FeatureGraph.this.graph.outgoingEdges(node)) {
                Node<PackageFeature, Unit> dependant = edge.getTarget();
                this.disableFeatureTransitively(dependant);
            }
        }
    }
}

