/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.workspace;

import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rust.cargo.CargoConfig;
import org.rust.cargo.CfgOptions;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.workspace.CargoWorkspaceData;
import org.rust.cargo.project.workspace.FeatureGraph;
import org.rust.cargo.project.workspace.FeatureState;
import org.rust.cargo.project.workspace.PackageFeature;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.project.workspace.StandardLibrary;
import org.rust.cargo.project.workspace.WorkspaceImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u0000 L2\u00020\u0001:\tDEFGHIJKLJ\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00162\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0016J\u001c\u0010!\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\u001f2\b\b\u0002\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\tH&J\u0010\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020\tH\u0016J$\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H&J4\u0010/\u001a\u00020\u00002*\u00100\u001a&\u0012\b\u0012\u00060\u0003j\u0002`2\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u001fj\u0002`3\u0012\u0004\u0012\u00020)0101j\u0002`4H&J\u0010\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:H'J\u0010\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=H'J\u0010\u0010>\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH&J&\u0010?\u001a\u00020\u00002\u001c\u0010@\u001a\u0018\u0012\u0004\u0012\u00020A\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u001fj\u0002`C0B01H'R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u00105\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006M\u00c0\u0006\u0001"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace;", "", "manifestPath", "Ljava/nio/file/Path;", "getManifestPath", "()Ljava/nio/file/Path;", "workspaceRootPath", "getWorkspaceRootPath", "workspaceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getWorkspaceRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "cfgOptions", "Lorg/rust/cargo/CfgOptions;", "getCfgOptions", "()Lorg/rust/cargo/CfgOptions;", "cargoConfig", "Lorg/rust/cargo/CargoConfig;", "getCargoConfig", "()Lorg/rust/cargo/CargoConfig;", "packages", "", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "getPackages", "()Ljava/util/Collection;", "featureGraph", "Lorg/rust/cargo/project/workspace/FeatureGraph;", "getFeatureGraph", "()Lorg/rust/cargo/project/workspace/FeatureGraph;", "findPackageById", "id", "", "Lorg/rust/cargo/project/workspace/PackageId;", "findPackageByName", "name", "isStd", "Lcom/intellij/util/ThreeState;", "findTargetByCrateRoot", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "root", "isCrateRoot", "", "withStdlib", "stdlib", "Lorg/rust/cargo/project/workspace/StandardLibrary;", "rustcInfo", "Lorg/rust/cargo/project/model/RustcInfo;", "withEnabledFeatures", "enabledFeatures", "", "Lorg/rust/cargo/project/workspace/PackageRoot;", "Lorg/rust/cargo/project/workspace/FeatureName;", "Lorg/rust/cargo/project/workspace/UserEnabledFeatures;", "hasStandardLibrary", "getHasStandardLibrary", "()Z", "withImplicitDependency", "pkgToAdd", "Lorg/rust/cargo/project/workspace/CargoWorkspaceData$Package;", "withEdition", "edition", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Edition;", "withCfgOptions", "withCargoFeatures", "features", "Lorg/rust/cargo/project/workspace/PackageFeature;", "", "Lorg/rust/cargo/project/workspace/FeatureDep;", "Package", "Target", "Dependency", "DepKindInfo", "DepKind", "TargetKind", "LibKind", "Edition", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoWorkspace.kt\norg/rust/cargo/project/workspace/CargoWorkspace\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,830:1\n1#2:831\n1761#3,3:832\n*S KotlinDebug\n*F\n+ 1 CargoWorkspace.kt\norg/rust/cargo/project/workspace/CargoWorkspace\n*L\n68#1:832,3\n*E\n"})
public interface CargoWorkspace {
    @NotNull
    public static final Companion Companion = org.rust.cargo.project.workspace.CargoWorkspace$Companion.$$INSTANCE;

    @NotNull
    public Path getManifestPath();

    @NotNull
    default public Path getWorkspaceRootPath() {
        Path path = this.getManifestPath().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        return path;
    }

    @Nullable
    public VirtualFile getWorkspaceRoot();

    @NotNull
    public CfgOptions getCfgOptions();

    @NotNull
    public CargoConfig getCargoConfig();

    @NotNull
    public Collection<Package> getPackages();

    @NotNull
    public FeatureGraph getFeatureGraph();

    @Nullable
    default public Package findPackageById(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.getPackages();
            for (Object t : iterable) {
                Package it2 = (Package)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    default public Package findPackageByName(@NotNull String name2, @NotNull ThreeState isStd) {
        Object v1;
        block10: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)isStd, (String)"isStd");
            Iterable iterable = this.getPackages();
            for (Object t : iterable) {
                boolean bl;
                Package it2 = (Package)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)name2) && !Intrinsics.areEqual((Object)it2.getNormName(), (Object)name2)) {
                    bl = false;
                } else {
                    switch (WhenMappings.$EnumSwitchMapping$0[isStd.ordinal()]) {
                        case 1: {
                            if (it2.getOrigin() == PackageOrigin.STDLIB) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 2: {
                            if (it2.getOrigin() == PackageOrigin.WORKSPACE || it2.getOrigin() == PackageOrigin.DEPENDENCY) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 3: {
                            bl = true;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (!bl) continue;
                v1 = t;
                break block10;
            }
            v1 = null;
        }
        return v1;
    }

    public static /* synthetic */ Package findPackageByName$default(CargoWorkspace cargoWorkspace, String string, ThreeState threeState, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPackageByName");
        }
        if ((n & 2) != 0) {
            threeState = ThreeState.UNSURE;
        }
        return cargoWorkspace.findPackageByName(string, threeState);
    }

    @Nullable
    public Target findTargetByCrateRoot(@NotNull VirtualFile var1);

    default public boolean isCrateRoot(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.findTargetByCrateRoot(root) != null;
    }

    @NotNull
    public CargoWorkspace withStdlib(@NotNull StandardLibrary var1, @NotNull CfgOptions var2, @Nullable RustcInfo var3);

    public static /* synthetic */ CargoWorkspace withStdlib$default(CargoWorkspace cargoWorkspace, StandardLibrary standardLibrary, CfgOptions cfgOptions, RustcInfo rustcInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withStdlib");
        }
        if ((n & 4) != 0) {
            rustcInfo = null;
        }
        return cargoWorkspace.withStdlib(standardLibrary, cfgOptions, rustcInfo);
    }

    @NotNull
    public CargoWorkspace withEnabledFeatures(@NotNull Map<Path, ? extends Map<String, Boolean>> var1);

    default public boolean getHasStandardLibrary() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getPackages();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Package it2 = (Package)element$iv;
                    boolean bl2 = false;
                    if (!(it2.getOrigin() == PackageOrigin.STDLIB)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @TestOnly
    @NotNull
    public CargoWorkspace withImplicitDependency(@NotNull CargoWorkspaceData.Package var1);

    @TestOnly
    @NotNull
    public CargoWorkspace withEdition(@NotNull Edition var1);

    @NotNull
    public CargoWorkspace withCfgOptions(@NotNull CfgOptions var1);

    @TestOnly
    @NotNull
    public CargoWorkspace withCargoFeatures(@NotNull Map<PackageFeature, ? extends List<String>> var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$Companion;", "", "<init>", "()V", "deserialize", "Lorg/rust/cargo/project/workspace/CargoWorkspace;", "manifestPath", "Ljava/nio/file/Path;", "data", "Lorg/rust/cargo/project/workspace/CargoWorkspaceData;", "cfgOptions", "Lorg/rust/cargo/CfgOptions;", "cargoConfig", "Lorg/rust/cargo/CargoConfig;", "intellij.rustrover.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final CargoWorkspace deserialize(@NotNull Path manifestPath, @NotNull CargoWorkspaceData data2, @NotNull CfgOptions cfgOptions, @NotNull CargoConfig cargoConfig) {
            Intrinsics.checkNotNullParameter((Object)manifestPath, (String)"manifestPath");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)cfgOptions, (String)"cfgOptions");
            Intrinsics.checkNotNullParameter((Object)cargoConfig, (String)"cargoConfig");
            return WorkspaceImpl.Companion.deserialize(manifestPath, data2, cfgOptions, cargoConfig);
        }

        public static /* synthetic */ CargoWorkspace deserialize$default(Companion companion, Path path, CargoWorkspaceData cargoWorkspaceData, CfgOptions cfgOptions, CargoConfig cargoConfig, int n, Object object) {
            if ((n & 4) != 0) {
                cfgOptions = CfgOptions.Companion.getDEFAULT();
            }
            if ((n & 8) != 0) {
                cargoConfig = CargoConfig.Companion.getDEFAULT();
            }
            return companion.deserialize(path, cargoWorkspaceData, cfgOptions, cargoConfig);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$DepKind;", "", "cargoName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getCargoName", "()Ljava/lang/String;", "Unclassified", "Stdlib", "Normal", "Development", "Build", "intellij.rustrover.core"})
    public static final class DepKind
    extends Enum<DepKind> {
        @Nullable
        private final String cargoName;
        public static final /* enum */ DepKind Unclassified = new DepKind(null);
        public static final /* enum */ DepKind Stdlib = new DepKind("stdlib?");
        public static final /* enum */ DepKind Normal = new DepKind(null);
        public static final /* enum */ DepKind Development = new DepKind("dev");
        public static final /* enum */ DepKind Build = new DepKind("build");
        private static final /* synthetic */ DepKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DepKind(String cargoName) {
            this.cargoName = cargoName;
        }

        @Nullable
        public final String getCargoName() {
            return this.cargoName;
        }

        public static DepKind[] values() {
            return (DepKind[])$VALUES.clone();
        }

        public static DepKind valueOf(String value) {
            return Enum.valueOf(DepKind.class, value);
        }

        @NotNull
        public static EnumEntries<DepKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = depKindArray = new DepKind[]{DepKind.Unclassified, DepKind.Stdlib, DepKind.Normal, DepKind.Development, DepKind.Build};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$DepKindInfo;", "", "kind", "Lorg/rust/cargo/project/workspace/CargoWorkspace$DepKind;", "target", "", "<init>", "(Lorg/rust/cargo/project/workspace/CargoWorkspace$DepKind;Ljava/lang/String;)V", "getKind", "()Lorg/rust/cargo/project/workspace/CargoWorkspace$DepKind;", "getTarget", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    public static final class DepKindInfo {
        @NotNull
        private final DepKind kind;
        @Nullable
        private final String target;

        public DepKindInfo(@NotNull DepKind kind2, @Nullable String target) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
            this.kind = kind2;
            this.target = target;
        }

        public /* synthetic */ DepKindInfo(DepKind depKind, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = null;
            }
            this(depKind, string);
        }

        @NotNull
        public final DepKind getKind() {
            return this.kind;
        }

        @Nullable
        public final String getTarget() {
            return this.target;
        }

        @NotNull
        public final DepKind component1() {
            return this.kind;
        }

        @Nullable
        public final String component2() {
            return this.target;
        }

        @NotNull
        public final DepKindInfo copy(@NotNull DepKind kind2, @Nullable String target) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
            return new DepKindInfo(kind2, target);
        }

        public static /* synthetic */ DepKindInfo copy$default(DepKindInfo depKindInfo, DepKind depKind, String string, int n, Object object) {
            if ((n & 1) != 0) {
                depKind = depKindInfo.kind;
            }
            if ((n & 2) != 0) {
                string = depKindInfo.target;
            }
            return depKindInfo.copy(depKind, string);
        }

        @NotNull
        public String toString() {
            return "DepKindInfo(kind=" + this.kind + ", target=" + this.target + ")";
        }

        public int hashCode() {
            int result2 = this.kind.hashCode();
            result2 = result2 * 31 + (this.target == null ? 0 : this.target.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DepKindInfo)) {
                return false;
            }
            DepKindInfo depKindInfo = (DepKindInfo)other;
            if (this.kind != depKindInfo.kind) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.target, (Object)depKindInfo.target);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$Dependency;", "", "pkg", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "getPkg", "()Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "name", "", "getName", "()Ljava/lang/String;", "cargoFeatureDependencyPackageName", "getCargoFeatureDependencyPackageName", "depKinds", "", "Lorg/rust/cargo/project/workspace/CargoWorkspace$DepKindInfo;", "getDepKinds", "()Ljava/util/List;", "requiredFeatures", "", "getRequiredFeatures", "()Ljava/util/Set;", "intellij.rustrover.core"})
    public static interface Dependency {
        @NotNull
        public Package getPkg();

        @NotNull
        public String getName();

        @NotNull
        public String getCargoFeatureDependencyPackageName();

        @NotNull
        public List<DepKindInfo> getDepKinds();

        @NotNull
        public Set<String> getRequiredFeatures();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$Edition;", "", "presentation", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getPresentation", "()Ljava/lang/String;", "EDITION_2015", "EDITION_2018", "EDITION_2021", "EDITION_2024", "Companion", "intellij.rustrover.core"})
    public static final class Edition
    extends Enum<Edition> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String presentation;
        @NotNull
        private static final Edition DEFAULT;
        public static final /* enum */ Edition EDITION_2015;
        public static final /* enum */ Edition EDITION_2018;
        public static final /* enum */ Edition EDITION_2021;
        public static final /* enum */ Edition EDITION_2024;
        private static final /* synthetic */ Edition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Edition(String presentation) {
            this.presentation = presentation;
        }

        @NotNull
        public final String getPresentation() {
            return this.presentation;
        }

        public static Edition[] values() {
            return (Edition[])$VALUES.clone();
        }

        public static Edition valueOf(String value) {
            return Enum.valueOf(Edition.class, value);
        }

        @NotNull
        public static EnumEntries<Edition> getEntries() {
            return $ENTRIES;
        }

        static {
            EDITION_2015 = new Edition("2015");
            EDITION_2018 = new Edition("2018");
            EDITION_2021 = new Edition("2021");
            EDITION_2024 = new Edition("2024");
            $VALUES = editionArray = new Edition[]{Edition.EDITION_2015, Edition.EDITION_2018, Edition.EDITION_2021, Edition.EDITION_2024};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            DEFAULT = EDITION_2018;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$Edition$Companion;", "", "<init>", "()V", "DEFAULT", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Edition;", "getDEFAULT", "()Lorg/rust/cargo/project/workspace/CargoWorkspace$Edition;", "intellij.rustrover.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Edition getDEFAULT() {
                return DEFAULT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$LibKind;", "", "<init>", "(Ljava/lang/String;I)V", "LIB", "DYLIB", "STATICLIB", "CDYLIB", "RLIB", "PROC_MACRO", "UNKNOWN", "intellij.rustrover.core"})
    public static final class LibKind
    extends Enum<LibKind> {
        public static final /* enum */ LibKind LIB = new LibKind();
        public static final /* enum */ LibKind DYLIB = new LibKind();
        public static final /* enum */ LibKind STATICLIB = new LibKind();
        public static final /* enum */ LibKind CDYLIB = new LibKind();
        public static final /* enum */ LibKind RLIB = new LibKind();
        public static final /* enum */ LibKind PROC_MACRO = new LibKind();
        public static final /* enum */ LibKind UNKNOWN = new LibKind();
        private static final /* synthetic */ LibKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LibKind[] values() {
            return (LibKind[])$VALUES.clone();
        }

        public static LibKind valueOf(String value) {
            return Enum.valueOf(LibKind.class, value);
        }

        @NotNull
        public static EnumEntries<LibKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = libKindArray = new LibKind[]{LibKind.LIB, LibKind.DYLIB, LibKind.STATICLIB, LibKind.CDYLIB, LibKind.RLIB, LibKind.PROC_MACRO, LibKind.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0012\u0010L\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0012\u0010\u0012\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001eR\u0014\u0010+\u001a\u0004\u0018\u00010,X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0018\u0010/\u001a\b\u0012\u0004\u0012\u00020100X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0012\u00104\u001a\u000205X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0012\u00108\u001a\u000209X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u001e\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0=X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0005R\"\u0010B\u001a\u0012\u0012\b\u0012\u00060\u000bj\u0002`C\u0012\u0004\u0012\u00020D0=X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010?R\u0014\u0010F\u001a\u0004\u0018\u00010GX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u0018\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000b00X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u00103\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006M\u00c0\u0006\u0001"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "Lcom/intellij/openapi/util/UserDataHolderEx;", "contentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContentRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "contentRootPath", "Ljava/nio/file/Path;", "getContentRootPath", "()Ljava/nio/file/Path;", "id", "", "getId", "()Ljava/lang/String;", "name", "getName", "normName", "getNormName", "version", "getVersion", "source", "getSource", "origin", "Lorg/rust/cargo/project/workspace/PackageOrigin;", "getOrigin", "()Lorg/rust/cargo/project/workspace/PackageOrigin;", "targets", "", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "getTargets", "()Ljava/util/Collection;", "libTarget", "getLibTarget", "()Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "customBuildTarget", "getCustomBuildTarget", "hasCustomBuildScript", "", "getHasCustomBuildScript", "()Z", "dependencies", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Dependency;", "getDependencies", "cfgOptions", "Lorg/rust/cargo/CfgOptions;", "getCfgOptions", "()Lorg/rust/cargo/CfgOptions;", "features", "", "Lorg/rust/cargo/project/workspace/PackageFeature;", "getFeatures", "()Ljava/util/Set;", "workspace", "Lorg/rust/cargo/project/workspace/CargoWorkspace;", "getWorkspace", "()Lorg/rust/cargo/project/workspace/CargoWorkspace;", "edition", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Edition;", "getEdition", "()Lorg/rust/cargo/project/workspace/CargoWorkspace$Edition;", "env", "", "getEnv", "()Ljava/util/Map;", "outDir", "getOutDir", "featureState", "Lorg/rust/cargo/project/workspace/FeatureName;", "Lorg/rust/cargo/project/workspace/FeatureState;", "getFeatureState", "procMacroArtifact", "Lorg/rust/cargo/project/workspace/CargoWorkspaceData$ProcMacroArtifact;", "getProcMacroArtifact", "()Lorg/rust/cargo/project/workspace/CargoWorkspaceData$ProcMacroArtifact;", "categories", "getCategories", "findDependency", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCargoWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoWorkspace.kt\norg/rust/cargo/project/workspace/CargoWorkspace$Package\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,830:1\n1#2:831\n*E\n"})
    public static interface Package
    extends UserDataHolderEx {
        @Nullable
        public VirtualFile getContentRoot();

        @NotNull
        public Path getContentRootPath();

        @NotNull
        public String getId();

        @NotNull
        public String getName();

        @NotNull
        default public String getNormName() {
            return StringsKt.replace$default((String)this.getName(), (char)'-', (char)'_', (boolean)false, (int)4, null);
        }

        @NotNull
        public String getVersion();

        @Nullable
        public String getSource();

        @NotNull
        public PackageOrigin getOrigin();

        @NotNull
        public Collection<Target> getTargets();

        @Nullable
        default public Target getLibTarget() {
            Object v0;
            block1: {
                Iterable iterable = this.getTargets();
                for (Object t : iterable) {
                    Target it2 = (Target)t;
                    boolean bl = false;
                    if (!it2.getKind().isLib()) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        default public Target getCustomBuildTarget() {
            Object v0;
            block1: {
                Iterable iterable = this.getTargets();
                for (Object t : iterable) {
                    Target it2 = (Target)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getKind(), (Object)TargetKind.CustomBuild.INSTANCE)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        default public boolean getHasCustomBuildScript() {
            return this.getCustomBuildTarget() != null;
        }

        @NotNull
        public Collection<Dependency> getDependencies();

        @Nullable
        public CfgOptions getCfgOptions();

        @NotNull
        public Set<PackageFeature> getFeatures();

        @NotNull
        public CargoWorkspace getWorkspace();

        @NotNull
        public Edition getEdition();

        @NotNull
        public Map<String, String> getEnv();

        @Nullable
        public VirtualFile getOutDir();

        @NotNull
        public Map<String, FeatureState> getFeatureState();

        @Nullable
        public CargoWorkspaceData.ProcMacroArtifact getProcMacroArtifact();

        @NotNull
        public Set<String> getCategories();

        @Nullable
        default public Target findDependency(@NotNull String normName) {
            Target target;
            Intrinsics.checkNotNullParameter((Object)normName, (String)"normName");
            if (Intrinsics.areEqual((Object)this.getNormName(), (Object)normName)) {
                target = this.getLibTarget();
            } else {
                Object object;
                Object v1;
                block3: {
                    Iterable iterable = this.getDependencies();
                    for (Object t : iterable) {
                        Dependency it2 = (Dependency)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getName(), (Object)normName)) continue;
                        v1 = t;
                        break block3;
                    }
                    v1 = null;
                }
                target = (object = (Dependency)v1) != null && (object = object.getPkg()) != null ? object.getLibTarget() : null;
            }
            return target;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006$\u00c0\u0006\u0001"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "", "name", "", "getName", "()Ljava/lang/String;", "normName", "getNormName", "kind", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "getKind", "()Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "crateRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCrateRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "pkg", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "getPkg", "()Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "edition", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Edition;", "getEdition", "()Lorg/rust/cargo/project/workspace/CargoWorkspace$Edition;", "doctest", "", "getDoctest", "()Z", "requiredFeatures", "", "getRequiredFeatures", "()Ljava/util/List;", "cfgOptions", "Lorg/rust/cargo/CfgOptions;", "getCfgOptions", "()Lorg/rust/cargo/CfgOptions;", "intellij.rustrover.core"})
    public static interface Target {
        @NotNull
        public String getName();

        @NotNull
        default public String getNormName() {
            return StringsKt.replace$default((String)this.getName(), (char)'-', (char)'_', (boolean)false, (int)4, null);
        }

        @NotNull
        public TargetKind getKind();

        @Nullable
        public VirtualFile getCrateRoot();

        @NotNull
        public Package getPkg();

        @NotNull
        public Edition getEdition();

        public boolean getDoctest();

        @NotNull
        public List<String> getRequiredFeatures();

        @NotNull
        public CfgOptions getCfgOptions();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\b\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u0082\u0001\b\u0019\u001a\u001b\u001c\u001d\u001e\u001f \u00a8\u0006!"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "isLib", "", "()Z", "isBin", "isExampleBin", "isCustomBuild", "isProcMacro", "canHaveMainFunction", "getCanHaveMainFunction", "Lib", "Bin", "Test", "ExampleBin", "ExampleLib", "Bench", "CustomBuild", "Unknown", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$Bench;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$Bin;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$CustomBuild;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$ExampleBin;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$ExampleLib;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$Lib;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$Test;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$Unknown;", "intellij.rustrover.core"})
    public static abstract sealed class TargetKind {
        @NotNull
        private final String name;

        private TargetKind(String name2) {
            this.name = name2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean isLib() {
            return this instanceof Lib;
        }

        public final boolean isBin() {
            return Intrinsics.areEqual((Object)this, (Object)Bin.INSTANCE);
        }

        public final boolean isExampleBin() {
            return Intrinsics.areEqual((Object)this, (Object)ExampleBin.INSTANCE);
        }

        public final boolean isCustomBuild() {
            return Intrinsics.areEqual((Object)this, (Object)CustomBuild.INSTANCE);
        }

        public final boolean isProcMacro() {
            return this instanceof Lib && ((Lib)this).getKinds().contains((Object)LibKind.PROC_MACRO);
        }

        public final boolean getCanHaveMainFunction() {
            return this.isBin() || this.isExampleBin() || this.isCustomBuild();
        }

        public /* synthetic */ TargetKind(String name2, DefaultConstructorMarker $constructor_marker) {
            this(name2);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$Bench;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class Bench
        extends TargetKind {
            @NotNull
            public static final Bench INSTANCE = new Bench();

            private Bench() {
                super("bench", null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$Bin;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class Bin
        extends TargetKind {
            @NotNull
            public static final Bin INSTANCE = new Bin();

            private Bin() {
                super("bin", null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$CustomBuild;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class CustomBuild
        extends TargetKind {
            @NotNull
            public static final CustomBuild INSTANCE = new CustomBuild();

            private CustomBuild() {
                super("custom-build", null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$ExampleBin;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class ExampleBin
        extends TargetKind {
            @NotNull
            public static final ExampleBin INSTANCE = new ExampleBin();

            private ExampleBin() {
                super("example", null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$ExampleLib;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "kinds", "Ljava/util/EnumSet;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$LibKind;", "<init>", "(Ljava/util/EnumSet;)V", "getKinds", "()Ljava/util/EnumSet;", "intellij.rustrover.core"})
        public static final class ExampleLib
        extends TargetKind {
            @NotNull
            private final EnumSet<LibKind> kinds;

            public ExampleLib(@NotNull EnumSet<LibKind> kinds) {
                Intrinsics.checkNotNullParameter(kinds, (String)"kinds");
                super("example", null);
                this.kinds = kinds;
            }

            @NotNull
            public final EnumSet<LibKind> getKinds() {
                return this.kinds;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$Lib;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "kinds", "Ljava/util/EnumSet;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$LibKind;", "<init>", "(Ljava/util/EnumSet;)V", "", "([Lorg/rust/cargo/project/workspace/CargoWorkspace$LibKind;)V", "getKinds", "()Ljava/util/EnumSet;", "intellij.rustrover.core"})
        public static final class Lib
        extends TargetKind {
            @NotNull
            private final EnumSet<LibKind> kinds;

            public Lib(@NotNull EnumSet<LibKind> kinds) {
                Intrinsics.checkNotNullParameter(kinds, (String)"kinds");
                super("lib", null);
                this.kinds = kinds;
            }

            @NotNull
            public final EnumSet<LibKind> getKinds() {
                return this.kinds;
            }

            public Lib(LibKind ... kinds) {
                Intrinsics.checkNotNullParameter((Object)kinds, (String)"kinds");
                EnumSet<LibKind> enumSet = EnumSet.copyOf((Collection)ArraysKt.asList((Object[])kinds));
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copyOf(...)");
                this(enumSet);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$Test;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class Test
        extends TargetKind {
            @NotNull
            public static final Test INSTANCE = new Test();

            private Test() {
                super("test", null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind$Unknown;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$TargetKind;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class Unknown
        extends TargetKind {
            @NotNull
            public static final Unknown INSTANCE = new Unknown();

            private Unknown() {
                super("unknown", null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.YES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.NO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.UNSURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

