/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.toolwindow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.toolwindow.CargoProjectTreeStructure;
import org.rust.cargo.project.toolwindow.CargoProjectsTreeKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.toolchain.CargoCommandLine;
import org.rust.cargo.toolchain.RsCommandLineBase;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/rust/cargo/project/toolwindow/CargoProjectsTree;", "Lcom/intellij/ui/treeStructure/SimpleTree;", "<init>", "()V", "selectedProject", "Lorg/rust/cargo/project/model/CargoProject;", "getSelectedProject", "()Lorg/rust/cargo/project/model/CargoProject;", "run", "", "commandLine", "Lorg/rust/cargo/toolchain/CargoCommandLine;", "project", "name", "", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoProjectsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoProjectsTree.kt\norg/rust/cargo/project/toolwindow/CargoProjectsTree\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,76:1\n13#2:77\n*S KotlinDebug\n*F\n+ 1 CargoProjectsTree.kt\norg/rust/cargo/project/toolwindow/CargoProjectsTree\n*L\n63#1:77\n*E\n"})
public class CargoProjectsTree
extends SimpleTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public CargoProjectsTree() {
        this.setRootVisible(false);
        this.showsRootHandles = true;
        this.getEmptyText().setText("There are no Cargo projects to display.");
        this.selectionModel.setSelectionMode(1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() < 2 || !SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                Object object = e.getSource();
                CargoProjectsTree cargoProjectsTree = object instanceof CargoProjectsTree ? (CargoProjectsTree)((Object)object) : null;
                if (cargoProjectsTree == null) {
                    return;
                }
                CargoProjectsTree tree = cargoProjectsTree;
                Object object2 = tree.selectionModel.getSelectionPath();
                Object object3 = object2 != null ? ((TreePath)object2).getLastPathComponent() : null;
                DefaultMutableTreeNode defaultMutableTreeNode = object3 instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object3 : null;
                if (defaultMutableTreeNode == null) {
                    return;
                }
                DefaultMutableTreeNode node = defaultMutableTreeNode;
                object2 = node.getUserObject();
                Object object4 = object2 instanceof CargoProjectTreeStructure.CargoSimpleNode.Target ? (CargoProjectTreeStructure.CargoSimpleNode.Target)((Object)object2) : null;
                if (object4 == null || (object4 = object4.getTarget()) == null) {
                    return;
                }
                Object target = object4;
                String command = CargoProjectsTreeKt.access$launchCommand((CargoWorkspace.Target)target);
                if (command == null) {
                    LOG.warn("Can't create launch command for `" + target.getName() + "` target");
                    return;
                }
                CargoProject cargoProject = this.getSelectedProject();
                if (cargoProject == null) {
                    return;
                }
                CargoProject cargoProject2 = cargoProject;
                String configurationName = UtilsKt.capitalized(command) + " " + target.getName();
                this.run(CargoCommandLine.Companion.forTarget$default(CargoCommandLine.Companion, (CargoWorkspace.Target)target, command, null, null, null, false, 60, null), cargoProject2, configurationName);
            }
        });
    }

    @Nullable
    public final CargoProject getSelectedProject() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        TreePath path = treePath;
        if (path.getPathCount() < 2) {
            return null;
        }
        Object object = path.getPathComponent(1);
        DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        if (defaultMutableTreeNode == null) {
            return null;
        }
        DefaultMutableTreeNode treeNode = defaultMutableTreeNode;
        object = treeNode.getUserObject();
        CargoProjectTreeStructure.CargoSimpleNode.Project project = object instanceof CargoProjectTreeStructure.CargoSimpleNode.Project ? (CargoProjectTreeStructure.CargoSimpleNode.Project)((Object)object) : null;
        return project != null ? project.getCargoProject() : null;
    }

    protected void run(@NotNull CargoCommandLine commandLine, @NotNull CargoProject project, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        RsCommandLineBase.run$default(commandLine, project, name2, false, null, 12, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CargoProjectsTree.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/project/toolwindow/CargoProjectsTree$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

