/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.Topic;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.RustupKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 \u001f*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0006\u001c\u001d\u001e\u001f !B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u0011J$\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u0011H\u0007J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\""}, d2={"Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase;", "T", "Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "project", "Lcom/intellij/openapi/project/Project;", "state", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isRustupAvailable", "", "()Z", "modify", "", "action", "Lkotlin/Function1;", "modifyTemporary", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "createSettingsChangedEvent", "Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$SettingsChangedEventBase;", "oldEvent", "newEvent", "(Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;)Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$SettingsChangedEventBase;", "notifySettingsChanged", "event", "RsProjectSettingsBase", "AffectsCargoMetadata", "AffectsHighlighting", "Companion", "RsSettingsListener", "SettingsChangedEventBase", "intellij.rustrover.core"})
public abstract class RsProjectSettingsServiceBase<T extends RsProjectSettingsBase<T>>
extends SimplePersistentStateComponent<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Topic<RsSettingsListener> RUST_SETTINGS_TOPIC;

    public RsProjectSettingsServiceBase(@NotNull Project project, @NotNull T state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        super((BaseState)state);
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    protected final boolean isRustupAvailable() {
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(this.project);
        return rsToolchainBase != null ? RustupKt.isRustupAvailable(rsToolchainBase) : false;
    }

    public final void modify(@NotNull Function1<? super T, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Object oldState = ((RsProjectSettingsBase)this.getState()).copy();
        BaseState baseState = this.getState();
        action2.invoke((Object)baseState);
        RsProjectSettingsBase newState = (RsProjectSettingsBase)baseState;
        SettingsChangedEventBase<RsProjectSettingsBase> event = this.createSettingsChangedEvent(oldState, newState);
        this.notifySettingsChanged(event);
    }

    @TestOnly
    public final void modifyTemporary(@NotNull Disposable parentDisposable, @NotNull Function1<? super T, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        RsProjectSettingsBase oldState = (RsProjectSettingsBase)this.getState();
        Object t = oldState.copy();
        action2.invoke(t);
        this.loadState((BaseState)t);
        Disposer.register((Disposable)parentDisposable, () -> RsProjectSettingsServiceBase.modifyTemporary$lambda$0(this, oldState));
    }

    @NotNull
    protected abstract SettingsChangedEventBase<T> createSettingsChangedEvent(@NotNull T var1, @NotNull T var2);

    protected void notifySettingsChanged(@NotNull SettingsChangedEventBase<T> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        ((RsSettingsListener)this.project.getMessageBus().syncPublisher(RUST_SETTINGS_TOPIC)).settingsChanged(event);
        if (event.getAffectsHighlighting()) {
            DaemonCodeAnalyzer.getInstance((Project)this.project).restart((Object)this);
        }
    }

    private static final void modifyTemporary$lambda$0(RsProjectSettingsServiceBase this$0, RsProjectSettingsBase $oldState) {
        this$0.loadState($oldState);
    }

    static {
        Topic topic = Topic.create((String)"rust settings changes", RsSettingsListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        RUST_SETTINGS_TOPIC = topic;
    }

    @Retention(value=AnnotationRetention.RUNTIME)
    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.PROPERTY})
    @java.lang.annotation.Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0085\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$AffectsCargoMetadata;", "", "intellij.rustrover.core"})
    protected static @interface AffectsCargoMetadata {
    }

    @Retention(value=AnnotationRetention.RUNTIME)
    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.PROPERTY})
    @java.lang.annotation.Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0085\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$AffectsHighlighting;", "", "intellij.rustrover.core"})
    protected static @interface AffectsHighlighting {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$Companion;", "", "<init>", "()V", "RUST_SETTINGS_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsSettingsListener;", "getRUST_SETTINGS_TOPIC", "()Lcom/intellij/util/messages/Topic;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<RsSettingsListener> getRUST_SETTINGS_TOPIC() {
            return RUST_SETTINGS_TOPIC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;", "T", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "copy", "()Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;", "intellij.rustrover.core"})
    public static abstract class RsProjectSettingsBase<T extends RsProjectSettingsBase<T>>
    extends BaseState {
        @NotNull
        public abstract T copy();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u0003\"\u000e\b\u0001\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsSettingsListener;", "", "settingsChanged", "", "T", "Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;", "e", "Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$SettingsChangedEventBase;", "intellij.rustrover.core"})
    public static interface RsSettingsListener {
        public <T extends RsProjectSettingsBase<T>> void settingsChanged(@NotNull SettingsChangedEventBase<T> var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00112\u0010\u0010\u0017\u001a\f\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\u000eR\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\tR\u001e\u0010\f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$SettingsChangedEventBase;", "T", "Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;", "", "oldState", "newState", "<init>", "(Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;)V", "getOldState", "()Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;", "Lorg/rust/cargo/project/settings/RsProjectSettingsServiceBase$RsProjectSettingsBase;", "getNewState", "cargoMetadataAffectingProps", "", "Lkotlin/reflect/KProperty1;", "highlightingAffectingProps", "affectsCargoMetadata", "", "getAffectsCargoMetadata", "()Z", "affectsHighlighting", "getAffectsHighlighting", "isChanged", "prop", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsProjectSettingsServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsProjectSettingsServiceBase.kt\norg/rust/cargo/project/settings/RsProjectSettingsServiceBase$SettingsChangedEventBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,95:1\n774#2:96\n865#2:97\n295#2,2:99\n866#2:101\n774#2:102\n865#2:103\n295#2,2:105\n866#2:107\n1761#2,3:108\n1761#2,3:111\n20#3:98\n20#3:104\n*S KotlinDebug\n*F\n+ 1 RsProjectSettingsServiceBase.kt\norg/rust/cargo/project/settings/RsProjectSettingsServiceBase$SettingsChangedEventBase\n*L\n80#1:96\n80#1:97\n80#1:99,2\n80#1:101\n83#1:102\n83#1:103\n83#1:105,2\n83#1:107\n86#1:108,3\n89#1:111,3\n80#1:98\n83#1:104\n*E\n"})
    public static abstract class SettingsChangedEventBase<T extends RsProjectSettingsBase<T>> {
        @NotNull
        private final T oldState;
        @NotNull
        private final T newState;
        @NotNull
        private final List<KProperty1<T, ?>> cargoMetadataAffectingProps;
        @NotNull
        private final List<KProperty1<T, ?>> highlightingAffectingProps;

        public SettingsChangedEventBase(@NotNull T oldState, @NotNull T newState) {
            boolean bl;
            Annotation it$iv;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv$iv;
            boolean $i$f$findAnnotation;
            KAnnotatedElement $this$findAnnotation$iv;
            KProperty1 it2;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter(oldState, (String)"oldState");
            Intrinsics.checkNotNullParameter(newState, (String)"newState");
            this.oldState = oldState;
            this.newState = newState;
            Iterable iterable = KClasses.getMemberProperties((KClass)JvmClassMappingKt.getKotlinClass(this.oldState.getClass()));
            SettingsChangedEventBase settingsChangedEventBase = this;
            boolean $i$f$filter = false;
            void var5_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Object v0;
                block4: {
                    it2 = (KProperty1)element$iv$iv;
                    boolean bl2 = false;
                    $this$findAnnotation$iv = (KAnnotatedElement)it2;
                    $i$f$findAnnotation = false;
                    $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                    $i$f$firstOrNull = false;
                    for (Object element$iv$iv2 : $this$firstOrNull$iv$iv) {
                        it$iv = (Annotation)element$iv$iv2;
                        bl = false;
                        if (!(it$iv instanceof AffectsCargoMetadata)) continue;
                        v0 = element$iv$iv2;
                        break block4;
                    }
                    v0 = null;
                }
                if (!((Annotation)v0 != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            settingsChangedEventBase.cargoMetadataAffectingProps = (List)destination$iv$iv;
            $this$filter$iv = KClasses.getMemberProperties((KClass)JvmClassMappingKt.getKotlinClass(this.oldState.getClass()));
            settingsChangedEventBase = this;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Object v1;
                block5: {
                    it2 = (KProperty1)element$iv$iv;
                    boolean bl3 = false;
                    $this$findAnnotation$iv = (KAnnotatedElement)it2;
                    $i$f$findAnnotation = false;
                    $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                    $i$f$firstOrNull = false;
                    for (Object element$iv$iv2 : $this$firstOrNull$iv$iv) {
                        it$iv = (Annotation)element$iv$iv2;
                        bl = false;
                        if (!(it$iv instanceof AffectsHighlighting)) continue;
                        v1 = element$iv$iv2;
                        break block5;
                    }
                    v1 = null;
                }
                if (!((Annotation)v1 != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            settingsChangedEventBase.highlightingAffectingProps = (List)destination$iv$iv;
        }

        @NotNull
        public final T getOldState() {
            return this.oldState;
        }

        @NotNull
        public final T getNewState() {
            return this.newState;
        }

        public final boolean getAffectsCargoMetadata() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.cargoMetadataAffectingProps;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KProperty1 p0 = (KProperty1)element$iv;
                        boolean bl2 = false;
                        if (!this.isChanged(p0)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean getAffectsHighlighting() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.highlightingAffectingProps;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KProperty1 p0 = (KProperty1)element$iv;
                        boolean bl2 = false;
                        if (!this.isChanged(p0)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean isChanged(@NotNull KProperty1<T, ?> prop) {
            Intrinsics.checkNotNullParameter(prop, (String)"prop");
            return !Intrinsics.areEqual((Object)prop.get(this.oldState), (Object)prop.get(this.newState));
        }
    }
}

