/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.model.impl;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.model.ProcessProgressListener;
import org.rust.cargo.project.model.impl.CargoSyncTask;
import org.rust.cargo.project.model.impl.CargoSyncTaskKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/rust/cargo/project/model/impl/SyncProcessAdapter;", "Lcom/intellij/execution/process/ProcessAdapter;", "Lorg/rust/cargo/project/model/ProcessProgressListener;", "context", "Lorg/rust/cargo/project/model/impl/CargoSyncTask$SyncContext;", "<init>", "(Lorg/rust/cargo/project/model/impl/CargoSyncTask$SyncContext;)V", "completeRegex", "Lkotlin/text/Regex;", "pendingRegex", "downloadingRegex", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "", "error", "title", "", "message", "warning", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoSyncTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoSyncTask.kt\norg/rust/cargo/project/model/impl/SyncProcessAdapter\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,685:1\n106#2:686\n78#2,22:687\n*S KotlinDebug\n*F\n+ 1 CargoSyncTask.kt\norg/rust/cargo/project/model/impl/SyncProcessAdapter\n*L\n591#1:686\n591#1:687,22\n*E\n"})
final class SyncProcessAdapter
extends ProcessAdapter
implements ProcessProgressListener {
    @NotNull
    private final CargoSyncTask.SyncContext context;
    @NotNull
    private final Regex completeRegex;
    @NotNull
    private final Regex pendingRegex;
    @NotNull
    private final Regex downloadingRegex;

    public SyncProcessAdapter(@NotNull CargoSyncTask.SyncContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.completeRegex = new Regex("([0-9]+) complete");
        this.pendingRegex = new Regex("([0-9]+) pending");
        this.downloadingRegex = new Regex("Downloading ([0-9]+) crates");
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<Object> outputType) {
        String text;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        String string = event.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (StringsKt.startsWith$default((String)(text = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"Updating", (boolean)false, (int)2, null)) {
            this.context.withProgressText(text);
        }
        if (StringsKt.startsWith$default((String)text, (String)"Fetch", (boolean)false, (int)2, null)) {
            Integer pending;
            Object object = Regex.find$default((Regex)this.completeRegex, (CharSequence)text, (int)0, (int)2, null);
            Integer complete = object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null;
            Object object2 = Regex.find$default((Regex)this.pendingRegex, (CharSequence)text, (int)0, (int)2, null);
            Integer n = object2 != null && (object2 = object2.getGroups()) != null && (object2 = object2.get(1)) != null && (object2 = object2.getValue()) != null ? Integer.valueOf(Integer.parseInt((String)object2)) : (pending = null);
            if (complete != null && pending != null) {
                Object[] objectArray = new Object[]{complete, complete + pending};
                this.context.withProgressText(RsBundle.INSTANCE.message("sync.task.progress.fetch.text", objectArray));
                this.context.changeFetchProgress(complete, pending);
            }
        }
        if (StringsKt.startsWith$default((String)text, (String)"Downloading", (boolean)false, (int)2, null)) {
            Integer cratesLeft;
            Object object = (MatchResult)SequencesKt.lastOrNull((Sequence)Regex.findAll$default((Regex)this.downloadingRegex, (CharSequence)text, (int)0, (int)2, null));
            Integer n = object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : (cratesLeft = null);
            if (cratesLeft == null || cratesLeft == 0) {
                this.context.withProgressText(RsBundle.INSTANCE.message("progress.text.updating.workspace.info", new Object[0]));
            } else {
                Object[] pending = new Object[]{cratesLeft};
                this.context.withProgressText(RsBundle.INSTANCE.message("progress.text.downloading.info", pending));
            }
            if (cratesLeft != null) {
                this.context.changeDownloadingProgress(cratesLeft);
            }
        }
        if (StringsKt.startsWith$default((String)text, (String)"Vendoring", (boolean)false, (int)2, null)) {
            String string2;
            int index = StringsKt.indexOf$default((CharSequence)text, (String)" (", (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                String string3 = text.substring(0, index);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string2 = text;
            }
            String progressText = string2;
            this.context.withProgressText(progressText);
        }
    }

    @Override
    public void error(@NotNull String title, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CargoSyncTaskKt.access$error(this.context, title, message);
    }

    @Override
    public void warning(@NotNull String title, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CargoSyncTaskKt.access$warning(this.context, title, message);
    }
}

