/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.model.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.PathUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.model.impl.CargoEventService;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\r\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/rust/cargo/project/model/impl/CargoTomlWatcher;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "cargoProjects", "Lorg/rust/cargo/project/model/CargoProjectsService;", "onCargoTomlChange", "Lkotlin/Function0;", "", "<init>", "(Lorg/rust/cargo/project/model/CargoProjectsService;Lkotlin/jvm/functions/Function0;)V", "before", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "after", "isInterestingEvent", "", "event", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoTomlWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoTomlWatcher.kt\norg/rust/cargo/project/model/impl/CargoTomlWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,105:1\n1761#2,3:106\n1761#2,3:109\n13#3:112\n*S KotlinDebug\n*F\n+ 1 CargoTomlWatcher.kt\norg/rust/cargo/project/model/impl/CargoTomlWatcher\n*L\n37#1:106,3\n53#1:109,3\n102#1:112\n*E\n"})
public final class CargoTomlWatcher
implements BulkFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CargoProjectsService cargoProjects;
    @NotNull
    private final Function0<Unit> onCargoTomlChange;
    @NotNull
    private static final List<String> IMPLICIT_TARGET_FILES;
    @NotNull
    private static final List<String> IMPLICIT_TARGET_DIRS;
    @NotNull
    private static final Logger LOG;

    public CargoTomlWatcher(@NotNull CargoProjectsService cargoProjects, @NotNull Function0<Unit> onCargoTomlChange) {
        Intrinsics.checkNotNullParameter((Object)cargoProjects, (String)"cargoProjects");
        Intrinsics.checkNotNullParameter(onCargoTomlChange, (String)"onCargoTomlChange");
        this.cargoProjects = cargoProjects;
        this.onCargoTomlChange = onCargoTomlChange;
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable $this$any$iv = events;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VFileEvent it2 = (VFileEvent)element$iv;
                    boolean bl2 = false;
                    if (!this.isInterestingEvent(it2)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            this.onCargoTomlChange.invoke();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInterestingEvent(VFileEvent event) {
        CargoProject it2;
        if (!Companion.isInterestingEvent(this.cargoProjects.getProject(), event)) {
            return false;
        }
        if (!(event instanceof VFileContentChangeEvent)) return true;
        VirtualFile virtualFile = ((VFileContentChangeEvent)event).getFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile file = virtualFile;
        Path fileParentPath = UtilsKt.getPathAsPath(file).getParent();
        CargoWorkspace.Package package_ = this.cargoProjects.findPackageForFile(file);
        if ((package_ != null ? package_.getOrigin() : null) == PackageOrigin.WORKSPACE) return true;
        Iterable $this$any$iv = this.cargoProjects.getAllProjects();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it2 = (CargoProject)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it2.getManifest().getParent(), (Object)fileParentPath));
        return true;
    }

    static {
        Object[] objectArray = new String[]{"/build.rs", "/src/main.rs", "/src/lib.rs"};
        IMPLICIT_TARGET_FILES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"/src/bin", "/examples", "/tests", "/benches"};
        IMPLICIT_TARGET_DIRS = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CargoTomlWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0014\u0010\u000e\u001a\u00020\t*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/rust/cargo/project/model/impl/CargoTomlWatcher$Companion;", "", "<init>", "()V", "IMPLICIT_TARGET_FILES", "", "", "IMPLICIT_TARGET_DIRS", "isInterestingEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "pathEndsWith", "suffix", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCargoTomlWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoTomlWatcher.kt\norg/rust/cargo/project/model/impl/CargoTomlWatcher$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1761#2,3:106\n1761#2,3:109\n*S KotlinDebug\n*F\n+ 1 CargoTomlWatcher.kt\norg/rust/cargo/project/model/impl/CargoTomlWatcher$Companion\n*L\n90#1:106,3\n94#1:109,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final boolean isInterestingEvent(@NotNull Project project, @NotNull VFileEvent event) {
            boolean bl;
            block21: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.pathEndsWith(event, "Cargo.toml")) {
                    bl = true;
                } else {
                    if (this.pathEndsWith(event, "Cargo.lock")) {
                        boolean bl2;
                        int delayThreshold;
                        long timestamp;
                        Path projectDir = Paths.get(event.getPath(), new String[0]).getParent();
                        CargoEventService cargoEventService = CargoEventService.Companion.getInstance(project);
                        Intrinsics.checkNotNull((Object)projectDir);
                        Long l = cargoEventService.extractTimestamp(projectDir);
                        long l2 = timestamp = l != null ? l : 0L;
                        if (event.getRequestor() != null) {
                            return true;
                        }
                        long current = System.currentTimeMillis();
                        long delay = current - timestamp;
                        if (delay > (long)(delayThreshold = Registry.Companion.intValue("org.rust.cargo.lock.update.delay.threshold"))) {
                            LOG.info("External change in " + event.getPath() + ". Previous Cargo metadata call was " + delay + " ms before");
                            bl2 = true;
                        } else {
                            LOG.info("Skip external change for " + event.getPath() + ". Previous Cargo metadata call was " + delay + " ms before");
                            bl2 = false;
                        }
                        return bl2;
                    }
                    if (event instanceof VFileContentChangeEvent) {
                        bl = false;
                    } else if (!this.pathEndsWith(event, ".rs")) {
                        bl = false;
                    } else if (event instanceof VFilePropertyChangeEvent && !Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)event).getPropertyName(), (Object)"name")) {
                        bl = false;
                    } else {
                        boolean bl3;
                        block20: {
                            Iterable $this$any$iv = IMPLICIT_TARGET_FILES;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    String it2 = (String)element$iv;
                                    boolean bl4 = false;
                                    if (!Companion.pathEndsWith(event, it2)) continue;
                                    bl3 = true;
                                    break block20;
                                }
                                bl3 = false;
                            }
                        }
                        if (bl3) {
                            bl = true;
                        } else {
                            String string = PathUtil.getParentPath((String)event.getPath());
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
                            String parent2 = string;
                            String string2 = PathUtil.getParentPath((String)parent2);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParentPath(...)");
                            String grandParent = string2;
                            Iterable $this$any$iv = IMPLICIT_TARGET_DIRS;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    String it3 = (String)element$iv;
                                    boolean bl5 = false;
                                    if (!(StringsKt.endsWith$default((String)parent2, (String)it3, (boolean)false, (int)2, null) || Companion.pathEndsWith(event, "main.rs") && StringsKt.endsWith$default((String)grandParent, (String)it3, (boolean)false, (int)2, null))) continue;
                                    bl = true;
                                    break block21;
                                }
                                bl = false;
                            }
                        }
                    }
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean pathEndsWith(VFileEvent $this$pathEndsWith, String suffix) {
            String string = $this$pathEndsWith.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.endsWith$default((String)string, (String)suffix, (boolean)false, (int)2, null)) return true;
            if (!($this$pathEndsWith instanceof VFilePropertyChangeEvent)) return false;
            String string2 = ((VFilePropertyChangeEvent)$this$pathEndsWith).getOldPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOldPath(...)");
            if (!StringsKt.endsWith$default((String)string2, (String)suffix, (boolean)false, (int)2, null)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

