/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.model.impl;

import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.progress.BuildProgress;
import com.intellij.build.progress.BuildProgressDescriptor;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ThreeState;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.rust.RsBundle;
import org.rust.RsTask;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.ProcMacroExpanderExecutable;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.model.impl.CargoProjectImpl;
import org.rust.cargo.project.model.impl.CargoProjectWithStdlib;
import org.rust.cargo.project.model.impl.CargoSyncTaskKt;
import org.rust.cargo.project.model.impl.RustcVersionProcessAdapter;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.tools.Rustc;
import org.rust.cargo.toolchain.tools.RustcKt;
import org.rust.cargo.toolchain.tools.Rustup;
import org.rust.cargo.toolchain.tools.RustupKt;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.cargo.util.ToolchainUtilKt;
import org.rust.ide.statistics.CargoSyncUsagesCollector;
import org.rust.lang.core.macros.proc.ProcMacroServerPool;
import org.rust.openapiext.RsProcessExecutionException;
import org.rust.openapiext.TaskResult;
import org.rust.openapiext.TaskResultKt;
import org.rust.stdext.HashCode;
import org.rust.stdext.RsResult;
import org.rust.util.UnitTestUtilService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0003$%&B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lorg/rust/cargo/project/model/impl/CargoSyncTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "Lorg/rust/RsTask;", "project", "Lcom/intellij/openapi/project/Project;", "cargoProjects", "", "Lorg/rust/cargo/project/model/impl/CargoProjectImpl;", "result", "Ljava/util/concurrent/CompletableFuture;", "isExplicitReload", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/concurrent/CompletableFuture;Z)V", "taskType", "Lorg/rust/RsTask$TaskType;", "getTaskType", "()Lorg/rust/RsTask$TaskType;", "runSyncInUnitTests", "getRunSyncInUnitTests", "()Z", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doRun", "syncProgress", "Lcom/intellij/build/progress/BuildProgress;", "Lcom/intellij/build/progress/BuildProgressDescriptor;", "createSyncProgressDescriptor", "progress", "fetchRustcInfo", "Lorg/rust/openapiext/TaskResult;", "Lorg/rust/cargo/project/model/RustcInfo;", "context", "Lorg/rust/cargo/project/model/impl/CargoSyncTask$SyncContext;", "Companion", "StopAction", "SyncContext", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoSyncTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoSyncTask.kt\norg/rust/cargo/project/model/impl/CargoSyncTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 RsResult.kt\norg/rust/stdext/RsResultKt\n*L\n1#1,685:1\n1761#2,3:686\n1563#2:689\n1634#2,3:690\n60#3,5:693\n13#3:702\n60#4,4:698\n*S KotlinDebug\n*F\n+ 1 CargoSyncTask.kt\norg/rust/cargo/project/model/impl/CargoSyncTask\n*L\n97#1:686,3\n131#1:689\n131#1:690,3\n157#1:693,5\n233#1:702\n202#1:698,4\n*E\n"})
public final class CargoSyncTask
extends Task.Backgroundable
implements RsTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<CargoProjectImpl> cargoProjects;
    @NotNull
    private final CompletableFuture<List<CargoProjectImpl>> result;
    private final boolean isExplicitReload;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final SemVer MIN_RUSTC_VERSION_WITH_EXPANDER_VERSION_CHECK;

    public CargoSyncTask(@NotNull Project project, @NotNull List<CargoProjectImpl> cargoProjects, @NotNull CompletableFuture<List<CargoProjectImpl>> result2, boolean isExplicitReload) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(cargoProjects, (String)"cargoProjects");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        super(project, RsBundle.INSTANCE.message("progress.title.reloading.cargo.projects", new Object[0]), true);
        this.cargoProjects = cargoProjects;
        this.result = result2;
        this.isExplicitReload = isExplicitReload;
    }

    @Override
    @NotNull
    public RsTask.TaskType getTaskType() {
        return RsTask.TaskType.CARGO_SYNC;
    }

    @Override
    public boolean getRunSyncInUnitTests() {
        return true;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        List<CargoProjectImpl> refreshedProjects;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        LOG.info("CargoSyncTask started");
        indicator.setIndeterminate(true);
        long start2 = System.currentTimeMillis();
        BuildProgress syncProgress = SyncViewManager.createBuildProgress((Project)this.getProject());
        try {
            boolean bl;
            block7: {
                syncProgress.start(this.createSyncProgressDescriptor(indicator));
                Intrinsics.checkNotNull((Object)syncProgress);
                refreshedProjects = this.doRun(indicator, (BuildProgress<BuildProgressDescriptor>)syncProgress);
                Iterable $this$any$iv = refreshedProjects;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CargoProjectImpl it2 = (CargoProjectImpl)element$iv;
                        boolean bl2 = false;
                        if (!(it2.getMergedStatus() instanceof CargoProject.UpdateStatus.UpdateFailed)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            boolean isUpdateFailed = bl;
            CargoSyncUsagesCollector.INSTANCE.logProjectRefreshed(!isUpdateFailed, this.isExplicitReload, refreshedProjects);
            BuildProgress buildProgress = isUpdateFailed ? syncProgress.fail() : syncProgress.finish();
        }
        catch (Throwable e) {
            if (e instanceof ProcessCanceledException) {
                v2 = syncProgress.cancel();
            } else {
                CargoSyncUsagesCollector.logProjectRefreshed$default(CargoSyncUsagesCollector.INSTANCE, false, this.isExplicitReload, null, 4, null);
                v2 = syncProgress.fail();
            }
            this.result.completeExceptionally(e);
            throw e;
        }
        List<CargoProjectImpl> refreshedProjects2 = refreshedProjects;
        this.result.complete(refreshedProjects2);
        long elapsed = System.currentTimeMillis() - start2;
        LOG.debug("Finished Cargo sync task in " + elapsed + " ms");
    }

    /*
     * WARNING - void declaration
     */
    private final List<CargoProjectImpl> doRun(ProgressIndicator indicator, BuildProgress<BuildProgressDescriptor> syncProgress) {
        List list;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsToolchainBase toolchain2 = RustProjectSettingsServiceKt.getToolchain(project);
        if (toolchain2 == null) {
            syncProgress.fail(System.currentTimeMillis(), RsBundle.INSTANCE.message("build.event.message.cargo.project.update.failed.no.rust.toolchain", new Object[0]));
            list = this.cargoProjects;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.cargoProjects;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void cargoProject;
                CargoProjectImpl cargoProjectImpl = (CargoProjectImpl)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object[] objectArray = new Object[]{cargoProject.getPresentableName()};
                collection.add((CargoProjectWithStdlib)CargoSyncTaskKt.runWithChildProgress$default(syncProgress, RsBundle.INSTANCE.message("build.event.title.sync.project", objectArray), CargoSyncTask::doRun$lambda$0$0, arg_0 -> CargoSyncTask.doRun$lambda$0$1((CargoProjectImpl)cargoProject, this, toolchain2, indicator, syncProgress, arg_0), null, 8, null));
            }
            list = CargoSyncTaskKt.access$deduplicateProjects(CargoSyncTaskKt.access$chooseAndAttachStdlib((List)destination$iv$iv));
        }
        List refreshedProjects = list;
        return refreshedProjects;
    }

    private final BuildProgressDescriptor createSyncProgressDescriptor(ProgressIndicator progress) {
        ThreeState threeState;
        BuildContentDescriptor buildContentDescriptor2 = new BuildContentDescriptor(null, null, new JComponent(){}, RsBundle.INSTANCE.message("build.event.title.cargo", new Object[0]));
        buildContentDescriptor2.setActivateToolWindowWhenFailed(this.isExplicitReload);
        buildContentDescriptor2.setActivateToolWindowWhenAdded(false);
        if (this.isExplicitReload) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            threeState = RustProjectSettingsServiceKt.getRustSettings(project).getAutoShowErrorsInEditor();
        } else {
            threeState = ThreeState.NO;
        }
        buildContentDescriptor2.setNavigateToError(threeState);
        AnAction refreshAction = ActionManager.getInstance().getAction("Cargo.RefreshCargoProject");
        Object object = new Object();
        String string = RsBundle.INSTANCE.message("build.event.title.cargo", new Object[0]);
        String string2 = this.getProject().getBasePath();
        Intrinsics.checkNotNull((Object)string2);
        DefaultBuildDescriptor descriptor = new DefaultBuildDescriptor(object, string, string2, System.currentTimeMillis()).withContentDescriptor(() -> CargoSyncTask.createSyncProgressDescriptor$lambda$0(buildContentDescriptor2)).withRestartAction(refreshAction).withRestartAction((AnAction)new StopAction(progress));
        return new BuildProgressDescriptor(descriptor){
            final /* synthetic */ DefaultBuildDescriptor $descriptor;
            {
                this.$descriptor = $descriptor;
            }

            public String getTitle() {
                String string = this.$descriptor.getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
                return string;
            }

            public BuildDescriptor getBuildDescriptor() {
                DefaultBuildDescriptor defaultBuildDescriptor = this.$descriptor;
                Intrinsics.checkNotNull((Object)defaultBuildDescriptor);
                return (BuildDescriptor)defaultBuildDescriptor;
            }
        };
    }

    private final TaskResult<RustcInfo> fetchRustcInfo(SyncContext context) {
        return context.runWithChildProgress(RsBundle.INSTANCE.message("progress.text.getting.toolchain.version", new Object[0]), arg_0 -> CargoSyncTask.fetchRustcInfo$lambda$0(this, context, arg_0));
    }

    private static final BuildProgress doRun$lambda$0$0(BuildProgress it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2;
    }

    private static final CargoProjectWithStdlib doRun$lambda$0$1(CargoProjectImpl $cargoProject, CargoSyncTask this$0, RsToolchainBase $toolchain, ProgressIndicator $indicator, BuildProgress $syncProgress, BuildProgress childProgress) {
        CargoProjectWithStdlib cargoProjectWithStdlib;
        Intrinsics.checkNotNullParameter((Object)childProgress, (String)"childProgress");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($cargoProject.getRootDirPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object[] objectArray = new Object[]{$cargoProject.getRootDirPath(), $cargoProject.getPresentableName()};
            childProgress.message(RsBundle.INSTANCE.message("tooltip.project.directory.does.not.exist", new Object[0]), RsBundle.INSTANCE.message("build.event.message.project.directory.does.not.exist.consider.detaching.project.from.cargo.tool.window", objectArray), MessageEvent.Kind.ERROR, null);
            Object[] objectArray2 = new Object[]{$cargoProject.getRootDirPath(), $cargoProject.getPresentableName()};
            CargoProject.UpdateStatus.UpdateFailed stdlibStatus = new CargoProject.UpdateStatus.UpdateFailed(RsBundle.INSTANCE.message("tooltip.project.directory.does.not.exist", new Object[0]), RsBundle.INSTANCE.message("build.event.message.project.directory.does.not.exist.consider.detaching.project.from.cargo.tool.window", objectArray2));
            cargoProjectWithStdlib = new CargoProjectWithStdlib(CargoProjectImpl.copy$default($cargoProject, null, null, null, null, null, null, null, stdlibStatus, null, null, 895, null), null);
        } else {
            Project project = this$0.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object object = $syncProgress.getId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
            SyncContext context = new SyncContext(project, $cargoProject, $toolchain, $indicator, object, (BuildProgress<BuildProgressDescriptor>)childProgress);
            TaskResult<RustcInfo> rustcInfoResult = this$0.fetchRustcInfo(context);
            TaskResult.Ok ok = rustcInfoResult instanceof TaskResult.Ok ? (TaskResult.Ok)rustcInfoResult : null;
            RustcInfo rustcInfo = ok != null ? (RustcInfo)ok.getValue() : null;
            Project project2 = this$0.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            TaskResult taskResult = CargoSyncTaskKt.access$fetchFullProjectDescription(context, rustcInfo, RustProjectSettingsServiceKt.getRustSettings(project2).getRustcTarget());
            TaskResult workspaceResult = TaskResultKt.component1(taskResult);
            TaskResult projectDescriptionStatusResult = TaskResultKt.component2(taskResult);
            CargoProjectImpl cargoProjectWithRustcInfoAndWorkspace = $cargoProject.withRustcInfo(rustcInfoResult).withWorkspace(workspaceResult, true).withProjectDescriptionStatus(projectDescriptionStatusResult);
            long startFetchingStdlib = System.currentTimeMillis();
            TaskResult stdlib = CargoSyncTaskKt.access$fetchStdlib(context, cargoProjectWithRustcInfoAndWorkspace, rustcInfo);
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Finished fetching stdlib in " + (System.currentTimeMillis() - startFetchingStdlib) + " ms", e$iv);
            }
            cargoProjectWithStdlib = new CargoProjectWithStdlib(cargoProjectWithRustcInfoAndWorkspace, stdlib);
        }
        return cargoProjectWithStdlib;
    }

    private static final RunContentDescriptor createSyncProgressDescriptor$lambda$0(BuildContentDescriptor $buildContentDescriptor) {
        return (RunContentDescriptor)$buildContentDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private static final TaskResult fetchRustcInfo$lambda$0(CargoSyncTask this$0, SyncContext $context, SyncContext childContext) {
        Object t;
        void $this$unwrapOrElse$iv;
        Intrinsics.checkNotNullParameter((Object)childContext, (String)"childContext");
        RsToolchainBase toolchain2 = childContext.getToolchain();
        if (!toolchain2.looksLikeValidToolchain()) {
            String location = toolchain2.getPresentableLocation();
            Object[] objectArray = new Object[]{location};
            return new TaskResult.Err(RsBundle.INSTANCE.message("invalid.rust.toolchain.02", objectArray), null, 2, null);
        }
        Path workingDirectory = childContext.getOldCargoProject().getRootDirPath();
        RustcVersionProcessAdapter listener2 = new RustcVersionProcessAdapter(childContext);
        Rustc rustc = RustcKt.rustc(toolchain2);
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsResult<RustcVersion, RsProcessExecutionException> rsResult = rustc.queryVersion(project, workingDirectory, (ProcessListener)listener2);
        boolean $i$f$unwrapOrElse = false;
        void var9_11 = $this$unwrapOrElse$iv;
        if (var9_11 instanceof RsResult.Ok) {
            t = ((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        } else if (var9_11 instanceof RsResult.Err) {
            RsProcessExecutionException it2 = (RsProcessExecutionException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
            boolean bl = false;
            LOG.warn("Failed to fetch rustc version", (Throwable)it2);
            String string = RsBundle.INSTANCE.message("build.event.title.failed.to.fetch.rustc.version", new Object[0]);
            String string2 = it2.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            CargoSyncTaskKt.access$error($context, string, string2);
            t = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        RustcVersion rustcVersion = (RustcVersion)t;
        LOG.info("Rust version/Rustc version/Rust toolchain version: " + rustcVersion);
        String string = (String)UnitTestUtilService.Companion.cached$default(UnitTestUtilService.Companion, rustcVersion, null, null, () -> CargoSyncTask.fetchRustcInfo$lambda$0$1(toolchain2, this$0, workingDirectory), 6, null);
        if (string == null) {
            return new TaskResult.Err(RsBundle.INSTANCE.message("failed.to.get.project.sysroot", new Object[0]), null, 2, null);
        }
        String sysroot = string;
        String rustupActiveToolchain = (String)UnitTestUtilService.Companion.cached$default(UnitTestUtilService.Companion, rustcVersion, null, null, () -> CargoSyncTask.fetchRustcInfo$lambda$0$2(toolchain2, workingDirectory, this$0), 6, null);
        List rustcTargets = (List)UnitTestUtilService.Companion.cached$default(UnitTestUtilService.Companion, rustcVersion, null, null, () -> CargoSyncTask.fetchRustcInfo$lambda$0$3(toolchain2, this$0, workingDirectory), 6, null);
        RustcVersion rustcVersion2 = rustcVersion;
        ProcMacroExpanderExecutable procMacroExpanderExecutable = Companion.findProcMacroExpanderExecutable(toolchain2, sysroot, (SemVer)(rustcVersion2 != null ? rustcVersion2.getSemver() : null));
        RustcInfo info = new RustcInfo(toolchain2, sysroot, rustcVersion, rustupActiveToolchain, rustcTargets, rustcVersion, procMacroExpanderExecutable);
        return new TaskResult.Ok<RustcInfo>(info);
    }

    private static final String fetchRustcInfo$lambda$0$1(RsToolchainBase $toolchain, CargoSyncTask this$0, Path $workingDirectory) {
        Rustc rustc = RustcKt.rustc($toolchain);
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return rustc.getSysroot(project, $workingDirectory);
    }

    private static final String fetchRustcInfo$lambda$0$2(RsToolchainBase $toolchain, Path $workingDirectory, CargoSyncTask this$0) {
        String string;
        Rustup rustup = RustupKt.rustup($toolchain, $workingDirectory);
        if (rustup != null) {
            Project project = this$0.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            string = rustup.activeToolchainName(project);
        } else {
            string = null;
        }
        return string;
    }

    private static final List fetchRustcInfo$lambda$0$3(RsToolchainBase $toolchain, CargoSyncTask this$0, Path $workingDirectory) {
        Rustc rustc = RustcKt.rustc($toolchain);
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return rustc.getRustcTargets(project, $workingDirectory);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CargoSyncTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        MIN_RUSTC_VERSION_WITH_EXPANDER_VERSION_CHECK = ToolchainUtilKt.parseSemVer("1.70.0");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\r*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/rust/cargo/project/model/impl/CargoSyncTask$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MIN_RUSTC_VERSION_WITH_EXPANDER_VERSION_CHECK", "Lcom/intellij/util/text/SemVer;", "findProcMacroExpanderExecutable", "Lorg/rust/cargo/project/model/ProcMacroExpanderExecutable;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "sysroot", "", "rustcVersionSemver", "distributionId", "getDistributionId", "(Lorg/rust/cargo/toolchain/RsToolchainBase;)Ljava/lang/String;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCargoSyncTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoSyncTask.kt\norg/rust/cargo/project/model/impl/CargoSyncTask$Companion\n+ 2 RsResult.kt\norg/rust/stdext/RsResultKt\n*L\n1#1,685:1\n60#2,4:686\n*S KotlinDebug\n*F\n+ 1 CargoSyncTask.kt\norg/rust/cargo/project/model/impl/CargoSyncTask$Companion\n*L\n246#1:686,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @Nullable
        public final ProcMacroExpanderExecutable findProcMacroExpanderExecutable(@NotNull RsToolchainBase toolchain2, @NotNull String sysroot, @Nullable SemVer rustcVersionSemver) {
            void $this$unwrapOrElse$iv;
            Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
            Intrinsics.checkNotNullParameter((Object)sysroot, (String)"sysroot");
            if (rustcVersionSemver == null) {
                return null;
            }
            Path path = ProcMacroServerPool.Companion.findExpanderExecutablePath(toolchain2, sysroot);
            if (path == null) {
                return null;
            }
            Path procMacroExpanderPath = path;
            boolean needsVersionCheck = rustcVersionSemver.compareTo(MIN_RUSTC_VERSION_WITH_EXPANDER_VERSION_CHECK) >= 0;
            RsResult<HashCode, IOException> rsResult = HashCode.Companion.ofFile(procMacroExpanderPath);
            boolean $i$f$unwrapOrElse = false;
            void var9_8 = $this$unwrapOrElse$iv;
            if (!(var9_8 instanceof RsResult.Ok)) {
                if (var9_8 instanceof RsResult.Err) {
                    IOException it2 = (IOException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                    boolean bl = false;
                    LOG.warn("Cannot calculate hash code of `" + procMacroExpanderPath + "` file", (Throwable)it2);
                    return null;
                }
                throw new NoWhenBranchMatchedException();
            }
            HashCode procMacroExpanderHashCode = (HashCode)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
            return new ProcMacroExpanderExecutable(this.getDistributionId(toolchain2), needsVersionCheck, procMacroExpanderPath, procMacroExpanderHashCode);
        }

        private final String getDistributionId(RsToolchainBase $this$distributionId) {
            return $this$distributionId instanceof RsWslToolchain ? ((RsWslToolchain)$this$distributionId).getWslPath().getDistributionId() : "Local";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/rust/cargo/project/model/impl/CargoSyncTask$StopAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.rustrover.core"})
    private static final class StopAction
    extends DumbAwareAction {
        @NotNull
        private final ProgressIndicator progress;

        public StopAction(@NotNull ProgressIndicator progress) {
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            super(StopAction::_init_$lambda$0, AllIcons.Actions.Suspend);
            this.progress = progress;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(this.progress.isRunning());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.progress.cancel();
        }

        private static final String _init_$lambda$0() {
            return ActionsBundle.message((String)"action.Stop.text", (Object[])new Object[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0001\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ6\u0010 \u001a\b\u0012\u0004\u0012\u0002H\"0!\"\u0004\b\u0000\u0010\"2\b\b\u0001\u0010#\u001a\u00020$2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\"0!0&J\u0010\u0010'\u001a\u00020(2\b\b\u0001\u0010)\u001a\u00020$J\u0016\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001dJ\u000e\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u001dJ\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0007H\u00c6\u0003J\t\u00102\u001a\u00020\tH\u00c6\u0003J\t\u00103\u001a\u00020\u0001H\u00c6\u0003J\u000f\u00104\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003JK\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00109\u001a\u00020\u001dH\u00d6\u0001J\t\u0010:\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019\u00a8\u0006;"}, d2={"Lorg/rust/cargo/project/model/impl/CargoSyncTask$SyncContext;", "", "project", "Lcom/intellij/openapi/project/Project;", "oldCargoProject", "Lorg/rust/cargo/project/model/impl/CargoProjectImpl;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "buildId", "syncProgress", "Lcom/intellij/build/progress/BuildProgress;", "Lcom/intellij/build/progress/BuildProgressDescriptor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/cargo/project/model/impl/CargoProjectImpl;Lorg/rust/cargo/toolchain/RsToolchainBase;Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/Object;Lcom/intellij/build/progress/BuildProgress;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getOldCargoProject", "()Lorg/rust/cargo/project/model/impl/CargoProjectImpl;", "getToolchain", "()Lorg/rust/cargo/toolchain/RsToolchainBase;", "getProgress", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "getBuildId", "()Ljava/lang/Object;", "getSyncProgress", "()Lcom/intellij/build/progress/BuildProgress;", "allCratesNum", "", "id", "getId", "runWithChildProgress", "Lorg/rust/openapiext/TaskResult;", "T", "title", "", "action", "Lkotlin/Function1;", "withProgressText", "", "text", "changeFetchProgress", "complete", "pending", "changeDownloadingProgress", "cratesLeft", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "intellij.rustrover.core"})
    public static final class SyncContext {
        @NotNull
        private final Project project;
        @NotNull
        private final CargoProjectImpl oldCargoProject;
        @NotNull
        private final RsToolchainBase toolchain;
        @NotNull
        private final ProgressIndicator progress;
        @NotNull
        private final Object buildId;
        @NotNull
        private final BuildProgress<BuildProgressDescriptor> syncProgress;
        private int allCratesNum;

        public SyncContext(@NotNull Project project, @NotNull CargoProjectImpl oldCargoProject, @NotNull RsToolchainBase toolchain2, @NotNull ProgressIndicator progress, @NotNull Object buildId, @NotNull BuildProgress<BuildProgressDescriptor> syncProgress) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)oldCargoProject, (String)"oldCargoProject");
            Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            Intrinsics.checkNotNullParameter(syncProgress, (String)"syncProgress");
            this.project = project;
            this.oldCargoProject = oldCargoProject;
            this.toolchain = toolchain2;
            this.progress = progress;
            this.buildId = buildId;
            this.syncProgress = syncProgress;
            this.allCratesNum = 1;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final CargoProjectImpl getOldCargoProject() {
            return this.oldCargoProject;
        }

        @NotNull
        public final RsToolchainBase getToolchain() {
            return this.toolchain;
        }

        @NotNull
        public final ProgressIndicator getProgress() {
            return this.progress;
        }

        @NotNull
        public final Object getBuildId() {
            return this.buildId;
        }

        @NotNull
        public final BuildProgress<BuildProgressDescriptor> getSyncProgress() {
            return this.syncProgress;
        }

        @NotNull
        public final Object getId() {
            Object object = this.syncProgress.getId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
            return object;
        }

        @NotNull
        public final <T> TaskResult<T> runWithChildProgress(@NlsContexts.ProgressText @NotNull String title, @NotNull Function1<? super SyncContext, ? extends TaskResult<? extends T>> action2) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            this.progress.checkCanceled();
            this.progress.setText(title);
            return (TaskResult)CargoSyncTaskKt.access$runWithChildProgress(this.syncProgress, title, arg_0 -> SyncContext.runWithChildProgress$lambda$0(this, arg_0), action2, SyncContext::runWithChildProgress$lambda$1);
        }

        public final void withProgressText(@NlsContexts.ProgressText @NlsContexts.ProgressTitle @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.progress.setText(text);
            this.syncProgress.progress(text);
        }

        public final void changeFetchProgress(int complete, int pending) {
            this.progress.setFraction((double)complete / (double)(complete + pending) * 0.5);
        }

        public final void changeDownloadingProgress(int cratesLeft) {
            if (cratesLeft > this.allCratesNum) {
                this.allCratesNum = cratesLeft;
            }
            this.progress.setFraction((double)(this.allCratesNum - cratesLeft) / (double)this.allCratesNum * 0.5 + 0.5);
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final CargoProjectImpl component2() {
            return this.oldCargoProject;
        }

        @NotNull
        public final RsToolchainBase component3() {
            return this.toolchain;
        }

        @NotNull
        public final ProgressIndicator component4() {
            return this.progress;
        }

        @NotNull
        public final Object component5() {
            return this.buildId;
        }

        @NotNull
        public final BuildProgress<BuildProgressDescriptor> component6() {
            return this.syncProgress;
        }

        @NotNull
        public final SyncContext copy(@NotNull Project project, @NotNull CargoProjectImpl oldCargoProject, @NotNull RsToolchainBase toolchain2, @NotNull ProgressIndicator progress, @NotNull Object buildId, @NotNull BuildProgress<BuildProgressDescriptor> syncProgress) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)oldCargoProject, (String)"oldCargoProject");
            Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            Intrinsics.checkNotNullParameter(syncProgress, (String)"syncProgress");
            return new SyncContext(project, oldCargoProject, toolchain2, progress, buildId, syncProgress);
        }

        public static /* synthetic */ SyncContext copy$default(SyncContext syncContext, Project project, CargoProjectImpl cargoProjectImpl, RsToolchainBase rsToolchainBase, ProgressIndicator progressIndicator, Object object, BuildProgress buildProgress, int n, Object object2) {
            if ((n & 1) != 0) {
                project = syncContext.project;
            }
            if ((n & 2) != 0) {
                cargoProjectImpl = syncContext.oldCargoProject;
            }
            if ((n & 4) != 0) {
                rsToolchainBase = syncContext.toolchain;
            }
            if ((n & 8) != 0) {
                progressIndicator = syncContext.progress;
            }
            if ((n & 0x10) != 0) {
                object = syncContext.buildId;
            }
            if ((n & 0x20) != 0) {
                buildProgress = syncContext.syncProgress;
            }
            return syncContext.copy(project, cargoProjectImpl, rsToolchainBase, progressIndicator, object, buildProgress);
        }

        @NotNull
        public String toString() {
            return "SyncContext(project=" + this.project + ", oldCargoProject=" + this.oldCargoProject + ", toolchain=" + this.toolchain + ", progress=" + this.progress + ", buildId=" + this.buildId + ", syncProgress=" + this.syncProgress + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + this.oldCargoProject.hashCode();
            result2 = result2 * 31 + this.toolchain.hashCode();
            result2 = result2 * 31 + this.progress.hashCode();
            result2 = result2 * 31 + this.buildId.hashCode();
            result2 = result2 * 31 + this.syncProgress.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SyncContext)) {
                return false;
            }
            SyncContext syncContext = (SyncContext)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)syncContext.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.oldCargoProject, (Object)syncContext.oldCargoProject)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.toolchain, (Object)syncContext.toolchain)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.progress, (Object)syncContext.progress)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.buildId, (Object)syncContext.buildId)) {
                return false;
            }
            return Intrinsics.areEqual(this.syncProgress, syncContext.syncProgress);
        }

        private static final SyncContext runWithChildProgress$lambda$0(SyncContext this$0, BuildProgress it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return SyncContext.copy$default(this$0, null, null, null, null, null, it2, 31, null);
        }

        private static final Unit runWithChildProgress$lambda$1(BuildProgress childProgress, TaskResult result2) {
            Intrinsics.checkNotNullParameter((Object)childProgress, (String)"childProgress");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            TaskResult taskResult = result2;
            if (taskResult instanceof TaskResult.Ok) {
                v0 = childProgress.finish();
            } else if (taskResult instanceof TaskResult.Err) {
                String string = ((TaskResult.Err)result2).getReason();
                String string2 = ((TaskResult.Err)result2).getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                childProgress.message(string, string2, MessageEvent.Kind.ERROR, null);
                v0 = childProgress.fail();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return Unit.INSTANCE;
        }
    }
}

