/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.model.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.experiments.RsExperiments;
import org.rust.lang.RsFileType;
import org.rust.lang.core.macros.proc.ProcMacroApplicationService;
import org.rust.toml.UtilKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J \u0010\n\u001a\u00020\r*\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002J \u0010\n\u001a\u00020\r*\u00020\u00112\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/cargo/project/model/impl/CargoSettingsFilesService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "settingsFilesCache", "", "", "Lorg/rust/cargo/project/model/impl/CargoSettingsFilesService$SettingFileType;", "collectSettingsFiles", "useCache", "", "", "Lorg/rust/cargo/project/model/CargoProject;", "out", "", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "Companion", "SettingFileType", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoSettingsFilesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoSettingsFilesService.kt\norg/rust/cargo/project/model/impl/CargoSettingsFilesService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n774#2:136\n865#2,2:137\n1#3:139\n*S KotlinDebug\n*F\n+ 1 CargoSettingsFilesService.kt\norg/rust/cargo/project/model/impl/CargoSettingsFilesService\n*L\n58#1:136\n58#1:137,2\n*E\n"})
public final class CargoSettingsFilesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private volatile Map<String, ? extends SettingFileType> settingsFilesCache;
    @NotNull
    private static final List<String> IMPLICIT_TARGET_FILES;
    @NotNull
    private static final List<String> IMPLICIT_TARGET_DIRS;

    public CargoSettingsFilesService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Map<String, SettingFileType> collectSettingsFiles(boolean useCache) {
        Map<String, SettingFileType> map2;
        if (useCache) {
            map2 = this.settingsFilesCache;
            if (map2 == null) {
                map2 = this.collectSettingsFiles();
            }
        } else {
            map2 = this.collectSettingsFiles();
        }
        return map2;
    }

    private final Map<String, SettingFileType> collectSettingsFiles() {
        Map result2 = new LinkedHashMap();
        for (CargoProject cargoProject : CargoProjectServiceKt.getCargoProjects(this.project).getAllProjects()) {
            this.collectSettingsFiles(cargoProject, (Map<String, SettingFileType>)result2);
        }
        this.settingsFilesCache = result2;
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void collectSettingsFiles(CargoProject $this$collectSettingsFiles, Map<String, SettingFileType> out) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String rootPath;
        VirtualFile virtualFile = $this$collectSettingsFiles.getRootDir();
        String string = rootPath = virtualFile != null ? virtualFile.getPath() : null;
        if (rootPath != null) {
            out.put(rootPath + "/Cargo.toml", SettingFileType.CONFIG);
            out.put(rootPath + "/Cargo.lock", SettingFileType.CONFIG);
            out.put(rootPath + "/rust-toolchain", SettingFileType.CONFIG);
            out.put(rootPath + "/rust-toolchain.toml", SettingFileType.CONFIG);
            out.put(rootPath + "/.cargo/config", SettingFileType.CONFIG);
            out.put(rootPath + "/.cargo/config.toml", SettingFileType.CONFIG);
        }
        CargoWorkspace cargoWorkspace = $this$collectSettingsFiles.getWorkspace();
        Collection collection = cargoWorkspace != null ? cargoWorkspace.getPackages() : null;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CargoWorkspace.Package it2 = (CargoWorkspace.Package)element$iv$iv;
            boolean bl = false;
            if (!(it2.getOrigin() == PackageOrigin.WORKSPACE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (CargoWorkspace.Package pkg : (List)destination$iv$iv) {
            this.collectSettingsFiles(pkg, out);
        }
    }

    private final void collectSettingsFiles(CargoWorkspace.Package $this$collectSettingsFiles, Map<String, SettingFileType> out) {
        VirtualFile buildScriptFile;
        VirtualFile virtualFile = $this$collectSettingsFiles.getContentRoot();
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        out.put(root.getPath() + "/Cargo.toml", SettingFileType.CONFIG);
        Set<VirtualFile> implicitTargets = Companion.collectImplicitTargets($this$collectSettingsFiles);
        for (VirtualFile target : implicitTargets) {
            out.put(target.getPath(), SettingFileType.IMPLICIT_TARGET);
        }
        if (RsExperiments.INSTANCE.getEVALUATE_BUILD_SCRIPTS().asBoolean() && (buildScriptFile = UtilKt.findBuildScriptFile($this$collectSettingsFiles)) != null) {
            out.put(buildScriptFile.getPath(), SettingFileType.CONFIG);
        }
        if (ProcMacroApplicationService.Companion.isAnyEnabled()) {
            VirtualFile procMacroLibCrateRoot;
            Object v1;
            block6: {
                Iterable iterable = $this$collectSettingsFiles.getTargets();
                for (Object t : iterable) {
                    CargoWorkspace.Target it2 = (CargoWorkspace.Target)t;
                    boolean bl = false;
                    if (!it2.getKind().isProcMacro()) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            CargoWorkspace.Target target = v1;
            Object object = procMacroLibCrateRoot = target != null ? target.getCrateRoot() : null;
            if (procMacroLibCrateRoot != null) {
                out.put(procMacroLibCrateRoot.getPath(), SettingFileType.CONFIG);
            }
        }
    }

    static {
        Object[] objectArray = new String[]{"src/main.rs", "src/lib.rs"};
        IMPLICIT_TARGET_FILES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"src/bin", "examples", "tests", "benches"};
        IMPLICIT_TARGET_DIRS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/cargo/project/model/impl/CargoSettingsFilesService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/rust/cargo/project/model/impl/CargoSettingsFilesService;", "project", "Lcom/intellij/openapi/project/Project;", "IMPLICIT_TARGET_FILES", "", "", "IMPLICIT_TARGET_DIRS", "collectImplicitTargets", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "pkg", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCargoSettingsFilesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoSettingsFilesService.kt\norg/rust/cargo/project/model/impl/CargoSettingsFilesService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,135:1\n30#2,2:136\n*S KotlinDebug\n*F\n+ 1 CargoSettingsFilesService.kt\norg/rust/cargo/project/model/impl/CargoSettingsFilesService$Companion\n*L\n94#1:136,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CargoSettingsFilesService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CargoSettingsFilesService> serviceClass$iv = CargoSettingsFilesService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CargoSettingsFilesService)object;
        }

        @NotNull
        public final Set<VirtualFile> collectImplicitTargets(@NotNull CargoWorkspace.Package pkg) {
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            VirtualFile virtualFile = pkg.getContentRoot();
            if (virtualFile == null) {
                return SetsKt.emptySet();
            }
            VirtualFile root = virtualFile;
            HashSet out = new HashSet();
            for (String targetFileName : IMPLICIT_TARGET_FILES) {
                Collection collection = out;
                VirtualFile virtualFile2 = root.findFileByRelativePath(targetFileName);
                if (virtualFile2 == null) continue;
                collection.add(virtualFile2);
            }
            VirtualFile buildScriptFile = UtilKt.findBuildScriptFile(pkg);
            if (buildScriptFile != null) {
                ((Collection)out).add(buildScriptFile);
            }
            for (String targetDirName : IMPLICIT_TARGET_DIRS) {
                VirtualFile[] virtualFileArray;
                VirtualFile dir;
                if (root.findFileByRelativePath(targetDirName) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)dir.getChildren(), (String)"getChildren(...)");
                for (VirtualFile file : virtualFileArray) {
                    if (file.isDirectory() || !Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)RsFileType.INSTANCE))) continue;
                    ((Collection)out).add(file);
                }
            }
            return out;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/project/model/impl/CargoSettingsFilesService$SettingFileType;", "", "<init>", "(Ljava/lang/String;I)V", "CONFIG", "IMPLICIT_TARGET", "intellij.rustrover.core"})
    public static final class SettingFileType
    extends Enum<SettingFileType> {
        public static final /* enum */ SettingFileType CONFIG = new SettingFileType();
        public static final /* enum */ SettingFileType IMPLICIT_TARGET = new SettingFileType();
        private static final /* synthetic */ SettingFileType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SettingFileType[] values() {
            return (SettingFileType[])$VALUES.clone();
        }

        public static SettingFileType valueOf(String value) {
            return Enum.valueOf(SettingFileType.class, value);
        }

        @NotNull
        public static EnumEntries<SettingFileType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = settingFileTypeArray = new SettingFileType[]{SettingFileType.CONFIG, SettingFileType.IMPLICIT_TARGET};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

