/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.model.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.LightDirectoryIndex;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.CargoWorkspaceKt;
import org.rust.openapiext.RsPluginDisposable;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0016J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/rust/cargo/project/model/impl/CargoPackageIndex;", "Lorg/rust/cargo/project/model/CargoProjectsService$CargoProjectsListener;", "project", "Lcom/intellij/openapi/project/Project;", "service", "Lorg/rust/cargo/project/model/CargoProjectsService;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/cargo/project/model/CargoProjectsService;)V", "indices", "", "Lorg/rust/cargo/project/model/CargoProject;", "Lcom/intellij/util/indexing/LightDirectoryIndex;", "Ljava/util/Optional;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "indexDisposable", "Lcom/intellij/openapi/Disposable;", "cargoProjectsUpdated", "", "projects", "", "findPackageForFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "resetIndex", "intellij.rustrover.core"})
public final class CargoPackageIndex
implements CargoProjectsService.CargoProjectsListener {
    @NotNull
    private final Project project;
    @NotNull
    private final CargoProjectsService service;
    @NotNull
    private final Map<CargoProject, LightDirectoryIndex<Optional<CargoWorkspace.Package>>> indices;
    @Nullable
    private Disposable indexDisposable;

    public CargoPackageIndex(@NotNull Project project, @NotNull CargoProjectsService service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.project = project;
        this.service = service;
        this.indices = new IdentityHashMap();
        this.project.getMessageBus().connect(RsPluginDisposable.Companion.getInstance(this.project)).subscribe(CargoProjectsService.Companion.getCARGO_PROJECTS_TOPIC(), (Object)this);
    }

    @Override
    public void cargoProjectsUpdated(@NotNull CargoProjectsService service, @NotNull Collection<? extends CargoProject> projects) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        UtilsKt.checkWriteAccessAllowed();
        this.resetIndex();
        Disposable disposable = Disposer.newDisposable((String)"CargoPackageIndexDisposable");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        Disposer.register((Disposable)RsPluginDisposable.Companion.getInstance(this.project), (Disposable)disposable2);
        for (CargoProject cargoProject : projects) {
            CargoWorkspace cargoWorkspace = cargoProject.getWorkspace();
            Collection collection = cargoWorkspace != null ? cargoWorkspace.getPackages() : null;
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Collection packages = collection;
            Map<CargoProject, LightDirectoryIndex<Optional<CargoWorkspace.Package>>> map2 = this.indices;
            LightDirectoryIndex lightDirectoryIndex = new LightDirectoryIndex(disposable2, Optional.empty(), arg_0 -> CargoPackageIndex.cargoProjectsUpdated$lambda$1(arg_0 -> CargoPackageIndex.cargoProjectsUpdated$lambda$0(packages, arg_0), arg_0));
            map2.put(cargoProject, (LightDirectoryIndex<Optional<CargoWorkspace.Package>>)lightDirectoryIndex);
        }
        this.indexDisposable = disposable2;
    }

    @Nullable
    public final CargoWorkspace.Package findPackageForFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        UtilsKt.checkReadAccessAllowed();
        CargoProject cargoProject = this.service.findProjectForFile(file);
        if (cargoProject == null) {
            return null;
        }
        CargoProject cargoProject2 = cargoProject;
        Object object = this.indices.get(cargoProject2);
        return object != null && (object = (Optional)object.getInfoForFile(file)) != null ? (CargoWorkspace.Package)((Optional)object).orElse(null) : null;
    }

    private final void resetIndex() {
        Disposable disposable = this.indexDisposable;
        if (disposable != null) {
            Disposer.dispose((Disposable)disposable);
        }
        this.indexDisposable = null;
        this.indices.clear();
    }

    private static final Unit cargoProjectsUpdated$lambda$0(Collection $packages, LightDirectoryIndex index) {
        for (CargoWorkspace.Package pkg : $packages) {
            Optional<CargoWorkspace.Package> info;
            Intrinsics.checkNotNullExpressionValue(Optional.of(pkg), (String)"of(...)");
            index.putInfo(pkg.getContentRoot(), info);
            index.putInfo(pkg.getOutDir(), info);
            for (VirtualFile additionalRoot : CargoWorkspaceKt.additionalRoots(pkg)) {
                index.putInfo(additionalRoot, info);
            }
            for (CargoWorkspace.Target target : pkg.getTargets()) {
                VirtualFile virtualFile = target.getCrateRoot();
                index.putInfo((VirtualFile)(virtualFile != null ? virtualFile.getParent() : null), info);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void cargoProjectsUpdated$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

