/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.model.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.stdext.CollectionsKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0015\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/rust/cargo/project/model/impl/CargoEventService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "metadataCallTimestamps", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/nio/file/Path;", "", "onMetadataCall", "", "projectDirectory", "extractTimestamp", "(Ljava/nio/file/Path;)Ljava/lang/Long;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoEventService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoEventService.kt\norg/rust/cargo/project/model/impl/CargoEventService\n+ 2 Collections.kt\norg/rust/stdext/CollectionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n150#2:51\n1634#3,3:52\n*S KotlinDebug\n*F\n+ 1 CargoEventService.kt\norg/rust/cargo/project/model/impl/CargoEventService\n*L\n35#1:51\n35#1:52,3\n*E\n"})
public final class CargoEventService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<Path, Long> metadataCallTimestamps;

    public CargoEventService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.metadataCallTimestamps = new ConcurrentHashMap();
        project.getMessageBus().connect().subscribe(CargoProjectsService.Companion.getCARGO_PROJECTS_TOPIC(), (arg_0, arg_1) -> CargoEventService._init_$lambda$0(this, arg_0, arg_1));
    }

    public final void onMetadataCall(@NotNull Path projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        ((Map)this.metadataCallTimestamps).put(projectDirectory, System.currentTimeMillis());
    }

    @Nullable
    public final Long extractTimestamp(@NotNull Path projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        return (Long)this.metadataCallTimestamps.remove(projectDirectory);
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda$0(CargoEventService this$0, CargoProjectsService cargoProjectsService, Collection projects) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cargoProjectsService, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)projects, (String)"projects");
        Iterable $this$mapToSet$iv = projects;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new HashSet(CollectionsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10)));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            CargoProject cargoProject = (CargoProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getRootDirPath());
        }
        Set projectDirs = (Set)destination$iv$iv;
        this$0.metadataCallTimestamps.keySet().retainAll(projectDirs);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/cargo/project/model/impl/CargoEventService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/rust/cargo/project/model/impl/CargoEventService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCargoEventService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoEventService.kt\norg/rust/cargo/project/model/impl/CargoEventService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,50:1\n30#2,2:51\n*S KotlinDebug\n*F\n+ 1 CargoEventService.kt\norg/rust/cargo/project/model/impl/CargoEventService$Companion\n*L\n47#1:51,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CargoEventService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CargoEventService> serviceClass$iv = CargoEventService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CargoEventService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

