/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.CfgOptions;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.FeatureState;
import org.rust.cargo.project.workspace.PackageFeature;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 02\u00020\u0001:\u00040123J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H&J \u0010\u0017\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\b0\u0019\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0007H&J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\bH&J \u0010!\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\b0\u00190\u00182\b\b\u0002\u0010\"\u001a\u00020\fH&J\u0016\u0010#\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\b0\u00190\u0018H&J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140%H&J&\u0010&\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+H&J&\u0010,\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\b2\u0014\u0010-\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010/0\u00180.H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0012\u0010\u0011\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00064\u00c0\u0006\u0001"}, d2={"Lorg/rust/cargo/project/model/CargoProjectsService;", "", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "allProjects", "", "Lorg/rust/cargo/project/model/CargoProject;", "getAllProjects", "()Ljava/util/Collection;", "hasAtLeastOneValidProject", "", "getHasAtLeastOneValidProject", "()Z", "initialized", "getInitialized", "isRefreshInProgress", "findProjectForFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findPackageForFile", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "attachCargoProject", "Ljava/util/concurrent/CompletableFuture;", "", "manifest", "Ljava/nio/file/Path;", "attachCargoProjects", "", "manifests", "detachCargoProject", "cargoProject", "refreshAllProjects", "isExplicitReload", "discoverAndRefresh", "suggestManifests", "Lkotlin/sequences/Sequence;", "modifyFeatures", "features", "", "Lorg/rust/cargo/project/workspace/PackageFeature;", "newState", "Lorg/rust/cargo/project/workspace/FeatureState;", "modifyCfgOptions", "action", "Lkotlin/Function0;", "Lorg/rust/cargo/CfgOptions;", "Companion", "CargoProjectsListener", "CargoProjectsRefreshListener", "CargoRefreshStatus", "intellij.rustrover.core"})
public interface CargoProjectsService {
    @NotNull
    public static final Companion Companion = org.rust.cargo.project.model.CargoProjectsService$Companion.$$INSTANCE;

    @NotNull
    public Project getProject();

    @NotNull
    public Collection<CargoProject> getAllProjects();

    public boolean getHasAtLeastOneValidProject();

    public boolean getInitialized();

    public boolean isRefreshInProgress();

    @Nullable
    public CargoProject findProjectForFile(@NotNull VirtualFile var1);

    @Nullable
    public CargoWorkspace.Package findPackageForFile(@NotNull VirtualFile var1);

    @Nullable
    public CompletableFuture<? extends List<CargoProject>> attachCargoProject(@NotNull Path var1);

    public void attachCargoProjects(@NotNull Collection<? extends Path> var1);

    public void detachCargoProject(@NotNull CargoProject var1);

    @NotNull
    public CompletableFuture<? extends List<CargoProject>> refreshAllProjects(boolean var1);

    public static /* synthetic */ CompletableFuture refreshAllProjects$default(CargoProjectsService cargoProjectsService, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: refreshAllProjects");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return cargoProjectsService.refreshAllProjects(bl);
    }

    @NotNull
    public CompletableFuture<? extends List<CargoProject>> discoverAndRefresh();

    @NotNull
    public Sequence<VirtualFile> suggestManifests();

    public void modifyFeatures(@NotNull CargoProject var1, @NotNull Set<PackageFeature> var2, @NotNull FeatureState var3);

    public void modifyCfgOptions(@NotNull CargoProject var1, @NotNull Function0<? extends CompletableFuture<CfgOptions>> var2);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/rust/cargo/project/model/CargoProjectsService$CargoProjectsListener;", "", "cargoProjectsUpdated", "", "service", "Lorg/rust/cargo/project/model/CargoProjectsService;", "projects", "", "Lorg/rust/cargo/project/model/CargoProject;", "intellij.rustrover.core"})
    public static interface CargoProjectsListener {
        public void cargoProjectsUpdated(@NotNull CargoProjectsService var1, @NotNull Collection<? extends CargoProject> var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0016J(\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lorg/rust/cargo/project/model/CargoProjectsService$CargoProjectsRefreshListener;", "", "onRefreshStarted", "", "isImplicitReload", "", "onRefreshFinished", "status", "Lorg/rust/cargo/project/model/CargoProjectsService$CargoRefreshStatus;", "projects", "", "Lorg/rust/cargo/project/model/CargoProject;", "intellij.rustrover.core"})
    public static interface CargoProjectsRefreshListener {
        default public void onRefreshStarted(boolean isImplicitReload) {
        }

        public static /* synthetic */ void onRefreshStarted$default(CargoProjectsRefreshListener cargoProjectsRefreshListener, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onRefreshStarted");
            }
            if ((n & 1) != 0) {
                bl = false;
            }
            cargoProjectsRefreshListener.onRefreshStarted(bl);
        }

        default public void onRefreshFinished(@NotNull CargoRefreshStatus status, @NotNull List<? extends CargoProject> projects, boolean isImplicitReload) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
        }

        public static /* synthetic */ void onRefreshFinished$default(CargoProjectsRefreshListener cargoProjectsRefreshListener, CargoRefreshStatus cargoRefreshStatus, List list, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onRefreshFinished");
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            cargoProjectsRefreshListener.onRefreshFinished(cargoRefreshStatus, list, bl);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/rust/cargo/project/model/CargoProjectsService$CargoRefreshStatus;", "", "<init>", "(Ljava/lang/String;I)V", "SUCCESS", "FAILURE", "CANCEL", "intellij.rustrover.core"})
    public static final class CargoRefreshStatus
    extends Enum<CargoRefreshStatus> {
        public static final /* enum */ CargoRefreshStatus SUCCESS = new CargoRefreshStatus();
        public static final /* enum */ CargoRefreshStatus FAILURE = new CargoRefreshStatus();
        public static final /* enum */ CargoRefreshStatus CANCEL = new CargoRefreshStatus();
        private static final /* synthetic */ CargoRefreshStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CargoRefreshStatus[] values() {
            return (CargoRefreshStatus[])$VALUES.clone();
        }

        public static CargoRefreshStatus valueOf(String value) {
            return Enum.valueOf(CargoRefreshStatus.class, value);
        }

        @NotNull
        public static EnumEntries<CargoRefreshStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cargoRefreshStatusArray = new CargoRefreshStatus[]{CargoRefreshStatus.SUCCESS, CargoRefreshStatus.FAILURE, CargoRefreshStatus.CANCEL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/rust/cargo/project/model/CargoProjectsService$Companion;", "", "<init>", "()V", "CARGO_PROJECTS_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/rust/cargo/project/model/CargoProjectsService$CargoProjectsListener;", "getCARGO_PROJECTS_TOPIC", "()Lcom/intellij/util/messages/Topic;", "CARGO_PROJECTS_REFRESH_TOPIC", "Lorg/rust/cargo/project/model/CargoProjectsService$CargoProjectsRefreshListener;", "getCARGO_PROJECTS_REFRESH_TOPIC", "findCargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @Topic.ProjectLevel
        @NotNull
        private static final Topic<CargoProjectsListener> CARGO_PROJECTS_TOPIC;
        @Topic.ProjectLevel
        @NotNull
        private static final Topic<CargoProjectsRefreshListener> CARGO_PROJECTS_REFRESH_TOPIC;

        private Companion() {
        }

        @NotNull
        public final Topic<CargoProjectsListener> getCARGO_PROJECTS_TOPIC() {
            return CARGO_PROJECTS_TOPIC;
        }

        @NotNull
        public final Topic<CargoProjectsRefreshListener> getCARGO_PROJECTS_REFRESH_TOPIC() {
            return CARGO_PROJECTS_REFRESH_TOPIC;
        }

        @Nullable
        public final CargoProject findCargoProject(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
                return null;
            }
            PsiFile file = psiFile;
            return CargoProjectServiceKt.getCargoProjects(project2).findProjectForFile((VirtualFile)file);
        }

        static {
            $$INSTANCE = new Companion();
            CARGO_PROJECTS_TOPIC = new Topic("cargo projects changes", CargoProjectsListener.class);
            CARGO_PROJECTS_REFRESH_TOPIC = new Topic("Cargo refresh", CargoProjectsRefreshListener.class);
        }
    }
}

