/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.model;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.CargoConstants;
import org.rust.cargo.project.autolink.UnlinkedProjectActivity;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.model.ContentEntryWrapper;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.toolchain.CargoCommandLine;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.RustupKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\b\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\bH\u0002\u001a\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\b\u001a\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u0010*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n\u001a\u0012\u0010\u001a\u001a\u00020\u0010*\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\n\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0011\u0010\u001e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"cargoProjects", "Lorg/rust/cargo/project/model/CargoProjectsService;", "Lcom/intellij/openapi/project/Project;", "getCargoProjects", "(Lcom/intellij/openapi/project/Project;)Lorg/rust/cargo/project/model/CargoProjectsService;", "cargoProjectsIfCreated", "getCargoProjectsIfCreated", "isGeneratedFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "guessAndSetupRustProject", "project", "explicitRequest", "createConfigurations", "discoverToolchain", "", "onToolchainDiscovered", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "attachProjectWithRunConfiguration", "manifest", "Ljava/nio/file/Path;", "createRunConfigurationsForOpenedProject", "", "Lorg/rust/cargo/project/model/CargoProject;", "setup", "Lcom/intellij/openapi/roots/ContentEntry;", "contentRoot", "Lorg/rust/cargo/project/model/ContentEntryWrapper;", "isNewProjectModelImportEnabled", "()Z", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoProjectService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoProjectService.kt\norg/rust/cargo/project/model/CargoProjectServiceKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n30#2,2:340\n58#2:342\n1#3:343\n1#3:354\n1#3:369\n1617#4,9:344\n1869#4:353\n1870#4:355\n1626#4:356\n1869#4,2:357\n1617#4,9:359\n1869#4:368\n1870#4:370\n1626#4:371\n1869#4,2:372\n*S KotlinDebug\n*F\n+ 1 CargoProjectService.kt\norg/rust/cargo/project/model/CargoProjectServiceKt\n*L\n113#1:340,2\n115#1:342\n308#1:354\n311#1:369\n308#1:344,9\n308#1:353\n308#1:355\n308#1:356\n308#1:357,2\n311#1:359,9\n311#1:368\n311#1:370\n311#1:371\n311#1:372,2\n*E\n"})
public final class CargoProjectServiceKt {
    @NotNull
    public static final CargoProjectsService getCargoProjects(@NotNull Project $this$cargoProjects) {
        Intrinsics.checkNotNullParameter((Object)$this$cargoProjects, (String)"<this>");
        ComponentManager $this$service$iv = (ComponentManager)$this$cargoProjects;
        boolean $i$f$service = false;
        Class<CargoProjectsService> serviceClass$iv = CargoProjectsService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (CargoProjectsService)object;
    }

    @Nullable
    public static final CargoProjectsService getCargoProjectsIfCreated(@NotNull Project $this$cargoProjectsIfCreated) {
        Intrinsics.checkNotNullParameter((Object)$this$cargoProjectsIfCreated, (String)"<this>");
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)$this$cargoProjectsIfCreated;
        boolean $i$f$serviceIfCreated = false;
        return (CargoProjectsService)$this$serviceIfCreated$iv.getServiceIfCreated(CargoProjectsService.class);
    }

    public static final boolean isGeneratedFile(@NotNull CargoProjectsService $this$isGeneratedFile, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CargoWorkspace.Package package_ = $this$isGeneratedFile.findPackageForFile(file);
        if (package_ == null || (package_ = package_.getOutDir()) == null) {
            return false;
        }
        CargoWorkspace.Package outDir = package_;
        return VfsUtil.isAncestor((VirtualFile)outDir, (VirtualFile)file, (boolean)false);
    }

    public static final boolean guessAndSetupRustProject(@NotNull Project project, boolean explicitRequest, boolean createConfigurations) {
        RsToolchainBase toolchain2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!explicitRequest) {
            boolean bl = false;
            String key = "org.rust.cargo.project.model.PROJECT_DISCOVERY";
            PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
            boolean alreadyTried = properties.getBoolean(key);
            properties.setValue(key, true);
            boolean alreadyTried2 = alreadyTried;
            if (alreadyTried2) {
                return false;
            }
        }
        if ((toolchain2 = RustProjectSettingsServiceKt.getRustSettings(project).getToolchain()) == null || !toolchain2.looksLikeValidToolchain()) {
            CargoProjectServiceKt.discoverToolchain(project, createConfigurations);
            return true;
        }
        if (!CargoProjectServiceKt.getCargoProjects(project).getHasAtLeastOneValidProject()) {
            CompletableFuture<? extends List<CargoProject>> futureProjects = CargoProjectServiceKt.getCargoProjects(project).discoverAndRefresh();
            if (createConfigurations) {
                futureProjects.thenApply(arg_0 -> CargoProjectServiceKt.guessAndSetupRustProject$lambda$2(arg_0 -> CargoProjectServiceKt.guessAndSetupRustProject$lambda$1(project, arg_0), arg_0));
            }
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean guessAndSetupRustProject$default(Project project, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return CargoProjectServiceKt.guessAndSetupRustProject(project, bl, bl2);
    }

    private static final void discoverToolchain(Project project, boolean createConfigurations) {
        if (UnlinkedProjectActivity.Helper.INSTANCE.isEnabledIn(project)) {
            return;
        }
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        Path projectPath = virtualFile != null ? UtilsKt.getPathAsPath(virtualFile) : null;
        RsToolchainBase rsToolchainBase = RsToolchainBase.Companion.suggest(projectPath);
        if (rsToolchainBase == null) {
            return;
        }
        RsToolchainBase toolchain2 = rsToolchainBase;
        ActionsKt.invokeLater$default(null, () -> CargoProjectServiceKt.discoverToolchain$lambda$0(project, toolchain2, createConfigurations), (int)1, null);
    }

    public static final void onToolchainDiscovered(@NotNull Project project, @NotNull RsToolchainBase toolchain2, boolean createConfigurations) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
        if (!RustupKt.isRustupAvailable(toolchain2)) {
            Object[] objectArray = new Object[]{toolchain2.getPresentableLocation()};
            org.rust.ide.notifications.UtilsKt.showBalloon$default(project, "rustup.not.available", RsBundle.INSTANCE.message("notification.content.using.path.to.cargo", objectArray), NotificationType.INFORMATION, null, 8, null);
        }
        CompletableFuture<? extends List<CargoProject>> futureProjects = CargoProjectServiceKt.getCargoProjects(project).discoverAndRefresh();
        if (createConfigurations) {
            futureProjects.thenApply(arg_0 -> CargoProjectServiceKt.onToolchainDiscovered$lambda$1(arg_0 -> CargoProjectServiceKt.onToolchainDiscovered$lambda$0(project, arg_0), arg_0));
        }
    }

    public static final void attachProjectWithRunConfiguration(@NotNull Project project, @NotNull Path manifest) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
            CompletableFuture<? extends List<CargoProject>> completableFuture = CargoProjectServiceKt.getCargoProjects(project).attachCargoProject(manifest);
            if (completableFuture == null) break block0;
            completableFuture.thenApply(arg_0 -> CargoProjectServiceKt.attachProjectWithRunConfiguration$lambda$1(arg_0 -> CargoProjectServiceKt.attachProjectWithRunConfiguration$lambda$0(project, arg_0), arg_0));
        }
    }

    private static final void createRunConfigurationsForOpenedProject(Project project, List<? extends CargoProject> cargoProjects) {
        RunManagerEx runManagerEx = RunManagerEx.getInstanceEx((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)runManagerEx, (String)"getInstanceEx(...)");
        RunManagerEx runManager = runManagerEx;
        boolean isConfigurationSelected = false;
        for (CargoProject cargoProject : cargoProjects) {
            Object object = cargoProject.getWorkspace();
            if (object == null || (object = object.getPackages()) == null) continue;
            Object packages = object;
            Iterator iterator2 = packages.iterator();
            while (iterator2.hasNext()) {
                CargoWorkspace.Target target;
                Object v2;
                CargoWorkspace.Package pkg;
                block3: {
                    pkg = (CargoWorkspace.Package)iterator2.next();
                    if (pkg.getOrigin() != PackageOrigin.WORKSPACE) continue;
                    Iterable iterable = pkg.getTargets();
                    for (Object t : iterable) {
                        CargoWorkspace.Target it2 = (CargoWorkspace.Target)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getKind(), (Object)CargoWorkspace.TargetKind.Bin.INSTANCE)) continue;
                        v2 = t;
                        break block3;
                    }
                    v2 = null;
                }
                if ((CargoWorkspace.Target)v2 == null) continue;
                CargoCommandLine commandLine = CargoCommandLine.Companion.forTarget$default(CargoCommandLine.Companion, target, "run", null, null, null, false, 60, null);
                RunnerAndConfigurationSettings configuration = commandLine.createRunConfiguration(runManager, "Run " + target.getName());
                runManager.addConfiguration(configuration);
                if (isConfigurationSelected || !Intrinsics.areEqual((Object)pkg.getContentRootPath(), (Object)cargoProject.getRootDirPath())) continue;
                runManager.setSelectedConfiguration(configuration);
                isConfigurationSelected = true;
            }
            CargoCommandLine commandLine = CargoCommandLine.Companion.forProject$default(CargoCommandLine.Companion, cargoProject, "test", CollectionsKt.listOf((Object)"--workspace"), false, null, null, null, 120, null);
            RunnerAndConfigurationSettings configuration = commandLine.createRunConfiguration(runManager, "Test " + cargoProject.getPresentableName());
            runManager.addConfiguration(configuration);
            if (isConfigurationSelected) continue;
            runManager.setSelectedConfiguration(configuration);
            isConfigurationSelected = true;
        }
    }

    public static final void setup(@NotNull ContentEntry $this$setup, @NotNull VirtualFile contentRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$setup, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        CargoProjectServiceKt.setup(new ContentEntryWrapper($this$setup), contentRoot);
    }

    public static final void setup(@NotNull ContentEntryWrapper $this$setup, @NotNull VirtualFile contentRoot) {
        block4: {
            Object it$iv$iv;
            boolean bl;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterator $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$setup, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
            Function1 makeVfsUrl = arg_0 -> CargoProjectServiceKt.setup$lambda$0(contentRoot, arg_0);
            Iterable $this$mapNotNull$iv = CargoConstants.ProjectLayout.INSTANCE.getSources();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl2 = false;
                if (makeVfsUrl.invoke(element$iv$iv) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl3 = false;
                $this$setup.addSourceFolder(it2, false);
            }
            $this$mapNotNull$iv = CargoConstants.ProjectLayout.INSTANCE.getTests();
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl2 = false;
                if (makeVfsUrl.invoke(element$iv$iv) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it3 = (String)element$iv;
                boolean bl4 = false;
                $this$setup.addSourceFolder(it3, true);
            }
            String string = (String)makeVfsUrl.invoke((Object)"target");
            if (string == null) break block4;
            String p0 = string;
            boolean bl5 = false;
            $this$setup.addExcludeFolder(p0);
        }
    }

    public static final boolean isNewProjectModelImportEnabled() {
        return Registry.Companion.is("org.rust.cargo.new.auto.import", false);
    }

    private static final Unit guessAndSetupRustProject$lambda$1(Project $project, List it2) {
        Intrinsics.checkNotNull((Object)it2);
        CargoProjectServiceKt.createRunConfigurationsForOpenedProject($project, it2);
        return Unit.INSTANCE;
    }

    private static final Unit guessAndSetupRustProject$lambda$2(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit discoverToolchain$lambda$0(Project $project, RsToolchainBase $toolchain, boolean $createConfigurations) {
        if ($project.isDisposed()) {
            return Unit.INSTANCE;
        }
        RsToolchainBase oldToolchain = RustProjectSettingsServiceKt.getRustSettings($project).getToolchain();
        if (oldToolchain != null && oldToolchain.looksLikeValidToolchain()) {
            return Unit.INSTANCE;
        }
        ActionsKt.runWriteAction(() -> CargoProjectServiceKt.discoverToolchain$lambda$0$0($project, $toolchain));
        CargoProjectServiceKt.onToolchainDiscovered($project, $toolchain, $createConfigurations);
        return Unit.INSTANCE;
    }

    private static final Unit discoverToolchain$lambda$0$0(Project $project, RsToolchainBase $toolchain) {
        RustProjectSettingsServiceKt.getRustSettings($project).modify(arg_0 -> CargoProjectServiceKt.discoverToolchain$lambda$0$0$0($toolchain, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit discoverToolchain$lambda$0$0$0(RsToolchainBase $toolchain, RustProjectSettingsService.RustProjectSettings it2) {
        Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
        it2.setToolchain($toolchain);
        return Unit.INSTANCE;
    }

    private static final Unit onToolchainDiscovered$lambda$0(Project $project, List it2) {
        Intrinsics.checkNotNull((Object)it2);
        CargoProjectServiceKt.createRunConfigurationsForOpenedProject($project, it2);
        return Unit.INSTANCE;
    }

    private static final Unit onToolchainDiscovered$lambda$1(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit attachProjectWithRunConfiguration$lambda$0(Project $project, List it2) {
        Intrinsics.checkNotNull((Object)it2);
        CargoProjectServiceKt.createRunConfigurationsForOpenedProject($project, it2);
        return Unit.INSTANCE;
    }

    private static final Unit attachProjectWithRunConfiguration$lambda$1(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final String setup$lambda$0(VirtualFile $contentRoot, String dirName) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        VirtualFile virtualFile = $contentRoot.findChild(dirName);
        return virtualFile != null ? virtualFile.getUrl() : null;
    }
}

