/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.model;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.autolink.UnlinkedProjectsUtils;
import org.rust.cargo.project.model.AttachCargoProjectActionKt;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectActionBase;
import org.rust.cargo.project.model.CargoProjectChooserDescriptor;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\t*\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/rust/cargo/project/model/AttachCargoProjectAction;", "Lorg/rust/cargo/project/model/CargoProjectActionBase;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "chooseFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "event", "update", "isActionEnabled", "", "findCargoToml", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nAttachCargoProjectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachCargoProjectAction.kt\norg/rust/cargo/project/model/AttachCargoProjectAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class AttachCargoProjectAction
extends CargoProjectActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DataKey<VirtualFile> MOCK_CHOSEN_FILE_KEY = DataKey.Companion.create("MOCK_CHOSEN_FILE_KEY");

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        UtilsKt.saveAllDocuments$default(false, 1, null);
        switch (e.getPlace()) {
            case "Cargo Toolbar": {
                virtualFile = this.chooseFile(project2, e);
                break;
            }
            case "RsEditorNotificationPanel": {
                VirtualFile file = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
                virtualFile = file;
                if (virtualFile != null) {
                    VirtualFile it2 = virtualFile;
                    boolean bl = false;
                    VirtualFile virtualFile2 = UnlinkedProjectsUtils.INSTANCE.findTargetCargoToml(project2, it2);
                    virtualFile = virtualFile2;
                    if (virtualFile2 != null) break;
                }
                virtualFile = this.chooseFile(project2, e);
                break;
            }
            default: {
                virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
            }
        }
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        VirtualFile virtualFile3 = this.findCargoToml(file);
        if (virtualFile3 == null) {
            return;
        }
        VirtualFile cargoToml = virtualFile3;
        if (CargoProjectServiceKt.getCargoProjects(project2).attachCargoProject(UtilsKt.getPathAsPath(cargoToml)) == null) {
            Messages.showErrorDialog((Project)project2, (String)RsBundle.INSTANCE.message("dialog.message.this.cargo.package.already.part.attached.workspace", new Object[0]), (String)RsBundle.INSTANCE.message("dialog.title.unable.to.attach.cargo.project", new Object[0]));
        }
    }

    private final VirtualFile chooseFile(Project project, AnActionEvent event) {
        if (!UtilsKt.isUnitTestMode()) {
            FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser((FileChooserDescriptor)CargoProjectChooserDescriptor.INSTANCE, project, null);
            Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"createFileChooser(...)");
            FileChooserDialog chooser = fileChooserDialog;
            VirtualFile[] virtualFileArray = chooser.choose(project, new VirtualFile[0]);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"choose(...)");
            return (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFileArray);
        }
        return (VirtualFile)event.getData(MOCK_CHOSEN_FILE_KEY);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        e.getPresentation().setEnabledAndVisible(this.isActionEnabled(e, project2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isActionEnabled(AnActionEvent e, Project project) {
        VirtualFile file;
        String string = e.getPlace();
        switch (string.hashCode()) {
            case 1393842903: {
                if (string.equals("Cargo Toolbar")) return true;
                break;
            }
            case 2045157963: {
                if (!string.equals("RsEditorNotificationPanel")) break;
                return true;
            }
        }
        if (DumbService.Companion.isDumb(project)) {
            return false;
        }
        VirtualFile virtualFile = file = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile == null) return false;
        if ((virtualFile2 = this.findCargoToml(virtualFile2)) == null) {
            return false;
        }
        VirtualFile cargoToml = virtualFile2;
        boolean bl = Companion.canBeAttached(project, cargoToml);
        return bl;
    }

    private final VirtualFile findCargoToml(VirtualFile $this$findCargoToml) {
        Object object;
        if ($this$findCargoToml.isDirectory()) {
            object = $this$findCargoToml.findChild("Cargo.toml");
        } else {
            VirtualFile virtualFile;
            VirtualFile it2 = virtualFile = $this$findCargoToml;
            boolean bl = false;
            object = AttachCargoProjectActionKt.isCargoToml(it2) ? virtualFile : null;
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/rust/cargo/project/model/AttachCargoProjectAction$Companion;", "", "<init>", "()V", "MOCK_CHOSEN_FILE_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getMOCK_CHOSEN_FILE_KEY$annotations", "getMOCK_CHOSEN_FILE_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "canBeAttached", "", "project", "Lcom/intellij/openapi/project/Project;", "cargoToml", "isCargoTomlAttached", "containsWorkspaceManifest", "Lorg/rust/cargo/project/model/CargoProject;", "path", "Ljava/nio/file/Path;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nAttachCargoProjectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachCargoProjectAction.kt\norg/rust/cargo/project/model/AttachCargoProjectAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1761#2,3:136\n1761#2,3:139\n1761#2,3:142\n*S KotlinDebug\n*F\n+ 1 AttachCargoProjectAction.kt\norg/rust/cargo/project/model/AttachCargoProjectAction$Companion\n*L\n107#1:136,3\n109#1:139,3\n115#1:142,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<VirtualFile> getMOCK_CHOSEN_FILE_KEY() {
            return MOCK_CHOSEN_FILE_KEY;
        }

        @VisibleForTesting
        public static /* synthetic */ void getMOCK_CHOSEN_FILE_KEY$annotations() {
        }

        public final boolean canBeAttached(@NotNull Project project, @NotNull VirtualFile cargoToml) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cargoToml, (String)"cargoToml");
            if (!AttachCargoProjectActionKt.isCargoToml(cargoToml)) {
                return false;
            }
            if (!ProjectFileIndex.getInstance((Project)project).isInContent(cargoToml)) {
                return false;
            }
            return !this.isCargoTomlAttached(project, cargoToml);
        }

        public final boolean isCargoTomlAttached(@NotNull Project project, @NotNull VirtualFile cargoToml) {
            boolean bl;
            block8: {
                CargoProject it2;
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                Path path;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)cargoToml, (String)"cargoToml");
                    path = UtilsKt.getPathAsPath(cargoToml);
                    $this$any$iv = CargoProjectServiceKt.getCargoProjects(project).getAllProjects();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it2 = (CargoProject)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it2.getManifest(), (Object)path)) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return true;
                }
                $this$any$iv = CargoProjectServiceKt.getCargoProjects(project).getAllProjects();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it2 = (CargoProject)element$iv;
                        boolean bl4 = false;
                        if (!Companion.containsWorkspaceManifest(it2, path)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean containsWorkspaceManifest(CargoProject $this$containsWorkspaceManifest, Path path) {
            boolean bl;
            block4: {
                void $this$any$iv;
                Path rootDir = path.getParent();
                CargoWorkspace cargoWorkspace = $this$containsWorkspaceManifest.getWorkspace();
                Collection collection = cargoWorkspace != null ? cargoWorkspace.getPackages() : null;
                if (collection == null) {
                    collection = CollectionsKt.emptyList();
                }
                Iterable iterable = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CargoWorkspace.Package it2 = (CargoWorkspace.Package)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it2.getContentRootPath(), (Object)rootDir)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

