/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.configurable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.configurable.RsConfigurableBase;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.settings.ui.RustProjectSettingsPanel;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/rust/cargo/project/configurable/RsProjectConfigurable;", "Lorg/rust/cargo/project/configurable/RsConfigurableBase;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "projectDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "rustProjectSettings", "Lorg/rust/cargo/project/settings/ui/RustProjectSettingsPanel;", "getRustProjectSettings", "()Lorg/rust/cargo/project/settings/ui/RustProjectSettingsPanel;", "rustProjectSettings$delegate", "Lkotlin/Lazy;", "createPanelInner", "Lcom/intellij/openapi/ui/DialogPanel;", "disposeUIResources", "", "apply", "getHelpTopic", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsProjectConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsProjectConfigurable.kt\norg/rust/cargo/project/configurable/RsProjectConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class RsProjectConfigurable
extends RsConfigurableBase
implements Configurable.NoScroll {
    private final Path projectDir;
    @NotNull
    private final Lazy rustProjectSettings$delegate;

    /*
     * WARNING - void declaration
     */
    public RsProjectConfigurable(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(project, RsBundle.INSTANCE.message("settings.rust.toolchain.name", new Object[0]), cs);
        RsProjectConfigurable rsProjectConfigurable = this;
        Object object = (CargoProject)CollectionsKt.firstOrNull((Iterable)CargoProjectServiceKt.getCargoProjects(project).getAllProjects());
        if (object == null || (object = object.getRootDir()) == null || (object = UtilsKt.getPathAsPath((VirtualFile)object)) == null) {
            String string = project.getBasePath();
            if (string != null) {
                void p0;
                String string2 = string;
                RsProjectConfigurable rsProjectConfigurable2 = rsProjectConfigurable;
                boolean bl = false;
                Path path = Paths.get((String)p0, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                object = path;
                rsProjectConfigurable = rsProjectConfigurable2;
            } else {
                object = Paths.get(".", new String[0]);
            }
        }
        rsProjectConfigurable.projectDir = object;
        this.rustProjectSettings$delegate = LazyKt.lazy(() -> RsProjectConfigurable.rustProjectSettings_delegate$lambda$0(project, this, cs));
    }

    private final RustProjectSettingsPanel getRustProjectSettings() {
        Lazy lazy = this.rustProjectSettings$delegate;
        return (RustProjectSettingsPanel)lazy.getValue();
    }

    @Override
    @NotNull
    public DialogPanel createPanelInner() {
        DialogPanel dialogPanel;
        DialogPanel it2 = dialogPanel = BuilderKt.panel(arg_0 -> RsProjectConfigurable.createPanelInner$lambda$0(this, arg_0));
        boolean bl = false;
        it2.addPropertyChangeListener("ancestor", arg_0 -> RsProjectConfigurable.createPanelInner$lambda$1$0(this, it2, arg_0));
        return dialogPanel;
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        Disposer.dispose((Disposable)this.getRustProjectSettings());
    }

    public void apply() throws ConfigurationException {
        this.getRustProjectSettings().validateSettings();
        super.apply();
    }

    @NotNull
    public String getHelpTopic() {
        return "rust.settings.toolchain";
    }

    private static final RustProjectSettingsPanel rustProjectSettings_delegate$lambda$0(Project $project, RsProjectConfigurable this$0, CoroutineScope $cs) {
        Path path = this$0.projectDir;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectDir");
        return new RustProjectSettingsPanel($project, path, $cs, null, 8, null);
    }

    private static final Unit createPanelInner$lambda$0(RsProjectConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        RustProjectSettingsService settings = RustProjectSettingsServiceKt.getRustSettings(this$0.getProject());
        RustProjectSettingsService.RustProjectSettings state = ((RustProjectSettingsService.RustProjectSettings)settings.getState()).copy();
        this$0.getRustProjectSettings().attachTo($this$panel);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RsProjectConfigurable.createPanelInner$lambda$0$0(state, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RsProjectConfigurable.createPanelInner$lambda$0$1(state, arg_0), (int)1, null);
        $this$panel.onApply(() -> RsProjectConfigurable.createPanelInner$lambda$0$2(settings, this$0, state));
        $this$panel.onReset(() -> RsProjectConfigurable.createPanelInner$lambda$0$3(settings, this$0));
        $this$panel.onIsModified(() -> RsProjectConfigurable.createPanelInner$lambda$0$4(this$0, settings));
        return Unit.INSTANCE;
    }

    private static final Unit createPanelInner$lambda$0$0(RustProjectSettingsService.RustProjectSettings $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)Cell.comment$default((Cell)$this$row.checkBox(RsBundle.INSTANCE.message("settings.rust.toolchain.expand.macros.checkbox", new Object[0])), (String)RsBundle.INSTANCE.message("settings.rust.toolchain.expand.macros.comment", new Object[0]), (int)0, null, (int)6, null), () -> RsProjectConfigurable.createPanelInner$lambda$0$0$0($state), arg_0 -> RsProjectConfigurable.createPanelInner$lambda$0$0$1($state, arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean createPanelInner$lambda$0$0$0(RustProjectSettingsService.RustProjectSettings $state) {
        return $state.getMacroExpansionEngine() != RustProjectSettingsService.MacroExpansionEngine.DISABLED;
    }

    private static final Unit createPanelInner$lambda$0$0$1(RustProjectSettingsService.RustProjectSettings $state, boolean it2) {
        $state.setMacroExpansionEngine(it2 ? RustProjectSettingsService.MacroExpansionEngine.NEW : RustProjectSettingsService.MacroExpansionEngine.DISABLED);
        return Unit.INSTANCE;
    }

    private static final Unit createPanelInner$lambda$0$1(RustProjectSettingsService.RustProjectSettings $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(RsBundle.INSTANCE.message("settings.rust.toolchain.inject.rust.in.doc.comments.checkbox", new Object[0])), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)$state){

            public Object get() {
                return ((RustProjectSettingsService.RustProjectSettings)((Object)this.receiver)).getDoctestInjectionEnabled();
            }

            public void set(Object value) {
                ((RustProjectSettingsService.RustProjectSettings)((Object)this.receiver)).setDoctestInjectionEnabled((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanelInner$lambda$0$2(RustProjectSettingsService $settings, RsProjectConfigurable this$0, RustProjectSettingsService.RustProjectSettings $state) {
        $settings.modify(arg_0 -> RsProjectConfigurable.createPanelInner$lambda$0$2$0(this$0, $state, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanelInner$lambda$0$2$0(RsProjectConfigurable this$0, RustProjectSettingsService.RustProjectSettings $state, RustProjectSettingsService.RustProjectSettings it2) {
        Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
        it2.setToolchain(this$0.getRustProjectSettings().getData().getToolchain());
        it2.setExplicitPathToStdlib(this$0.getRustProjectSettings().getData().getExplicitPathToStdlib());
        it2.setMacroExpansionEngine($state.getMacroExpansionEngine());
        it2.setDoctestInjectionEnabled($state.getDoctestInjectionEnabled());
        it2.setEnvs(MapsKt.toMutableMap(this$0.getRustProjectSettings().getData().getEnvs()));
        return Unit.INSTANCE;
    }

    private static final Unit createPanelInner$lambda$0$3(RustProjectSettingsService $settings, RsProjectConfigurable this$0) {
        RsToolchainBase rsToolchainBase = $settings.getToolchain();
        if (rsToolchainBase == null) {
            rsToolchainBase = RsToolchainBase.Companion.suggest(this$0.projectDir);
        }
        RustProjectSettingsPanel.Data newData = new RustProjectSettingsPanel.Data(rsToolchainBase, $settings.getExplicitPathToStdlib(), $settings.getEnvs());
        if (!Intrinsics.areEqual((Object)this$0.getRustProjectSettings().getData(), (Object)newData)) {
            this$0.getRustProjectSettings().setData(newData);
        }
        return Unit.INSTANCE;
    }

    private static final boolean createPanelInner$lambda$0$4(RsProjectConfigurable this$0, RustProjectSettingsService $settings) {
        RustProjectSettingsPanel.Data data2 = this$0.getRustProjectSettings().getData();
        RsToolchainBase rsToolchainBase = data2.getToolchain();
        RsToolchainBase rsToolchainBase2 = $settings.getToolchain();
        return !Intrinsics.areEqual((Object)(rsToolchainBase != null ? rsToolchainBase.getLocation() : null), (Object)(rsToolchainBase2 != null ? rsToolchainBase2.getLocation() : null)) || !Intrinsics.areEqual((Object)data2.getExplicitPathToStdlib(), (Object)$settings.getExplicitPathToStdlib()) || !Intrinsics.areEqual(data2.getEnvs(), $settings.getEnvs());
    }

    private static final void createPanelInner$lambda$1$0(RsProjectConfigurable this$0, DialogPanel $it, PropertyChangeEvent propertyChangeEvent) {
        RustProjectSettingsPanel rustProjectSettingsPanel = this$0.getRustProjectSettings();
        ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)$it));
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        rustProjectSettingsPanel.start(modalityState);
    }
}

