/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.autolink;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.autolink.CargoProjectCandidate;
import org.rust.cargo.project.autolink.WorkspaceData;
import org.rust.cargo.project.model.AttachCargoProjectAction;
import org.rust.openapiext.UtilsKt;
import org.rust.toml.UtilKt;
import org.rust.toml.psi.PropertiesManipulatorsKt;
import org.rust.toml.psi.TomlPropertyValue;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"mapToData", "", "Lorg/rust/cargo/project/autolink/CargoProjectCandidate;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "findWorkspace", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nUnlinkedProjectsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnlinkedProjectsUtils.kt\norg/rust/cargo/project/autolink/UnlinkedProjectsUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n1#2:228\n1563#3:229\n1634#3,3:230\n1761#3,3:233\n*S KotlinDebug\n*F\n+ 1 UnlinkedProjectsUtils.kt\norg/rust/cargo/project/autolink/UnlinkedProjectsUtilsKt\n*L\n173#1:229\n173#1:230,3\n149#1:233,3\n*E\n"})
public final class UnlinkedProjectsUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<CargoProjectCandidate> mapToData(@NotNull List<? extends VirtualFile> $this$mapToData, @NotNull Project project) {
        Path basePath;
        Path path;
        Path path2;
        Intrinsics.checkNotNullParameter($this$mapToData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        UtilsKt.checkReadAccessAllowed();
        Map workspacesMap = new LinkedHashMap();
        List freeProjects = new ArrayList();
        Object object = $this$mapToData.iterator();
        while (object.hasNext()) {
            Object object2;
            VirtualFile tomlFile = object.next();
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(tomlFile);
            TomlFile psiFile2 = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
            if (psiFile2 == null) continue;
            VirtualFile workspace = UnlinkedProjectsUtilsKt.findWorkspace(tomlFile, project);
            if (workspace != null) {
                PsiFile psiFile3 = PsiManager.getInstance((Project)project).findFile(workspace);
                TomlFile workspacePsiFile = psiFile3 instanceof TomlFile ? (TomlFile)psiFile3 : null;
                object2 = workspacesMap.compute(workspace, (arg_0, arg_1) -> UnlinkedProjectsUtilsKt.mapToData$lambda$1((arg_0, arg_1) -> UnlinkedProjectsUtilsKt.mapToData$lambda$0(workspacePsiFile, freeProjects, tomlFile, workspace, arg_0, arg_1), arg_0, arg_1));
                continue;
            }
            object2 = freeProjects.add(tomlFile);
        }
        Object $this$mapToData_u24lambda_u242 = object = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object object3 = ProjectUtil.guessProjectDir((Project)project);
        if (object3 != null && (object3 = object3.getPath()) != null) {
            Object it2 = object3;
            boolean bl2 = false;
            path2 = Path.of((String)it2, new String[0]);
        } else {
            path2 = null;
        }
        Path projectBasePath = path2;
        for (Map.Entry workspace : workspacesMap.entrySet()) {
            void $this$mapTo$iv$iv;
            boolean bl3;
            path = UtilsKt.getPathAsPath((VirtualFile)workspace.getKey());
            if (projectBasePath != null) {
                boolean bl4 = false;
                bl3 = Intrinsics.areEqual((Object)((Object)basePath.relativize(path)).toString(), (Object)"Cargo.toml");
            } else {
                bl3 = false;
            }
            boolean isRootTomlFile = bl3;
            boolean isAttached = isRootTomlFile || AttachCargoProjectAction.Companion.isCargoTomlAttached(project, (VirtualFile)workspace.getKey());
            Iterable $this$map$iv = ((WorkspaceData)workspace.getValue()).getMembers();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(new CargoProjectCandidate.Project(UtilsKt.getPathAsPath((VirtualFile)it3), AttachCargoProjectAction.Companion.isCargoTomlAttached(project, (VirtualFile)it3)));
            }
            List members = (List)destination$iv$iv;
            $this$mapToData_u24lambda_u242.add(new CargoProjectCandidate.Workspace(path, isAttached, members));
        }
        for (VirtualFile freeProject : freeProjects) {
            boolean bl6;
            path = UtilsKt.getPathAsPath(freeProject);
            if (projectBasePath != null) {
                boolean bl7 = false;
                bl6 = Intrinsics.areEqual((Object)((Object)basePath.relativize(path)).toString(), (Object)"Cargo.toml");
            } else {
                bl6 = false;
            }
            boolean isRootTomlFile = bl6;
            boolean isAttached = isRootTomlFile || AttachCargoProjectAction.Companion.isCargoTomlAttached(project, freeProject);
            $this$mapToData_u24lambda_u242.add(new CargoProjectCandidate.Project(path, isAttached));
        }
        return CollectionsKt.build((List)object);
    }

    @Nullable
    public static final VirtualFile findWorkspace(@NotNull VirtualFile $this$findWorkspace, @NotNull Project project) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)$this$findWorkspace, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        UtilsKt.checkReadAccessAllowed();
        PsiFile psiFile = UtilsKt.toPsiFile($this$findWorkspace, project);
        if (psiFile != null) {
            PsiFile it2 = psiFile;
            boolean bl = false;
            if (it2 instanceof TomlFile) {
                if (UtilKt.isWorkspace((TomlFile)it2)) {
                    return ((TomlFile)it2).getVirtualFile();
                }
                String[] stringArray = new String[]{"package", "workspace"};
                TomlPropertyValue tomlPropertyValue = PropertiesManipulatorsKt.findPropertyValue((TomlFile)it2, stringArray);
                if (tomlPropertyValue != null) {
                    TomlPropertyValue workspaceProp = tomlPropertyValue;
                    boolean bl2 = false;
                    Object object = workspaceProp instanceof TomlPropertyValue.SimpleValue ? (TomlPropertyValue.SimpleValue)workspaceProp : null;
                    if (object != null && (object = ((TomlPropertyValue.SimpleValue)object).getValue()) != null && (object = UtilKt.getStringValue((TomlValue)object)) != null) {
                        Object workspacePath = object;
                        boolean bl3 = false;
                        VirtualFile virtualFile2 = ((TomlFile)it2).getVirtualFile().getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
                        VirtualFile virtualFile3 = UtilsKt.findFileByMaybeRelativePath(virtualFile2, (String)workspacePath);
                        return virtualFile3 != null ? virtualFile3.findChild("Cargo.toml") : null;
                    }
                }
            }
        }
        if ((virtualFile = $this$findWorkspace.getParent()) == null || (virtualFile = virtualFile.getParent()) == null) {
            return null;
        }
        VirtualFile parent2 = virtualFile;
        while (parent2 != null && ProjectFileIndex.getInstance((Project)project).isInProject(parent2)) {
            VirtualFile cargoToml = parent2.findChild("Cargo.toml");
            parent2 = parent2.getParent();
            if (cargoToml == null) continue;
            PsiFile cargoTomlPsi = UtilsKt.toPsiFile(cargoToml, project);
            TomlFile tomlFile = cargoTomlPsi instanceof TomlFile ? (TomlFile)cargoTomlPsi : null;
            boolean bl = tomlFile != null ? UtilKt.isWorkspace(tomlFile) : false;
            if (!bl) continue;
            return cargoToml;
        }
        return null;
    }

    private static final WorkspaceData mapToData$lambda$0(TomlFile $workspacePsiFile, List $freeProjects, VirtualFile $tomlFile, VirtualFile $workspace, VirtualFile virtualFile, WorkspaceData value) {
        boolean bl;
        Object members;
        List excluded;
        block8: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
            Object object2 = value;
            if (object2 == null || (object2 = ((WorkspaceData)object2).getExclude()) == null) {
                TomlFile tomlFile = $workspacePsiFile;
                object2 = excluded = tomlFile != null ? UtilKt.getWorkspaceExclude(tomlFile) : CollectionsKt.emptyList();
            }
            if ((object = value) == null || (object = ((WorkspaceData)object).getMembers()) == null) {
                object = new ArrayList();
            }
            members = object;
            Iterable $this$any$iv = excluded;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Path it2 = (Path)element$iv;
                    boolean bl2 = false;
                    if (!UtilsKt.getPathAsPath($tomlFile).startsWith(it2)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            $freeProjects.add($tomlFile);
        } else if (!Intrinsics.areEqual((Object)$workspace, (Object)$tomlFile)) {
            members.add($tomlFile);
        }
        return new WorkspaceData((List<VirtualFile>)members, excluded);
    }

    private static final WorkspaceData mapToData$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (WorkspaceData)$tmp0.invoke(p0, p1);
    }
}

