/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.autolink;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ThreeState;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.autolink.AttachProjectsDialog;
import org.rust.cargo.project.autolink.CargoProjectCandidate;
import org.rust.cargo.project.autolink.UnlinkedProjectsUtilsKt;
import org.rust.cargo.project.model.AttachCargoProjectActionKt;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.toolwindow.CargoToolWindow;
import org.rust.ide.inspections.RsDetachedFileInspection;
import org.rust.ide.statistics.RsAttachProjectsCounterUsagesCollector;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.openapiext.UtilsKt;
import org.toml.lang.psi.TomlFileType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0011H\u0086\u0010J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/rust/cargo/project/autolink/UnlinkedProjectsUtils;", "", "<init>", "()V", "ATTACH_PROJECTS_DIALOG_SHOWN", "Lcom/intellij/openapi/util/Key;", "", "ATTACH_PROJECTS_DIALOG_SETTING_KEY", "", "ATTACH_PROJECTS_ON_FILE_OPEN_DIALOG_SETTING_KEY", "cargoProjectsFromIndex", "", "Lorg/rust/cargo/project/autolink/CargoProjectCandidate;", "project", "Lcom/intellij/openapi/project/Project;", "cargoProjectsFromVFS", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showAttachProjectsDialog", "", "cargoProjects", "selectedFile", "Ljava/nio/file/Path;", "findCargoTomlInParents", "file", "checkAttachProjectsDialogShown", "rememberAttachProjectsDialogShown", "findTargetCargoToml", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nUnlinkedProjectsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnlinkedProjectsUtils.kt\norg/rust/cargo/project/autolink/UnlinkedProjectsUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n774#2:228\n865#2,2:229\n*S KotlinDebug\n*F\n+ 1 UnlinkedProjectsUtils.kt\norg/rust/cargo/project/autolink/UnlinkedProjectsUtils\n*L\n61#1:228\n61#1:229,2\n*E\n"})
public final class UnlinkedProjectsUtils {
    @NotNull
    public static final UnlinkedProjectsUtils INSTANCE = new UnlinkedProjectsUtils();
    @NotNull
    private static final Key<Boolean> ATTACH_PROJECTS_DIALOG_SHOWN;
    @NotNull
    public static final String ATTACH_PROJECTS_DIALOG_SETTING_KEY = "org.rust.show.attach.projects.dialog";
    @NotNull
    public static final String ATTACH_PROJECTS_ON_FILE_OPEN_DIALOG_SETTING_KEY = "org.rust.show.attach.projects.dialog.on.file.opened";

    private UnlinkedProjectsUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CargoProjectCandidate> cargoProjectsFromIndex(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        UtilsKt.checkReadAccessAllowed();
        Collection collection = FileTypeIndex.getFiles((FileType)((FileType)TomlFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it2 = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            if (!AttachCargoProjectActionKt.isCargoToml(it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return UnlinkedProjectsUtilsKt.mapToData((List)destination$iv$iv, project);
    }

    @Nullable
    public final Object cargoProjectsFromVFS(@NotNull Project project, @Nullable VirtualFile projectDir, @NotNull Continuation<? super List<? extends CargoProjectCandidate>> $completion) {
        if (projectDir == null) {
            return CollectionsKt.emptyList();
        }
        List files2 = new ArrayList();
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS};
        VirtualFileVisitor.Option[] optionArray2 = optionArray;
        VfsUtil.visitChildrenRecursively((VirtualFile)projectDir, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>((List<VirtualFile>)files2, optionArray2){
            final /* synthetic */ List<VirtualFile> $files;
            {
                this.$files = $files;
                super($super_call_param$1);
            }

            public VirtualFileVisitor.Result visitFileEx(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (file.isDirectory()) {
                    VirtualFileVisitor.Result result2 = VirtualFileVisitor.CONTINUE;
                    Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"CONTINUE");
                    return result2;
                }
                if (AttachCargoProjectActionKt.isCargoToml(file)) {
                    this.$files.add(file);
                }
                VirtualFileVisitor.Result result3 = VirtualFileVisitor.CONTINUE;
                Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"CONTINUE");
                return result3;
            }
        }));
        return CoroutinesKt.readAction(() -> UnlinkedProjectsUtils.cargoProjectsFromVFS$lambda$0(files2, project), $completion);
    }

    public final void showAttachProjectsDialog(@NotNull Project project, @NotNull List<? extends CargoProjectCandidate> cargoProjects, @Nullable Path selectedFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(cargoProjects, (String)"cargoProjects");
        String string = project.getBasePath();
        if (string == null) {
            return;
        }
        Path projectBasePath = Path.of(string, new String[0]);
        Intrinsics.checkNotNull((Object)projectBasePath);
        AttachProjectsDialog dialog = new AttachProjectsDialog(project, projectBasePath, cargoProjects, selectedFile);
        if (dialog.showAndGet() && !((Collection)dialog.getSelectedElements()).isEmpty()) {
            CargoProjectServiceKt.getCargoProjects(project).attachCargoProjects((Collection<? extends Path>)dialog.getSelectedElements());
            CargoToolWindow.Companion.openToolWindow(project);
        }
        RsAttachProjectsCounterUsagesCollector.INSTANCE.logProjectsAttachedPercentage(project, (int)((double)dialog.getSelectedElements().size() / (double)cargoProjects.size() * (double)100));
    }

    public static /* synthetic */ void showAttachProjectsDialog$default(UnlinkedProjectsUtils unlinkedProjectsUtils, Project project, List list, Path path, int n, Object object) {
        if ((n & 4) != 0) {
            path = null;
        }
        unlinkedProjectsUtils.showAttachProjectsDialog(project, list, path);
    }

    @Nullable
    public final VirtualFile findCargoTomlInParents(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile virtualFile;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            UnlinkedProjectsUtils unlinkedProjectsUtils = this;
            while (ProjectFileIndex.getInstance((Project)project).isInContent(file) && file.isDirectory()) {
                virtualFile = file.findChild("Cargo.toml");
                if (virtualFile == null) {
                    VirtualFile virtualFile2;
                    UnlinkedProjectsUtils unlinkedProjectsUtils2 = unlinkedProjectsUtils;
                    Project project2 = project;
                    Intrinsics.checkNotNullExpressionValue((Object)file.getParent(), (String)"getParent(...)");
                    unlinkedProjectsUtils = unlinkedProjectsUtils2;
                    project = project2;
                    file = virtualFile2;
                    continue;
                }
                break block2;
            }
            virtualFile = null;
        }
        return virtualFile;
    }

    public final boolean checkAttachProjectsDialogShown(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Boolean bl = (Boolean)project.getUserData(ATTACH_PROJECTS_DIALOG_SHOWN);
        return bl != null ? bl : false;
    }

    public final void rememberAttachProjectsDialogShown(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.putUserData(ATTACH_PROJECTS_DIALOG_SHOWN, (Object)true);
    }

    @Nullable
    public final VirtualFile findTargetCargoToml(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        UtilsKt.checkReadAccessAllowed();
        if (!file.isValid()) {
            return null;
        }
        if (!ProjectFileIndex.getInstance((Project)project).isInContent(file)) {
            return null;
        }
        if (AttachCargoProjectActionKt.isCargoToml(file)) {
            return file;
        }
        if (RsFileKt.isRustFile(file)) {
            PsiFile psiFile = UtilsKt.toPsiFile(file, project);
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            ThreeState isDetached = RsDetachedFileInspection.Helper.INSTANCE.isFileDetached(psiFile2);
            if (isDetached != ThreeState.NO) {
                VirtualFile virtualFile = file.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
                return this.findCargoTomlInParents(project, virtualFile);
            }
        }
        return null;
    }

    private static final List cargoProjectsFromVFS$lambda$0(List $files, Project $project) {
        return UnlinkedProjectsUtilsKt.mapToData($files, $project);
    }

    static {
        Key key = Key.create((String)"ATTACH_PROJECTS_DIALOG_SHOWN");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ATTACH_PROJECTS_DIALOG_SHOWN = key;
    }
}

