/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.autolink;

import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.autolink.AttachProjectsFilesTree;
import org.rust.cargo.project.autolink.CargoProjectCandidate;
import org.rust.ide.actions.ui.RsUIUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/rust/cargo/project/autolink/AttachProjectsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "projectBasePath", "Ljava/nio/file/Path;", "cargoProjects", "", "Lorg/rust/cargo/project/autolink/CargoProjectCandidate;", "selectedFile", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;Ljava/util/List;Ljava/nio/file/Path;)V", "explanationLabel", "Lcom/intellij/ui/components/JBLabel;", "tree", "Lorg/rust/cargo/project/autolink/AttachProjectsFilesTree;", "value", "selectedElements", "getSelectedElements", "()Ljava/util/List;", "doOKAction", "", "createCenterPanel", "Ljavax/swing/JComponent;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "getDimensionServiceKey", "", "intellij.rustrover.core"})
public final class AttachProjectsDialog
extends DialogWrapper {
    @NotNull
    private final JBLabel explanationLabel;
    @NotNull
    private final AttachProjectsFilesTree tree;
    @NotNull
    private List<? extends Path> selectedElements;

    public AttachProjectsDialog(@NotNull Project project, @NotNull Path projectBasePath, @NotNull List<? extends CargoProjectCandidate> cargoProjects, @Nullable Path selectedFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectBasePath, (String)"projectBasePath");
        Intrinsics.checkNotNullParameter(cargoProjects, (String)"cargoProjects");
        super(project, true);
        this.explanationLabel = new JBLabel(RsBundle.INSTANCE.message("attach.projects.dialog.explanation", new Object[0]), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER);
        this.tree = AttachProjectsFilesTree.Companion.generateTree(projectBasePath, cargoProjects, selectedFile);
        this.selectedElements = CollectionsKt.emptyList();
        this.setTitle(RsBundle.INSTANCE.message("attach.projects.dialog.title", new Object[0]));
        this.setOKButtonText(RsBundle.INSTANCE.message("attach.projects.dialog.ok.button", new Object[0]));
        this.init();
    }

    @NotNull
    public final List<Path> getSelectedElements() {
        return this.selectedElements;
    }

    protected void doOKAction() {
        this.selectedElements = this.tree.getSelectedFiles();
        super.doOKAction();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel;
        JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout(10, 4));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.add((Component)this.explanationLabel, "North");
        $this$createCenterPanel_u24lambda_u240.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.tree))), "Center");
        $this$createCenterPanel_u24lambda_u240.setPreferredSize((Dimension)JBUI.size((int)500, (int)RsUIUtils.INSTANCE.calcPreferredHeightForContentWithScrollPanel(UiSizeUtilKt.getPreferredHeight((JComponent)((JComponent)this.explanationLabel)) + UiSizeUtilKt.getPreferredHeight((JComponent)((JComponent)((Object)this.tree))))));
        return jPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[3];
        Intrinsics.checkNotNullExpressionValue((Object)this.myCancelAction, (String)"myCancelAction");
        Intrinsics.checkNotNullExpressionValue((Object)this.myOKAction, (String)"myOKAction");
        String string = RsBundle.INSTANCE.message("attach.projects.dialog.dont.show.again.button", new Object[0]);
        actionArray[2] = new DialogWrapper.DialogWrapperAction(this, string){
            final /* synthetic */ AttachProjectsDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(ActionEvent p0) {
                AdvancedSettings.Companion.setBoolean("org.rust.show.attach.projects.dialog", false);
                this.this$0.doCancelAction();
            }
        };
        return actionArray;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#org.rust.cargo.project.autolink.AttachProjectsDialog";
    }
}

