/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rust.sql;

import com.intellij.database.dialects.sqlite.sql.SqliteDialect;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.maria.MariaDialect;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.jetbrains.rust.sql.SqlxInjectorKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rust/sql/SqlDialectDetector;", "", "<init>", "()V", "schemaDriverToId", "", "", "Lcom/intellij/sql/dialects/base/SqlLanguageDialectBase;", "kotlin.jvm.PlatformType", "detect", "Lcom/intellij/lang/Language;", "context", "Lcom/intellij/psi/PsiElement;", "intellij.rustrover.sql"})
@SourceDebugExtension(value={"SMAP\nSqlxInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlxInjector.kt\ncom/jetbrains/rust/sql/SqlDialectDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
final class SqlDialectDetector {
    @NotNull
    public static final SqlDialectDetector INSTANCE = new SqlDialectDetector();
    @NotNull
    private static final Map<String, SqlLanguageDialectBase> schemaDriverToId;

    private SqlDialectDetector() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Language detect(@NotNull PsiElement context) {
        Language language;
        String[] stringArray;
        SqlLanguageDialect configuredDialect;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile file = context.getContainingFile().getVirtualFile();
        SqlLanguageDialect sqlLanguageDialect = configuredDialect = (SqlLanguageDialect)SqlDialectMappings.getInstance((Project)project2).getConfiguredMapping(file);
        if (sqlLanguageDialect != null) {
            return (Language)sqlLanguageDialect;
        }
        PsiFile psiFile = context.getContainingFile();
        String databaseUrl = SqlxInjectorKt.access$findDatabaseUrl(project2, psiFile instanceof RsFile ? (RsFile)psiFile : null);
        Object object = databaseUrl;
        Object object2 = object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{":"}), (boolean)false, (int)0, (int)6, null)) != null ? (String)CollectionsKt.first((List)object) : null;
        SqlLanguageDialectBase sqlLanguageDialectBase = object2;
        if (sqlLanguageDialectBase != null) {
            SqlLanguageDialectBase driver = sqlLanguageDialectBase;
            boolean bl = false;
            SqlLanguageDialectBase sqlLanguageDialectBase2 = schemaDriverToId.get(driver);
            sqlLanguageDialectBase = sqlLanguageDialectBase2;
            if (sqlLanguageDialectBase2 != null) {
                language = (Language)sqlLanguageDialectBase;
                return language;
            }
        }
        SqlLanguageDialect sqlLanguageDialect2 = SqlDialectMappings.getDefaultSqlDialect();
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect2, (String)"getDefaultSqlDialect(...)");
        language = (Language)sqlLanguageDialect2;
        return language;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"mysql", (Object)MysqlDialect.INSTANCE), TuplesKt.to((Object)"postgres", (Object)PgDialect.INSTANCE), TuplesKt.to((Object)"sqlite", (Object)SqliteDialect.INSTANCE), TuplesKt.to((Object)"mariadb", (Object)MariaDialect.INSTANCE)};
        schemaDriverToId = MapsKt.mapOf((Pair[])pairArray);
    }
}

