/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.scheme;

import com.intellij.css.scheme.CssValueTokenTypes;
import com.intellij.css.scheme.psi.AndExpr;
import com.intellij.css.scheme.psi.AnyExpr;
import com.intellij.css.scheme.psi.CssValueFile;
import com.intellij.css.scheme.psi.Expression;
import com.intellij.css.scheme.psi.FuncCall;
import com.intellij.css.scheme.psi.Group;
import com.intellij.css.scheme.psi.Inline;
import com.intellij.css.scheme.psi.NamedValue;
import com.intellij.css.scheme.psi.OrExpr;
import com.intellij.css.scheme.psi.ParenExpr;
import com.intellij.css.scheme.psi.PropertyReference;
import com.intellij.css.scheme.psi.Quantifier;
import com.intellij.css.scheme.psi.SimpleExpr;
import com.intellij.css.scheme.psi.TextValue;
import com.intellij.css.scheme.psi.Visitor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueSchemeGenerator {
    public static final Set<String> KNOWN_VALUE_TAGS = ContainerUtil.newHashSet((Object[])new String[]{"any", "position", "expression", "javaScript", "selector", "integer", "resolution", "number", "uri", "percentage", "length", "urange", "angle", "time", "flex", "frequency", "color", "decibel", "semitones", "empty", "name", "text", "string", "property", "inline", "invoke", "group"});
    private final boolean myAppendWithWideKeywords;
    @Nullable
    private final String myFunctionsSuffix;

    public CssValueSchemeGenerator() {
        this(true, null);
    }

    public CssValueSchemeGenerator(boolean appendWithWideKeywords, @Nullable String functionsSuffix) {
        this.myFunctionsSuffix = functionsSuffix;
        this.myAppendWithWideKeywords = appendWithWideKeywords;
    }

    public String generate(CssValueFile file, Map<String, String> valueTooltips) {
        StringBuilder valueXml = new StringBuilder();
        file.acceptChildren(new XmlGeneratingVisitor(valueTooltips, valueXml));
        return valueXml.toString();
    }

    private class XmlGeneratingVisitor
    extends Visitor {
        private final Map<String, String> myValueTooltips;
        private final StringBuilder myValueXml;

        XmlGeneratingVisitor(Map<String, String> valueTooltips, StringBuilder result) {
            this.myValueTooltips = valueTooltips;
            this.myValueXml = result;
        }

        @Override
        public void visitExpression(@NotNull Expression o) {
            if (o == null) {
                XmlGeneratingVisitor.$$$reportNull$$$0(0);
            }
            if (!(o instanceof Group)) {
                o.acceptChildren(this);
                return;
            }
            String tooltip = this.myValueTooltips.get(o.getText().trim());
            PsiElement parent = o.getParent();
            this.wrapWithOrGroupIfNeeded(o);
            String groupType = XmlGeneratingVisitor.getGroupType(o);
            this.myValueXml.append("<group");
            if (!groupType.isEmpty()) {
                this.myValueXml.append(" type=\"").append(groupType).append("\"");
            }
            if (StringUtil.isNotEmpty((String)tooltip)) {
                this.myValueXml.append(" tooltip=\"").append(tooltip).append("\"");
            }
            if (parent instanceof ParenExpr) {
                this.printQuantifier(((ParenExpr)parent).getQuantifier());
            }
            this.myValueXml.append(">\n");
            o.acceptChildren(this);
            if (parent instanceof PsiFile && CssValueSchemeGenerator.this.myAppendWithWideKeywords && !XmlGeneratingVisitor.shouldWrapWithOrGroup(o)) {
                this.myValueXml.append("<inline id=\"wide-keywords\" inline=\"yes\"/>\n");
            }
            this.myValueXml.append("</group>\n");
            this.closeWrappingOrGroupIfNeeded(o);
        }

        @Override
        public void visitParenExpr(@NotNull ParenExpr o) {
            if (o == null) {
                XmlGeneratingVisitor.$$$reportNull$$$0(1);
            }
            this.wrapWithOrGroupIfNeeded(o);
            PsiElement parent = o.getParent();
            if (parent instanceof ParenExpr) {
                this.myValueXml.append("<group ");
                this.printQuantifier(((ParenExpr)parent).getQuantifier());
                this.myValueXml.append(">");
            }
            super.visitParenExpr(o);
            if (parent instanceof ParenExpr) {
                this.myValueXml.append("</group>");
            }
            this.closeWrappingOrGroupIfNeeded(o);
        }

        private void wrapWithOrGroupIfNeeded(PsiElement o) {
            if (XmlGeneratingVisitor.shouldWrapWithOrGroup(o)) {
                this.myValueXml.append("<group type=\"or\">\n");
            }
        }

        private void closeWrappingOrGroupIfNeeded(PsiElement o) {
            if (XmlGeneratingVisitor.shouldWrapWithOrGroup(o)) {
                if (CssValueSchemeGenerator.this.myAppendWithWideKeywords) {
                    this.myValueXml.append("<inline id=\"wide-keywords\" inline=\"yes\"/>\n");
                }
                this.myValueXml.append("</group>\n");
            }
        }

        private static boolean shouldWrapWithOrGroup(PsiElement o) {
            PsiElement parent = o.getParent();
            return parent instanceof PsiFile && !(o instanceof OrExpr);
        }

        @Override
        public void visitTextValue(@NotNull TextValue o) {
            if (o == null) {
                XmlGeneratingVisitor.$$$reportNull$$$0(2);
            }
            this.myValueXml.append("<text value=\"");
            this.myValueXml.append(StringUtil.unquoteString((String)o.getText()));
            this.myValueXml.append("\"");
        }

        @Override
        public void visitFuncCall(@NotNull FuncCall o) {
            Expression expression;
            if (o == null) {
                XmlGeneratingVisitor.$$$reportNull$$$0(3);
            }
            if ((expression = o.getExpression()) != null) {
                this.myValueXml.append("<invoke id=\"");
                String name = o.getNode().getFirstChildNode().getText();
                if (CssValueSchemeGenerator.this.myFunctionsSuffix != null) {
                    this.myValueXml.append(name).append("-").append(CssValueSchemeGenerator.this.myFunctionsSuffix).append("\" name=\"").append(name);
                } else {
                    this.myValueXml.append(name);
                }
                this.myValueXml.append("\"");
            } else {
                this.myValueXml.append("<text value=\"");
                this.myValueXml.append(o.getText());
                this.myValueXml.append("\"");
            }
        }

        @Override
        public void visitInline(@NotNull Inline o) {
            String inlineText;
            String name;
            if (o == null) {
                XmlGeneratingVisitor.$$$reportNull$$$0(4);
            }
            String string = name = (inlineText = o.getText()).length() > 1 ? inlineText.substring(1, o.getTextLength() - 1) : inlineText;
            if ("positive-integer".equals(name)) {
                this.myValueXml.append("<integer min-value=\"1\"");
            } else if (KNOWN_VALUE_TAGS.contains(StringUtil.toLowerCase((String)name)) && !"color".equals(name)) {
                this.myValueXml.append("<").append(name);
            } else {
                this.myValueXml.append("<inline id=\"");
                this.myValueXml.append(name);
                this.myValueXml.append("\"");
            }
            String text = inlineText.trim();
            if (this.myValueTooltips.containsKey(text)) {
                this.myValueXml.append(" tooltip=\"");
                this.myValueXml.append(this.myValueTooltips.get(text));
                this.myValueXml.append("\"");
            }
        }

        @Override
        public void visitPropertyReference(@NotNull PropertyReference o) {
            if (o == null) {
                XmlGeneratingVisitor.$$$reportNull$$$0(5);
            }
            this.myValueXml.append("<property id=\"");
            this.myValueXml.append(o.getText(), 2, o.getTextLength() - 2);
            this.myValueXml.append("\"");
        }

        @Override
        public void visitNamedValue(@NotNull NamedValue o) {
            if (o == null) {
                XmlGeneratingVisitor.$$$reportNull$$$0(6);
            }
            this.myValueXml.append("<name value=\"");
            String text = o.getText();
            this.myValueXml.append(text);
            this.myValueXml.append("\"");
            if (this.myValueTooltips.containsKey(text)) {
                this.myValueXml.append(" tooltip=\"");
                this.myValueXml.append(this.myValueTooltips.get(text));
                this.myValueXml.append("\"");
            }
        }

        @Override
        public void visitSimpleExpr(@NotNull SimpleExpr o) {
            String text;
            if (o == null) {
                XmlGeneratingVisitor.$$$reportNull$$$0(7);
            }
            if ("inherit".equalsIgnoreCase(text = o.getText()) || "initial".equalsIgnoreCase(text) || "unset".equalsIgnoreCase(text)) {
                return;
            }
            this.wrapWithOrGroupIfNeeded(o);
            o.acceptChildren(this);
            this.printQuantifier(o.getQuantifier());
            this.myValueXml.append("/>\n");
            this.closeWrappingOrGroupIfNeeded(o);
        }

        private void printQuantifier(Quantifier quantifier) {
            Couple<Integer> minMax = XmlGeneratingVisitor.getMinMax(quantifier);
            if ((Integer)minMax.first != 1) {
                this.myValueXml.append(" min=\"").append(minMax.first).append("\"");
            }
            if ((Integer)minMax.second != 1) {
                this.myValueXml.append(" max=\"").append(minMax.second).append("\"");
            }
            if (quantifier != null && quantifier.getFirstChild().getNode().getElementType() == CssValueTokenTypes.HASH) {
                this.myValueXml.append(" comma-separated=\"yes\"");
            }
        }

        private static Couple<Integer> getMinMax(Quantifier quantifier) {
            if (quantifier != null) {
                if (quantifier.getFirstChild().getNode().getElementType() == CssValueTokenTypes.OPTIONAL) {
                    return Couple.of((Object)0, (Object)1);
                }
                if (quantifier.getFirstChild().getNode().getElementType() == CssValueTokenTypes.ASTERISK) {
                    return Couple.of((Object)0, (Object)-1);
                }
                if (quantifier.getFirstChild().getNode().getElementType() == CssValueTokenTypes.PLUS) {
                    return Couple.of((Object)1, (Object)-1);
                }
                ASTNode[] ints = quantifier.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{CssValueTokenTypes.INT}));
                if (ints.length == 1) {
                    return Couple.of((Object)StringUtil.parseInt((String)ints[0].getText(), (int)1), (Object)StringUtil.parseInt((String)ints[0].getText(), (int)1));
                }
                if (ints.length == 2) {
                    return Couple.of((Object)StringUtil.parseInt((String)ints[0].getText(), (int)1), (Object)StringUtil.parseInt((String)ints[1].getText(), (int)1));
                }
            }
            return Couple.of((Object)1, (Object)1);
        }

        private static String getGroupType(Expression expression) {
            if (expression instanceof OrExpr) {
                return "or";
            }
            if (expression instanceof AndExpr) {
                return "and";
            }
            if (expression instanceof AnyExpr) {
                return "any";
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "o";
            objectArray2[1] = "com/intellij/css/scheme/CssValueSchemeGenerator$XmlGeneratingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenExpr";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTextValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFuncCall";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInline";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPropertyReference";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNamedValue";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSimpleExpr";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

