/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScopeHints;
import com.jetbrains.cidr.execution.testing.CidrTestSuiteFieldAdapter;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsRunConfigurationEditorBase;
import com.jetbrains.cidr.execution.testing.tcatch.CatchTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchBundle;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class CidrCatchTestRunConfigurationEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrTestWithScopeElementsRunConfigurationEditorBase<BC, TARGET, CONFIGURATION, BCH> {
    private final CidrTestScopeHints myHints;

    public CidrCatchTestRunConfigurationEditor(@NotNull Project project, @NotNull BCH configHelper) {
        if (project == null) {
            CidrCatchTestRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        if (configHelper == null) {
            CidrCatchTestRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        super(project, configHelper);
        this.myHints = new CidrTestScopeHints(){

            @NlsContexts.HintText
            @Contract(pure=true)
            @NotNull
            public String getSuitePlaceholder() {
                String string = CidrCatchBundle.message("catch.allTestTags", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NlsContexts.Tooltip
            @Contract(pure=true)
            @NotNull
            public String getSuitesTipMessage() {
                String string = CidrCatchBundle.message("catch.testSuitesTip", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NlsContexts.Label
            @Contract(pure=true)
            @NotNull
            public String getSuiteFieldLabelName() {
                String string = CidrCatchBundle.message("catch.configuration.tags", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NlsContexts.StatusText
            @NotNull
            public String getAllTestsMessage() {
                String string = "non-tagged".equals(CidrCatchTestRunConfigurationEditor.this.myTestScopeEditor.getTestSuiteText()) ? CidrCatchBundle.message("catch.selectTestForNonTagged", new Object[0]) : CidrCatchBundle.message("catch.allTestForTags", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestRunConfigurationEditor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSuitePlaceholder";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSuitesTipMessage";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSuiteFieldLabelName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllTestsMessage";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    protected CidrTestWithScopeElementsRunConfigurationEditorBase.CidrTestWithScopeElementsEditor createTestScopeEditor() {
        return new CidrTestWithScopeElementsRunConfigurationEditorBase.CidrTestWithScopeElementsEditor(this.myHints){

            @NotNull
            protected CidrTestSuiteFieldAdapter createSuiteAdapter() {
                return new CidrTestSuiteFieldAdapter(this){

                    @Contract(pure=true)
                    @NotNull
                    public String getName(String item) {
                        String string = item == null ? "non-tagged" : item;
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    @NotNull
                    public Collection<String> collectValuesFromProject(@NotNull Project project, @Nullable Condition<String> condition) {
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        Set set = CatchTestLanguageSupport.getInstance().collectAllSuiteNames(project, condition);
                        if (set == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return set;
                    }

                    @NotNull
                    public String getPrefix(@NotNull String text, int offset) {
                        if (text == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        int i = Math.max(text.lastIndexOf(93, offset - 1), text.lastIndexOf(32, offset - 1)) + 1;
                        int j = text.lastIndexOf(10, offset - 1) + 1;
                        String string = text.substring(Math.max(i, j), offset);
                        if (string == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 1, 3 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestRunConfigurationEditor$1$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "project";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "text";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getName";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestRunConfigurationEditor$1$1";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "collectValuesFromProject";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getPrefix";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "collectValuesFromProject";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "getPrefix";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 1, 3 -> new IllegalArgumentException(string);
                        };
                    }
                };
            }

            public boolean isValidSuiteName() {
                String tagsInLine = this.getTestSuiteText();
                if (tagsInLine == null) {
                    return false;
                }
                return "non-tagged".equals(tagsInLine) || CidrCatchTestUtil.isValidStringOfTags(tagsInLine);
            }

            @NotNull
            public Set<String> collectSuiteTests() {
                String tags = this.getTestSuiteText();
                if (tags == null) {
                    Set<String> set = Collections.emptySet();
                    if (set == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return set;
                }
                Set set = CatchTestLanguageSupport.getInstance().collectTestsInSuite(CidrCatchTestRunConfigurationEditor.this.myProject, tags);
                if (set == null) {
                    1.$$$reportNull$$$0(1);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestRunConfigurationEditor$1", "collectSuiteTests"));
            }
        };
    }

    @NotNull
    protected @Unmodifiable List<TARGET> getTargets() {
        List list = ContainerUtil.filter((Collection)super.getTargets(), CidrBuildTarget::isExecutable);
        if (list == null) {
            CidrCatchTestRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected boolean isChecking() {
        return super.isChecking() || CatchTestLanguageSupport.getInstance().isIndexing(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

