/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrMetaParam;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsActionEx;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestExecutionUtil;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestLocation;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunMode;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.tcatch.CatchTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestElements;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestLinker;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrTestCommandLineState<CONFIGURATION> {
    public static final String RNG_SEED_SWITCH = "--rng-seed=";
    public static final Supplier<CidrTestScope> EMPTY_TEST_SCOPE_PRODUCER = () -> CidrTestScope.createEmptyTestScope((String)CatchTestLanguageSupport.getInstance().getPatternSeparatorInCommandLine());

    public CidrCatchTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        if (configuration == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(0);
        }
        if (launcher == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(3);
        }
        super(configuration, launcher, env, executor, failedTests, EMPTY_TEST_SCOPE_PRODUCER);
    }

    @Contract(value="_ -> !null")
    @NotNull
    public CidrTestScope getFromString(@Nullable String arg) {
        CidrTestScope cidrTestScope = this.createEmptyTestScope().configureForPreRenderedScope(StringUtil.notNullize((String)arg));
        if (cidrTestScope == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(4);
        }
        return cidrTestScope;
    }

    @NotNull
    public CidrTestScope testScope() {
        if (this.myFailedTests != null) {
            CidrTestScope cidrTestScope = this.normalizeScopeToRunnableTestSet(this.myFailedTests, this.myFailedTests.getElements(), CidrTestScopeElement::getPattern);
            if (cidrTestScope == null) {
                CidrCatchTestCommandLineState.$$$reportNull$$$0(5);
            }
            return cidrTestScope;
        }
        CidrTestRunConfigurationData delegate = this.myConfiguration.getTestData();
        if (delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN) {
            CidrTestScope patternScope = this.getFromString(delegate.getTestPattern());
            CidrTestScope cidrTestScope = this.normalizeScopeToRunnableTestSet(patternScope, ContainerUtil.map((Object[])patternScope.getAsPattern().split("(?<!\\\\),"), String::trim), String::toString);
            if (cidrTestScope == null) {
                CidrCatchTestCommandLineState.$$$reportNull$$$0(6);
            }
            return cidrTestScope;
        }
        if (delegate.getTestMode() == CidrTestRunConfigurationData.Mode.SUITE_TEST) {
            if (delegate.getTestName() == null && delegate.getTestSuite() == null) {
                CidrTestScope cidrTestScope = this.getFromString(null);
                if (cidrTestScope == null) {
                    CidrCatchTestCommandLineState.$$$reportNull$$$0(7);
                }
                return cidrTestScope;
            }
            if (delegate.getTestName() == null && delegate.getTestSuite() != null) {
                CidrTestScope cidrTestScope = this.getFromString(delegate.getTestSuite());
                if (cidrTestScope == null) {
                    CidrCatchTestCommandLineState.$$$reportNull$$$0(8);
                }
                return cidrTestScope;
            }
            CidrTestScope cidrTestScope = this.getFromString(CidrCatchTestLinker.prepareTestPathForPattern(delegate.getTestName()));
            if (cidrTestScope == null) {
                CidrCatchTestCommandLineState.$$$reportNull$$$0(9);
            }
            return cidrTestScope;
        }
        CidrTestLog.LOG.error("Unknown CidrTestRunConfigurationData.Mode: " + String.valueOf(delegate.getTestMode()));
        CidrTestScope cidrTestScope = this.getFromString("*");
        if (cidrTestScope == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(10);
        }
        return cidrTestScope;
    }

    private <T> CidrTestScope normalizeScopeToRunnableTestSet(@NotNull CidrTestScope collectedTestSet, @NotNull Collection<T> patternProviders, @NotNull Function<T, String> funGetPattern) {
        if (collectedTestSet == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(11);
        }
        if (patternProviders == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(12);
        }
        if (funGetPattern == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(13);
        }
        if (patternProviders.size() <= 1) {
            return collectedTestSet;
        }
        TreeSet<String> patterns = new TreeSet<String>();
        for (T pp : patternProviders) {
            List<String> escapedTestOrSectionNames = CidrCatchTestLinker.splitPattern(funGetPattern.apply(pp));
            if (escapedTestOrSectionNames.isEmpty()) continue;
            patterns.add(escapedTestOrSectionNames.get(0));
        }
        CidrTestScope rerunScope = this.createEmptyTestScope();
        patterns.forEach(pattern -> rerunScope.addPattern(pattern));
        return rerunScope;
    }

    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView consoleView) {
        if (consoleView == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(14);
        }
        return new CidrRerunFailedTestsActionEx((ComponentContainer)consoleView, testContext -> {
            String url = ((AbstractTestProxy)testContext.first).getLocationUrl();
            if (url != null && url.startsWith("catch://")) {
                return CidrCatchTestLinker.create(url.substring("catch://".length())).getPatternForCommandLine();
            }
            return null;
        }, (CidrTestCommandLineState)this);
    }

    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String testTags, @Nullable String testMethod) {
        CidrTestScopeElement cidrTestScopeElement = CidrCatchTestElements.createTestScopeElement(testTags, testMethod);
        if (cidrTestScopeElement == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(15);
        }
        return cidrTestScopeElement;
    }

    public void prepareTestExecutionEnvironment(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(16);
        }
        CidrTestRunConfiguration configuration = this.getConfiguration();
        CidrTestLanguageSupport language = CatchTestLanguageSupport.getInstance();
        Project project = configuration.getProject();
        configuration.getTestData().setCommandLineTestPattern(CidrTestExecutionUtil.getAsPatternForCommandLine((Project)project, file -> language.getElementsInFile(file), EMPTY_TEST_SCOPE_PRODUCER, () -> language.areSymbolsLoaded(project), (CidrTestScope)this.testScope(), (ProgressIndicator)progress));
        super.prepareTestExecutionEnvironment(progress);
    }

    @Contract(pure=true)
    protected boolean needCloseBeforeTestRunTaskResults() {
        return false;
    }

    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        String commandLineTestPattern;
        if (cl == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(17);
        }
        CidrCatchTestCommandLineState.fixerForRndSeedFromLocation(cl, this.getEnvironment().getDataContext());
        if (this.myRunMode == CidrTestRunMode.GET_TEST_LIST) {
            cl.addParameter("--list-tests");
        }
        if (this.myRunMode == CidrTestRunMode.RUN_TEST) {
            cl.addParameters(new String[]{"-r", "xml", "-d", "yes"});
        }
        @NonNls String testOrderSwitch = "--order";
        if (!cl.getParametersList().hasParameter("--order")) {
            cl.addParameters(new String[]{"--order", "lex"});
        }
        if (!StringUtil.isEmpty((String)(commandLineTestPattern = this.getConfiguration().getTestData().getCommandLineTestPattern()))) {
            CidrCatchTestCommandLineState.fixtureForAllTestsInFile(cl, commandLineTestPattern);
            CidrCatchTestLinker.addCommandLineParams(cl, commandLineTestPattern);
        } else if (this.myRunMode == CidrTestRunMode.GET_TEST_LIST) {
            cl.addParameter("~[.]");
        }
        return cl;
    }

    private static void fixerForRndSeedFromLocation(@NotNull GeneralCommandLine cl, @Nullable DataContext context) {
        CidrTestLocation ctl;
        String rnd;
        if (cl == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(18);
        }
        if (context == null) {
            return;
        }
        Location location = (Location)context.getData(Location.DATA_KEY);
        if (location instanceof CidrTestLocation && (rnd = (String)CidrMetaParam.parse((String)(ctl = (CidrTestLocation)location).getMetainfo()).get("rng_seed")) != null) {
            String newRndSeedSwitchWithValue = RNG_SEED_SWITCH + rnd;
            ParametersList list = cl.getParametersList();
            boolean found = false;
            for (int i = 0; i < list.getParametersCount(); ++i) {
                if (!list.get(i).startsWith(RNG_SEED_SWITCH)) continue;
                found = true;
                list.set(i, newRndSeedSwitchWithValue);
                break;
            }
            if (!found) {
                list.add(newRndSeedSwitchWithValue);
            }
        }
    }

    private static void fixtureForAllTestsInFile(@NotNull GeneralCommandLine cl, @NotNull String maybeRunAllInFileScope) {
        if (cl == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(19);
        }
        if (maybeRunAllInFileScope == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(20);
        }
        if (maybeRunAllInFileScope.startsWith("[#") && maybeRunAllInFileScope.endsWith("]")) {
            cl.addParameter("-#");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestCommandLineState";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedTestSet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProviders";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funGetPattern";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeRunAllInFileScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestCommandLineState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromString";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "testScope";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "normalizeScopeToRunnableTestSet";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRerunFailedTestsAction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestExecutionEnvironment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fixerForRndSeedFromLocation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fixtureForAllTestsInFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 15 -> new IllegalStateException(string);
        };
    }
}

