/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.schema;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.clangFormat.messages.ClangFormatBundle;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\r\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\bH\u0016J\r\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/clangFormat/schema/ClangFormatSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "<init>", "()V", "CLANG_FORMAT_SCHEMA", "", "CLANG_FORMAT_DARK_SCHEMA", "clangFormatOptionsFileName", "Lorg/jetbrains/annotations/Nls;", "schemaName", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSchemaFile", "getName", "getPresentableName", "Lcom/intellij/openapi/util/NlsContexts$ListItem;", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "getSchemaVersion", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaVersion;", "isUserVisible", "intellij.cidr.clangFormat.schema"})
public final class ClangFormatSchemaProvider
implements JsonSchemaFileProvider {
    @NotNull
    public static final ClangFormatSchemaProvider INSTANCE = new ClangFormatSchemaProvider();
    @NotNull
    private static final String CLANG_FORMAT_SCHEMA = "clangformat.json";
    @NotNull
    private static final String CLANG_FORMAT_DARK_SCHEMA = "clangformatDark.json";
    @NotNull
    private static final String clangFormatOptionsFileName;
    @NotNull
    private static final String schemaName;

    private ClangFormatSchemaProvider() {
    }

    public boolean isAvailable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        if (ClangFormatFileUtils.isClangFormatName((String)fileName)) {
            return true;
        }
        return file instanceof LightVirtualFile && StringsKt.startsWith$default((String)fileName, (String)clangFormatOptionsFileName, (boolean)false, (int)2, null) && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)YAMLFileType.YML);
    }

    @Nullable
    public VirtualFile getSchemaFile() {
        String schema = EditorColorsManager.getInstance().isDarkEditor() ? CLANG_FORMAT_DARK_SCHEMA : CLANG_FORMAT_SCHEMA;
        return JsonSchemaProviderFactory.getResourceFile(this.getClass(), (String)("/schemas/" + schema));
    }

    @NotNull
    public String getName() {
        return schemaName;
    }

    @NotNull
    public String getPresentableName() {
        return schemaName;
    }

    @NotNull
    public SchemaType getSchemaType() {
        return SchemaType.embeddedSchema;
    }

    @Nullable
    public JsonSchemaVersion getSchemaVersion() {
        return JsonSchemaVersion.SCHEMA_7;
    }

    public boolean isUserVisible() {
        return false;
    }

    static {
        Object[] objectArray = new Object[]{""};
        clangFormatOptionsFileName = ClangFormatBundle.message((String)"cf.title.actual.clang.format", (Object[])objectArray);
        schemaName = ClangFormatBundle.message((String)"cf.schema.name", (Object[])new Object[0]);
    }
}

