/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectFixture;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.project.workspace.OCWorkspaceModelRootsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OCRootsSynchronizerTestCase
extends OCCodeInsightTestCase {
    @Override
    protected boolean shouldRunInWriteAction() {
        return true;
    }

    public void assertScope(int mask, VirtualFile ... files) {
        ((OCMockProjectFixture)this.myProjectFixture).assertScope(mask, files);
    }

    @NotNull
    protected static OCRootsSynchronizer createSynchronizer(@NotNull Project project) {
        if (project == null) {
            OCRootsSynchronizerTestCase.$$$reportNull$$$0(0);
        }
        OCRootsSynchronizer oCRootsSynchronizer = OCRootsSynchronizer.getInstance((Project)project);
        if (oCRootsSynchronizer == null) {
            OCRootsSynchronizerTestCase.$$$reportNull$$$0(1);
        }
        return oCRootsSynchronizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/project/workspace/OCRootsSynchronizerTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/project/workspace/OCRootsSynchronizerTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSynchronizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSynchronizer";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public class TestRoots {
        private OCRootsSynchronizer mySynchronizer;
        protected OCRootsSynchronizer.RootsInfo info = new OCRootsSynchronizer.RootsInfo();
        protected List<VirtualFile> expectedContentRoots = new ArrayList<VirtualFile>();
        protected List<VirtualFile> expectedSourceFolders = new ArrayList<VirtualFile>();
        protected List<VirtualFile> expectedExcludeFolders = new ArrayList<VirtualFile>();
        protected List<VirtualFile> expectedLibraryRoots = new ArrayList<VirtualFile>();
        protected List<VirtualFile> expectedLibraryExcludeFolders = new ArrayList<VirtualFile>();

        protected TestRoots() {
            this.info.registerSystemHeaderRootUnderContentRootAsLibraries = true;
        }

        protected TestRoots(OCRootsSynchronizer synchronizer) {
            this.mySynchronizer = synchronizer;
        }

        protected void contentRoots(VirtualFile ... files) {
            this.contentRoots(Arrays.asList(files), Arrays.asList(files));
        }

        protected void contentRoots(Collection<VirtualFile> specified, Collection<VirtualFile> expected) {
            this.info.contentRoots.addAll(VfsUtilCore.virtualToIoFiles(specified));
            this.expectedContentRoots.addAll(expected);
        }

        protected void sourceFiles(VirtualFile ... files) {
            this.sourceFiles(Arrays.asList(files), Arrays.asList(files));
        }

        protected void sourceFiles(Collection<VirtualFile> specified, Collection<VirtualFile> expected) {
            this.info.sourceFiles.addAll(VfsUtilCore.virtualToIoFiles(specified));
            this.expectedSourceFolders.addAll(expected);
        }

        protected void generatedSourceFiles(VirtualFile ... files) {
            this.generatedSourceFiles(Arrays.asList(files), Arrays.asList(files));
        }

        protected void generatedSourceFiles(Collection<VirtualFile> specified, Collection<VirtualFile> expected) {
            this.info.generatedSourceFiles.addAll(VfsUtilCore.virtualToIoFiles(specified));
            this.expectedSourceFolders.addAll(expected);
        }

        protected void explicitSourceFolders(VirtualFile ... files) {
            this.explicitSourceFolders(Arrays.asList(files), Arrays.asList(files));
        }

        protected void explicitSourceFolders(Collection<VirtualFile> specified, Collection<VirtualFile> expected) {
            this.info.explicitSourceFolders.addAll(VfsUtilCore.virtualToIoFiles(specified));
            this.expectedSourceFolders.addAll(expected);
        }

        protected void excludeFolders(VirtualFile ... files) {
            this.excludeFolders(Arrays.asList(files), Arrays.asList(files));
        }

        protected void excludeFolders(Collection<VirtualFile> specified, Collection<VirtualFile> expected) {
            this.info.explicitExcludeFolders.addAll(VfsUtilCore.virtualToIoFiles(specified));
            this.expectedExcludeFolders.addAll(expected);
        }

        protected void explicitLibraryRoots(VirtualFile ... files) {
            this.explicitLibraryRoots(Arrays.asList(files), Arrays.asList(files));
        }

        protected void explicitLibraryRoots(Collection<VirtualFile> specified, Collection<VirtualFile> expected) {
            this.explicitLibraryRoots(specified, expected, Collections.emptySet());
        }

        protected void explicitLibraryRoots(Collection<VirtualFile> specified, Collection<VirtualFile> expected, Collection<VirtualFile> excluded) {
            this.info.explicitLibraryRoots.addAll(VfsUtilCore.virtualToIoFiles(specified));
            this.expectedLibraryRoots.addAll(expected);
            this.expectedLibraryExcludeFolders.addAll(excluded);
        }

        protected void headerRoots(List<? extends HeadersSearchRoot> requested, Collection<VirtualFile> expected) {
            this.headerRoots(requested, expected, Collections.emptySet());
        }

        protected void headerRoots(List<? extends HeadersSearchRoot> requested, Collection<VirtualFile> expected, Collection<VirtualFile> excluded) {
            this.info.headersSearchRoots.addAll(requested);
            this.expectedLibraryRoots.addAll(expected);
            this.expectedLibraryExcludeFolders.addAll(excluded);
        }

        public void check() {
            this.update();
            this.checkWithoutUpdate();
        }

        public void update() {
            OCRootsSynchronizer synchronizer = this.mySynchronizer != null ? this.mySynchronizer : OCRootsSynchronizerTestCase.createSynchronizer(OCRootsSynchronizerTestCase.this.getProject());
            try {
                synchronizer.updateRootsWithInfoBlocking((CidrWorkspace)((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).getMockWorkspace(), this.info);
            }
            finally {
                if (this.mySynchronizer == null) {
                    Disposer.dispose((Disposable)synchronizer);
                }
            }
        }

        public void checkWithoutUpdate() {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).getModule());
            UsefulTestCase.assertSameElements("Unexpected content roots: ", ((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).getContentRootPaths(), ((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).collectFullFilesPaths(this.expectedContentRoots));
            UsefulTestCase.assertSameElements("Unexpected source folders: ", ((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).getSourceRootPaths(), ((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).collectFullFilesPaths(this.expectedSourceFolders));
            UsefulTestCase.assertSameElements("Unexpected exclude folders: ", ((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).getExcludeRootPaths(), ((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).collectFullFilesPaths(this.expectedExcludeFolders));
            ArrayList<String> actualLibrarySources = new ArrayList<String>();
            ArrayList<String> actualLibraryClasses = new ArrayList<String>();
            ArrayList<String> actualLibraryExcludes = new ArrayList<String>();
            for (OrderEntry each : rootManager.getOrderEntries()) {
                if (!(each instanceof LibraryOrderEntry)) continue;
                Collections.addAll(actualLibrarySources, ((LibraryOrderEntry)each).getRootUrls(OrderRootType.SOURCES));
                Collections.addAll(actualLibraryClasses, ((LibraryOrderEntry)each).getRootUrls(OrderRootType.CLASSES));
                Library library = ((LibraryOrderEntry)each).getLibrary();
                if (!(library instanceof LibraryEx)) continue;
                Collections.addAll(actualLibraryExcludes, ((LibraryEx)library).getExcludedRootUrls());
            }
            for (VirtualFileUrl excludedUrl : OCWorkspaceModelRootsBuilder.excludedLibraryUrls((Project)OCRootsSynchronizerTestCase.this.getProject())) {
                actualLibraryExcludes.add(FileUtil.toCanonicalPath((String)VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)excludedUrl).toString()));
            }
            UsefulTestCase.assertSameElements("Unexpected library sources: ", TestRoots.sorted(actualLibrarySources), TestRoots.sorted(((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).collectFullFilesPaths(this.expectedLibraryRoots)));
            UsefulTestCase.assertSameElements("Unexpected library classes: ", TestRoots.sorted(actualLibraryClasses), TestRoots.sorted(((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).collectFullFilesPaths(this.expectedLibraryRoots)));
            UsefulTestCase.assertSameElements("Unexpected library excludes: ", TestRoots.sorted(actualLibraryExcludes), TestRoots.sorted(((OCMockProjectFixture)OCRootsSynchronizerTestCase.this.myProjectFixture).collectFullFilesPaths(this.expectedLibraryExcludeFolders)));
        }

        @NotNull
        private static List<String> sorted(List<String> actualLibrarySources) {
            List<String> list = TestRoots.toPaths(actualLibrarySources).stream().sorted().toList();
            if (list == null) {
                TestRoots.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static List<String> toPaths(List<String> urls) {
            return ContainerUtil.map(urls, url -> FileUtil.toCanonicalPath((String)VfsUtilCore.urlToPath((String)url)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/project/workspace/OCRootsSynchronizerTestCase$TestRoots", "sorted"));
        }
    }
}

