/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.openapi.ui.MessageType;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.assertions.Assertions;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public final class NotificationChecker {
    final HyperlinkListener[] notifiedListener;

    private NotificationChecker(HyperlinkListener[] notifiedListener) {
        this.notifiedListener = notifiedListener;
    }

    public static NotificationChecker attachNotificationListener() {
        final HyperlinkListener[] notifiedListener = new HyperlinkListener[1];
        CidrWorkspace.setBalloonNotifierInTests((CidrWorkspace.BalloonNotifier)new CidrWorkspace.BalloonNotifier(){

            public void notify(@NotNull MessageType type, @NotNull String message, @NotNull HyperlinkListener listener) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (listener == null) {
                    1.$$$reportNull$$$0(2);
                }
                notifiedListener[0] = listener;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/project/workspace/NotificationChecker$1";
                objectArray[2] = "notify";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return new NotificationChecker(notifiedListener);
    }

    public void reset() {
        NotificationChecker.doAfterAllEvents(() -> {
            this.notifiedListener[0] = null;
        });
    }

    public void assertNoNotification() {
        NotificationChecker.doAfterAllEvents(() -> Assertions.assertThat((Object)this.notifiedListener[0]).isNull());
    }

    public void assertNotificationShown() {
        NotificationChecker.doAfterAllEvents(() -> Assertions.assertThat((Object)this.notifiedListener[0]).isNotNull());
    }

    public void clickIgnore() {
        NotificationChecker.doAfterAllEvents(() -> {
            TestCase.assertNotNull((Object)this.notifiedListener[0]);
            this.notifiedListener[0].hyperlinkUpdate(new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, null, "ignore"));
        });
    }

    private static void doAfterAllEvents(Runnable run) {
        EdtTestUtil.runInEdtAndWait(() -> {
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            run.run();
        }, false);
    }
}

