/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCBuiltInCompilerKindProvider;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKindProvider;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompilerTestCaseBase
extends CidrTestCase {
    protected File myWorkingDir;
    protected static final Pattern COMPILER_VERSION_PATTERN = Pattern.compile(".*");

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.myWorkingDir = FileUtil.createTempDirectory((String)"compiler_test", null);
        ServiceContainerUtil.registerExtension((ComponentManager)ApplicationManager.getApplication(), OCCompilerKindProvider.EP_NAME, new OCBuiltInCompilerKindProvider(), this.getTestRootDisposable());
    }

    @Override
    public void tearDown() throws Exception {
        try {
            OCCompilerBase.setCompilerRunnerInTests(null);
            FileUtil.delete((File)this.myWorkingDir);
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected boolean runInDispatchThread() {
        return false;
    }

    @NotNull
    protected String getPrefix() {
        return "";
    }

    protected void addAdditionalCompilerSwitches(@NotNull Consumer<? super String> compilerSwitches) {
        if (compilerSwitches == null) {
            CompilerTestCaseBase.$$$reportNull$$$0(0);
        }
    }

    @NotNull
    protected GCCCompiler getCompiler() {
        GCCCompiler gCCCompiler = this.getCompiler(this.getToolEnvironment());
        if (gCCCompiler == null) {
            CompilerTestCaseBase.$$$reportNull$$$0(1);
        }
        return gCCCompiler;
    }

    @NotNull
    protected GCCCompiler getCompiler(@NotNull CidrToolEnvironment env) {
        if (env == null) {
            CompilerTestCaseBase.$$$reportNull$$$0(2);
        }
        File file = this.getCompilerExecutable();
        CompilerTestCaseBase.assertNotNull((Object)file);
        return new GCCCompiler(file, this.myWorkingDir, env, (TempFilesPool)TempFilesPool.INSTANCE);
    }

    protected void assertDefinesContain(List<String> defines, Collection<String> contains, Collection<String> doesntContain) {
        for (String each : contains) {
            CompilerTestCaseBase.assertNotNull((String)(each + " not found among:\n" + String.valueOf(defines)), (Object)ContainerUtil.find(defines, define -> define.contains(each)));
        }
        for (String each : doesntContain) {
            CompilerTestCaseBase.assertNull((String)(each + " found among:\n" + String.valueOf(defines)), (Object)ContainerUtil.find(defines, define -> define.contains(each)));
        }
    }

    @NotNull
    protected CidrCompilerSwitches createSwitches(@NotNull String params) {
        if (params == null) {
            CompilerTestCaseBase.$$$reportNull$$$0(3);
        }
        CidrSwitchBuilder switchBuilder = new CidrSwitchBuilder().parseAndAdd(params, CidrCompilerSwitches.Format.BASH_SHELL);
        this.addAdditionalCompilerSwitches((Consumer<? super String>)((Consumer)arg_0 -> ((CidrSwitchBuilder)switchBuilder).addSingleRaw(arg_0)));
        CidrCompilerSwitches cidrCompilerSwitches = switchBuilder.build();
        if (cidrCompilerSwitches == null) {
            CompilerTestCaseBase.$$$reportNull$$$0(4);
        }
        return cidrCompilerSwitches;
    }

    protected abstract OCCompilerKind getCompilerKind();

    protected abstract void assertWindowsPaths(String var1, List<HeadersSearchPath> var2);

    @Nullable
    protected abstract File getCompilerExecutable();

    protected abstract CidrToolEnvironment getToolEnvironment();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSwitches";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerTestCaseBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerTestCaseBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompiler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSwitches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalCompilerSwitches";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCompiler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSwitches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

