/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScopeService;
import com.jetbrains.cidr.lang.workspace.OCGeneratedSourcesFilter;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSearchScopeTestCase
extends OCCodeInsightTestCase {
    public OCSearchScopeTestCase(CidrTestProjectDescription testProjectDescription) {
        super(testProjectDescription);
    }

    protected void assertInSourceScope(VirtualFile ... files) {
        this.assertInSourceScope(false, files);
    }

    protected void assertInSourceScope(boolean generated, VirtualFile ... files) {
        OCSearchScopeTestCase.assertEmpty(ContainerUtil.filter((Object[])files, each -> !OCSearchScope.getProjectSourcesScope((Project)this.getProject()).contains(each)));
        OCSearchScopeTestCase.assertEmpty(ContainerUtil.filter((Object[])files, each -> OCGeneratedSourcesFilter.isGeneratedSource((Project)this.getProject(), (VirtualFile)each) != generated));
    }

    protected void assertInExplicitSourceScope(VirtualFile ... files) {
        Collection explicitSources = (Collection)ReadAction.compute(() -> OCSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)this.getProject()));
        OCSearchScopeTestCase.assertContainsElements(explicitSources, files);
    }

    protected void assertNotInSourceScope(VirtualFile ... files) {
        OCSearchScopeTestCase.assertEmpty(ContainerUtil.filter((Object[])files, each -> OCSearchScope.getProjectSourcesScope((Project)this.getProject()).contains(each)));
        this.assertNotInExplicitSourceScope(files);
    }

    protected void assertNotInExplicitSourceScope(VirtualFile ... files) {
        Collection explicitSources = (Collection)ReadAction.compute(() -> OCSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)this.getProject()));
        OCSearchScopeTestCase.assertDoesntContain(explicitSources, files);
    }

    protected static void doTestScopes(@NotNull Project project, PsiElement in_project, PsiElement in_project_in_sources, PsiElement in_project_in_generated_sources, PsiElement in_sources_in_libraries, PsiElement in_libraries, PsiElement in_libraries_in_project, PsiElement in_libraries_in_project_in_sources, PsiElement not_in_project) {
        if (project == null) {
            OCSearchScopeTestCase.$$$reportNull$$$0(0);
        }
        OCSearchScopeService scopeService = OCSearchScopeService.getInstance((Project)project);
        OCSearchScopeTestCase.assertNotInScope(in_project, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSources(arg_0));
        OCSearchScopeTestCase.assertInScope(in_project_in_sources, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSources(arg_0));
        OCSearchScopeTestCase.assertInScope(in_project_in_generated_sources, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSources(arg_0));
        OCSearchScopeTestCase.assertInScope(in_sources_in_libraries, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSources(arg_0));
        OCSearchScopeTestCase.assertNotInScope(in_libraries, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSources(arg_0));
        OCSearchScopeTestCase.assertNotInScope(in_libraries_in_project, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSources(arg_0));
        OCSearchScopeTestCase.assertInScope(in_libraries_in_project_in_sources, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSources(arg_0));
        OCSearchScopeTestCase.assertNotInScope(not_in_project, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSources(arg_0));
        OCSearchScopeTestCase.assertNotInScope(in_project, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSourcesOrLibraries(arg_0));
        OCSearchScopeTestCase.assertInScope(in_project_in_sources, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSourcesOrLibraries(arg_0));
        OCSearchScopeTestCase.assertInScope(in_project_in_generated_sources, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSourcesOrLibraries(arg_0));
        OCSearchScopeTestCase.assertInScope(in_sources_in_libraries, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSourcesOrLibraries(arg_0));
        OCSearchScopeTestCase.assertInScope(in_libraries, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSourcesOrLibraries(arg_0));
        OCSearchScopeTestCase.assertInScope(in_libraries_in_project, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSourcesOrLibraries(arg_0));
        OCSearchScopeTestCase.assertInScope(in_libraries_in_project_in_sources, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSourcesOrLibraries(arg_0));
        OCSearchScopeTestCase.assertNotInScope(not_in_project, arg_0 -> ((OCSearchScopeService)scopeService).isInProjectSourcesOrLibraries(arg_0));
        OCSearchScopeTestCase.assertNotInScope(in_project, arg_0 -> ((OCSearchScopeService)scopeService).isInLibraries(arg_0));
        OCSearchScopeTestCase.assertNotInScope(in_project_in_sources, arg_0 -> ((OCSearchScopeService)scopeService).isInLibraries(arg_0));
        OCSearchScopeTestCase.assertNotInScope(in_project_in_generated_sources, arg_0 -> ((OCSearchScopeService)scopeService).isInLibraries(arg_0));
        OCSearchScopeTestCase.assertNotInScope(in_sources_in_libraries, arg_0 -> ((OCSearchScopeService)scopeService).isInLibraries(arg_0));
        OCSearchScopeTestCase.assertInScope(in_libraries, arg_0 -> ((OCSearchScopeService)scopeService).isInLibraries(arg_0));
        OCSearchScopeTestCase.assertInScope(in_libraries_in_project, arg_0 -> ((OCSearchScopeService)scopeService).isInLibraries(arg_0));
        OCSearchScopeTestCase.assertNotInScope(in_libraries_in_project_in_sources, arg_0 -> ((OCSearchScopeService)scopeService).isInLibraries(arg_0));
        OCSearchScopeTestCase.assertNotInScope(not_in_project, arg_0 -> ((OCSearchScopeService)scopeService).isInLibraries(arg_0));
    }

    protected static void assertInScope(@Nullable PsiElement file, Function<@NotNull PsiElement, Boolean> scopeCheck) {
        OCSearchScopeTestCase.assertScope(true, file, scopeCheck);
    }

    protected static void assertNotInScope(@Nullable PsiElement file, Function<@NotNull PsiElement, Boolean> scopeCheck) {
        OCSearchScopeTestCase.assertScope(false, file, scopeCheck);
    }

    protected static void assertScope(boolean expected, @Nullable PsiElement file, Function<@NotNull PsiElement, Boolean> scopeCheck) {
        if (file == null) {
            return;
        }
        OCSearchScopeTestCase.assertEquals((boolean)expected, (boolean)scopeCheck.apply(file));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/search/OCSearchScopeTestCase", "doTestScopes"));
    }
}

