/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.lang.daemon.CidrAnnotationFixture;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCExtractCategoryHandler;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCExtractSubClassHandler;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCExtractSuperClassHandler;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Assert;

public class OCMoveTestFixture {
    protected CidrAnnotationFixture myAnnotationFixture;
    protected CidrCodeInsightFixture myCodeInsightFixture;
    private String myResultPrefix = "result";

    public String getResultPrefix() {
        return this.myResultPrefix;
    }

    public void setResultPrefix(String resultPrefix) {
        this.myResultPrefix = resultPrefix;
    }

    public OCMoveTestFixture(CidrAnnotationFixture annotationFixture, CidrCodeInsightFixture codeInsightFixture) {
        this.myAnnotationFixture = annotationFixture;
        this.myCodeInsightFixture = codeInsightFixture;
    }

    public void doTest(final String testName, RefactoringActionHandler handler, Ref<Listener> listenerRef, final boolean checkConflicts, String ... fileNames) throws Exception {
        final ArrayList<SmartPsiElementPointer<PsiFile>> sourceFiles = new ArrayList<SmartPsiElementPointer<PsiFile>>();
        ArrayList<String> resultFileNames = new ArrayList<String>();
        final SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myCodeInsightFixture.getProject());
        for (int i = fileNames.length - 1; i >= 0; --i) {
            String name = fileNames[i];
            resultFileNames.add(0, this.myResultPrefix + (String)(name.startsWith(".") ? name : "-" + name));
            if (name.startsWith("new")) continue;
            String fileNameSuffix = "source" + (String)(name.startsWith(".") ? name : "-" + name);
            sourceFiles.add(0, (SmartPsiElementPointer<PsiFile>)pointerManager.createSmartPsiElementPointer((PsiElement)this.myCodeInsightFixture.configureByFile(testName, fileNameSuffix)));
        }
        listenerRef.set((Object)new Listener(){

            @Override
            public void passToTest(String conflicts, PsiFile[] newFiles) {
                sourceFiles.addAll(ContainerUtil.map((Object[])newFiles, arg_0 -> ((SmartPointerManager)pointerManager).createSmartPsiElementPointer(arg_0)));
                if (checkConflicts) {
                    String resultConflicts;
                    try {
                        resultConflicts = OCMoveTestFixture.this.myCodeInsightFixture.loadFile(testName, "conflicts.txt");
                    }
                    catch (IOException e) {
                        resultConflicts = "";
                    }
                    Assert.assertEquals((String)"Conflicts mismatch: ", (Object)resultConflicts.trim(), (Object)conflicts.trim());
                }
            }
        });
        this.myAnnotationFixture.assertRefactoring(sourceFiles, resultFileNames, handler);
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    public void doTestExtractSuperClass(String testName, boolean checkConflicts, String ... fileNames) throws Exception {
        final Ref listenerRef = new Ref();
        this.doTest(testName, (RefactoringActionHandler)new OCExtractSuperClassHandler(this){

            protected void passToTest(String conflicts, PsiFile[] newFiles) {
                ((Listener)listenerRef.get()).passToTest(conflicts, newFiles);
            }
        }, (Ref<Listener>)listenerRef, checkConflicts, fileNames);
    }

    public void doTestExtractSubClass(String testName, String assertException, String ... fileNames) throws Exception {
        final Ref listenerRef = new Ref();
        try {
            this.doTest(testName, (RefactoringActionHandler)new OCExtractSubClassHandler(this){

                protected void passToTest(String conflicts, PsiFile[] newFiles) {
                    ((Listener)listenerRef.get()).passToTest(conflicts, newFiles);
                }
            }, (Ref<Listener>)listenerRef, true, fileNames);
        }
        catch (Exception e) {
            if (assertException == null) {
                throw e;
            }
            Assert.assertEquals((Object)e.getMessage(), (Object)assertException);
            return;
        }
        if (assertException != null) {
            Assert.fail((String)("Exception was not thrown: " + assertException));
        }
    }

    public void doTestExtractCategory(String testName, String ... fileNames) throws Exception {
        final Ref listenerRef = new Ref();
        this.doTest(testName, (RefactoringActionHandler)new OCExtractCategoryHandler(this){

            protected void passToTest(String conflicts, PsiFile[] newFiles) {
                ((Listener)listenerRef.get()).passToTest(conflicts, newFiles);
            }
        }, (Ref<Listener>)listenerRef, true, fileNames);
    }

    public static interface Listener {
        public void passToTest(String var1, PsiFile[] var2);
    }
}

