/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.CidrTestUtils;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerUtilsKt;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0002,-B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0011J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000fJ3\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010$\u001a\u00020%J\u0012\u0010)\u001a\u00020*2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0014H\u0016J\u0006\u0010+\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006."}, d2={"Lcom/jetbrains/cidr/lang/fixtures/OCMockWorkspace;", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "Lcom/intellij/openapi/Disposable;", "myDelegate", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl;", "myClientKey", "", "contentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "myAdditionalSourceFiles", "", "myGeneratedSourceFiles", "myContentRootAsSourceFolder", "", "dispose", "", "initialized", "beforeUpdateContentRoots", "Ljava/io/File;", "shouldEnableRootConfiguration", "setContentRootAsSourceFolder", "value", "addSourceFile", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "file", "forcedKind", "addTo", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration$ModifiableModel;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/cidr/lang/OCLanguageKind;[Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration$ModifiableModel;)Lcom/jetbrains/cidr/lang/OCLanguageKind;", "removeSourceFile", "model", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "addGeneratedSourceFile", "getDelegate", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace;", "clientKey", "getClientKey", "()Ljava/lang/String;", "collectRootsInfo", "Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$RootsInfo;", "updateRoots", "CompilerSettingsData", "Companion", "intellij.cidr.common.testFramework.core.nolang"})
@SourceDebugExtension(value={"SMAP\nOCMockWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCMockWorkspace.kt\ncom/jetbrains/cidr/lang/fixtures/OCMockWorkspace\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n23#2:251\n1869#3,2:252\n*S KotlinDebug\n*F\n+ 1 OCMockWorkspace.kt\ncom/jetbrains/cidr/lang/fixtures/OCMockWorkspace\n*L\n84#1:251\n99#1:252,2\n*E\n"})
public final class OCMockWorkspace
extends CidrWorkspace
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OCWorkspaceImpl myDelegate;
    @NotNull
    private final String myClientKey;
    @NotNull
    private final Set<VirtualFile> myAdditionalSourceFiles;
    @NotNull
    private final Set<VirtualFile> myGeneratedSourceFiles;
    private boolean myContentRootAsSourceFolder;

    public OCMockWorkspace(@NotNull OCWorkspaceImpl myDelegate, @NotNull String myClientKey, @Nullable VirtualFile contentRoot) {
        Intrinsics.checkNotNullParameter((Object)myDelegate, (String)"myDelegate");
        Intrinsics.checkNotNullParameter((Object)myClientKey, (String)"myClientKey");
        super(myDelegate.getProject());
        this.myDelegate = myDelegate;
        this.myClientKey = myClientKey;
        this.myAdditionalSourceFiles = new LinkedHashSet();
        this.myGeneratedSourceFiles = new LinkedHashSet();
        this.myContentRootAsSourceFolder = true;
        VirtualFile virtualFile = contentRoot;
        this.myContentRoot = virtualFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile) : null;
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this);
        Topic topic = OCWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new OCWorkspaceListener(){

            public void workspaceChanged(OCWorkspaceListener.OCWorkspaceEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.updateRoots();
            }
        });
    }

    public void dispose() {
        this.unload(true);
    }

    public final void initialized() {
        super.initializeAndStart();
        CidrWorkspaceManager.Companion.getInstance(this.myProject).markInitialized((CidrWorkspace)this);
        CidrWorkspaceManager.Companion.getInstance(this.myProject).markLoaded((CidrWorkspace)this);
        this.myDelegate.setInitialized();
        this.updateRoots();
        this.myDelegate.fireWorkspaceInitializedEvent();
    }

    @Nullable
    public File beforeUpdateContentRoots(@Nullable File contentRoot) {
        return contentRoot;
    }

    public boolean shouldEnableRootConfiguration() {
        return false;
    }

    public final void setContentRootAsSourceFolder(boolean value2) {
        this.myContentRootAsSourceFolder = value2;
        this.updateRoots();
    }

    @Nullable
    public final OCLanguageKind addSourceFile(@NotNull VirtualFile file, @Nullable OCLanguageKind forcedKind, OCResolveConfiguration.ModifiableModel ... addTo) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)addTo, (String)"addTo");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        if (!OCFileTypeHelpers.isHeaderFile((String)fileName)) {
            OCLanguageKind kind;
            OCLanguageKind oCLanguageKind = forcedKind;
            if (oCLanguageKind == null) {
                oCLanguageKind = OCLanguageKindCalculatorBase.calculateMinimalKindByExtension((Project)this.myProject, (String)fileName);
            }
            if ((kind = oCLanguageKind) == null) {
                OCMockWorkspace $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(OCMockWorkspace.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unknown language kind for " + fileName);
            } else {
                for (OCResolveConfiguration.ModifiableModel eachConfig : addTo) {
                    eachConfig.addSource(file, kind);
                }
                return kind;
            }
        }
        this.myAdditionalSourceFiles.add(file);
        return null;
    }

    public final void removeSourceFile(@NotNull VirtualFile file, @NotNull OCWorkspace.ModifiableModel model) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        List list = model.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurations(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OCResolveConfiguration.ModifiableModel it = (OCResolveConfiguration.ModifiableModel)element$iv;
            boolean bl = false;
            it.removeSource(file);
        }
        this.myAdditionalSourceFiles.remove(file);
    }

    public final void addGeneratedSourceFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myGeneratedSourceFiles.add(file);
    }

    @NotNull
    public final OCWorkspace getDelegate() {
        return (OCWorkspace)this.myDelegate;
    }

    @NotNull
    public String getClientKey() {
        return this.myClientKey;
    }

    @NotNull
    public OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable File contentRoot) {
        List list = VfsUtilCore.virtualToIoFiles((Collection)this.myAdditionalSourceFiles);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"virtualToIoFiles(...)");
        List additionalSourceFiles = CollectionsKt.toMutableList((Collection)list);
        if (this.myContentRootAsSourceFolder) {
            additionalSourceFiles.add(contentRoot);
        }
        List list2 = this.myDelegate.getConfigurations(this.myClientKey);
        List list3 = CollectionsKt.listOfNotNull((Object)contentRoot);
        List list4 = VfsUtilCore.virtualToIoFiles((Collection)this.myGeneratedSourceFiles);
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"virtualToIoFiles(...)");
        OCRootsSynchronizer.RootsInfo info = CidrWorkspace.Companion.createRootsInfo(list2, list3, additionalSourceFiles, list4);
        info.registerSystemHeaderRootUnderContentRootAsLibraries = true;
        return info;
    }

    public final void updateRoots() {
        if (!this.isInitialized() || this.myContentRoot == null) {
            return;
        }
        try {
            ActionsKt.runWriteAction(() -> OCMockWorkspace.updateRoots$lambda$0(this));
        }
        catch (Throwable e) {
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static final Unit updateRoots$lambda$0(OCMockWorkspace this$0) {
        this$0.updateContentRootsBlocking();
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void applyDefaultDefinesAndFeatures(@NotNull OCLanguageKind languageKind, @NotNull OCCompilerSettings.ModifiableModel model, @Nullable OCLanguageStandard defaultLangStandard) {
        Companion.applyDefaultDefinesAndFeatures(languageKind, model, defaultLangStandard);
    }

    @JvmStatic
    public static final void applyDefinesAndFeatures(@NotNull OCLanguageKind languageKind, @NotNull OCCompilerSettings.ModifiableModel model, @NotNull CompilerSettingsData data, @Nullable OCLanguageStandard defaultLangStandard) {
        Companion.applyDefinesAndFeatures(languageKind, model, data, defaultLangStandard);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J*\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J.\u0010\u000f\u001a\u00020\u000b2\u001a\u0010\u0010\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/fixtures/OCMockWorkspace$Companion;", "", "<init>", "()V", "applyDefaultDefinesAndFeatures", "", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "model", "Lcom/jetbrains/cidr/lang/workspace/OCCompilerSettings$ModifiableModel;", "defaultLangStandard", "Lcom/jetbrains/cidr/lang/OCLanguageStandard;", "applyDefinesAndFeatures", "data", "Lcom/jetbrains/cidr/lang/fixtures/OCMockWorkspace$CompilerSettingsData;", "getLanguageStandard", "features", "", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Type;", "intellij.cidr.common.testFramework.core.nolang"})
    @SourceDebugExtension(value={"SMAP\nOCMockWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCMockWorkspace.kt\ncom/jetbrains/cidr/lang/fixtures/OCMockWorkspace$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,250:1\n37#2,2:251\n37#2,2:253\n*S KotlinDebug\n*F\n+ 1 OCMockWorkspace.kt\ncom/jetbrains/cidr/lang/fixtures/OCMockWorkspace$Companion\n*L\n177#1:251,2\n193#1:253,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void applyDefaultDefinesAndFeatures(@NotNull OCLanguageKind languageKind, @NotNull OCCompilerSettings.ModifiableModel model, @Nullable OCLanguageStandard defaultLangStandard) {
            Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.applyDefinesAndFeatures(languageKind, model, new CompilerSettingsData(null, null, null, null), defaultLangStandard);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void applyDefinesAndFeatures(@NotNull OCLanguageKind languageKind, @NotNull OCCompilerSettings.ModifiableModel model, @NotNull CompilerSettingsData data, @Nullable OCLanguageStandard defaultLangStandard) {
            Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Map allFeatures = new LinkedHashMap();
            List allDefines = new ArrayList();
            if (languageKind.isObjC()) {
                void var8_9;
                allDefines.add("#define __OBJC__");
                allDefines.add("#define __objc_no ((BOOL)0)");
                allDefines.add("#define __objc_yes ((BOOL)1)");
                Collection collection = (Collection)EntriesMappings.entries$0;
                int $i$f$toTypedArray = 0;
                Collection thisCollection$iv = collection;
                OCCompilerFeatures.Feature[] featureArray = thisCollection$iv.toArray(new OCCompilerFeatures.Feature[0]);
                boolean bl = false;
                $i$f$toTypedArray = featureArray.length;
                while (var8_9 < $i$f$toTypedArray) {
                    Object each = featureArray[var8_9];
                    if (StringUtil.startsWithIgnoreCase((String)each.name(), (String)"OBJC_")) {
                        allFeatures.put(each, true);
                    }
                    ++var8_9;
                }
            }
            if (languageKind.isCpp()) {
                OCLanguageStandard std;
                OCLanguageStandard oCLanguageStandard = std = CidrTestUtils.hasRadler() ? this.getLanguageStandard(data.features, defaultLangStandard) : OCLanguageStandard.Companion.latestCpp();
                if (std.isCpp()) {
                    String entry = OCLanguageStandard.Companion.getCplusplusValueForStandard(std);
                    allDefines.add("#define __cplusplus " + entry);
                    Collection $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
                    int $i$f$toTypedArray = 0;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    for (OCCompilerFeatures.Feature each : thisCollection$iv.toArray(new OCCompilerFeatures.Feature[0])) {
                        if (!StringUtil.startsWithIgnoreCase((String)each.name(), (String)"CXX_")) continue;
                        OCLanguageStandard featureStandard = each.getAvailableInStandard();
                        allFeatures.put(each, featureStandard != null && std.supports(featureStandard));
                    }
                }
            }
            if (!languageKind.isCpp() && !languageKind.isCuda()) {
                allDefines.add("#define __STDC_VERSION__ " + OCLanguageStandard.Companion.getStdCValueForStandard(OCLanguageStandard.C17));
            }
            if (data.features != null) {
                Map<OCCompilerFeatures.Type<?>, ? extends Object> map = data.features;
                Intrinsics.checkNotNull(map);
                allFeatures.putAll(map);
            }
            if (data.defines != null) {
                List<String> list = data.defines;
                Intrinsics.checkNotNull(list);
                allDefines.addAll((Collection)list);
            }
            allDefines.addAll(GCCCompiler.Companion.getClangTestMacros());
            allDefines.addAll(GCCCompiler.Companion.getGCCBuiltInFunctionMacros());
            for (Map.Entry entry : allFeatures.entrySet()) {
                String clangId;
                OCCompilerFeatures.Type key = (OCCompilerFeatures.Type)entry.getKey();
                Object value2 = entry.getValue();
                if (!(key instanceof OCCompilerFeatures.Feature) || (clangId = ClangFeatures.getClangIdForFeature((OCCompilerFeatures.Feature)((OCCompilerFeatures.Feature)key))) == null) continue;
                String featureMacro = GCCCompilerUtilsKt.clangFeatureMacro((String)clangId);
                String featureMacroValue = Intrinsics.areEqual(value2, (Object)true) ? "1" : "0";
                String string = "#define %s %s";
                Object[] objectArray = new Object[]{featureMacro, featureMacroValue};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                allDefines.add(string2);
            }
            model.setPreprocessorDefines(allDefines);
            model.setCompilerFeatures(allFeatures);
            model.setCompilerSwitches(data.switches);
            model.setImplicitIncludes(data.implicitIncludes);
        }

        private final OCLanguageStandard getLanguageStandard(Map<OCCompilerFeatures.Type<?>, ? extends Object> features, OCLanguageStandard defaultLangStandard) {
            OCLanguageStandard fallback;
            OCLanguageStandard oCLanguageStandard = defaultLangStandard;
            if (oCLanguageStandard == null) {
                oCLanguageStandard = fallback = OCLanguageStandard.Companion.latestCpp();
            }
            if (features == null) {
                return fallback;
            }
            Object givenLangStd = features.get(OCCompilerFeatures.LANGUAGE_STANDARD);
            if (givenLangStd instanceof OCLanguageStandard) {
                return (OCLanguageStandard)givenLangStd;
            }
            return fallback;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<OCCompilerFeatures.Feature> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])OCCompilerFeatures.Feature.values()));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BM\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u001a\u0010\u0005\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0003\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/lang/fixtures/OCMockWorkspace$CompilerSettingsData;", "", "defines", "", "", "features", "", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Type;", "switches", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;", "implicitIncludes", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/util/List;Ljava/util/Map;Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;Ljava/util/List;)V", "intellij.cidr.common.testFramework.core.nolang"})
    public static final class CompilerSettingsData {
        @JvmField
        @Nullable
        public List<String> defines;
        @JvmField
        @Nullable
        public Map<OCCompilerFeatures.Type<?>, ? extends Object> features;
        @JvmField
        @Nullable
        public CidrCompilerSwitches switches;
        @JvmField
        @Nullable
        public List<? extends VirtualFile> implicitIncludes;

        public CompilerSettingsData(@Nullable List<String> defines, @Nullable Map<OCCompilerFeatures.Type<?>, ? extends Object> features, @Nullable CidrCompilerSwitches switches, @Nullable List<? extends VirtualFile> implicitIncludes) {
            this.defines = defines;
            this.features = features;
            this.switches = switches;
            this.implicitIncludes = implicitIncludes;
        }
    }
}

