/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.fixtures.OCMockWorkspace;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NotImplementedError;
import kotlin.io.path.PathsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public final class OCMockProjectReader {
    public static final String EXTENSION = "yaml";
    @Nullable
    private OCLanguageStandard defaultLangStandard = null;

    public static void read(@NotNull Path projectFile, @NotNull OCMockWorkspace mockWorkspace) {
        if (projectFile == null) {
            OCMockProjectReader.$$$reportNull$$$0(0);
        }
        if (mockWorkspace == null) {
            OCMockProjectReader.$$$reportNull$$$0(1);
        }
        new OCMockProjectReader().readProject(projectFile, mockWorkspace);
    }

    public OCMockProjectReader withDefaultLangStandard(OCLanguageStandard standard) {
        this.defaultLangStandard = standard;
        return this;
    }

    public void readProject(@NotNull Path projectFile, @NotNull OCMockWorkspace mockWorkspace) {
        if (projectFile == null) {
            OCMockProjectReader.$$$reportNull$$$0(2);
        }
        if (mockWorkspace == null) {
            OCMockProjectReader.$$$reportNull$$$0(3);
        }
        OCWorkspace.ModifiableModel model = mockWorkspace.getDelegate().getModifiableModel(mockWorkspace.getClientKey(), true);
        try {
            this.doRead(projectFile, mockWorkspace, model);
            model.preCommit();
            WriteAction.run(() -> ((OCWorkspace.ModifiableModel)model).commit());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Disposer.dispose((Disposable)model);
        }
    }

    private void doRead(@NotNull Path projectFile, @NotNull OCMockWorkspace mockWorkspace, @NotNull OCWorkspace.ModifiableModel workspaceModel) throws IOException {
        Yaml yaml;
        Object object;
        if (projectFile == null) {
            OCMockProjectReader.$$$reportNull$$$0(4);
        }
        if (mockWorkspace == null) {
            OCMockProjectReader.$$$reportNull$$$0(5);
        }
        if (workspaceModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(6);
        }
        if ((object = (yaml = new Yaml()).load(PathsKt.readText((Path)projectFile, (Charset)StandardCharsets.UTF_8))) == null) {
            return;
        }
        if (!(object instanceof Map)) {
            throw new RuntimeException("Unexpected project format " + String.valueOf(object));
        }
        Path baseDir = projectFile.getParent();
        LocalFileSystem.getInstance().refreshNioFiles(Collections.singletonList(baseDir), false, true, null);
        VirtualFile virtualFileDir = LocalFileSystem.getInstance().findFileByNioFile(baseDir);
        if (virtualFileDir == null) {
            throw new RuntimeException("Basedir not found " + String.valueOf(baseDir));
        }
        Map projectEntriesMap = (Map)object;
        Object projectAttribute = projectEntriesMap.get("project");
        if (projectAttribute instanceof Map && Boolean.FALSE.equals(((Map)projectAttribute).get("content_root_as_source_folder"))) {
            mockWorkspace.setContentRootAsSourceFolder(false);
        }
        OCMockProjectReader.readGeneratedSources(mockWorkspace, virtualFileDir, projectEntriesMap);
        Collection<Object> profiles = Collections.singletonList(null);
        Object profilesAttribute = projectEntriesMap.get("profiles");
        if (profilesAttribute instanceof List) {
            profiles = (Collection)profilesAttribute;
        }
        for (String string : profiles) {
            if (!projectEntriesMap.containsKey("configs")) {
                OCResolveConfiguration.ModifiableModel config = OCMockProjectReader.addConfiguration(workspaceModel, "default", string);
                OCMockWorkspace.CompilerSettingsData compilerSettings = this.readConfigOptions(config, virtualFileDir, projectEntriesMap);
                this.readFiles(mockWorkspace, config, compilerSettings, virtualFileDir, projectEntriesMap);
                return;
            }
            Object configs = projectEntriesMap.get("configs");
            if (configs == null) {
                return;
            }
            for (Object eachConfig : (List)configs) {
                boolean inlinedFiles;
                Set entries = ((Map)eachConfig).entrySet();
                Iterator iterator = entries.iterator();
                Map.Entry header = iterator.next();
                String configId = (String)header.getKey();
                OCResolveConfiguration.ModifiableModel configModel = OCMockProjectReader.addConfiguration(workspaceModel, configId, string);
                LinkedHashMap configMap = new LinkedHashMap();
                while (iterator.hasNext()) {
                    Map.Entry next = iterator.next();
                    configMap.put((String)next.getKey(), next.getValue());
                }
                OCMockWorkspace.CompilerSettingsData compilerSettings = this.readConfigOptions(configModel, virtualFileDir, configMap);
                boolean bl = inlinedFiles = header.getValue() != null;
                if (inlinedFiles) {
                    this.readFiles(mockWorkspace, configModel, compilerSettings, virtualFileDir, Collections.singletonMap("files", header.getValue()));
                }
                if (!this.readFiles(mockWorkspace, configModel, compilerSettings, virtualFileDir, configMap) || !inlinedFiles) continue;
                throw new RuntimeException("Config " + configModel.getUniqueId() + " has conflicting files sections");
            }
        }
    }

    @NotNull
    private static OCResolveConfiguration.ModifiableModel addConfiguration(@NotNull OCWorkspace.ModifiableModel workspaceModel, @NotNull String configName, @Nullable String profile) {
        if (workspaceModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(7);
        }
        if (configName == null) {
            OCMockProjectReader.$$$reportNull$$$0(8);
        }
        String configId = profile == null ? configName : configName + " [" + profile + "]";
        OCResolveConfiguration.ModifiableModel modifiableModel = workspaceModel.addConfiguration(configId, configName, profile == null ? null : new OCVariant(profile));
        if (modifiableModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(9);
        }
        return modifiableModel;
    }

    @NotNull
    private OCMockWorkspace.CompilerSettingsData readConfigOptions(@NotNull OCResolveConfiguration.ModifiableModel configModel, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        if (configModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(10);
        }
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(11);
        }
        if (map == null) {
            OCMockProjectReader.$$$reportNull$$$0(12);
        }
        OCCompilerSettings.ModifiableModel defaultSettingsModel = configModel.getDefaultCompilerSettings();
        OCMockProjectReader.readSearchPaths(defaultSettingsModel, baseDir, map);
        String compilerKind = (String)map.get("compiler");
        if (compilerKind != null) {
            boolean compiledFound = false;
            for (OCCompilerKind oCCompilerKind : OCCompilerKind.values()) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)oCCompilerKind.getDisplayName(), (CharSequence)compilerKind)) continue;
                defaultSettingsModel.setCompiler(oCCompilerKind, null, null);
                compiledFound = true;
                break;
            }
            if (!compiledFound) {
                throw new RuntimeException("Unknown compiler: " + compilerKind);
            }
        }
        OCMockWorkspace.CompilerSettingsData settings = this.getCompilerSettings(baseDir, map);
        for (OCCompilerKind oCCompilerKind : CLanguageKind.values()) {
            OCMockWorkspace.applyDefinesAndFeatures((OCLanguageKind)oCCompilerKind, configModel.getLanguageCompilerSettings((OCLanguageKind)oCCompilerKind), settings, this.defaultLangStandard);
        }
        OCMockWorkspace.CompilerSettingsData compilerSettingsData = settings;
        if (compilerSettingsData == null) {
            OCMockProjectReader.$$$reportNull$$$0(13);
        }
        return compilerSettingsData;
    }

    @NotNull
    private OCMockWorkspace.CompilerSettingsData getCompilerSettings(@NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(14);
        }
        OCMockWorkspace.CompilerSettingsData settings = new OCMockWorkspace.CompilerSettingsData(OCMockProjectReader.getDefines(map), OCMockProjectReader.getFeatures(map), OCMockProjectReader.getCompilerSwitches(baseDir, map), OCMockProjectReader.getImplicitIncludes(baseDir, map));
        if (this.defaultLangStandard != null) {
            if (settings.features == null) {
                settings.features = new LinkedHashMap();
            }
            Map<OCCompilerFeatures.Type<?>, Object> mutableFeatures = settings.features;
            mutableFeatures.putIfAbsent(OCCompilerFeatures.LANGUAGE_STANDARD, this.defaultLangStandard);
        }
        OCMockWorkspace.CompilerSettingsData compilerSettingsData = settings;
        if (compilerSettingsData == null) {
            OCMockProjectReader.$$$reportNull$$$0(15);
        }
        return compilerSettingsData;
    }

    @Nullable
    private static Map<OCCompilerFeatures.Type<?>, Object> getFeatures(@Nullable Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object features = map.get("features");
        if (features == null) {
            return null;
        }
        assert (features instanceof Map) : "unexpected type for 'features', should be a map";
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry eachEntry : ((Map)features).entrySet()) {
            String featureName = (String)eachEntry.getKey();
            if (OCCompilerFeatures.LANGUAGE_STANDARD.toString().equals(featureName)) {
                String value2 = (String)eachEntry.getValue();
                try {
                    OCLanguageStandard standard = OCLanguageStandard.valueOf((String)value2);
                    result.put(OCCompilerFeatures.LANGUAGE_STANDARD, standard);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Unknown or unsupported language standard: " + value2);
                }
            }
            try {
                OCCompilerFeatures.Feature feature = OCCompilerFeatures.Feature.valueOf((String)featureName);
                result.put((OCCompilerFeatures.Type<?>)feature, (Boolean)eachEntry.getValue());
            }
            catch (IllegalArgumentException e) {
                try {
                    OCCompilerFeatures.TypeSize typeSize = OCCompilerFeatures.TypeSize.valueOf((String)featureName);
                    result.put((OCCompilerFeatures.Type<?>)typeSize, ((Number)eachEntry.getValue()).shortValue());
                }
                catch (IllegalArgumentException e2) {
                    throw new RuntimeException("Unknown or unsupported compiler feature: " + featureName);
                }
            }
        }
        return result;
    }

    @Nullable
    private static List<String> getDefines(@Nullable Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object defines = map.get("defines");
        if (defines == null) {
            return null;
        }
        assert (defines instanceof Map) : "unexpected type for 'defines', should be a map";
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry eachEntry : ((Map)defines).entrySet()) {
            String define = "#define " + (String)eachEntry.getKey();
            if (eachEntry.getValue() != null) {
                define = define + " " + String.valueOf(eachEntry.getValue());
            }
            result.add(define);
        }
        return result;
    }

    @Nullable
    private static CidrCompilerSwitches getCompilerSwitches(@NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(16);
        }
        if (map == null) {
            return null;
        }
        Object compilerOptions = map.get("compilerArgs");
        if (compilerOptions == null) {
            return null;
        }
        ArrayList<String> options = new ArrayList<String>();
        if (compilerOptions instanceof String) {
            options.add(OCMockProjectReader.replaceMacros(baseDir, (String)compilerOptions));
        } else {
            options.addAll(ContainerUtil.map((Collection)((List)compilerOptions), opt -> OCMockProjectReader.replaceMacros(baseDir, opt)));
        }
        return new CidrCompilerSwitches(options);
    }

    @Nullable
    private static List<VirtualFile> getImplicitIncludes(@NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(17);
        }
        List<VirtualFile> pchIncludes = OCMockProjectReader.getPCHIncludes(baseDir, map);
        List<VirtualFile> forcedIncludes = OCMockProjectReader.getForcedIncludes(baseDir, map);
        if (pchIncludes == null) {
            return forcedIncludes;
        }
        if (forcedIncludes == null) {
            return pchIncludes;
        }
        ArrayList<VirtualFile> allIncludes = new ArrayList<VirtualFile>();
        allIncludes.addAll(pchIncludes);
        allIncludes.addAll(forcedIncludes);
        return allIncludes;
    }

    @Nullable
    private static List<VirtualFile> getForcedIncludes(@NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        ArrayList<String> options;
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(18);
        }
        if (map == null) {
            return null;
        }
        Object compilerOptions = map.get("compilerArgs");
        if (compilerOptions == null) {
            return null;
        }
        if (compilerOptions instanceof String) {
            options = new ArrayList<String>();
            options.add((String)compilerOptions);
        } else {
            options = (ArrayList<String>)compilerOptions;
        }
        boolean skipNext = false;
        boolean isThisOptImplicitIncludePath = false;
        ArrayList<VirtualFile> implicitIncludes = new ArrayList<VirtualFile>();
        for (String option : options) {
            VirtualFile vf;
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (option.equals("-Xclang")) {
                skipNext = true;
                continue;
            }
            if (isThisOptImplicitIncludePath) {
                VirtualFile vf2 = VfsUtil.findFile((Path)Paths.get(OCMockProjectReader.replaceMacros(baseDir, option), new String[0]), (boolean)false);
                if (CidrLog.LOG.assertTrue(vf2 != null, (Object)("cannot find implicit include: " + String.valueOf(vf2)))) {
                    implicitIncludes.add(vf2);
                }
                isThisOptImplicitIncludePath = false;
                continue;
            }
            if (option.startsWith("-include-")) continue;
            if (option.equals("-include") || option.equals("-imacros")) {
                isThisOptImplicitIncludePath = true;
                continue;
            }
            String implicitIncludePath = null;
            if (option.startsWith("-include") || option.startsWith("-imacros")) {
                implicitIncludePath = option.substring("-include".length());
            } else if (option.startsWith("--include=") || option.startsWith("--imacros=")) {
                implicitIncludePath = option.substring("--include=".length());
            }
            if (implicitIncludePath == null || !CidrLog.LOG.assertTrue((vf = VfsUtil.findFile((Path)Paths.get(OCMockProjectReader.replaceMacros(baseDir, implicitIncludePath), new String[0]), (boolean)false)) != null, (Object)("cannot find implicit include: " + String.valueOf(vf)))) continue;
            implicitIncludes.add(vf);
        }
        return implicitIncludes.isEmpty() ? null : implicitIncludes;
    }

    @Nullable
    private static List<VirtualFile> getPCHIncludes(@NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(19);
        }
        if (map == null) {
            return null;
        }
        Object args = map.get("pch");
        if (args == null) {
            return null;
        }
        ArrayList<VirtualFile> pchFiles = new ArrayList<VirtualFile>(1);
        if (args instanceof String) {
            VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])new String[]{(String)args});
            if (CidrLog.LOG.assertTrue(file != null, (Object)("cannot find PCH file: " + String.valueOf(args)))) {
                pchFiles.add(file);
            }
        } else {
            for (String arg : (List)args) {
                VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])new String[]{arg});
                if (!CidrLog.LOG.assertTrue(file != null, (Object)("cannot find PCH file: " + arg))) continue;
                pchFiles.add(file);
            }
        }
        return pchFiles;
    }

    private static void readSearchPaths(@NotNull OCCompilerSettings.ModifiableModel settingsModel, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        Object files;
        if (settingsModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(20);
        }
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(21);
        }
        if (map == null) {
            OCMockProjectReader.$$$reportNull$$$0(22);
        }
        if ((files = map.get("headers_paths")) == null) {
            return;
        }
        if (files instanceof List) {
            File baseDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
            ArrayList<HeadersSearchPath> paths = new ArrayList<HeadersSearchPath>();
            for (Object eachEntry : (List)files) {
                File path;
                String eachPath;
                boolean isRecursive = false;
                HeadersSearchPath.Kind kind = HeadersSearchPath.Kind.SYSTEM;
                boolean isFrameworks = false;
                boolean ensureExists = true;
                boolean insideProjectTree = false;
                if (eachEntry instanceof String) {
                    eachPath = (String)eachEntry;
                } else {
                    Map entryMap = (Map)eachEntry;
                    if (entryMap.size() != 1) {
                        throw new RuntimeException("Unexpected entry in headers_paths: " + String.valueOf(eachEntry));
                    }
                    Map.Entry item = entryMap.entrySet().iterator().next();
                    eachPath = (String)item.getKey();
                    Map attributes = (Map)item.getValue();
                    isRecursive = Boolean.TRUE.equals(attributes.get("recursive"));
                    kind = Boolean.TRUE.equals(attributes.get("user")) ? HeadersSearchPath.Kind.USER : kind;
                    kind = Boolean.TRUE.equals(attributes.get("builtin")) ? HeadersSearchPath.Kind.BUILTIN : kind;
                    isFrameworks = Boolean.TRUE.equals(attributes.get("frameworks"));
                    ensureExists = !Boolean.FALSE.equals(attributes.get("ensureExists"));
                    insideProjectTree = Boolean.TRUE.equals(attributes.get("insideProjectTree"));
                }
                VirtualFile file = FileUtil.isAbsolute((String)eachPath) ? VfsUtil.findFile((Path)Paths.get(eachPath, new String[0]), (boolean)false) : baseDir.findFileByRelativePath(eachPath);
                if (ensureExists && file == null) {
                    throw new RuntimeException("Headers path " + eachPath + " not found in " + String.valueOf(baseDir));
                }
                File file2 = path = file != null ? VfsUtilCore.virtualToIoFile((VirtualFile)file) : new File(baseDirPath, eachPath);
                if (isFrameworks) {
                    kind = kind == HeadersSearchPath.Kind.USER ? HeadersSearchPath.Kind.USER_FRAMEWORK : HeadersSearchPath.Kind.FRAMEWORK;
                }
                paths.add(new HeadersSearchPath(path.getPath(), isRecursive, kind, insideProjectTree));
            }
            settingsModel.setHeadersSearchPaths(paths);
        }
    }

    private static boolean readGeneratedSources(@NotNull OCMockWorkspace workspace, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        if (workspace == null) {
            OCMockProjectReader.$$$reportNull$$$0(23);
        }
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(24);
        }
        if (map == null) {
            OCMockProjectReader.$$$reportNull$$$0(25);
        }
        return OCMockProjectReader.addFiles(baseDir, map.get("generated_sources"), (baseDirFile, eachRoot, fileAttrs) -> {
            if (!ContainerUtil.isEmpty((Map)fileAttrs)) {
                throw new NotImplementedError("No attributes are currently supported for generated_sources");
            }
            workspace.addGeneratedSourceFile(eachRoot);
            return true;
        });
    }

    private boolean readFiles(@NotNull OCMockWorkspace workspace, @NotNull OCResolveConfiguration.ModifiableModel configModel, @NotNull OCMockWorkspace.CompilerSettingsData configCompilerSettings, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        if (workspace == null) {
            OCMockProjectReader.$$$reportNull$$$0(26);
        }
        if (configModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(27);
        }
        if (configCompilerSettings == null) {
            OCMockProjectReader.$$$reportNull$$$0(28);
        }
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(29);
        }
        if (map == null) {
            OCMockProjectReader.$$$reportNull$$$0(30);
        }
        return OCMockProjectReader.addFiles(baseDir, map.get("files"), (baseDirFile, eachFile, fileAttributes) -> {
            OCLanguageKind langKind;
            if (eachFile.isDirectory()) {
                return false;
            }
            OCLanguageKind forcedKind = null;
            if (fileAttributes != null) {
                forcedKind = OCMockProjectReader.languageById((String)fileAttributes.get("language"));
            }
            if ((langKind = workspace.addSourceFile(eachFile, forcedKind, configModel)) != null) {
                OCCompilerSettings.ModifiableModel settingsModel = configModel.getSourceCompilerSettings(eachFile);
                assert (settingsModel != null) : "Settings model could not be retrieved";
                if (fileAttributes != null) {
                    OCMockProjectReader.readSearchPaths(settingsModel, baseDirFile, fileAttributes);
                }
                OCMockWorkspace.CompilerSettingsData fileCompilerSettings = this.getCompilerSettings(baseDir, fileAttributes);
                OCMockWorkspace.CompilerSettingsData mergedSettings = new OCMockWorkspace.CompilerSettingsData(fileCompilerSettings.defines != null ? fileCompilerSettings.defines : configCompilerSettings.defines, fileCompilerSettings.features != null ? fileCompilerSettings.features : configCompilerSettings.features, fileCompilerSettings.switches != null ? fileCompilerSettings.switches : configCompilerSettings.switches, fileCompilerSettings.implicitIncludes != null ? fileCompilerSettings.implicitIncludes : configCompilerSettings.implicitIncludes);
                OCMockWorkspace.applyDefinesAndFeatures(langKind, settingsModel, mergedSettings, this.defaultLangStandard);
            }
            return true;
        });
    }

    private static OCLanguageKind languageById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return switch (id) {
            case "c" -> CLanguageKind.C;
            case "c++" -> CLanguageKind.CPP;
            case "objc" -> CLanguageKind.OBJ_C;
            case "objc++" -> CLanguageKind.OBJ_CPP;
            default -> null;
        };
    }

    private static boolean addFiles(@NotNull VirtualFile baseDir, @Nullable Object files, @NotNull FileConsumer consumer) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(31);
        }
        if (consumer == null) {
            OCMockProjectReader.$$$reportNull$$$0(32);
        }
        if (files == null) {
            return false;
        }
        if (files instanceof List) {
            for (Object eachFileEntry : (List)files) {
                if (eachFileEntry instanceof Map) {
                    OCMockProjectReader.addFile(baseDir, (Map)eachFileEntry, consumer);
                    continue;
                }
                if (!(eachFileEntry instanceof String)) continue;
                OCMockProjectReader.addFile(baseDir, (String)eachFileEntry, null, consumer);
            }
        } else if (files instanceof String) {
            OCMockProjectReader.addFile(baseDir, (String)files, null, consumer);
        } else if (files instanceof Map) {
            OCMockProjectReader.addFile(baseDir, (Map)files, consumer);
        }
        return true;
    }

    private static void addFile(@NotNull VirtualFile baseDir, @NotNull Map<String, Map<String, Object>> entryMap, @NotNull FileConsumer consumer) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(33);
        }
        if (entryMap == null) {
            OCMockProjectReader.$$$reportNull$$$0(34);
        }
        if (consumer == null) {
            OCMockProjectReader.$$$reportNull$$$0(35);
        }
        if (entryMap.size() != 1) {
            throw new RuntimeException("Unexpected entry in files: " + String.valueOf(entryMap));
        }
        Map.Entry<String, Map<String, Object>> item = entryMap.entrySet().iterator().next();
        String eachFile = item.getKey();
        Map<String, Object> attributes = item.getValue();
        OCMockProjectReader.addFile(baseDir, eachFile, attributes, consumer);
    }

    private static void addFile(@NotNull VirtualFile baseDir, @NotNull String fileName, @Nullable Map<String, Object> fileAttrs, @NotNull FileConsumer consumer) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(36);
        }
        if (fileName == null) {
            OCMockProjectReader.$$$reportNull$$$0(37);
        }
        if (consumer == null) {
            OCMockProjectReader.$$$reportNull$$$0(38);
        }
        boolean[] found = new boolean[]{false};
        while (fileName.startsWith("../")) {
            fileName = fileName.substring(3);
            if ((baseDir = baseDir.getParent()) != null) continue;
            throw new RuntimeException(fileName + " not found, relative path is invalid");
        }
        String pattern = FileUtil.convertAntToRegexp((String)fileName);
        VirtualFile baseDirFile = baseDir;
        VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)baseDir, eachFile -> {
            String relative = VfsUtilCore.getRelativePath((VirtualFile)eachFile, (VirtualFile)baseDirFile, (char)'/');
            assert (relative != null) : "Relative path could not be determined";
            if (relative.matches(pattern) && !FileUtilRt.extensionEquals((String)relative, (String)EXTENSION) && consumer.addFile(baseDirFile, (VirtualFile)eachFile, fileAttrs)) {
                found[0] = true;
            }
            return true;
        });
        if (!found[0]) {
            throw new RuntimeException(fileName + " not found in " + String.valueOf(baseDir));
        }
    }

    @NotNull
    private static String replaceMacros(@NotNull VirtualFile baseDir, @NotNull String option) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(39);
        }
        if (option == null) {
            OCMockProjectReader.$$$reportNull$$$0(40);
        }
        if (option.contains("${BASE_DIR}")) {
            String string = option.replaceAll("\\$\\{BASE_DIR}", baseDir.getPath());
            if (string == null) {
                OCMockProjectReader.$$$reportNull$$$0(41);
            }
            return string;
        }
        String string = option;
        if (string == null) {
            OCMockProjectReader.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 13, 15, 41, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockWorkspace";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/fixtures/OCMockProjectReader";
                break;
            }
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configModel";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 12: 
            case 22: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsModel";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configCompilerSettings";
                break;
            }
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryMap";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/fixtures/OCMockProjectReader";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addConfiguration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readConfigOptions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerSettings";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readProject";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 41: 
            case 42: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readConfigOptions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerSettings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerSwitches";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitIncludes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getForcedIncludes";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPCHIncludes";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readSearchPaths";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readGeneratedSources";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "readFiles";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "replaceMacros";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 13, 15, 41, 42 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    private static interface FileConsumer {
        public boolean addFile(@NotNull VirtualFile var1, @NotNull VirtualFile var2, @Nullable Map<String, Object> var3);
    }
}

