/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.testFramework.ParsingTestCase;
import com.intellij.util.Consumer;
import com.intellij.util.FileContentUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrCodeInsightFixtureAdapter;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCaseBase;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectFixture;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCodeInsightTestCase
extends OCCodeInsightTestCaseBase<OCMockProjectFixture, CidrExecutionFixture<OCMockProjectFixture>, CidrDebuggingFixture<CidrExecutionFixture<OCMockProjectFixture>>, CidrCodeInsightFixture> {
    public OCCodeInsightTestCase() {
    }

    public OCCodeInsightTestCase(@NlsSafe @NotNull String relativeProjectPath) {
        if (relativeProjectPath == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(0);
        }
        super(relativeProjectPath);
    }

    public OCCodeInsightTestCase(@Nullable CidrTestProjectDescription testProjectDescription) {
        super(testProjectDescription);
    }

    public OCCodeInsightTestCase(@NlsSafe @NotNull String testFilesPath, @NlsSafe @NotNull String testFilesExtension) {
        if (testFilesPath == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(1);
        }
        if (testFilesExtension == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(2);
        }
        super(testFilesPath, testFilesExtension);
    }

    public OCCodeInsightTestCase(@NlsSafe @NotNull String projectRelativePath, @NlsSafe @NotNull String testFilesPath, @NlsSafe @NotNull String testFilesExtension) {
        if (projectRelativePath == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(3);
        }
        if (testFilesPath == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(4);
        }
        if (testFilesExtension == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(5);
        }
        super(projectRelativePath, testFilesPath, testFilesExtension);
    }

    @Override
    @Nullable
    protected OCMockProjectFixture createProjectFixture() {
        return this.applyProjectFixture(new OCMockProjectFixture(this.myTestDataFixture));
    }

    @Override
    @Nullable
    protected CidrCodeInsightFixture createCodeInsightFixture() {
        return new CidrCodeInsightFixture(this.myProjectFixture, OCCodeInsightTestCase.createProjectAdapter((OCMockProjectFixture)this.myProjectFixture), this.myTestFilesPath, this.myTestFilesExtension);
    }

    public static CidrCodeInsightFixtureAdapter<OCMockProjectFixture> createProjectAdapter(OCMockProjectFixture fixture) {
        return new CidrCodeInsightFixtureAdapter<OCMockProjectFixture>(fixture){

            @Override
            public void addFileToProject(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((OCMockProjectFixture)this.myProjectFixture).updateFirstResolveConfiguration((Consumer<OCResolveConfiguration.ModifiableModel>)((Consumer)model -> ((OCMockProjectFixture)this.myProjectFixture).getMockWorkspace().addSourceFile(file, null, (OCResolveConfiguration.ModifiableModel)model)));
            }

            @Override
            public void removeFileFromProject(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                ((OCMockProjectFixture)this.myProjectFixture).updateWorkspace((Consumer<OCWorkspace.ModifiableModel>)((Consumer)model -> ((OCMockProjectFixture)this.myProjectFixture).getMockWorkspace().removeSourceFile(file, (OCWorkspace.ModifiableModel)model)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/jetbrains/cidr/lang/fixtures/OCCodeInsightTestCase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addFileToProject";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removeFileFromProject";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void assertTypesEqual(@NotNull OCType type1, OCType type2) {
        if (type1 == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(6);
        }
        OCCodeInsightTestCase.assertTrue((String)String.format("Expected: %s, got %s", type1.getCanonicalName(OCResolveContext.empty((Project)this.getProject())), type2 == null ? "null" : type2.getCanonicalName(OCResolveContext.empty((Project)this.getProject()))), (boolean)type1.equals((Object)type2, OCResolveContext.empty((Project)this.getProject())));
    }

    protected void assertTypeSize(short expectedSizeInBytes, OCType type) {
        Integer actualSize = type == null ? null : Integer.valueOf(type.getSizeInBytes(null, null, this.getProject()));
        OCCodeInsightTestCase.assertTrue((String)String.format("Expected: %s, got %s", expectedSizeInBytes, type == null ? "null" : "sizeof(" + type.getCanonicalName(OCResolveContext.empty((Project)this.getProject())) + ") = " + actualSize), (actualSize != null && actualSize == expectedSizeInBytes ? 1 : 0) != 0);
    }

    protected static boolean isDumb(PsiFile psiFile) {
        return SyntaxTraverser.psiTraverser((PsiElement)psiFile).traverse().filter(element -> OCParsing.DUMB_ELEMENT_TYPE.equals(element.getNode().getElementType())).isNotEmpty();
    }

    protected <T extends PsiElement> void assertActionAvailable(String check, IntentionAction intentionAction, OCLanguageKind languageKind) {
        this.myAnnotationFixture.assertActionAvailable(check, this.myAnnotationFixture.getActionFromIntention(intentionAction), languageKind);
    }

    public static PsiFile reparse(VirtualFile file, Project project) {
        FileContentUtil.reparseFiles((Project)project, Collections.singletonList(file), (boolean)false);
        FileViewProvider fvp = PsiManager.getInstance((Project)project).findViewProvider(file);
        OCCodeInsightTestCase.assertNotNull((Object)fvp);
        PsiFile result = null;
        for (PsiFile psiFile : fvp.getAllFiles()) {
            ParsingTestCase.ensureParsed(psiFile);
            if (psiFile.getLanguage() != LanguageUtils.getInstance().getConfigLanguage()) continue;
            result = psiFile;
        }
        OCCodeInsightTestCase.assertNotNull(result);
        return result;
    }

    @NotNull
    public static LocalInspectionEP createInspectionProfile(@NotNull Class<? extends OCInspection> inspectionClass) {
        if (inspectionClass == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(7);
        }
        LocalInspectionEP inspection = new LocalInspectionEP();
        String name = inspectionClass.getCanonicalName();
        inspection.setPluginDescriptor((PluginDescriptor)new DefaultPluginDescriptor(PluginId.getId((String)"OCCodeInsightTestCase"), OCCodeInsightTestCase.class.getClassLoader()));
        inspection.shortName = InspectionProfileEntry.getShortName((String)StringUtil.getShortName((String)name));
        inspection.displayName = name;
        inspection.groupDisplayName = name;
        inspection.level = "WARNING";
        inspection.enabledByDefault = true;
        inspection.implementationClass = inspectionClass.getName();
        inspection.runForWholeFile = inspectionClass.getSimpleName().matches("OCUnused.*Inspection");
        LocalInspectionEP localInspectionEP = inspection;
        if (localInspectionEP == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(8);
        }
        return localInspectionEP;
    }

    @NotNull
    public OCMockProjectFixture applyProjectFixture(@NotNull OCMockProjectFixture ocMockProjectFixture) {
        if (ocMockProjectFixture == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(9);
        }
        OCMockProjectFixture oCMockProjectFixture = ocMockProjectFixture;
        if (oCMockProjectFixture == null) {
            OCCodeInsightTestCase.$$$reportNull$$$0(10);
        }
        return oCMockProjectFixture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeProjectPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilesPath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilesExtension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRelativePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/fixtures/OCCodeInsightTestCase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocMockProjectFixture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/fixtures/OCCodeInsightTestCase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createInspectionProfile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyProjectFixture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertTypesEqual";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInspectionProfile";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyProjectFixture";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10 -> new IllegalStateException(string);
        };
    }
}

