/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangdBridgeStartupActivity;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.tests.ClangdTestUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCClangdTestUtil
extends ClangdTestUtilBase {
    protected void runStartupActivity(Project project) {
        super.runStartupActivity(project);
        ClangdBridgeStartupActivity.runStartupActivity((Project)project);
    }

    public static void setUp(@NotNull Project project, @NotNull Disposable disposable, @NotNull Runnable onCrash, boolean useCommonTarget) {
        if (project == null) {
            OCClangdTestUtil.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            OCClangdTestUtil.$$$reportNull$$$0(1);
        }
        if (onCrash == null) {
            OCClangdTestUtil.$$$reportNull$$$0(2);
        }
        new OCClangdTestUtil().doSetUp(project, disposable, onCrash, useCommonTarget);
    }

    public static void enableClangTidy(@NotNull CodeInsightTestFixture fixture, @NotNull Project project, @NotNull String clangTidyChecks) {
        if (fixture == null) {
            OCClangdTestUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            OCClangdTestUtil.$$$reportNull$$$0(4);
        }
        if (clangTidyChecks == null) {
            OCClangdTestUtil.$$$reportNull$$$0(5);
        }
        ClangTidyInspection inspection = new ClangTidyInspection();
        inspection.setClangTidyChecks(clangTidyChecks);
        inspection.setPreferClangTidyFilesOverIDESettings(false);
        fixture.enableInspections(new InspectionProfileEntry[]{inspection});
        project.putUserData(ClangTidyAnnotator.RUN_IN_UNIT_TEST_MODE, (Object)true);
    }

    public static void enableMisra(@NotNull CodeInsightTestFixture fixture, @NotNull Project project, @NotNull String misraC2012Checks, @NotNull String misraCpp2008Checks, @NotNull String misraCpp2023Checks) {
        if (fixture == null) {
            OCClangdTestUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            OCClangdTestUtil.$$$reportNull$$$0(7);
        }
        if (misraC2012Checks == null) {
            OCClangdTestUtil.$$$reportNull$$$0(8);
        }
        if (misraCpp2008Checks == null) {
            OCClangdTestUtil.$$$reportNull$$$0(9);
        }
        if (misraCpp2023Checks == null) {
            OCClangdTestUtil.$$$reportNull$$$0(10);
        }
        MisraInspection inspection = new MisraInspection();
        inspection.setMyMisraC2012Checks(misraC2012Checks);
        inspection.setMyMisraCPP2008Checks(misraCpp2008Checks);
        inspection.setMyMisraCPP2023Checks(misraCpp2023Checks);
        fixture.enableInspections(new InspectionProfileEntry[]{inspection});
        project.putUserData(ClangTidyAnnotator.RUN_IN_UNIT_TEST_MODE, (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void withUserData(@NotNull Project project, @NotNull ThrowableRunnable<? extends Exception> runnable, @NotNull Key<T> key, @Nullable T value2) throws Exception {
        if (project == null) {
            OCClangdTestUtil.$$$reportNull$$$0(11);
        }
        if (runnable == null) {
            OCClangdTestUtil.$$$reportNull$$$0(12);
        }
        if (key == null) {
            OCClangdTestUtil.$$$reportNull$$$0(13);
        }
        Object previous = project.getUserData(key);
        try {
            project.putUserData(key, value2);
            runnable.run();
        }
        finally {
            project.putUserData(key, previous);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onCrash";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyChecks";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "misraC2012Checks";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "misraCpp2008Checks";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "misraCpp2023Checks";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/fixtures/OCClangdTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setUp";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enableClangTidy";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "enableMisra";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "withUserData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

