/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.WaitFor;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.fixtures.OCClangdTestUtil;
import com.jetbrains.cidr.lang.fixtures.OCFoundationCodeInsightTestCase;
import com.jetbrains.cidr.lang.fixtures.TestAdvancedClangIdeFacade;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class OCClangdCodeInsightTestCase
extends OCFoundationCodeInsightTestCase {
    public OCClangdCodeInsightTestCase() {
    }

    public OCClangdCodeInsightTestCase(@NlsSafe @NotNull String relativeProjectPath) {
        if (relativeProjectPath == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(0);
        }
        super(relativeProjectPath);
    }

    public OCClangdCodeInsightTestCase(@NlsSafe @NotNull String testFilesPath, @NlsSafe @NotNull String testFilesExtension) {
        if (testFilesPath == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(1);
        }
        if (testFilesExtension == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(2);
        }
        super(testFilesPath, testFilesExtension);
    }

    public static void setUpClangd(@NotNull Project project, @NotNull Disposable testRootDisposable, @NotNull Consumer<? super Throwable> onSuppressedException, boolean useCommonTarget) {
        if (project == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(3);
        }
        if (testRootDisposable == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(4);
        }
        if (onSuppressedException == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(5);
        }
        project.putUserData(ClangDaemonContext.IDE_FACADE_KEY, (Object)new TestAdvancedClangIdeFacade("main"));
        OCClangdTestUtil.setUp(project, testRootDisposable, () -> onSuppressedException.accept(new RuntimeException("Server has crashed!")), useCommonTarget);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        OCClangdCodeInsightTestCase.setUpClangd(this.getProject(), this.getTestRootDisposable(), x$0 -> this.addSuppressedException((Throwable)x$0), true);
    }

    protected void enableClangWarnings() {
        this.getProject().putUserData(CidrCodeInsightFixture.ENABLE_CLANG_WARNINGS, (Object)true);
    }

    protected void disableClangErrors() {
        this.getProject().putUserData(CidrCodeInsightFixture.DISABLE_CLANG_ERRORS, (Object)true);
    }

    protected void withClangWarnings(@NotNull Project project, @NotNull ThrowableRunnable<? extends Exception> runnable) throws Exception {
        if (project == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(7);
        }
        OCClangdTestUtil.withUserData(project, runnable, CidrCodeInsightFixture.ENABLE_CLANG_WARNINGS, true);
    }

    protected void withoutClangErrors(@NotNull Project project, @NotNull ThrowableRunnable<? extends Exception> runnable) throws Exception {
        if (project == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(8);
        }
        if (runnable == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(9);
        }
        OCClangdTestUtil.withUserData(project, runnable, CidrCodeInsightFixture.DISABLE_CLANG_ERRORS, true);
    }

    protected void withTimeout(@NotNull ThrowableRunnable<? extends Exception> runnable) throws Exception {
        if (runnable == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(10);
        }
        this.withTimeout(180, runnable, (ThrowableConsumer<? super Thread, ? extends Exception>)((ThrowableConsumer)mainThread -> {
            LOG.warn("Native stack traces:\n" + this.getNativeStacktrace());
            LOG.warn("Java stack traces:\n" + ThreadDumper.dumpThreadsToString());
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withTimeout(int timeoutSeconds, @NotNull ThrowableRunnable<? extends Exception> runnable, @NotNull ThrowableConsumer<? super Thread, ? extends Exception> onTimeout) throws Exception {
        if (runnable == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(11);
        }
        if (onTimeout == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(12);
        }
        final AtomicBoolean finished = new AtomicBoolean(false);
        Thread mainThread = Thread.currentThread();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            new WaitFor(this, (int)TimeUnit.SECONDS.toMillis(timeoutSeconds)){

                protected boolean condition() {
                    return finished.get();
                }
            };
            if (!finished.get()) {
                try {
                    onTimeout.consume((Object)mainThread);
                }
                catch (Throwable thr) {
                    LOG.error(thr);
                }
            }
        });
        try {
            runnable.run();
        }
        finally {
            finished.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected String getNativeStacktrace() throws Exception {
        ClangLanguageService service = ClangLanguageServiceProvider.getOrStart((Project)this.getProject());
        OCClangdCodeInsightTestCase.assertNotNull((Object)service);
        int clangdPid = service.getServerPid();
        MyDebuggerHandler handler = new MyDebuggerHandler();
        MyTestGDBConfiguration configuration = new MyTestGDBConfiguration();
        DebuggerDriver driver = configuration.createDriver(handler, ArchitectureType.X86_64);
        driver.startDebuggerProcess();
        driver.getProcessHandler().startNotify();
        StringBuilder stacktraces = new StringBuilder();
        DebuggerDriver.Inferior inferior = driver.loadForAttach(clangdPid);
        inferior.start();
        handler.running.get(15L, TimeUnit.SECONDS);
        driver.interrupt();
        handler.suspended.get(15L, TimeUnit.SECONDS);
        handler.clear();
        List threads = driver.getThreads();
        int counter = 0;
        for (LLThread thread : threads) {
            DebuggerDriver.ResultList frames = driver.getFrames(thread, 0, 30, false);
            stacktraces.append("Thread ").append(++counter);
            stacktraces.append('\n');
            for (LLFrame frame : frames.list) {
                stacktraces.append("[").append(frame.getProgramCounter()).append("] ").append(frame.getFunction()).append(" at ").append(frame.getFile()).append(":").append(frame.getIndex()).append('\n');
            }
            stacktraces.append('\n');
        }
        driver.resume();
        handler.running.get(15L, TimeUnit.SECONDS);
        inferior.detach();
        handler.detached.get(15L, TimeUnit.SECONDS);
        String string = stacktraces.toString();
        Object object = string;
        if (object == null) {
            OCClangdCodeInsightTestCase.$$$reportNull$$$0(13);
        }
        return object;
        finally {
            driver.getProcessHandler().destroyProcess();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeProjectPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilesPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilesExtension";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRootDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuppressedException";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onTimeout";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/fixtures/OCClangdCodeInsightTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/fixtures/OCClangdCodeInsightTestCase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeStacktrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setUpClangd";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withClangWarnings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withoutClangErrors";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withTimeout";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    private static class MyDebuggerHandler
    implements DebuggerDriver.Handler {
        @NotNull
        CompletableFuture<Object> attached = new CompletableFuture();
        @NotNull
        CompletableFuture<Object> running = new CompletableFuture();
        @NotNull
        CompletableFuture<Object> suspended = new CompletableFuture();
        @NotNull
        CompletableFuture<Object> detached = new CompletableFuture();

        private MyDebuggerHandler() {
        }

        public void handleAttached(int pid) {
            this.attached.complete(true);
        }

        public void handleRunning() {
            this.running.complete(true);
        }

        public void handleSignal(// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
            if (signal == null) {
                MyDebuggerHandler.$$$reportNull$$$0(0);
            }
            if (meaning == null) {
                MyDebuggerHandler.$$$reportNull$$$0(1);
            }
            if (stopPlace == null) {
                MyDebuggerHandler.$$$reportNull$$$0(2);
            }
            this.suspended.complete(true);
        }

        public void handleInterrupted(// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull DebuggerDriver.StopPlace stopPlace) {
            if (stopPlace == null) {
                MyDebuggerHandler.$$$reportNull$$$0(3);
            }
            this.suspended.complete(true);
        }

        public void handleDetached() {
            this.detached.complete(true);
        }

        void clear() {
            this.attached = new CompletableFuture();
            this.running = new CompletableFuture();
            this.suspended = new CompletableFuture();
            this.detached = new CompletableFuture();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meaning";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stopPlace";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/fixtures/OCClangdCodeInsightTestCase$MyDebuggerHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleSignal";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInterrupted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyTestGDBConfiguration
    extends GDBDriverConfiguration {
        private MyTestGDBConfiguration() {
        }
    }
}

