/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editing;

import com.intellij.psi.PsiElement;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrFormattingFixture;
import com.jetbrains.cidr.lang.CidrFileBasedChangeTestFixture;
import com.jetbrains.cidr.lang.OCFileBasedResultTestCase;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.OCLineIndentProvider;
import java.io.File;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public abstract class OCTypingTestCase
extends OCFileBasedResultTestCase {
    protected CidrFormattingFixture myFormattingFixture;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myFormattingFixture.setUp();
        this.getOCSettings().INDENT_NAMESPACE_MEMBERS = 4;
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myFormattingFixture = new CidrFormattingFixture((CidrCodeInsightFixture)this.myCodeInsightFixture);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myFormattingFixture.tearDown();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    public OCTypingTestCase(OCLanguageKind languageKind, String dataDir) {
        super(dataDir, languageKind);
    }

    @Override
    public String getLangTestDataPath() {
        return new File(super.getLangTestDataPath(), "complete_statement_and_typing/result/").getPath();
    }

    protected String getAssertionBlockPrefix() {
        return "///";
    }

    @Override
    protected CidrFileBasedChangeTestFixture createTestFixture() {
        return new CidrFileBasedChangeTestFixture<String>(this, (CidrCodeInsightFixture)this.myCodeInsightFixture, this.myProjectFixture, this.getAssertionBlockPrefix()){

            @Override
            protected void performInWriteAction(CodeInsightTestFixture fixture, String data, String errorPrefix) {
                switch (data) {
                    case "<COMPLETE_STATEMENT>": {
                        fixture.performEditorAction("EditorCompleteStatement");
                        break;
                    }
                    case "<TYPE_ENTER>": {
                        fixture.type('\n');
                        break;
                    }
                    case "<TYPE_LBRACE>": {
                        fixture.type('{');
                        break;
                    }
                    case "<TYPE_COLON>": {
                        fixture.type(':');
                        break;
                    }
                    case "<TYPE_AT>": {
                        fixture.type('@');
                        break;
                    }
                    case "<TYPE_APO>": {
                        fixture.type('\'');
                        break;
                    }
                    case "<TYPE_QUOTE>": {
                        fixture.type('\"');
                        break;
                    }
                    case "<TYPE_HASH>": {
                        fixture.type('#');
                        break;
                    }
                    case "<TYPE_BACKSPACE>": {
                        fixture.performEditorAction("EditorBackSpace");
                        break;
                    }
                    default: {
                        TestCase.fail((String)"Unknown action");
                    }
                }
            }

            @Override
            @NotNull
            protected String readAssertionData(String assertionContents) {
                String string = assertionContents.trim();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editing/OCTypingTestCase$1", "readAssertionData"));
            }
        };
    }

    protected void assertFormatAfterEnter(String before, String after2) throws Exception {
        this.assertFormatAfterTyping("\n", before, after2);
    }

    protected void assertFormatAfterEnterCPP(String before, String after2) throws Exception {
        this.assertFormatAfterTypingEx("cpp", "\n", before, after2);
    }

    protected void assertFormatAfterTyping(String typed, String before, String after2) throws Exception {
        this.assertFormatAfterTypingEx("m", typed, before, after2);
    }

    protected void assertFormatAfterTypingCPP(String typed, String before, String after2) throws Exception {
        this.assertFormatAfterTypingEx("cpp", typed, before, after2);
    }

    public void assertFormatAfterTypingEx(String fileExtWithoutDot, String typed, String before, String after2) throws Exception {
        ((CidrCodeInsightFixture)this.myCodeInsightFixture).configureByText(before, "test." + fileExtWithoutDot);
        ((CidrCodeInsightFixture)this.myCodeInsightFixture).getFixture().type(typed);
        try {
            ((CidrCodeInsightFixture)this.myCodeInsightFixture).checkResult(after2);
        }
        catch (Throwable e) {
            try {
                OCTypingTestCase.printPsiStructure((PsiElement)this.getFile());
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e instanceof Exception ? (Exception)e : new RuntimeException(e);
        }
    }

    public static void execIndentProcessorAsInApplication(@NotNull ThrowableRunnable<Exception> doit) throws Exception {
        if (doit == null) {
            OCTypingTestCase.$$$reportNull$$$0(0);
        }
        boolean canUseFormatterForIndent = OCLineIndentProvider.setCanUseFormatterForIndent((boolean)true);
        try {
            doit.run();
        }
        finally {
            OCLineIndentProvider.setCanUseFormatterForIndent((boolean)canUseFormatterForIndent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doit", "com/jetbrains/cidr/lang/editing/OCTypingTestCase", "execIndentProcessorAsInApplication"));
    }
}

