/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.completion;

import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrFormattingFixture;
import com.jetbrains.cidr.lang.CidrFileBasedChangeTestFixture;
import com.jetbrains.cidr.lang.CidrFileBasedCompletionTestFixture;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.fixtures.OCFoundationCodeInsightTestCase;
import java.io.File;

public abstract class OCCompletionResultTestCase
extends OCFoundationCodeInsightTestCase {
    protected final OCLanguageKind myDefaultLanguageKind;
    protected CidrFileBasedChangeTestFixture myFileBasedChangeTestFixture;
    protected CidrFormattingFixture myFormattingFixture;

    public OCCompletionResultTestCase(OCLanguageKind languageKind, String dataDir) {
        super(dataDir, languageKind.getDefaultSourceExtension());
        this.myDefaultLanguageKind = languageKind;
    }

    protected final void doTest() throws Exception {
        this.doTest(this.myDefaultLanguageKind);
    }

    protected void doTest(OCLanguageKind languageKind) throws Exception {
        this.myFileBasedChangeTestFixture.doTest(((CidrCodeInsightFixture)this.myCodeInsightFixture).getFullFileName(this.getTestName(false), "." + languageKind.getDefaultSourceExtension()));
    }

    protected void doTestCMake() throws Exception {
        this.myFileBasedChangeTestFixture.doTest(((CidrCodeInsightFixture)this.myCodeInsightFixture).getFullFileName(this.getTestName(false), ".cmake"));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myFileBasedChangeTestFixture = this.createTestFixture();
        this.myFileBasedChangeTestFixture.setUp();
        this.myFormattingFixture.wrapBodyIntoBraces();
        this.getProject().putUserData(CallableInsertUtils.ENABLED_PLACEHOLDERS_IN_TESTS, (Object)false);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myFileBasedChangeTestFixture.tearDown();
            this.getProject().putUserData(CallableInsertUtils.ENABLED_PLACEHOLDERS_IN_TESTS, null);
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myFormattingFixture = new CidrFormattingFixture((CidrCodeInsightFixture)this.myCodeInsightFixture);
    }

    @Override
    public String getLangTestDataPath() {
        return new File(super.getLangTestDataPath(), "completion/result/").getPath();
    }

    protected CidrFileBasedChangeTestFixture createTestFixture() {
        return new CidrFileBasedCompletionTestFixture((CidrCodeInsightFixture)this.myCodeInsightFixture, this.myProjectFixture, "//");
    }
}

