/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.ide.ui.IdeUiService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.ui.OCResolveContextPanel;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class ConfigPanelAssert {
    private final OCResolveContextPanel myPanel;

    public ConfigPanelAssert(@NotNull Project project, @NotNull Disposable testRootDisposable) {
        if (project == null) {
            ConfigPanelAssert.$$$reportNull$$$0(0);
        }
        if (testRootDisposable == null) {
            ConfigPanelAssert.$$$reportNull$$$0(1);
        }
        this.myPanel = new OCResolveContextPanel(project);
        TestCase.assertNotNull((String)"resolve panel not found", (Object)this.myPanel);
        Disposer.register((Disposable)testRootDisposable, (Disposable)this.myPanel);
    }

    public void assertPresentation(OCResolveContextPanel panel, boolean visible, String text2) {
        TestCase.assertEquals((boolean)visible, (boolean)panel.getComponent().isVisible());
        TestCase.assertEquals((String)text2, (String)ConfigPanelAssert.getText(panel));
    }

    public void assertConfigurations(List<OCResolveConfiguration> expectedConfigs, OCResolveConfiguration selectedConfig) {
        this.assertConfigurations(expectedConfigs, selectedConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertConfigurations(List<OCResolveConfiguration> expectedConfigs, OCResolveConfiguration selectedConfig, OCLanguageKind languageKind) {
        Assert.assertFalse((boolean)expectedConfigs.isEmpty());
        String panelText = ConfigPanelAssert.getText(this.myPanel);
        if (languageKind != null) {
            Assert.assertEquals((Object)(languageKind.getShortDisplayName() + ": " + selectedConfig.getDisplayName()), (Object)panelText);
        } else {
            Assert.assertThat((Object)panelText, (Matcher)CoreMatchers.endsWith((String)(": " + selectedConfig.getDisplayName())));
        }
        ListPopup popup = this.getPanelPopup();
        try {
            ListPopupStep list = popup.getListStep();
            ArrayList<OCResolveConfiguration> actualConfigs = new ArrayList<OCResolveConfiguration>();
            List actionList = list.getValues();
            boolean hasAutoSelect = false;
            for (int i = 0; i < actionList.size(); ++i) {
                AnAction action = ((PopupFactoryImpl.ActionItem)actionList.get(i)).getAction();
                if (action instanceof OCResolveContextPanel.AutoSelectItem) {
                    Assert.assertEquals((long)0L, (long)i);
                    hasAutoSelect = true;
                    continue;
                }
                if (!(action instanceof OCResolveContextPanel.ConfigurationItem)) continue;
                OCResolveConfiguration config = ((OCResolveContextPanel.ConfigurationItem)action).getConfig();
                actualConfigs.add(config);
            }
            Assert.assertEquals((Object)(actualConfigs.size() > 1 ? 1 : 0), (Object)hasAutoSelect);
            UsefulTestCase.assertOrderedEquals(actualConfigs, expectedConfigs);
            if (!expectedConfigs.isEmpty()) {
                int selectedConfigIndex = actualConfigs.indexOf(selectedConfig);
                TestCase.assertTrue((String)("config not found " + String.valueOf(selectedConfig) + " among " + String.valueOf(expectedConfigs)), (selectedConfigIndex >= 0 ? 1 : 0) != 0);
                TestCase.assertEquals((int)(selectedConfigIndex + (hasAutoSelect ? 1 : 0)), (int)list.getDefaultOptionIndex());
            }
        }
        finally {
            Disposer.dispose((Disposable)popup);
        }
    }

    public static String getText(OCResolveContextPanel panel) {
        return ((TextPanel)panel.getComponent()).getText();
    }

    public ListPopup getPanelPopup() {
        return this.myPanel.createPopup(IdeUiService.getInstance().createUiDataContext((Component)this.myPanel.getComponent()));
    }

    public OCResolveContextPanel getPanel() {
        return this.myPanel;
    }

    public void scheduleUpdate(boolean immediately) {
        this.myPanel.updateInTests(immediately);
    }

    public void flushUpdate() {
        this.myPanel.flushUpdateInTests();
    }

    public void scheduleUpdate() {
        this.scheduleUpdate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "testRootDisposable";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/ConfigPanelAssert";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

