/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrTestCaseBase;
import com.jetbrains.cidr.WaitUtilKt;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public final class CidrTestExecutionFixtureUtil {
    public static final String MARKER = "<MARKER>";
    private static final Pattern TEST_NUM_PATTERN = Pattern.compile("(.*)\\[(\\d+)]");

    public static SMTestRunnerResultsForm getTestResultsView(ExecutionConsole console) {
        SMTRunnerConsoleView testConsole = (SMTRunnerConsoleView)console;
        return testConsole.getResultsViewer();
    }

    public static SMTestProxy.SMRootTestProxy getTestRootNode(ExecutionConsole console) {
        return CidrTestExecutionFixtureUtil.getTestResultsView(console).getTestsRootNode();
    }

    public static String printTest(SMTestProxy test) {
        MockPrinter printer = new MockPrinter();
        test.printOn((Printer)printer);
        return printer.getOutput();
    }

    @NotNull
    public static String testNodeToString(SMTestProxy test) {
        StringBuilder builder = new StringBuilder();
        CidrTestExecutionFixtureUtil.print(test, "", builder);
        String string = builder.toString();
        if (string == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static void print(SMTestProxy test, String prefix, StringBuilder builder) {
        builder.append(prefix).append(test.getName()).append(":");
        if (test.getMagnitudeInfo() == TestStateInfo.Magnitude.IGNORED_INDEX) {
            builder.append((Object)Node.TestState.SKIPPED);
        } else if (test.isDefect()) {
            builder.append((Object)Node.TestState.FAILED);
        } else {
            builder.append((Object)Node.TestState.OK);
        }
        if (test.isInProgress()) {
            builder.append(" [RUNNING]");
        }
        builder.append("\n");
        for (SMTestProxy each : test.getChildren()) {
            CidrTestExecutionFixtureUtil.print(each, prefix + "  ", builder);
        }
    }

    @NotNull
    public static Node root(Node.TestState state, Node ... children) {
        return new Node("[root]", state, children);
    }

    @NotNull
    public static Node group(String name, Node.TestState state, Node ... children) {
        return new Node(name, state, children);
    }

    @NotNull
    public static Node test(String name, Node.TestState state) {
        return new Node(name, state, new Node[0]);
    }

    @NotNull
    public static SMTestProxy findTest(@NotNull SMTestProxy.SMRootTestProxy root, @NotNull String path, @NotNull String splitter) {
        if (root == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(1);
        }
        if (path == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(2);
        }
        if (splitter == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(3);
        }
        SMTestProxy.SMRootTestProxy current = root;
        for (String each : StringUtil.split((String)path, (String)splitter)) {
            String finalEach;
            List found;
            int index = 0;
            Matcher matcher = TEST_NUM_PATTERN.matcher(each);
            if (matcher.matches()) {
                each = matcher.group(1);
                index = Integer.parseInt(matcher.group(2));
            }
            if ((current = (found = current.getChildren((Filter)new Filter<SMTestProxy>(finalEach = each){
                final /* synthetic */ String val$finalEach;
                {
                    this.val$finalEach = string;
                }

                public boolean shouldAccept(SMTestProxy test) {
                    return test.getName().equals(this.val$finalEach);
                }
            })).isEmpty() ? null : (SMTestProxy)found.get(index)) != null) continue;
            break;
        }
        Assert.assertNotNull((String)("Test not found:" + path), (Object)current);
        SMTestProxy.SMRootTestProxy sMRootTestProxy = current;
        if (sMRootTestProxy == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(4);
        }
        return sMRootTestProxy;
    }

    @NotNull
    public static SMTestProxy findTest(@NotNull SMTestProxy.SMRootTestProxy root, @NotNull String path) {
        if (root == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(5);
        }
        if (path == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(6);
        }
        return CidrTestExecutionFixtureUtil.findTest(root, path, ">>");
    }

    @NotNull
    public static PsiElement getTestNavigationPsiElement(Project project, String testName, ExecutionConsole console) {
        PsiElement psiElement = CidrTestExecutionFixtureUtil.getTestNavigationLocation(project, testName, console).getPsiElement();
        if (psiElement == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @NotNull
    public static Location getTestNavigationLocation(Project project, String testName, ExecutionConsole console) {
        SMTestProxy test = CidrTestExecutionFixtureUtil.findTest(CidrTestExecutionFixtureUtil.getTestRootNode(console), testName);
        Assert.assertNotNull((Object)test);
        Location location = (Location)ReadAction.compute(() -> test.getLocation(project, ((BaseTestsOutputConsoleView)console).getProperties().getScope()));
        UsefulTestCase.assertInstanceOf(location, PsiLocation.class);
        Location location2 = location;
        if (location2 == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(8);
        }
        return location2;
    }

    public static PsiElement getTestErrorNavigationPsiElement(Project project, String testName, ExecutionConsole console) {
        OpenFileDescriptor desc;
        SMTestProxy test = CidrTestExecutionFixtureUtil.findTest(CidrTestExecutionFixtureUtil.getTestRootNode(console), testName);
        Assert.assertNotNull((Object)test);
        Navigatable nav = (Navigatable)ReadAction.compute(() -> {
            TestConsoleProperties properties = ((BaseTestsOutputConsoleView)console).getProperties();
            Location location = test.getLocation(project, properties.getScope());
            return test.getDescriptor(location, properties);
        });
        if (nav instanceof OpenFileDescriptor) {
            desc = (OpenFileDescriptor)nav;
        } else if (nav instanceof SMTRunnerConsoleProperties.FileHyperlinkNavigatable) {
            desc = ((SMTRunnerConsoleProperties.FileHyperlinkNavigatable)nav).getOpenFileDescriptor();
        } else {
            Assert.fail((String)("Unexpected navigatable type: " + String.valueOf(nav.getClass())));
            return null;
        }
        VirtualFile file = desc.getFile();
        int offset = desc.getOffset();
        return (PsiElement)ReadAction.compute(() -> {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            return psiFile == null ? null : psiFile.findElementAt(offset);
        });
    }

    public static void assertTestsRegexp(@NotNull ExecutionConsole executionConsole, @NotNull Node expectedRoot, @NotNull @RegExp String commandLineMandatoryPattern, @NotNull @RegExp String testOutPattern) {
        if (executionConsole == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(9);
        }
        if (expectedRoot == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(10);
        }
        if (commandLineMandatoryPattern == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(11);
        }
        if (testOutPattern == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(12);
        }
        try {
            CidrTestCaseBase.assertMatches(CidrTestExecutionFixtureUtil.checkTestNodeAndPrepareOut(executionConsole, expectedRoot, commandLineMandatoryPattern), testOutPattern);
        }
        catch (Throwable ex) {
            String out = CidrTestExecutionFixtureUtil.checkTestNodeAndPrepareOut(executionConsole, expectedRoot, commandLineMandatoryPattern);
            List outChunk = StringUtil.split((String)out, (String)"\n");
            String[] patternChunk = testOutPattern.split("\\\\n");
            int i = 0;
            for (String pa : patternChunk) {
                String p = pa.trim();
                p = StringUtil.trimStart((String)p, (String)"]*");
                p = StringUtil.trimStart((String)p, (String)"*");
                if ((p = StringUtil.trimEnd((String)p, (String)"[")).isEmpty()) continue;
                String s = "";
                while (i < outChunk.size() && (s = ((String)outChunk.get(i++)).trim()).isEmpty()) {
                }
                System.out.println("r-pattern: " + pa);
                System.out.println("  pattern: " + p);
                System.out.println("   source: " + s);
                try {
                    System.out.println("--------------------- " + Pattern.compile(p).matcher(s).matches());
                }
                catch (Throwable ignore) {
                    System.out.println("--------------------- bad");
                }
            }
            throw ex;
        }
    }

    @NotNull
    public static String checkTestNodeAndPrepareOut(@NotNull ExecutionConsole console, @NotNull Node expectedRoot, @NotNull @RegExp String commandLineMandatoryPattern) {
        if (console == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(13);
        }
        if (expectedRoot == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(14);
        }
        if (commandLineMandatoryPattern == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(15);
        }
        String[] consoleDump = new String[]{""};
        String[] treeDump = new String[]{""};
        UIUtil.invokeAndWaitIfNeeded(() -> {
            CidrTestLog.LOG.debug("{read");
            SMTestProxy.SMRootTestProxy actualRoot = CidrTestExecutionFixtureUtil.getTestRootNode(console);
            consoleDump[0] = CidrTestExecutionFixtureUtil.printTest((SMTestProxy)actualRoot);
            treeDump[0] = CidrTestExecutionFixtureUtil.testNodeToString((SMTestProxy)actualRoot);
            CidrTestLog.LOG.debug("}read");
            CidrTestLog.LOG.debug("log:" + consoleDump[0]);
            CidrTestLog.LOG.debug("tree:" + treeDump[0]);
        });
        TestCase.assertEquals((String)consoleDump[0], (String)expectedRoot.toString(), (String)treeDump[0]);
        HashSet<Pattern> staffLines = new HashSet<Pattern>();
        staffLines.add(Pattern.compile("[^\\n]*" + commandLineMandatoryPattern + "[^\\n]*"));
        staffLines.add(CidrOutputToGeneralTestEventsConverter.TEST_STARTED_PATTERN);
        staffLines.add(CidrOutputToGeneralTestEventsConverter.PROCESS_FINISHED_PATTERN);
        List lines2 = StringUtil.split((String)consoleDump[0], (String)"\n", (boolean)true, (boolean)false);
        ArrayList<String> testLines = new ArrayList<String>();
        for (String line : lines2) {
            boolean staffLine = line.startsWith("Cannot create and read debug symbols:");
            if (staffLine) continue;
            for (Pattern pattern : staffLines) {
                if (!pattern.matcher(line).matches()) continue;
                staffLines.remove(pattern);
                staffLine = true;
                break;
            }
            if (staffLine) continue;
            testLines.add(line);
        }
        TestCase.assertTrue((String)("Staff lines are absent:" + String.valueOf(staffLines) + "\nin text:\n" + consoleDump[0]), (boolean)staffLines.isEmpty());
        String string = StringUtil.join(testLines, (String)"\n");
        if (string == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static ExecutionConsole getConsoleAndWaitResults(@NotNull ExecutionConsole console) {
        if (console == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(17);
        }
        SMTestRunnerResultsForm view = CidrTestExecutionFixtureUtil.getTestResultsView(console);
        WaitUtilKt.waitForEvent((Function0<Boolean>)((Function0)() -> !view.isRunning()), null, 300000L);
        ExecutionConsole executionConsole = console;
        if (executionConsole == null) {
            CidrTestExecutionFixtureUtil.$$$reportNull$$$0(18);
        }
        return executionConsole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 9, 10, 11, 12, 13, 14, 15, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestExecutionFixtureUtil";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedRoot";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineMandatoryPattern";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testOutPattern";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "testNodeToString";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestExecutionFixtureUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTest";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNavigationPsiElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNavigationLocation";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "checkTestNodeAndPrepareOut";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleAndWaitResults";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTest";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "assertTestsRegexp";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkTestNodeAndPrepareOut";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleAndWaitResults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 9, 10, 11, 12, 13, 14, 15, 17 -> new IllegalArgumentException(string);
        };
    }

    private static class MockPrinter
    implements Printer {
        @NotNull
        private final StringBuilder myOutput = new StringBuilder();

        private MockPrinter() {
        }

        @NotNull
        public String getOutput() {
            String string = this.myOutput.toString();
            if (string == null) {
                MockPrinter.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
            if (text2 == null) {
                MockPrinter.$$$reportNull$$$0(1);
            }
            if (contentType == null) {
                MockPrinter.$$$reportNull$$$0(2);
            }
            this.myOutput.append(text2);
        }

        public void onNewAvailable(@NotNull Printable printable) {
            if (printable == null) {
                MockPrinter.$$$reportNull$$$0(3);
            }
            printable.printOn((Printer)this);
        }

        public void printHyperlink(@NotNull String text2, HyperlinkInfo info) {
            if (text2 == null) {
                MockPrinter.$$$reportNull$$$0(4);
            }
        }

        public void mark() {
            this.myOutput.append(CidrTestExecutionFixtureUtil.MARKER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestExecutionFixtureUtil$MockPrinter";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutput";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestExecutionFixtureUtil$MockPrinter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "print";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onNewAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "printHyperlink";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

