/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrContextConfigurationProducerFixture;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTestFixtureDelegate;
import com.jetbrains.cidr.execution.CidrTextFieldWithAutoCompletionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.testing.CidrBaseTestCase;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditor;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationProducer;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class CidrBaseTestRunConfigurationEditorTestCase<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, CODE_INSIGHT_FIXTURE extends CidrCodeInsightFixture, PRODUCER extends CidrTestRunConfigurationProducer<BC, TARGET, CONFIGURATION, ?>, DELEGATE extends CidrTestFixtureDelegate<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CODE_INSIGHT_FIXTURE> & CidrContextConfigurationProducerFixture<TARGET, PRODUCER>>
extends CidrBaseTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CODE_INSIGHT_FIXTURE, DELEGATE> {
    private final String[] myValidTargets;
    private final String[] myValidConfigurations;
    private final String myTargetTests;
    private final String myTargetCrashingTests;
    private final String myConfigDebug;
    private final String myConfigRelease;
    private static final Map<String, String> TEST_ENVS = Map.of("TESTVAR", "TESTVAL");
    private static final String TEST_PROGRAM_PARAMETERS = "-test_test_test";
    private static final String DEFAULT_SUITE = "DefaultSuite";
    protected CidrTextFieldWithAutoCompletionFixture myCompletionFixture;
    protected CidrTestRunConfigurationEditor myConfigurationEditor;

    protected CidrBaseTestRunConfigurationEditorTestCase(String @NotNull [] targets, String @NotNull [] valid_configurations, @NotNull String target_tests, @NotNull String target_crashing_tests, @NotNull String config_debug, @NotNull String config_release, @NotNull DELEGATE delegate) {
        if (target_tests == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(0);
        }
        if (target_crashing_tests == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(1);
        }
        if (config_debug == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(2);
        }
        if (config_release == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(3);
        }
        if (delegate == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(4);
        }
        if (targets == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(5);
        }
        if (valid_configurations == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(6);
        }
        super(delegate);
        this.myValidTargets = targets;
        this.myValidConfigurations = valid_configurations;
        this.myTargetTests = target_tests;
        this.myTargetCrashingTests = target_crashing_tests;
        this.myConfigDebug = config_debug;
        this.myConfigRelease = config_release;
    }

    @Override
    public void afterProjectOpened() {
        this.myConfigurationEditor = this.createEditor();
        Disposer.register((Disposable)this.getTestRootDisposable(), (Disposable)this.myConfigurationEditor);
        WriteAction.computeAndWait(() -> this.myConfigurationEditor.getComponent());
        this.myCompletionFixture.afterProjectOpened();
    }

    @Override
    public void beforeProjectClosed() {
        this.myCompletionFixture.beforeProjectClosed();
        Disposer.dispose((Disposable)this.myConfigurationEditor);
        this.myConfigurationEditor = null;
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrTestDataFixture(CidrTestDataFixture.getCLionTestData().toFile());
    }

    @Override
    protected boolean runInDispatchThread() {
        return !this.getName().endsWith("_Async");
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myCompletionFixture = new CidrTextFieldWithAutoCompletionFixture(CompletionType.SMART){

            @Override
            protected TextFieldWithAutoCompletion createTextFieldWithCompletion() {
                return CidrBaseTestRunConfigurationEditorTestCase.this.myConfigurationEditor.getSuiteField();
            }
        };
    }

    public void testNotIncreasingOutOfCodeModificationTracker() {
        Document document = this.myConfigurationEditor.getSuiteField().getDocument();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProjectFixture.getProject());
        Consumer updateDocument = s -> WriteAction.runAndWait(() -> {
            document.setText((CharSequence)s);
            psiDocumentManager.commitDocument(document);
        });
        ModificationTracker oobTracker = FileSymbolTablesCache.getInstance((Project)this.getProject()).getOutOfBlockModificationTracker();
        updateDocument.consume((Object)"1");
        long previousCount = oobTracker.getModificationCount();
        updateDocument.consume((Object)"2");
        CidrBaseTestRunConfigurationEditorTestCase.assertEquals((long)previousCount, (long)oobTracker.getModificationCount());
    }

    protected void assertTestList(String name, String ... methods) {
        this.myConfigurationEditor.getSuiteField().setText(name);
        Set suites = (Set)Cancellation.computeInNonCancelableSection(() -> this.myConfigurationEditor.myTestScopeEditor.collectSuiteTests());
        CidrBaseTestRunConfigurationEditorTestCase.assertOrderedEquals(suites, methods);
    }

    protected void assertValid(String name) {
        this.assertValid(name, true);
    }

    protected void assertInvalid(String name) {
        this.assertValid(name, false);
    }

    private void assertValid(String name, boolean valid) {
        this.myConfigurationEditor.getSuiteField().setText(name);
        CidrBaseTestRunConfigurationEditorTestCase.assertEquals((boolean)valid, (boolean)this.myConfigurationEditor.myTestScopeEditor.isValidSuiteName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyTargetSetup() throws Exception {
        RunManager runManager = RunManager.getInstance((Project)this.getProject());
        RunnerAndConfigurationSettings empty = runManager.createConfiguration("empty", this.getTestRunConfigurationTypeFactory());
        try {
            CidrRunConfiguration emptyConfiguration = (CidrRunConfiguration)empty.getConfiguration();
            this.myConfigurationEditor.applyTo((Object)emptyConfiguration);
            BuildTargetAndConfigurationData data = emptyConfiguration.getTargetAndConfigurationData();
            CidrBaseTestRunConfigurationEditorTestCase.assertNull((Object)data.target);
            CidrBaseTestRunConfigurationEditorTestCase.assertNull((Object)data.configurationName);
        }
        finally {
            runManager.removeConfiguration(empty);
        }
    }

    @Contract(pure=true)
    public static String @NotNull [] fromItem(@NotNull String item) {
        if (item == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(7);
        }
        String[] stringArray = new String[]{item};
        if (stringArray == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    public void testTargetInheritanceWhenCreatingInEditor() {
        ConfigurationFactory factory = this.getTestRunConfigurationTypeFactory();
        CONFIGURATION template = this.setupTemplateConfigurationWithDefaults(factory);
        this.assertNewConfigurationFromTemplateWithDefaults(factory, this.myValidTargets, this.myValidConfigurations, "fromEmpty");
        for (String target : this.myValidTargets) {
            for (String config : this.myValidConfigurations) {
                template.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(this.getProject().getName(), target, config));
                this.assertNewConfigurationFromTemplateWithDefaults(factory, CidrBaseTestRunConfigurationEditorTestCase.fromItem(target), CidrBaseTestRunConfigurationEditorTestCase.fromItem(config), "inherited");
            }
        }
        template.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(this.getProject().getName(), "AbsentTarget", "AbsentConfiguration"));
        this.assertNewConfigurationFromTemplateWithDefaults(factory, this.myValidTargets, this.myValidConfigurations, "error");
    }

    public void testTargetInheritanceInContextWithoutSelectedConfiguration() {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)this.getProject());
        runManager.setSelectedConfiguration(null);
        CidrTestRunConfigurationProducer<BC, TARGET, CONFIGURATION, ?> producer = this.getTestRunConfigurationProducer();
        ConfigurationFactory factory = this.getTestRunConfigurationTypeFactory();
        CONFIGURATION template = this.setupTemplateConfigurationWithDefaults(factory);
        for (String config : this.myValidConfigurations) {
            template.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(this.getProject().getName(), this.myTargetTests, config));
            CONFIGURATION fromTemplateGood = this.assertNewConfigurationFromTemplateWithDefaults(factory, CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myTargetTests), CidrBaseTestRunConfigurationEditorTestCase.fromItem(config), "inherited");
            producer.setupTarget(fromTemplateGood, ContainerUtil.createMaybeSingletonList(this.getTestTargetByName(this.myTargetTests)));
            this.checkSettingsWithDefaults(CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myTargetTests), CidrBaseTestRunConfigurationEditorTestCase.fromItem(config), fromTemplateGood);
            CONFIGURATION fromTemplateBad = this.assertNewConfigurationFromTemplateWithDefaults(factory, CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myTargetTests), CidrBaseTestRunConfigurationEditorTestCase.fromItem(config), "inherited");
            producer.setupTarget(fromTemplateBad, ContainerUtil.createMaybeSingletonList(this.getTestTargetByName(this.myTargetCrashingTests)));
            this.checkSettingsWithDefaults(CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myTargetCrashingTests), CidrBaseTestRunConfigurationEditorTestCase.fromItem(config), fromTemplateBad);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTargetInheritanceInContextWithSelectedConfiguration() {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)this.getProject());
        RunnerAndConfigurationSettings selected = runManager.createConfiguration("selected", this.getTestRunConfigurationTypeFactory());
        runManager.addConfiguration(selected);
        try {
            runManager.setSelectedConfiguration(selected);
            ConfigurationFactory factory = this.getTestRunConfigurationTypeFactory();
            CONFIGURATION template = this.setupTemplateConfigurationWithDefaults(factory);
            template.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(this.getProject().getName(), this.myTargetTests, this.myConfigRelease));
            CidrTestRunConfigurationProducer<BC, TARGET, CONFIGURATION, ?> producer = this.getTestRunConfigurationProducer();
            CONFIGURATION fromTemplateGood = this.assertNewConfigurationFromTemplateWithDefaults(factory, CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myTargetTests), CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myConfigRelease), "inherited");
            CidrRunConfiguration selectedConfiguration = (CidrRunConfiguration)selected.getConfiguration();
            selectedConfiguration.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(this.getProject().getName(), this.myTargetTests, this.myConfigRelease));
            producer.setupTarget(fromTemplateGood, ContainerUtil.createMaybeSingletonList(this.getTestTargetByName(this.myTargetTests)));
            this.checkSettingsWithDefaults(CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myTargetTests), CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myConfigRelease), fromTemplateGood);
            producer.setupTarget(fromTemplateGood, ContainerUtil.createMaybeSingletonList(this.getTestTargetByName(this.myTargetCrashingTests)));
            this.checkSettingsWithDefaults(CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myTargetCrashingTests), CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myConfigRelease), fromTemplateGood);
            selectedConfiguration.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(this.getProject().getName(), this.myTargetTests, this.myConfigDebug));
            producer.setupTarget(fromTemplateGood, ContainerUtil.createMaybeSingletonList(this.getTestTargetByName(this.myTargetTests)));
            this.checkSettingsWithDefaults(CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myTargetTests), CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myConfigDebug), fromTemplateGood);
            producer.setupTarget(fromTemplateGood, ContainerUtil.createMaybeSingletonList(this.getTestTargetByName(this.myTargetCrashingTests)));
            this.checkSettingsWithDefaults(CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myTargetCrashingTests), CidrBaseTestRunConfigurationEditorTestCase.fromItem(this.myConfigDebug), fromTemplateGood);
        }
        finally {
            runManager.removeConfiguration(selected);
        }
    }

    protected CONFIGURATION setupTemplateConfigurationWithDefaults(ConfigurationFactory factory) {
        CidrRunConfiguration template = (CidrRunConfiguration)RunManager.getInstance((Project)this.getProject()).getConfigurationTemplate(factory).getConfiguration();
        template.onNewConfigurationCreated();
        template.setEnvs(TEST_ENVS);
        template.setProgramParameters(TEST_PROGRAM_PARAMETERS);
        template.setWorkingDirectory(this.getHomePath());
        ((CidrTestRunConfiguration)template).getTestData().setTestMode(CidrTestRunConfigurationData.Mode.SUITE_TEST);
        ((CidrTestRunConfiguration)template).getTestData().setTestSuite(DEFAULT_SUITE);
        return (CONFIGURATION)template;
    }

    protected void assertDefaults(CONFIGURATION configuration) {
        CidrBaseTestRunConfigurationEditorTestCase.assertEquals((String)TEST_ENVS.toString(), (String)configuration.getEnvs().toString());
        CidrBaseTestRunConfigurationEditorTestCase.assertEquals((String)TEST_PROGRAM_PARAMETERS, (String)configuration.getProgramParameters());
        CidrBaseTestRunConfigurationEditorTestCase.assertNotNull((Object)configuration.getWorkingDirectory());
        CidrBaseTestRunConfigurationEditorTestCase.assertEquals((String)this.getHomePath().replace('\\', '/'), (String)configuration.getWorkingDirectory().replace('\\', '/'));
        CidrBaseTestRunConfigurationEditorTestCase.assertEquals((Object)CidrTestRunConfigurationData.Mode.SUITE_TEST, (Object)((CidrTestRunConfiguration)configuration).getTestData().getTestMode());
        CidrBaseTestRunConfigurationEditorTestCase.assertEquals((String)DEFAULT_SUITE, (String)((CidrTestRunConfiguration)configuration).getTestData().getTestSuite());
    }

    @NotNull
    public CONFIGURATION assertNewConfigurationFromTemplateWithDefaults(@NotNull ConfigurationFactory factory, String @NotNull [] acceptableTargetNames, String @NotNull [] acceptableConfigurationTypes, @NotNull String configName) {
        if (factory == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(9);
        }
        if (configName == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(10);
        }
        if (acceptableTargetNames == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(11);
        }
        if (acceptableConfigurationTypes == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(12);
        }
        RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)this.getProject()).createConfiguration(configName, factory);
        CidrRunConfiguration runConfiguration = (CidrRunConfiguration)configuration.getConfiguration();
        runConfiguration.onNewConfigurationCreated();
        this.checkSettingsWithDefaults(acceptableTargetNames, acceptableConfigurationTypes, runConfiguration);
        CidrRunConfiguration cidrRunConfiguration = runConfiguration;
        if (cidrRunConfiguration == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(13);
        }
        return (CONFIGURATION)cidrRunConfiguration;
    }

    public void checkSettingsWithDefaults(String @NotNull [] acceptableTargetNames, String @NotNull [] acceptableConfigurationTypes, CONFIGURATION runConfiguration) {
        if (acceptableTargetNames == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(14);
        }
        if (acceptableConfigurationTypes == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(15);
        }
        BuildTargetAndConfigurationData targetAndConfigurationData = runConfiguration.getTargetAndConfigurationData();
        CidrBaseTestRunConfigurationEditorTestCase.assertNotNull((Object)targetAndConfigurationData);
        CidrBaseTestRunConfigurationEditorTestCase.assertNotNull((Object)targetAndConfigurationData.target);
        CidrBaseTestRunConfigurationEditorTestCase.assertOneOf(targetAndConfigurationData.target.targetName, acceptableTargetNames);
        if (this.myDelegate.shouldSetupConfiguration()) {
            CidrBaseTestRunConfigurationEditorTestCase.assertOneOf(targetAndConfigurationData.configurationName, acceptableConfigurationTypes);
        }
        this.assertDefaults(runConfiguration);
    }

    @NotNull
    protected CidrTestRunConfigurationEditor createEditor() {
        CidrTestRunConfigurationEditor cidrTestRunConfigurationEditor = ((CidrContextConfigurationProducerFixture)((Object)this.myDelegate)).createEditor(this.getProject());
        if (cidrTestRunConfigurationEditor == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(16);
        }
        return cidrTestRunConfigurationEditor;
    }

    @NotNull
    public ConfigurationFactory getTestRunConfigurationTypeFactory() {
        ConfigurationFactory configurationFactory = this.myDelegate.getContextConfigurationTypeFactory();
        if (configurationFactory == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(17);
        }
        return configurationFactory;
    }

    @NotNull
    public CidrTestRunConfigurationProducer<BC, TARGET, CONFIGURATION, ?> getTestRunConfigurationProducer() {
        CidrTestRunConfigurationProducer cidrTestRunConfigurationProducer = (CidrTestRunConfigurationProducer)RunConfigurationProducer.getInstance(((CidrContextConfigurationProducerFixture)((Object)this.myDelegate)).getContextConfigurationProducerClass());
        if (cidrTestRunConfigurationProducer == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(18);
        }
        return cidrTestRunConfigurationProducer;
    }

    @NotNull
    public TARGET getTestTargetByName(@NotNull String targetName) {
        if (targetName == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(19);
        }
        Object TARGET = ((CidrContextConfigurationProducerFixture)((Object)this.myDelegate)).getTestTargetByName(this.getProject(), targetName);
        if (TARGET == null) {
            CidrBaseTestRunConfigurationEditorTestCase.$$$reportNull$$$0(20);
        }
        return TARGET;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 13, 16, 17, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target_tests";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target_crashing_tests";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config_debug";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config_release";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valid_configurations";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrBaseTestRunConfigurationEditorTestCase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableTargetNames";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableConfigurationTypes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrBaseTestRunConfigurationEditorTestCase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromItem";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "assertNewConfigurationFromTemplateWithDefaults";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunConfigurationTypeFactory";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunConfigurationProducer";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestTargetByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromItem";
                break;
            }
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "assertNewConfigurationFromTemplateWithDefaults";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkSettingsWithDefaults";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTestTargetByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 13, 16, 17, 18, 20 -> new IllegalStateException(string);
        };
    }
}

