/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrTestFixtureDelegate;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.testing.CidrBaseTestCase;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.CidrTestRunLineMarkerProvider;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableListener;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class CidrBaseTestRecognizerTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, CODE_INSIGHT_FIXTURE extends CidrCodeInsightFixture, DELEGATE extends CidrTestFixtureDelegate<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CODE_INSIGHT_FIXTURE>>
extends CidrBaseTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CODE_INSIGHT_FIXTURE, DELEGATE> {
    public CidrBaseTestRecognizerTestCase(@NotNull DELEGATE delegate) {
        if (delegate == null) {
            CidrBaseTestRecognizerTestCase.$$$reportNull$$$0(0);
        }
        super(delegate);
    }

    @Override
    protected boolean runInDispatchThread() {
        return false;
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrTestDataFixture(CidrTestDataFixture.getCLionTestData().toFile());
    }

    public void assertTestIcons(String fileName, String ... expectedIcons) {
        List actualIconsAsString = (List)ReadAction.compute(() -> ((CidrCodeInsightFixture)this.myCodeInsightFixture).getIconsAsStrings((PsiElement)this.myProjectFixture.getProjectSubPsiFile(fileName), null));
        List actual = ContainerUtil.filter((Collection)actualIconsAsString, it -> it.contains("TestMark"));
        CidrBaseTestRecognizerTestCase.assertOrderedEquals(actual, expectedIcons);
    }

    public void assertTestLineMarkerIcons(String fileName, String ... expectedIcons) {
        ((CidrCodeInsightFixture)this.myCodeInsightFixture).assertLineMarkerIcons((PsiElement)this.myProjectFixture.getProjectSubPsiFile(fileName), (RunLineMarkerContributor)new CidrTestRunLineMarkerProvider(), expectedIcons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doTestInfoUpdate(@NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> testFramework, @NotNull PsiFile notATestFile, @NotNull PsiFile testFile, int testFileLinksNumber, boolean useOobTracker) {
        if (testFramework == null) {
            CidrBaseTestRecognizerTestCase.$$$reportNull$$$0(1);
        }
        if (notATestFile == null) {
            CidrBaseTestRecognizerTestCase.$$$reportNull$$$0(2);
        }
        if (testFile == null) {
            CidrBaseTestRecognizerTestCase.$$$reportNull$$$0(3);
        }
        CidrTestListUpdater.setSchedulingDisabledInTests((Boolean)false);
        Project project = notATestFile.getProject();
        CidrTestListUpdater updater = testFramework.getUpdater(project);
        updater.dropTestInfo(true);
        CidrTestListUpdater.setTaskExecutionDisabledInTests((boolean)true);
        try {
            Collection queue = updater.getProcessingQueue();
            CidrBaseTestRecognizerTestCase.checkQueue(project, queue, "");
            OCTestExecution.executeWithCachedValuesFastIgnoreUTMode(() -> {
                testFramework.isAvailable(notATestFile);
                CidrBaseTestRecognizerTestCase.assertTrue((boolean)updater.getScheduledFilesIterator().hasNext());
                return Void.TYPE;
            });
            OCTestExecution.executeWithRealValuesSlowIgnoreUTMode(() -> {
                updater.processTestInfoDirectly(updater.getScheduledFilesIterator());
                return Void.TYPE;
            });
            CidrBaseTestRecognizerTestCase.checkQueue(project, queue, "");
            Ref originalTestObjects = Ref.create();
            OCTestExecution.executeWithCachedValuesFastIgnoreUTMode(() -> {
                CidrBaseTestRecognizerTestCase.assertFalse((boolean)testFramework.isAvailable(notATestFile));
                CidrBaseTestRecognizerTestCase.assertFalse((boolean)updater.getScheduledFilesIterator().hasNext());
                CidrBaseTestRecognizerTestCase.assertTrue((boolean)testFramework.isAvailable(testFile));
                CidrBaseTestRecognizerTestCase.assertFalse((boolean)updater.getScheduledFilesIterator().hasNext());
                originalTestObjects.set(testFramework.getTestObjects(testFile).values());
                if (useOobTracker) {
                    FileSymbolTablesCache.getInstance((Project)project).incModificationCount();
                } else {
                    ((OCFileSymbolTableListener)project.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onAllSymbolTablesDropped();
                }
                CidrBaseTestRecognizerTestCase.assertFalse((boolean)testFramework.isAvailable(notATestFile));
                CidrBaseTestRecognizerTestCase.checkQueue(project, queue, notATestFile.getName() + ",");
                CidrBaseTestRecognizerTestCase.assertTrue((boolean)testFramework.isAvailable(testFile));
                CidrBaseTestRecognizerTestCase.checkQueue(project, queue, testFile.getName() + "," + notATestFile.getName() + ",");
                Map links = testFramework.getTestObjects(testFile);
                CidrBaseTestRecognizerTestCase.assertEquals((int)testFileLinksNumber, (int)links.size());
                return Void.TYPE;
            });
            updater.dropTestInfo(false);
            updater.initFirstScanIfNeedDirectly();
            CidrBaseTestRecognizerTestCase.checkQueue(project, queue, "");
            OCTestExecution.executeWithCachedValuesFastIgnoreUTMode(() -> {
                CidrBaseTestRecognizerTestCase.assertTrue((boolean)testFramework.isAvailable(testFile));
                CidrBaseTestRecognizerTestCase.assertSameElements((Collection)originalTestObjects.get(), testFramework.getTestObjects(testFile).values());
                return Void.TYPE;
            });
            CidrBaseTestRecognizerTestCase.checkQueue(project, queue, testFile.getName() + ",");
        }
        finally {
            CidrTestListUpdater.setTaskExecutionDisabledInTests((boolean)false);
            updater.dropTestInfo(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkQueue(@NotNull Project project, @NotNull Collection<VirtualFile> queue, @NotNull String expected) {
        if (project == null) {
            CidrBaseTestRecognizerTestCase.$$$reportNull$$$0(4);
        }
        if (queue == null) {
            CidrBaseTestRecognizerTestCase.$$$reportNull$$$0(5);
        }
        if (expected == null) {
            CidrBaseTestRecognizerTestCase.$$$reportNull$$$0(6);
        }
        Collection<VirtualFile> collection = queue;
        synchronized (collection) {
            List groups = StringUtil.split((String)expected, (String)"---", (boolean)true, (boolean)true);
            Iterator<VirtualFile> vfi = queue.iterator();
            for (String group : groups) {
                List expectedFileNames = StringUtil.split((String)group, (String)",", (boolean)true, (boolean)true);
                ArrayList<String> realFileNames = new ArrayList<String>();
                block4: for (String fileName : expectedFileNames) {
                    while (vfi.hasNext()) {
                        VirtualFile vfSource = vfi.next();
                        if (OCLanguageKindCalculatorBase.tryFileTypeAndExtension((Project)project, (VirtualFile)vfSource) == null) continue;
                        realFileNames.add(vfSource.getName());
                        continue block4;
                    }
                }
                CidrBaseTestRecognizerTestCase.assertSameElements(realFileNames, expectedFileNames);
            }
            while (vfi.hasNext()) {
                VirtualFile vfSource = vfi.next();
                if (OCLanguageKindCalculatorBase.tryFileTypeAndExtension((Project)project, (VirtualFile)vfSource) == null) continue;
                CidrBaseTestRecognizerTestCase.fail((String)("There is at least one more file in queue: " + vfi.next().getPath()));
                break;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFramework";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notATestFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrBaseTestRecognizerTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doTestInfoUpdate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkQueue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

