/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerAssertions;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrTestFixtureDelegate;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingTestCase;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.testing.OCUnitDebuggingProjectMarkup;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.concurrent.BlockingQueue;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public abstract class CidrBaseTestDebuggingTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, CODE_INSIGHT_FIXTURE extends CidrCodeInsightFixture, DELEGATE extends CidrTestFixtureDelegate<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CODE_INSIGHT_FIXTURE>>
extends CidrDebuggingTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, OCUnitDebuggingProjectMarkup> {
    @NotNull
    private final DELEGATE myDelegate;

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        CidrTestDataFixture cidrTestDataFixture = this.myDelegate.createTestDataFixture();
        if (cidrTestDataFixture == null) {
            CidrBaseTestDebuggingTestCase.$$$reportNull$$$0(0);
        }
        return cidrTestDataFixture;
    }

    public CidrBaseTestDebuggingTestCase(@NotNull DebuggerDriverKind backend, @NotNull String targetName, @NotNull String fixtureProjectFileRelativePath, @NotNull DELEGATE delegate) {
        if (backend == null) {
            CidrBaseTestDebuggingTestCase.$$$reportNull$$$0(1);
        }
        if (targetName == null) {
            CidrBaseTestDebuggingTestCase.$$$reportNull$$$0(2);
        }
        if (fixtureProjectFileRelativePath == null) {
            CidrBaseTestDebuggingTestCase.$$$reportNull$$$0(3);
        }
        if (delegate == null) {
            CidrBaseTestDebuggingTestCase.$$$reportNull$$$0(4);
        }
        super(backend, targetName, fixtureProjectFileRelativePath);
        this.myDelegate = delegate;
        this.myDelegate.initApplication();
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = this.myDelegate.shouldBuildSymbolTables();
        if (symbolsKind == null) {
            CidrBaseTestDebuggingTestCase.$$$reportNull$$$0(5);
        }
        return symbolsKind;
    }

    @Test
    public void testTests() throws Exception {
        this.initExecutionFixture();
        XDebuggerTestUtil.toggleBreakpoint(this.getProject(), ((OCUnitDebuggingProjectMarkup)this.myProjectMarkup).FILE_TESTS_FILE, ((OCUnitDebuggingProjectMarkup)this.myProjectMarkup).LINE_TEST1_TEST_SUCCESS);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((OCUnitDebuggingProjectMarkup)this.myProjectMarkup).FILE_TESTS_FILE, ((OCUnitDebuggingProjectMarkup)this.myProjectMarkup).LINE_TEST1_TEST_SUCCESS);
        this.getSession().resume();
        TestCase.assertEquals((Object)CidrDebuggingFixture.DebuggerState.RESUMED, (Object)CidrDebuggingFixture.waitFor(state));
        TestCase.assertEquals((Object)CidrDebuggingFixture.DebuggerState.STOPPED, (Object)CidrDebuggingFixture.waitFor(state));
        this.assertDefaultTests();
        TestCase.assertEquals((int)0, (int)state.size());
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.assumeDebugger().supportsTargetInputOutput();
    }

    @Override
    @NotNull
    protected OCUnitDebuggingProjectMarkup createProjectMarkup(@NotNull VirtualFile projectDir) throws Exception {
        if (projectDir == null) {
            CidrBaseTestDebuggingTestCase.$$$reportNull$$$0(6);
        }
        return new OCUnitDebuggingProjectMarkup(projectDir);
    }

    protected abstract void assertDefaultTests();

    protected abstract void initExecutionFixture();

    @Override
    @NotNull
    protected PROJECT_FIXTURE createProjectFixture() {
        Object PROJECT_FIXTURE = this.myDelegate.createProjectFixture(this.myTestDataFixture);
        if (PROJECT_FIXTURE == null) {
            CidrBaseTestDebuggingTestCase.$$$reportNull$$$0(7);
        }
        return PROJECT_FIXTURE;
    }

    @Override
    @NotNull
    protected EXECUTION_FIXTURE createExecutionFixture() {
        Object EXECUTION_FIXTURE = this.myDelegate.createExecutionFixture((CidrProjectFixture)this.myProjectFixture);
        if (EXECUTION_FIXTURE == null) {
            CidrBaseTestDebuggingTestCase.$$$reportNull$$$0(8);
        }
        return EXECUTION_FIXTURE;
    }

    @Override
    @NotNull
    protected DEBUGGING_FIXTURE createDebuggingFixture() {
        Object DEBUGGING_FIXTURE = this.myDelegate.createDebuggingFixture(this.myBackend, this.myTestDataFixture, (CidrExecutionFixture)this.myExecutionFixture, this.getQualifiedTestMethodName());
        if (DEBUGGING_FIXTURE == null) {
            CidrBaseTestDebuggingTestCase.$$$reportNull$$$0(9);
        }
        return DEBUGGING_FIXTURE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrBaseTestDebuggingTestCase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backend";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixtureProjectFileRelativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestDataFixture";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrBaseTestDebuggingTestCase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectFixture";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutionFixture";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebuggingFixture";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createProjectMarkup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

