/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.RunManager;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrTestFixtureDelegate;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrBaseTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, CODE_INSIGHT_FIXTURE extends CidrCodeInsightFixture, DELEGATE extends CidrTestFixtureDelegate<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CODE_INSIGHT_FIXTURE>>
extends CidrTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CODE_INSIGHT_FIXTURE> {
    @NotNull
    protected final DELEGATE myDelegate;
    private boolean myTargetDetectionIsOn;

    public CidrBaseTestCase(@NotNull DELEGATE delegate) {
        if (delegate == null) {
            CidrBaseTestCase.$$$reportNull$$$0(0);
        }
        this.myDelegate = delegate;
        this.myDelegate.initApplication();
    }

    @Override
    protected void setUp() throws Exception {
        this.myTargetDetectionIsOn = CidrBuildConfigurationHelper.setTargetDetection((boolean)true);
        Registry.get((String)"cidr.enable.testRunLineMarkers.clangGtestTestFrameworkSupport").setValue(false);
        Registry.get((String)"cidr.enable.testRunLineMarkers.clangBoostTestFrameworkSupport").setValue(false);
        Registry.get((String)"cidr.enable.testRunLineMarkers.clangDoctestTestFrameworkSupport").setValue(false);
        Registry.get((String)"cidr.enable.testRunLineMarkers.clangCatchTestFrameworkSupport").setValue(false);
        super.setUp();
        this.myDelegate.initProject((CidrProjectFixture)this.myProjectFixture);
        this.cleanProject();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            CidrBuildConfigurationHelper.setTargetDetection((boolean)this.myTargetDetectionIsOn);
            this.cleanProject();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            Registry.get((String)"cidr.enable.testRunLineMarkers.clangGtestTestFrameworkSupport").resetToDefault();
            Registry.get((String)"cidr.enable.testRunLineMarkers.clangBoostTestFrameworkSupport").resetToDefault();
            Registry.get((String)"cidr.enable.testRunLineMarkers.clangDoctestTestFrameworkSupport").resetToDefault();
            Registry.get((String)"cidr.enable.testRunLineMarkers.clangCatchTestFrameworkSupport").resetToDefault();
            super.tearDown();
        }
    }

    private void cleanProject() {
        WriteAction.runAndWait(() -> this.cleanAllConfigurations());
    }

    private void cleanAllConfigurations() {
        ((RunManagerImpl)RunManager.getInstance((Project)this.getProject())).clearAll();
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = this.myDelegate.shouldBuildSymbolTables();
        if (symbolsKind == null) {
            CidrBaseTestCase.$$$reportNull$$$0(1);
        }
        return symbolsKind;
    }

    @Override
    @Nullable
    protected PROJECT_FIXTURE createProjectFixture() {
        return this.myDelegate.createProjectFixture(this.myTestDataFixture);
    }

    @Override
    @Nullable
    protected CODE_INSIGHT_FIXTURE createCodeInsightFixture() {
        return this.myDelegate.createCodeInsightFixture((CidrProjectFixture)this.myProjectFixture);
    }

    @Override
    @Nullable
    protected EXECUTION_FIXTURE createExecutionFixture() {
        return this.myDelegate.createExecutionFixture((CidrProjectFixture)this.myProjectFixture);
    }

    @NotNull
    protected static String toRegexp(String text2, @RegExp String pathRegexp) {
        String string = StringUtil.escapeToRegexp((String)text2).replace("__FAILURE__", "(?:Failure|error:)").replace("__TPATH__", pathRegexp).replace("__TLINE__", "[:(]?\\d+\\)?").replace("\\n", "[ \\n]*").replace("__ANYEND__", "[^\\n]*").replace("__MAYBE_CLASS__", "(class )?").replace("__STD_UNKNOWN__", "(Unknown |std[:][:])");
        if (string == null) {
            CidrBaseTestCase.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrBaseTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrBaseTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toRegexp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

