/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.DSLDebuggerCommands;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import junit.framework.Assert;
import org.jetbrains.annotations.NotNull;

public final class DSLDebuggerStacktraceVerifier {
    @NotNull
    private static String runDebuggerCommand(@NotNull String command, @NotNull DSLDebuggerCommands debuggerCommands, @NotNull String fileWithPos) throws Exception {
        if (command == null) {
            DSLDebuggerStacktraceVerifier.$$$reportNull$$$0(0);
        }
        if (debuggerCommands == null) {
            DSLDebuggerStacktraceVerifier.$$$reportNull$$$0(1);
        }
        if (fileWithPos == null) {
            DSLDebuggerStacktraceVerifier.$$$reportNull$$$0(2);
        }
        CidrDebuggerLog.LOG.info(String.format("Running  command '%s' from '%s'", command, fileWithPos));
        switch (command) {
            case "step-into": {
                debuggerCommands.stepInto();
                break;
            }
            case "step-out": {
                debuggerCommands.stepOut();
                break;
            }
            case "step-over": {
                debuggerCommands.stepOver();
                break;
            }
            case "end": {
                debuggerCommands.end();
                break;
            }
            case "get-stack": {
                String string = debuggerCommands.getStack();
                if (string == null) {
                    DSLDebuggerStacktraceVerifier.$$$reportNull$$$0(3);
                }
                return string;
            }
            default: {
                Assert.fail((String)String.format("Unknown command '%s'", command));
            }
        }
        return "";
    }

    public static void verifyStepping(@NotNull DSLDebuggerCommands debuggerCommands, @NotNull File goldFile) throws Exception {
        if (debuggerCommands == null) {
            DSLDebuggerStacktraceVerifier.$$$reportNull$$$0(4);
        }
        if (goldFile == null) {
            DSLDebuggerStacktraceVerifier.$$$reportNull$$$0(5);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(goldFile, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            int currentLine = 1;
            String commandPrefix = "<<!";
            String commentPrefix = "#";
            while (line != null) {
                if (line.startsWith(commentPrefix)) {
                    line = reader.readLine();
                    ++currentLine;
                    continue;
                }
                if (!line.startsWith(commandPrefix)) {
                    Assert.fail((String)String.format("Expected command or comment at %s:%s", goldFile, currentLine));
                }
                String command = line.substring(commandPrefix.length()).trim();
                String commandOutput = DSLDebuggerStacktraceVerifier.runDebuggerCommand(command, debuggerCommands, String.format("%s:%s", goldFile, currentLine));
                StringJoiner expectedOutputJoiner = new StringJoiner("\n");
                line = reader.readLine();
                int lastCommandLine = ++currentLine;
                while (line != null && !line.startsWith(commandPrefix)) {
                    if (!line.isEmpty() && !line.startsWith(commentPrefix)) {
                        expectedOutputJoiner.add(line);
                    }
                    line = reader.readLine();
                    ++currentLine;
                }
                Assert.assertEquals((String)String.format("Command '%s' output on line %d generates unexpected output in file %s:%d", command, lastCommandLine, goldFile, lastCommandLine), (String)expectedOutputJoiner.toString(), (String)commandOutput);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerCommands";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithPos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/DSLDebuggerStacktraceVerifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goldFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/DSLDebuggerStacktraceVerifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runDebuggerCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runDebuggerCommand";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "verifyStepping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

