/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.XTestValueNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u001a'\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u001a\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a-\u0010\u0013\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u000f\u001a\u0018\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%\u001a\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(\u001a\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u000f\u001a\u0016\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020%2\u0006\u0010$\u001a\u00020%\u001a\u000e\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/\u001a!\u00100\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u000e\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0005\u00a2\u0006\u0002\u00102\u001a\u0014\u00103\u001a\u00020\u001a2\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\u0005\"\u0016\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"runInDumbMode", "T", "project", "Lcom/intellij/openapi/project/Project;", "block", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getVariables", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "stopPlace", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "evaluate", "expression", "", "getTopFrameFunctionName", "session", "Lcom/intellij/xdebugger/XDebugSession;", "runWithProcDumpOnError", "pids", "", "action", "Ljava/util/concurrent/Callable;", "(Ljava/util/List;Ljava/util/concurrent/Callable;)Ljava/lang/Object;", "runProcdump", "", "pid", "dumpDir", "GDBSERVER_TARGET_PID_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "runGdbServer", "Lcom/intellij/execution/process/OSProcessHandler;", "cl", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "disposable", "Lcom/intellij/openapi/Disposable;", "computeValue", "v", "Lcom/intellij/xdebugger/frame/XValue;", "skipTest", "reason", "disposeOnEdt", "parentDisposable", "waitForSessionToRun", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "waitForNotNull", "supplier", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "waitForCondition", "condition", "", "intellij.cidr.common.testFramework.core.nolang"})
public final class CidrDebuggingUtilKt {
    private static final Pattern GDBSERVER_TARGET_PID_PATTERN = Pattern.compile("(?:Process .* created; pid =|Detaching from process|Launched .* as process) (\\d+)(?:\\.\\.\\.)?");

    public static final <T> T runInDumbMode(@NotNull Project project, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return (T)CoroutinesKt.runBlockingCancellable((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(project, block, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ Function0<T> $block;
            {
                this.$project = $project;
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DumbServiceKt.runInDumbMode((DumbService)DumbService.Companion.getInstance(this.$project), (Function1)((Function1)new Function1<Continuation<? super T>, Object>(this.$block, null){
                            int label;
                            final /* synthetic */ Function0<T> $block;
                            {
                                this.$block = $block;
                                super(1, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        return this.$block.invoke();
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super T> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public static final List<LLValue> getVariables(@NotNull DebuggerDriver $this$getVariables, @NotNull DebuggerDriver.StopPlace stopPlace) throws ExecutionException, DebuggerCommandException {
        Intrinsics.checkNotNullParameter((Object)$this$getVariables, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stopPlace, (String)"stopPlace");
        List list = $this$getVariables.getVariables(stopPlace.thread, stopPlace.frame);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVariables(...)");
        return list;
    }

    @NotNull
    public static final LLValue evaluate(@NotNull DebuggerDriver $this$evaluate, @NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String expression) throws ExecutionException, DebuggerCommandException {
        Intrinsics.checkNotNullParameter((Object)$this$evaluate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stopPlace, (String)"stopPlace");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        LLValue lLValue = $this$evaluate.evaluate(stopPlace.thread, stopPlace.frame, expression);
        Intrinsics.checkNotNullExpressionValue((Object)lLValue, (String)"evaluate(...)");
        return lLValue;
    }

    @Nullable
    public static final String getTopFrameFunctionName(@NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        XSuspendContext xSuspendContext = session.getSuspendContext();
        XStackFrame xStackFrame = xSuspendContext != null && (xSuspendContext = xSuspendContext.getActiveExecutionStack()) != null ? xSuspendContext.getTopFrame() : null;
        CidrStackFrame cidrFrame = xStackFrame instanceof CidrStackFrame ? (CidrStackFrame)xStackFrame : null;
        CidrStackFrame cidrStackFrame = cidrFrame;
        return cidrStackFrame != null && (cidrStackFrame = cidrStackFrame.getFrame()) != null ? cidrStackFrame.getFunction() : null;
    }

    public static final <T> T runWithProcDumpOnError(@NotNull List<Long> pids, @NotNull Callable<T> action) {
        Intrinsics.checkNotNullParameter(pids, (String)"pids");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            return action.call();
        }
        catch (Throwable e) {
            if (!SystemInfo.isWindows) {
                throw e;
            }
            String dumpDir = System.getProperty("teamcity.build.tempDir");
            Iterator<Long> iterator = pids.iterator();
            while (iterator.hasNext()) {
                long pid = ((Number)iterator.next()).longValue();
                CidrDebuggingUtilKt.runProcdump(pid, dumpDir);
            }
            throw e;
        }
    }

    public static final void runProcdump(long pid, @Nullable String dumpDir) {
        GeneralCommandLine generalCommandLine;
        CidrDebuggerLog.LOG.info("Creating a dump of the process " + pid);
        if (dumpDir == null) {
            var4_2 = new String[]{"procdump", "-accepteula", "-ma", String.valueOf(pid)};
            GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(var4_2);
            generalCommandLine = generalCommandLine2;
        } else {
            var4_2 = new String[]{"procdump", "-accepteula", "-ma", String.valueOf(pid), dumpDir};
            GeneralCommandLine generalCommandLine3 = new GeneralCommandLine(var4_2);
            generalCommandLine = generalCommandLine3;
        }
        GeneralCommandLine cmd = generalCommandLine;
        try {
            ProcessOutput result = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
            CidrDebuggerLog.LOG.info(StringsKt.trimIndent((String)("\n            Created a dump of the process " + pid + ":\n            stdout: " + result.getStdout() + "\n            stderr: " + result.getStderr() + "\n            exit code: " + result.getExitCode() + "\n          ")));
        }
        catch (ExecutionException dumpError) {
            CidrDebuggerLog.LOG.warn("Failed to create dump the process " + pid, (Throwable)dumpError);
        }
    }

    public static /* synthetic */ void runProcdump$default(long l, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        CidrDebuggingUtilKt.runProcdump(l, string);
    }

    @Nullable
    public static final OSProcessHandler runGdbServer(@NotNull GeneralCommandLine cl, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        CompletableFuture<Integer> pidResult = new CompletableFuture<Integer>();
        OSProcessHandler handler = new OSProcessHandler(cl);
        handler.addProcessListener(new ProcessListener(pidResult){
            final /* synthetic */ CompletableFuture<Integer> $pidResult;
            {
                this.$pidResult = $pidResult;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text2 = StringsKt.removeSuffix((String)string, (CharSequence)"\n");
                CidrDebuggerLog.LOG.debug("gdbserver>" + text2);
                Matcher pidMatcher = CidrDebuggingUtilKt.access$getGDBSERVER_TARGET_PID_PATTERN$p().matcher(text2);
                if (pidMatcher.matches()) {
                    String string2 = pidMatcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                    this.setPid(Integer.parseInt(string2));
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int exitCode = event.getExitCode();
                CidrDebuggerLog.LOG.debug("gdbserver finished, exit code: " + exitCode);
                this.setPid(-exitCode);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void setPid(int result) {
                CompletableFuture<Integer> completableFuture = this.$pidResult;
                CompletableFuture<Integer> completableFuture2 = this.$pidResult;
                CompletableFuture<Integer> completableFuture3 = completableFuture;
                synchronized (completableFuture3) {
                    boolean bl = false;
                    if (!completableFuture2.isDone()) {
                        completableFuture2.complete(result);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
        Disposer.register((Disposable)disposable, () -> CidrDebuggingUtilKt.runGdbServer$lambda$0(handler, pidResult));
        handler.startNotify();
        try {
            Integer pid = pidResult.get(3L, TimeUnit.SECONDS);
            if (pid <= 0) {
                CidrDebuggerLog.LOG.warn("gdbserver exited with code " + -pid.intValue());
                return null;
            }
        }
        catch (TimeoutException timeoutException) {
            CidrDebuggerLog.LOG.warn("gdbserver inferior PID is unknown: gdbserver didn't report PID after startup");
        }
        return handler;
    }

    @NotNull
    public static final String computeValue(@NotNull XValue v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        XTestValueNode node = XDebuggerTestUtil.computePresentation(v);
        String string = node.myValue;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myValue");
        return string;
    }

    public static final void skipTest(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Assume.assumeTrue((String)reason, (boolean)false);
    }

    public static final void disposeOnEdt(@NotNull Disposable parentDisposable, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Disposer.register((Disposable)parentDisposable, () -> CidrDebuggingUtilKt.disposeOnEdt$lambda$0(disposable));
    }

    public static final void waitForSessionToRun(@NotNull CidrDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        CidrDebuggingUtilKt.waitForCondition((Function0<Boolean>)((Function0)() -> CidrDebuggingUtilKt.waitForSessionToRun$lambda$0(debugProcess)));
    }

    public static final <T> T waitForNotNull(@NotNull Function0<? extends T> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        Ref.ObjectRef result = new Ref.ObjectRef();
        CidrDebuggingUtilKt.waitForCondition((Function0<Boolean>)((Function0)() -> CidrDebuggingUtilKt.waitForNotNull$lambda$0(result, supplier)));
        Object object = result.element;
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    public static final void waitForCondition(@NotNull Function0<Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        long started = System.currentTimeMillis();
        while (!((Boolean)condition.invoke()).booleanValue()) {
            Thread.sleep(100L);
            if (System.currentTimeMillis() - started <= 25000L) continue;
            Assert.fail((String)"Waiting for condition timed out");
        }
    }

    private static final void runGdbServer$lambda$0(OSProcessHandler $handler, CompletableFuture $pidResult) {
        Integer pid;
        if (!CidrDebuggingFixture.waitFor((ProcessHandler)$handler, 3000L)) {
            $handler.destroyProcess();
        }
        if ((pid = (Integer)$pidResult.getNow(null)) != null) {
            if (pid > 0) {
                CidrDebuggerLog.LOG.debug("Killing gdbserver inferior PID: " + pid);
                OSProcessUtil.killProcess((int)pid);
            }
        } else {
            CidrDebuggerLog.LOG.warn("gdbserver inferior PID is unknown: target process might be left unattended and cause subsequent tests to fail");
        }
    }

    private static final void disposeOnEdt$lambda$0(Disposable $disposable) {
        ApplicationManager.getApplication().invokeAndWait(() -> CidrDebuggingUtilKt.disposeOnEdt$lambda$0$0($disposable));
    }

    private static final void disposeOnEdt$lambda$0$0(Disposable $disposable) {
        Disposer.dispose((Disposable)$disposable);
    }

    private static final boolean waitForSessionToRun$lambda$0(CidrDebugProcess $debugProcess) {
        return $debugProcess.getDriverInTests().getState() == DebuggerDriver.TargetState.RUNNING;
    }

    private static final boolean waitForNotNull$lambda$0(Ref.ObjectRef $result, Function0 $supplier) {
        $result.element = $supplier.invoke();
        return $result.element != null;
    }

    public static final /* synthetic */ Pattern access$getGDBSERVER_TARGET_PID_PATTERN$p() {
        return GDBSERVER_TARGET_PID_PATTERN;
    }
}

