/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerAssertions;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.jetbrains.cidr.CidrDebugProjectMarkup;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.assumptions.SystemAssumption;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingUtilKt;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingWithDebugProjectTestCase;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspendContext;
import com.jetbrains.cidr.execution.debugger.DSLDebuggerCommands;
import com.jetbrains.cidr.execution.debugger.DSLDebuggerStacktraceVerifier;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHitCountMode;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemoteDebugParameters;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.StringConcatFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assume;
import org.junit.Test;

public abstract class CidrDebuggingGeneralTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrDebuggingWithDebugProjectTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE> {
    public CidrDebuggingGeneralTestCase(String targetName, DebuggerDriverKind backend, String fixtureProjectFileRelativePath) {
        super(backend, targetName, fixtureProjectFileRelativePath);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.waitForResolve();
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        CidrTestDataFixture fixture = super.createTestDataFixture();
        fixture.enableSymlinkedProjectCreation();
        CidrTestDataFixture cidrTestDataFixture = fixture;
        if (cidrTestDataFixture == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(0);
        }
        return cidrTestDataFixture;
    }

    @Test
    public void testStartingAndFinishing() throws Exception {
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSession(new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler()));
    }

    @Test
    public void testExceptionsOnAsyncCommand() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        Throwable throwable = new ExecutionException("Execution error");
        CidrDebuggingGeneralTestCase.assertEquals((String)throwable.toString(), (String)this.catchErrorFromAsyncCommand(arg_0 -> CidrDebuggingGeneralTestCase.createThrowingCommand(throwable).consume(arg_0), false).toString());
        throwable = new DebuggerCommandException("debugger command error");
        CidrDebuggingGeneralTestCase.assertEquals((String)throwable.toString(), (String)this.catchErrorFromAsyncCommand(arg_0 -> CidrDebuggingGeneralTestCase.createThrowingCommand(throwable).consume(arg_0), false).toString());
        throwable = new RuntimeException("runtime error");
        CidrDebuggingGeneralTestCase.assertEquals((String)throwable.toString(), (String)this.catchErrorFromAsyncCommand(arg_0 -> CidrDebuggingGeneralTestCase.createThrowingCommand(throwable).consume(arg_0), true).toString());
        throwable = new ProcessCanceledException();
        CidrDebuggingGeneralTestCase.assertEquals((String)throwable.toString(), (String)this.catchErrorFromAsyncCommand(arg_0 -> CidrDebuggingGeneralTestCase.createThrowingCommand(throwable).consume(arg_0), false).toString());
        throwable = new NullPointerException();
        CidrDebuggingGeneralTestCase.assertEquals((String)throwable.toString(), (String)this.catchErrorFromAsyncCommand(arg_0 -> CidrDebuggingGeneralTestCase.createThrowingCommand(throwable).consume(arg_0), true).toString());
        this.getSession().resume();
    }

    @NotNull
    private static <T extends Throwable> ThrowableConsumer<DebuggerDriver, T> createThrowingCommand(T throwable) {
        ThrowableConsumer throwableConsumer = driver -> {
            throwable.addSuppressed(new Throwable());
            throw throwable;
        };
        if (throwableConsumer == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(1);
        }
        return throwableConsumer;
    }

    private Throwable catchErrorFromAsyncCommand(@NotNull CidrDebugProcess.VoidDebuggerCommand command, boolean mustBeLogged) throws Exception {
        if (command == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(2);
        }
        ArrayList<Throwable> loggedErrors = new ArrayList<Throwable>();
        Throwable throwable = (Throwable)CidrDebuggingGeneralTestCase.withLoggedErrorsRecorded(() -> {
            CidrDebugProcess debugProcess = (CidrDebugProcess)this.getSession().getDebugProcess();
            ExecutionResult executionResult = ExecutionResult.fromCompletableFuture((CompletableFuture)debugProcess.postCommand(command));
            try {
                executionResult.get(25000L, TimeUnit.MILLISECONDS);
                Throwable throwable = null;
                return throwable;
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                return throwable;
            }
            catch (ProcessCanceledException e) {
                ProcessCanceledException processCanceledException = e;
                return processCanceledException;
            }
            finally {
                debugProcess.postCommand(driver -> null).get(25000L, TimeUnit.MILLISECONDS);
            }
        }, loggedErrors);
        try {
            if (mustBeLogged) {
                CidrDebuggingGeneralTestCase.assertContainsElements(loggedErrors, throwable);
            } else {
                CidrDebuggingGeneralTestCase.assertDoesntContain(loggedErrors, throwable);
            }
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed(throwable);
            throw e;
        }
        return throwable;
    }

    protected static <T> T withLoggedErrorsRecorded(@NotNull ThrowableComputable<T, Exception> computable, @NotNull List<Throwable> loggedErrors) throws Exception {
        if (computable == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(3);
        }
        if (loggedErrors == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(4);
        }
        AtomicReference r = new AtomicReference();
        final List<Throwable> synchronizedLoggedErrors = Collections.synchronizedList(loggedErrors);
        LoggedErrorProcessor.executeWith(new LoggedErrorProcessor(){

            @Override
            @NotNull
            public Set<LoggedErrorProcessor.Action> processError(@NotNull String category, @NotNull String message, String @NotNull [] details, Throwable t) {
                if (category == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (details == null) {
                    1.$$$reportNull$$$0(2);
                }
                synchronizedLoggedErrors.add(t);
                EnumSet<LoggedErrorProcessor.Action> enumSet = LoggedErrorProcessor.Action.NONE;
                if (enumSet == null) {
                    1.$$$reportNull$$$0(3);
                }
                return enumSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "category";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "details";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingGeneralTestCase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingGeneralTestCase$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processError";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processError";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }, () -> r.set(computable.compute()));
        return (T)r.get();
    }

    @Test
    public void testPassingEnvVars() throws Exception {
        this.assumeDebugger().supportsTargetInputOutput();
        ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSession((Consumer<CidrRunConfiguration>)((Consumer)configuration -> {
            configuration.setProgramParameters("printEnv");
            configuration.getEnvs().put("TEST_ENV_VAR", "Foo");
            configuration.setPassParentEnvs(false);
        }), new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler());
        CidrDebuggingGeneralTestCase.assertMatches(((CidrDebuggingFixture)this.myDebuggingFixture).getConsoleText(), ".*TEST_ENV_VAR=Foo.*", 32);
    }

    @Test
    public void testPassingCommandLineArguments() throws Exception {
        this.assumeDebugger().supportsTargetInputOutput();
        ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSession((Consumer<CidrRunConfiguration>)((Consumer)configuration -> configuration.setProgramParameters("printArgs $SOME_VAR $PATH %PATH% \"foo bar\\baz\"")), new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler());
        String pattern = PlatformUtils.isAppCode() ? ".*1: printArgs\\n2: .*?:/usr/sbin:.*?\\n3: %PATH%\\n4: foo bar\\\\baz\\n.*" : ".*1: printArgs\\n2: \\$SOME_VAR\\n3: \\$PATH\\n4: %PATH%\\n5: foo bar\\\\baz\\n.*";
        CidrDebuggingGeneralTestCase.assertMatches(((CidrDebuggingFixture)this.myDebuggingFixture).getConsoleText(), pattern, 32);
    }

    @Test
    public void testInputRedirection() throws Exception {
        this.assumeDebugger().supportsTargetInputOutput();
        Path tempDir2 = this.getHostMachine().createTempDirectory("cidr", "test");
        File outputFile = FileUtil.createTempFile((File)tempDir2.toFile(), (String)"out", null);
        String outputEnvPath = this.getEnvironment().toEnvPath(outputFile.getAbsolutePath());
        String inputFile = ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath();
        ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSession((Consumer<CidrRunConfiguration>)((Consumer)configuration -> {
            configuration.setProgramParameters("echo");
            configuration.getEnvs().put("TEST_OUTPUT_FILE", outputEnvPath);
            configuration.setRedirectInput(true);
            configuration.setRedirectInputPath(inputFile);
        }), new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler());
        String expectedText = PlatformTestUtil.loadFileText(inputFile);
        String actualText = PlatformTestUtil.loadFileText(outputFile.getAbsolutePath());
        CidrDebuggingGeneralTestCase.assertEquals((String)expectedText, (String)actualText);
    }

    @Test
    public void testPausingAndResuming() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSessionWithListener("loop");
        CidrDebuggingGeneralTestCase.assertTrue((boolean)((XDebugSessionImpl)this.getSession()).isPauseActionSupported());
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)this.getSession().isPaused());
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingGeneralTestCase.assertFalse((boolean)this.getSession().isPaused());
        this.getSession().pause();
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)this.getSession().isPaused());
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingGeneralTestCase.assertFalse((boolean)this.getSession().isPaused());
        CidrDebuggingFixture.assertNoMoreEvents(state);
    }

    @Test
    public void testSwitchThreadOnPause() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSessionWithListener("loop");
        CidrDebuggingGeneralTestCase.assertTrue((boolean)((XDebugSessionImpl)this.getSession()).isPauseActionSupported());
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)this.getSession().isPaused());
        String mainThreadName = this.getSession().getSuspendContext().getActiveExecutionStack().getDisplayName();
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingGeneralTestCase.assertFalse((boolean)this.getSession().isPaused());
        this.getSession().pause();
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)this.getSession().isPaused());
        CidrDebuggingFixture.assertNoMoreEvents(state);
        String pausedThreadName = this.getSession().getSuspendContext().getActiveExecutionStack().getDisplayName();
        CidrDebuggingGeneralTestCase.assertEquals((String)mainThreadName, (String)pausedThreadName);
    }

    @Test
    public void testSuspendOnException() throws Exception {
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSessionWithListener("exception_in_extensionless_header");
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)this.getSession().isPaused());
        XSuspendContext suspendContext = this.getSession().getSuspendContext();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)suspendContext);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)suspendContext.getActiveExecutionStack());
    }

    @Test
    public void testSettingBreakpointsBeforeStarting() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
    }

    @Test
    public void testSettingBreakpointsWhileRunning() throws Exception {
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSessionWithListener("loop");
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrDebuggingGeneralTestCase.waitForSwing();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        CidrDebuggingFixture.assertNoMoreEvents(state);
    }

    @Test
    public void testRemovingBreakpoint() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FUNC_BEGINNING);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("func");
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FUNC_BEGINNING);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrDebuggingGeneralTestCase.waitForSwing();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
        CidrDebuggingFixture.assertNoMoreEvents(state);
    }

    @Test
    public void testBreakpointOnEmptyLine() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_EMPTY);
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
    }

    @Test
    public void testBreakpointInAsmCode() throws Exception {
        this.assumeSystem().isNotMac();
        this.assumeArchitecture().isX86orX64();
        VirtualFile asmFile = this.isMSVCRuntime() ? ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_ASM_MASM : ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_ASM;
        int asmLine = this.isMSVCRuntime() ? ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_ASM_MASM_PRINT_HELLO_AFTER_PROLOGUE : ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_ASM_PRINT_HELLO_AFTER_PROLOGUE;
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), asmFile, asmLine);
        this.startDebugSessionAndWaitForPause("asmPrintHello");
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), asmFile, asmLine);
    }

    @Test
    public void testBreakpointBeforeAllCode() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_BEFORE_MAIN_CODE);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        DebuggerDriver driver = this.getDebugProcess().getDriverInTests();
        if (driver instanceof GDBDriver) {
            GDBDriver gdbDriver = (GDBDriver)driver;
            Version gdbVersion = gdbDriver.getGdbVersion();
            Assume.assumeTrue((String)"GDB older than 16.1 allows adding breakpoints outside functions", (gdbVersion.major >= 16 ? 1 : 0) != 0);
        } else if (driver instanceof LLDBDriver) {
            Assume.assumeFalse((boolean)this.isWindowsHost());
        }
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XDebuggerAssertions.assertBreakpointValidity(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_BEFORE_MAIN_CODE, false, false, "The breakpoint will not currently be hit. No executable code is associated with this line.", CidrLineBreakpointType.class);
    }

    @Test
    public void testBreakpointInSharedLibrary() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
        XDebuggerAssertions.assertBreakpointValidity(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING, true, false, null, CidrLineBreakpointType.class);
    }

    @Test
    public void testBreakpointWithConditionInSharedLibrary() throws Exception {
        XLineBreakpoint breakpoint = XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)breakpoint);
        breakpoint.setCondition("argc");
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
    }

    @Test
    public void testBreakpointWithInvalidConditionInSharedLibrary() throws Exception {
        this.doTestBreakpointWithInvalidCondition(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
    }

    @Test
    public void testBreakpointWithInvalidCondition() throws Exception {
        this.doTestBreakpointWithInvalidCondition(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
    }

    public void doTestBreakpointWithInvalidCondition(VirtualFile file, int line) throws Exception {
        XLineBreakpoint breakpoint = XDebuggerAssertions.toggleBreakpoint(this.getProject(), file, line);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)breakpoint);
        breakpoint.setCondition("some_totally_invalid_condition");
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (this.myBackend == DebuggerDriverKind.LLDB) {
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
            this.getSession().resume();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        }
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
    }

    @Test
    public void testBreakpointErrorShownInUi() throws Exception {
        CustomizedBreakpointPresentation presentation;
        XLineBreakpoint breakpoint = XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_BREAKPOINT_WITH_STRING_CONDITION);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)breakpoint);
        breakpoint.setCondition("s == 3");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("breakpoint_with_string_condition");
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_BREAKPOINT_WITH_STRING_CONDITION);
        if (this.isMSVCRuntime() && this.myBackend == DebuggerDriverKind.LLDB) {
            this.getSession().resume();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
            XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_BREAKPOINT_WITH_STRING_CONDITION);
        }
        String errorMessage = (presentation = ((XDebugSessionImpl)this.getSession()).getBreakpointPresentation((XBreakpoint)breakpoint)) != null ? presentation.getErrorMessage() : null;
        CidrDebuggingGeneralTestCase.assertNotNull((Object)errorMessage);
        CidrDebuggingGeneralTestCase.assertTrue((String)("Unexpected error message: " + errorMessage), (boolean)errorMessage.startsWith("Failed to evaluate breakpoint condition"));
    }

    @Test
    public void testBreakpointInNotCompiledClass() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_UNUSED, 0);
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        String errMessage = CidrDebuggerBundle.message((String)"debug.breakpoint.line.unresolved.hint", (Object[])new Object[0]);
        XDebuggerAssertions.assertBreakpointValidity(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_UNUSED, 0, true, true, errMessage, CidrLineBreakpointType.class);
    }

    @Test
    public void testManuallyAddedBreakpoints() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XDebuggerTestUtil.waitFor(this.getDebugProcess().postCommand(driver -> {
            try {
                driver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
            }
            catch (DebuggerCommandException e) {
                throw new ExecutionException("Cannot set a breakpoint", (Throwable)e);
            }
        }), 25000L);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
        CidrDebuggingFixture.assertNoMoreEvents(state);
    }

    @Test
    public void testNoFrameIsPreselectedOnLineBreakpointInFunctionWithNoSource() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        XDebuggerTestUtil.waitFor(this.getDebugProcess().postCommand(driver -> {
            driver.addSymbolicBreakpoint("main_sourceless");
            driver.addSymbolicBreakpoint("_main_sourceless");
        }), 25000L);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), ".*\\b(_)?main_sourceless\\b.*");
        CidrDebuggingGeneralTestCase.assertNull((Object)((XStackFrame)((List)frames.first).get(0)).getSourcePosition());
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(1)).getFrame().getFunction(), "main\\b.*");
        CidrDebuggingGeneralTestCase.assertEquals((Object)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (Object)((XStackFrame)((List)frames.first).get(1)).getSourcePosition().getFile());
        CidrDebuggingGeneralTestCase.assertSame(null, (Object)frames.second);
    }

    @Test
    public void testFirstFrameWithSourceIsPreselectedOnExceptionBreakpointInFunctionWithNoSource() throws Exception {
        int mainIdx;
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("sourceless_throw");
        XDebuggerAssertions.insertBreakpoint(this.getProject(), new CidrExceptionBreakpointType.Properties(CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION, null), CidrExceptionBreakpointType.class);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertNull((Object)((XStackFrame)((List)frames.first).get(0)).getSourcePosition());
        for (mainIdx = 1; mainIdx < ((List)frames.first).size() && !((CidrStackFrame)((List)frames.first).get(mainIdx)).getFrame().getFunction().matches("main\\b.*"); ++mainIdx) {
        }
        CidrDebuggingGeneralTestCase.assertTrue((String)"Can't find main() frame", (mainIdx < ((List)frames.first).size() ? 1 : 0) != 0);
        CidrDebuggingGeneralTestCase.assertEquals((Object)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (Object)((XStackFrame)((List)frames.first).get(mainIdx)).getSourcePosition().getFile());
        CidrDebuggingGeneralTestCase.assertSame(((List)frames.first).get(mainIdx), (Object)frames.second);
    }

    @Test
    public void testExceptionBreakpointWhenOCExceptionThrown() throws Exception {
        Assume.assumeTrue((String)"OC debugging", (boolean)((CidrDebuggingFixture)this.myDebuggingFixture).isOCDebuggingSupported());
        XDebuggerAssertions.insertBreakpoint(this.getProject(), new CidrExceptionBreakpointType.Properties(CidrExceptionBreakpointType.Properties.Type.OBJC_EXCEPTION, null), CidrExceptionBreakpointType.class);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("ns_exception_breakpoints");
        String errorNodeName = "Exception";
        String errorNodeValue = "Exception breakpoint";
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), "objc_exception_throw", null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.ns_breakpoints_frame(frames), "ns_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_OC, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_THROWN, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.ns_breakpoints_frame(frames), (Object)frames.second);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), "objc_exception_throw", null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.ns_breakpoints_frame(frames), "ns_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_OC, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_UNCAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.ns_breakpoints_frame(frames), (Object)frames.second);
        CidrDebuggingFixture.assertNoMoreEvents(state);
    }

    @NotNull
    private CidrStackFrame ns_breakpoints_frame(Pair<List<XStackFrame>, XStackFrame> frames) {
        CidrStackFrame cidrStackFrame = ((CidrDebuggingFixture)this.myDebuggingFixture).findFrameMatching((List)frames.first, "ns_exception_breakpoints.*");
        if (cidrStackFrame == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(5);
        }
        return cidrStackFrame;
    }

    @NotNull
    private CidrStackFrame cpp_breakpoints_frame(Pair<List<XStackFrame>, XStackFrame> frames) {
        CidrStackFrame cidrStackFrame = ((CidrDebuggingFixture)this.myDebuggingFixture).findFrameMatching((List)frames.first, "cpp_exception_breakpoints.*");
        if (cidrStackFrame == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(6);
        }
        return cidrStackFrame;
    }

    @Test
    public void testExceptionBreakpointWhenCPPExceptionThrown() throws Exception {
        XDebuggerAssertions.insertBreakpoint(this.getProject(), new CidrExceptionBreakpointType.Properties(CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION, null), CidrExceptionBreakpointType.class);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("cpp_exception_breakpoints");
        String errorNodeName = "Exception";
        String errorNodeValue = "Exception breakpoint";
        String throwFuncPattern = this.isMSVCRuntime() ? "_CxxThrowException" : ".*cxa_throw";
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), throwFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame(frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_THROWN, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame(frames), (Object)frames.second);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), throwFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame(frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_UNCAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame(frames), (Object)frames.second);
        CidrDebuggingFixture.assertNoMoreEvents(state);
    }

    @Test
    public void testExceptionBreakpointWhenOCExceptionCaught() throws Exception {
        Assume.assumeTrue((String)"OC debugging", (boolean)((CidrDebuggingFixture)this.myDebuggingFixture).isOCDebuggingSupported());
        XDebuggerAssertions.insertBreakpoint(this.getProject(), new CidrExceptionBreakpointType.Properties(null, CidrExceptionBreakpointType.Properties.Type.OBJC_EXCEPTION), CidrExceptionBreakpointType.class);
        this.startDebugSessionAndWaitForPause("ns_exception_breakpoints");
        String errorNodeName = "Exception";
        String errorNodeValue = "Exception breakpoint";
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), ".*cxa_begin_catch", null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.ns_breakpoints_frame(frames), "ns_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_OC, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_CAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.ns_breakpoints_frame(frames), (Object)frames.second);
    }

    @Test
    public void testExceptionBreakpointWhenCPPExceptionCaught() throws Exception {
        Assume.assumeTrue((String)"exception catch breakpoints", (boolean)((CidrDebuggingFixture)this.myDebuggingFixture).isExceptionCatchBreakpointsSupported());
        XDebuggerAssertions.insertBreakpoint(this.getProject(), new CidrExceptionBreakpointType.Properties(null, CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION), CidrExceptionBreakpointType.class);
        this.startDebugSessionAndWaitForPause("cpp_exception_breakpoints");
        String errorNodeName = "Exception";
        String errorNodeValue = "Exception breakpoint";
        String catchFuncPattern = ".*cxa_begin_catch";
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), catchFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame(frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_CAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame(frames), (Object)frames.second);
    }

    @Test
    public void testExceptionBreakpointWhenCPPExceptionThrownAndCaught() throws Exception {
        Assume.assumeTrue((String)"exception catch breakpoints", (boolean)((CidrDebuggingFixture)this.myDebuggingFixture).isExceptionCatchBreakpointsSupported());
        XDebuggerAssertions.insertBreakpoint(this.getProject(), new CidrExceptionBreakpointType.Properties(CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION, CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION), CidrExceptionBreakpointType.class);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("cpp_exception_breakpoints");
        String errorNodeName = "Exception";
        String errorNodeValue = "Exception breakpoint";
        String throwFuncPattern = this.isMSVCRuntime() ? "_CxxThrowException" : ".*cxa_throw";
        String catchFuncPattern = ".*cxa_begin_catch";
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), throwFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame(frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_THROWN, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame(frames), (Object)frames.second);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), catchFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame(frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_CAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame(frames), (Object)frames.second);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), throwFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame(frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_UNCAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame(frames), (Object)frames.second);
    }

    @Test
    public void testExceptionBreakpointWhenOCExceptionUncaught() throws Exception {
        Assume.assumeTrue((String)"OC debugging", (boolean)((CidrDebuggingFixture)this.myDebuggingFixture).isOCDebuggingSupported());
        this.startDebugSessionAndWaitForPause("ns_exception_breakpoints");
        CidrDebuggingGeneralTestCase.assertTrue((((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_UNCAUGHT > ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_THROWN ? 1 : 0) != 0);
        CidrDebuggingGeneralTestCase.assertTrue((((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_UNCAUGHT > ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_CAUGHT ? 1 : 0) != 0);
        String errorNodeName = "Signal";
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), ".*pthread_kill", null, 0, errorNodeName, null, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.ns_breakpoints_frame(frames), "ns_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_OC, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_UNCAUGHT, errorNodeName, null, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.ns_breakpoints_frame(frames), (Object)frames.second);
    }

    @Test
    public void testExceptionBreakpointWhenCPPExceptionUncaught() throws Exception {
        Assume.assumeFalse((String)"not for GDB on Windows", (this.myBackend == DebuggerDriverKind.GDB && this.isWindowsHost() ? 1 : 0) != 0);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("cpp_exception_breakpoints");
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrDebuggingGeneralTestCase.assertTrue((((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_UNCAUGHT > ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_THROWN ? 1 : 0) != 0);
        CidrDebuggingGeneralTestCase.assertTrue((((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_UNCAUGHT > ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_CAUGHT ? 1 : 0) != 0);
        String errorNodeName = this.isWindowsHost() ? "Exception" : "Signal";
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        if (!this.isWindowsHost()) {
            String signalRaiseFrameNamePattern = ".*(?:pthread_kill|raise|gsignal).*";
            CidrStackFrame signalRaiseFrame = ((CidrDebuggingFixture)this.myDebuggingFixture).findFrameMatching((List)frames.first, ".*(?:pthread_kill|raise|gsignal).*", false);
            if (signalRaiseFrame == null) {
                signalRaiseFrame = (XStackFrame)((List)frames.first).get(0);
            }
            CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)signalRaiseFrame, ".*(?:pthread_kill|raise|gsignal).*", null, 0, errorNodeName, null, new String[0]);
        }
        if (this.myBackend == DebuggerDriverKind.GDB && this.isMacHost()) {
            return;
        }
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame(frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_UNCAUGHT, errorNodeName, null, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame(frames), (Object)frames.second);
    }

    @Test
    public void testEnablingExceptionBreakpointsWhileProgramIsRunning() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_EXCEPTION_IN_LOOP_START);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("exception_in_loop");
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_EXCEPTION_IN_LOOP_START);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        XDebuggerAssertions.insertBreakpoint(this.getProject(), new CidrExceptionBreakpointType.Properties(CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION, null), CidrExceptionBreakpointType.class);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XSourcePosition throwPosition = XDebuggerUtil.getInstance().createPosition(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_EXCEPTION_IN_LOOP_THROW);
        List<XStackFrame> frames = XDebuggerAssertions.collectFrames(this.getSession());
        XStackFrame found = (XStackFrame)ContainerUtil.find(frames, frame -> XSourcePosition.isOnTheSameLine((XSourcePosition)frame.getSourcePosition(), (XSourcePosition)throwPosition));
        CidrDebuggingGeneralTestCase.assertNotNull((String)"No frame at throw position", (Object)found);
    }

    @Test
    public void testFramesOnSignals() throws Exception {
        Assume.assumeFalse((String)"not for GDB on Windows", (this.myBackend == DebuggerDriverKind.GDB && this.isWindowsHost() ? 1 : 0) != 0);
        this.startDebugSessionAndWaitForPause("signal");
        String errorNodeName = this.selectDriver("Signal", this.isLinuxHost() ? "Signal" : "Exception");
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), "raiseSignal", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SIGNAL, errorNodeName, null, "someVar");
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(1), "main", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SIGNAL_CALL, errorNodeName, null, "argc", "argv");
    }

    private static void assertFrameOnSignal(@NotNull XStackFrame frame, @RegExp @Nullable String frameFunction, VirtualFile sourcePositionFile, int line, String errorNodeName, String errorNodeValue, String ... expectedVariables) {
        if (frame == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(7);
        }
        if (frameFunction != null) {
            CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)frame).getFrame().getFunction(), "(" + frameFunction + ").*", 2);
        }
        if (sourcePositionFile == null) {
            CidrDebuggingGeneralTestCase.assertNull((Object)frame.getSourcePosition());
        } else {
            XDebuggerAssertions.assertSourcePosition(frame, sourcePositionFile, line);
        }
        List<XValue> variables = XDebuggerAssertions.collectChildren((XValueContainer)frame);
        List allExpectedVariables = ContainerUtil.concat(Collections.singletonList(errorNodeName), Arrays.asList(expectedVariables));
        XDebuggerAssertions.assertVariablesContain(variables, ArrayUtilRt.toStringArray((Collection)allExpectedVariables));
        XDebuggerAssertions.assertVariable(variables, errorNodeName, null, errorNodeValue, (Boolean)false);
    }

    @Test
    public void testStoppingWhenWaitingForInput() throws Exception {
        this.assumeDebugger().supportsTargetInputOutput();
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INPUT_LOOP);
        this.startDebugSessionAndWaitForPause("input_loop");
        this.getSession().resume();
        CidrDebuggingGeneralTestCase.assertFalse((boolean)CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler(), 200L));
        OutputStream stream = this.getDebugProcess().getDriverInTests().getProcessInput();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)stream);
        stream.write("test\n".getBytes(StandardCharsets.UTF_8));
        CidrDebuggingGeneralTestCase.assertFalse((boolean)CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler(), 200L));
        this.getSession().stop();
        CidrDebuggingGeneralTestCase.assertTrue((boolean)CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler()));
    }

    @Test
    public void testAttachingAndDetaching() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        Pair<BaseProcessHandler<?>, Integer> handlerAndPid = this.launchApp("loop");
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).attachDebugSession(this.getProject(), info);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        ((CidrDebuggingFixture)this.myDebuggingFixture).assertConsoleTextEndsWith("Debugger attached to process " + String.valueOf(handlerAndPid.second) + "\n");
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        this.getSession().stop();
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
        ((CidrDebuggingFixture)this.myDebuggingFixture).assertConsoleTextMatches(".*\nDebugger detached\n.*");
        CidrDebuggingGeneralTestCase.assertFalse((boolean)((ProcessHandler)handlerAndPid.first).isProcessTerminating());
        CidrDebuggingGeneralTestCase.assertFalse((boolean)((ProcessHandler)handlerAndPid.first).isProcessTerminated());
    }

    @Test
    public void testDetachingWhileOnBreakpoint() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        Pair<BaseProcessHandler<?>, Integer> handlerAndPid = this.launchApp("loop");
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).attachDebugSession(this.getProject(), info);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.getSession().stop();
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
        ((CidrDebuggingFixture)this.myDebuggingFixture).assertConsoleTextMatches(".*\nDebugger detached\n.*");
        CidrDebuggingGeneralTestCase.assertFalse((boolean)((ProcessHandler)handlerAndPid.first).isProcessTerminating());
        CidrDebuggingGeneralTestCase.assertFalse((boolean)((ProcessHandler)handlerAndPid.first).isProcessTerminated());
    }

    @Test
    public void testStepIntoOnBreakpointAfterAttachingInWindowsInIncrementalBuild() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        SystemAssumption.assumeLocalSystem().isWindows();
        Assume.assumeTrue((String)"is msvc runtime", (boolean)this.isMSVCRuntime());
        Pair<BaseProcessHandler<?>, Integer> handlerAndPid = this.launchApp("loop", "Target_Libstdcxx_increment_link.exe");
        this.changeTestToolchainToWindows();
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).attachDebugSession(this.getProject(), info);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.getSession().stepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)frame);
        String expectedPattern = this.isMSVCRuntime() ? "my_sleep\\(unsigned int\\)" : "my_sleep";
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)frame).getFrame().getFunction(), expectedPattern);
    }

    @Test
    public void testAddingBreakpointAfterAttaching() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        Pair<BaseProcessHandler<?>, Integer> handlerAndPid = this.launchApp("loop");
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).attachDebugSession(this.getProject(), info);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
    }

    @Test
    public void testFinishingAppWhileAttached() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        Pair<BaseProcessHandler<?>, Integer> handlerAndPid = this.launchApp("loop");
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).attachDebugSession(this.getProject(), info);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.evaluate("stop = 1");
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
        ((CidrDebuggingFixture)this.myDebuggingFixture).assertConsoleTextMatches(".*Debugger attached to process " + String.valueOf(handlerAndPid.second) + "\n.*Debugger detached\n.*");
    }

    @Test
    public void testRemoteConnectingAndTargetFinishing() throws Exception {
        this.assumeDebugger().supportsRemoteDebug();
        Pair<File, OSProcessHandler> fileAndHandler = this.launchRemoteApp("r42");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).createRemoteDebugSession(this.getProject(), new CidrRemoteDebugParameters("tcp:localhost:4242", ((File)fileAndHandler.first).getPath(), "/"), new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
        ((CidrDebuggingFixture)this.myDebuggingFixture).assertConsoleTextEndsWith("Debugger connected to tcp:localhost:4242\nDebugger disconnected\n");
        CidrDebuggingGeneralTestCase.assertTrue((boolean)CidrDebuggingFixture.waitFor((ProcessHandler)fileAndHandler.second));
    }

    @Test
    public void testRemoteConnectingAndDisconnectingWithoutFinishingTarget() throws Exception {
        this.assumeDebugger().supportsRemoteDebug();
        Pair<File, OSProcessHandler> fileAndHandler = this.launchRemoteApp("loop");
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).createRemoteDebugSession(this.getProject(), new CidrRemoteDebugParameters("tcp:localhost:4242", ((File)fileAndHandler.first).getPath(), "/"), new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.getSession().stop();
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
        ((CidrDebuggingFixture)this.myDebuggingFixture).assertConsoleTextMatches(".*Debugger connected to tcp:localhost:4242\n(?:(?:Remote communication error\\.  Target disconnected\\.: .*|Remote connection closed)\n\n)?Debugger disconnected\n$");
    }

    @Test
    public void testCollectingFrames() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES_BEGIN);
        this.startDebugSessionAndWaitForPause("values");
        XSuspendContext context2 = ((CidrDebuggingFixture)this.myDebuggingFixture).getSession().getSuspendContext();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)context2.getActiveExecutionStack());
        CidrDebuggingGeneralTestCase.assertNotNull((Object)context2.getActiveExecutionStack().getTopFrame());
        CidrDebuggingGeneralTestCase.assertEquals((Object)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (Object)context2.getActiveExecutionStack().getTopFrame().getSourcePosition().getFile());
        CidrDebuggingGeneralTestCase.assertEquals((int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES_BEGIN, (int)context2.getActiveExecutionStack().getTopFrame().getSourcePosition().getLine());
        List<XStackFrame> frames = ((CidrDebuggingFixture)this.myDebuggingFixture).collectFrames(context2.getActiveExecutionStack());
        CidrDebuggingFixture.assertFramePresentationMatches(frames.get(0), "values.*");
        CidrDebuggingFixture.assertFramePresentationMatches(frames.get(1), "main.*");
        CidrDebuggingGeneralTestCase.assertSame((Object)context2.getActiveExecutionStack().getTopFrame(), (Object)frames.get(0));
    }

    @Test
    public void testCollectingDeepStacks() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FRAMES);
        this.startDebugSessionAndWaitForPause("deep_frames");
        List<XStackFrame> frames = ((CidrDebuggingFixture)this.myDebuggingFixture).collectFrames();
        CidrDebuggingGeneralTestCase.assertTrue((String)("Not enough frames: " + frames.size()), (frames.size() >= 1001 ? 1 : 0) != 0);
        for (int i = 0; i < frames.size(); ++i) {
            CidrStackFrame each = (CidrStackFrame)frames.get(i);
            CidrDebuggingGeneralTestCase.assertEquals((int)i, (int)each.getFrame().getIndex());
        }
    }

    @Test
    public void testErrorDuringFrameCollection() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES_BEGIN);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("values");
        ThrowInTest.throwOn((Object)this.getSession().getDebugProcess(), (Key)CidrDebugProcess.THROW_ON_FRAME_COLLECTION, (boolean)true);
        XExecutionStack thread = XDebuggerAssertions.getActiveThread(this.getSession());
        CidrDebuggingGeneralTestCase.assertNotNull((Object)thread);
        CidrDebuggingFixture.assertFramePresentationMatches(thread.getTopFrame(), "values.*");
        Pair<List<XStackFrame>, String> framesWithError = XDebuggerAssertions.collectFramesWithError(thread, 25000L);
        CidrDebuggingGeneralTestCase.assertEmpty((Collection)framesWithError.first);
        CidrDebuggingGeneralTestCase.assertEquals((String)"user exception", (String)((String)framesWithError.second));
        this.getSession().stepOver(false);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        ThrowInTest.throwOn((Object)this.getSession().getDebugProcess(), (Key)CidrDebugProcess.THROW_ON_FRAME_COLLECTION, (boolean)false);
        thread = XDebuggerAssertions.getActiveThread(this.getSession());
        CidrDebuggingGeneralTestCase.assertNotNull((Object)thread);
        CidrDebuggingFixture.assertFramePresentationMatches(thread.getTopFrame(), "values.*");
        framesWithError = XDebuggerAssertions.collectFramesWithError(thread, 25000L);
        CidrDebuggingGeneralTestCase.assertEmpty((Collection)framesWithError.first);
        CidrDebuggingGeneralTestCase.assertEquals((String)"Execution exception", (String)((String)framesWithError.second));
    }

    @Test
    public void testNonLibraryFrames() throws Exception {
        this.setShowLibraryStackFrames(false);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        XSuspendContext context2 = ((CidrDebuggingFixture)this.myDebuggingFixture).getSession().getSuspendContext();
        XExecutionStack stack = context2.getActiveExecutionStack();
        List<XStackFrame> framesFromZeroIndex = ((CidrDebuggingFixture)this.myDebuggingFixture).collectFrames(stack);
        XDebuggerTestUtil.XTestStackFrameContainer container = new XDebuggerTestUtil.XTestStackFrameContainer();
        stack.computeStackFrames(framesFromZeroIndex.size(), (XExecutionStack.XStackFrameContainer)container);
        List framesFromSizeIndex = (List)container.waitFor((long)25000L).first;
        CidrDebuggingGeneralTestCase.assertEmpty(framesFromSizeIndex);
    }

    @Test
    public void testFrameToSelectWithLibraryFiltering() throws Exception {
        this.setShowLibraryStackFrames(false);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FRAMES);
        this.startDebugSessionAndWaitForPause("deep_frames");
        XSuspendContext context2 = ((CidrDebuggingFixture)this.myDebuggingFixture).getSession().getSuspendContext();
        XExecutionStack stack = context2.getActiveExecutionStack();
        XDebuggerTestUtil.XTestStackFrameContainer container = new XDebuggerTestUtil.XTestStackFrameContainer();
        stack.computeStackFrames(0, (XExecutionStack.XStackFrameContainer)container);
        Pair frames = container.waitFor(25000L);
        XStackFrame topFrame = (XStackFrame)((List)frames.first).get(0);
        CidrDebuggingGeneralTestCase.assertTrue((container.frameToSelect == null || container.frameToSelect.equals(topFrame) ? 1 : 0) != 0);
    }

    @Test
    public void testErrorDuringFrameVariablesCollection() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES_BEGIN);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("values");
        CidrStackFrame frame = (CidrStackFrame)((CidrDebuggingFixture)this.myDebuggingFixture).collectFrames().get(0);
        ThrowInTest.throwOn((Object)frame, (Key)CidrStackFrame.THROW_ON_VARIABLES_COLLECTION, (boolean)true);
        CidrDebuggingFixture.assertVarCollectingError((XStackFrame)frame, "user exception");
        this.getSession().stepOver(false);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        frame = (CidrStackFrame)((CidrDebuggingFixture)this.myDebuggingFixture).collectFrames().get(0);
        ThrowInTest.throwOn((Object)frame, (Key)CidrStackFrame.THROW_ON_VARIABLES_COLLECTION, (boolean)false);
        CidrDebuggingFixture.assertVarCollectingError((XStackFrame)frame, "Execution exception");
    }

    @Test
    public void testStepIntoFunctionWithNoSource() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL);
        this.getSession().stepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL + 1);
    }

    @Test
    public void testForceStepIntoFunctionWithNoSource() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrStackFrame stackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        CidrDebuggingGeneralTestCase.assertFalse((String)"Must be disassembly", (boolean)stackFrame.hasSourceFile());
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        this.checkIsInMainCppMain();
    }

    @Test
    public void testAddressBreakpointInsideSourcelessFunction() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_2);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_3);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("double_sourceless");
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_2);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XSourcePosition pos = CidrDebuggingGeneralTestCase.checkAndLoadDisasmPosition(this.getDebugProcess());
        XLineBreakpoint toggledBreakpoint = XDebuggerAssertions.toggleBreakpoint(this.getProject(), pos.getFile(), pos.getLine());
        CidrDebuggingGeneralTestCase.assertNotNull((Object)toggledBreakpoint);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_3);
        this.getSession().stepOver(false);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^(_)?my_sourceless1\\b.*");
    }

    @Test
    public void testJumpToAddressInsideSourcelessFunction() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_1);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("double_sourceless");
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_1);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^(_)?my_sourceless2\\b.*");
        CidrStackFrame stack = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)stack);
        XSourcePosition targetPos = CidrDebuggingGeneralTestCase.checkAndLoadDisasmPosition(this.getDebugProcess());
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_2);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_2);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^(_)?my_sourceless1\\b.*");
        CidrDebuggingGeneralTestCase.checkAndLoadDisasmPosition(this.getDebugProcess());
        boolean jumpStatus = ((CidrDebuggingFixture)this.myDebuggingFixture).myDebugProcess.jumpToLine(stack.getThread(), targetPos.getFile(), targetPos.getLine());
        CidrDebuggingGeneralTestCase.assertTrue((boolean)jumpStatus);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^(_)?my_sourceless2\\b.*");
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_3);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_3);
        XDebuggerAssertions.assertVariableValue(this.collectVars(0), "result_1", "2");
    }

    @NotNull
    private static XSourcePosition checkAndLoadDisasmPosition(@NotNull CidrDebugProcess debugProcess) {
        if (debugProcess == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(8);
        }
        CidrStackFrame stack = (CidrStackFrame)debugProcess.getSession().getCurrentStackFrame();
        CidrDebuggingGeneralTestCase.assertNull((String)"Source position must be null", (Object)stack.getSourcePosition());
        XSourcePosition pos = stack.getDisasmPosition();
        CidrDebuggingGeneralTestCase.assertNotNull((String)"Disasm position must not be null", (Object)pos);
        CidrMemoryDoc memoryDoc = debugProcess.fileToMemoryDoc(pos.getFile());
        CidrDebuggingGeneralTestCase.assertNotNull((String)"Disasm position must be in a memory doc", (Object)memoryDoc);
        CidrDebuggingGeneralTestCase.assertInstanceOf(pos, CidrMemoryDoc.AddressPosition.class);
        ((CidrMemoryDoc.AddressPosition)pos).requestLoading();
        memoryDoc.waitForLoad(25000L);
        XSourcePosition xSourcePosition = pos;
        if (xSourcePosition == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(9);
        }
        return xSourcePosition;
    }

    @Test
    public void testSteppingOutOfMain() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FUNC_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("func");
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FUNC_BEGINNING);
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_FUNC_CALL + this.offsetAfterStepOut());
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (!this.steppingWorksWellWithLibcDebugInfo()) {
            return;
        }
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
    }

    protected int offsetAfterStepOut() {
        return this.isMSVCRuntime() && this.isArchX86() ? 0 : 1;
    }

    @Test
    public void testSteppingOutSkippingSingleSourcelessFrame() throws Exception {
        int stepOutCount = 1;
        this.doTestSteppingOutSkippingSourcelessFrames("sourceless_hello", stepOutCount);
    }

    @Test
    public void testSteppingOutSkippingMultipleSourcelessFrames() throws Exception {
        int stepOutCount = 1;
        if (this.myBackend == DebuggerDriverKind.LLDB && this.isMSVCRuntime()) {
            stepOutCount = 7;
        }
        this.doTestSteppingOutSkippingSourcelessFrames("sourceless_recurse_indirect7", stepOutCount);
    }

    @Test
    public void testSteppingOutSkippingRecursiveSourcelessFrames() throws Exception {
        int stepOutCount = 1;
        if (this.myBackend == DebuggerDriverKind.LLDB && this.isMSVCRuntime()) {
            stepOutCount = 8;
        }
        this.doTestSteppingOutSkippingSourcelessFrames("sourceless_recurse_direct7", stepOutCount);
    }

    public void doTestSteppingOutSkippingSourcelessFrames(@NotNull String param, int stepOutCount) throws Exception {
        if (param == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(10);
        }
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause(param);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        for (int currentStep = 0; currentStep < stepOutCount; ++currentStep) {
            this.getSession().stepOut();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        }
        this.checkIsInMainCppMain();
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (!this.steppingWorksWellWithLibcDebugInfo()) {
            return;
        }
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
    }

    @Test
    public void testSteppingOverSkippingSingleSourcelessFrame() throws Exception {
        this.doTestSteppingOverSkippingSourcelessFrames("sourceless_hello");
    }

    @Test
    public void testSteppingOverSkippingMultipleSourcelessFrames() throws Exception {
        this.doTestSteppingOverSkippingSourcelessFrames("sourceless_recurse_indirect7");
    }

    @Test
    public void testSteppingOverSkippingRecursiveSourcelessFrames() throws Exception {
        this.doTestSteppingOverSkippingSourcelessFrames("sourceless_recurse_direct7");
    }

    public void doTestSteppingOverSkippingSourcelessFrames(@NotNull String param) throws Exception {
        if (param == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(11);
        }
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause(param);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        this.getSession().stepOver(false);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        if (((CidrStackFrame)this.getSession().getCurrentStackFrame()).getFrame().getFunction().matches("^hello_from_sourceless\\b.*")) {
            XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS + 1);
            this.getSession().stepOver(false);
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        }
        this.checkIsInMainCppMain();
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (!this.steppingWorksWellWithLibcDebugInfo()) {
            return;
        }
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
    }

    @Test
    public void testSteppingOutThroughSingleSourcelessFrame() throws Exception {
        this.assumeBackendKind().isNotLLDB();
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("sourceless_hello");
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        if (((CidrStackFrame)this.getSession().getCurrentStackFrame()).getFrame().getFunction().matches("^hello_from_sourceless\\b.*")) {
            XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS + 1);
            this.getSession().forceStepInto();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        }
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertNull((Object)((XStackFrame)((List)frames.first).get(0)).getSourcePosition());
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(1)).getFrame().getFunction(), "^main\\b.*");
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        this.checkIsInMainCppMain();
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (!this.steppingWorksWellWithLibcDebugInfo()) {
            return;
        }
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
    }

    @Test
    public void testSteppingOutThroughMultipleSourcelessFrames() throws Exception {
        if (!this.isMSVCRuntime()) {
            this.doTestSteppingThroughSourcelessFrames("sourceless_recurse_indirect7", 7, false);
        } else {
            this.doTestSteppingThroughSourcelessFramesForMSVCRuntime("sourceless_recurse_indirect4", "sourceless_recurse_stepping_out_indirect");
        }
    }

    @Test
    public void testSteppingOutThroughRecursiveSourcelessFrames() throws Exception {
        if (!this.isMSVCRuntime()) {
            this.doTestSteppingThroughSourcelessFrames("sourceless_recurse_direct7", 7, false);
        } else {
            this.doTestSteppingThroughSourcelessFramesForMSVCRuntime("sourceless_recurse_direct4", "sourceless_recurse_stepping_out_direct");
        }
    }

    @Test
    public void testSteppingOverThroughMultipleSourcelessFrames() throws Exception {
        if (!this.isMSVCRuntime()) {
            this.doTestSteppingThroughSourcelessFrames("sourceless_recurse_indirect7", 7, true);
        } else {
            this.doTestSteppingThroughSourcelessFramesForMSVCRuntime("sourceless_recurse_indirect4", "sourceless_recurse_stepping_over_indirect");
        }
    }

    @Test
    public void testSteppingOverThroughRecursiveSourcelessFrames() throws Exception {
        if (!this.isMSVCRuntime()) {
            this.doTestSteppingThroughSourcelessFrames("sourceless_recurse_direct7", 7, true);
        } else {
            this.doTestSteppingThroughSourcelessFramesForMSVCRuntime("sourceless_recurse_direct4", "sourceless_recurse_stepping_over_direct");
        }
    }

    public void doTestSteppingThroughSourcelessFramesForMSVCRuntime(@NotNull String param, @NotNull String file) throws Exception {
        if (param == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(12);
        }
        if (file == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(13);
        }
        Assume.assumeTrue((String)"This is only for the MSVC toolchain, which have different sourceless behaviour from *nix dbgs.", (boolean)this.isMSVCRuntime());
        Assume.assumeFalse((String)"Unfortunately, we cannot perform step-out in LLDB on win-arm64 (CPP-34448)", (boolean)this.isArchAarch64());
        this.setShowLibraryStackFrames(true);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause(param);
        DSLDebuggerStacktraceVerifier.verifyStepping(this.getDSLDebuggerCommands(state), this.getCommandsFile(file));
    }

    @NotNull
    private File getCommandsFile(@NotNull String file) {
        if (file == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(14);
        }
        File file2 = this.myTestDataFixture.getTestDataFile(String.format("stepping/msvc-%s/debug-session/%s.txt", ((CidrDebuggingFixture)this.myDebuggingFixture).getArchitectureType().getId(), file));
        if (file2 == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(15);
        }
        return file2;
    }

    @NotNull
    private DSLDebuggerCommands getDSLDebuggerCommands(final BlockingQueue<CidrDebuggingFixture.DebuggerState> state) {
        return new DSLDebuggerCommands(){

            @Override
            public void stepInto() throws Exception {
                CidrDebuggingGeneralTestCase.this.getSession().forceStepInto();
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingGeneralTestCase.this.PAUSED);
            }

            @Override
            public void stepOut() throws Exception {
                CidrDebuggingGeneralTestCase.this.getSession().stepOut();
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingGeneralTestCase.this.PAUSED);
            }

            @Override
            public void stepOver() throws Exception {
                CidrDebuggingGeneralTestCase.this.getSession().stepOver(true);
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingGeneralTestCase.this.PAUSED);
            }

            @Override
            public void end() throws Exception {
                CidrDebuggingGeneralTestCase.this.getSession().stepOut();
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingGeneralTestCase.this.STOPPED);
            }

            @Override
            @NotNull
            public String getStack() {
                Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(CidrDebuggingGeneralTestCase.this.getSession(), 25000L);
                String string = ((List)frames.first).stream().map(frame -> ((CidrStackFrame)frame).getFrame().getFunction()).collect(Collectors.joining("\n"));
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggingGeneralTestCase$2", "getStack"));
            }
        };
    }

    public void doTestSteppingThroughSourcelessFrames(@NotNull String param, int depth, boolean useStepOver) throws Exception {
        if (param == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(16);
        }
        Assume.assumeFalse((String)"MSVC toolchain has another tests, see doTestSteppingThroughSourcelessFramesForMSVCRuntime method", (boolean)this.isMSVCRuntime());
        this.setShowLibraryStackFrames(true);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause(param);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        boolean isGCC = ((CidrStackFrame)this.getSession().getCurrentStackFrame()).getFrame().getFunction().matches("^hello_from_sourceless\\b.*");
        if (isGCC) {
            XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS + 1);
            this.getSession().forceStepInto();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        }
        int numSourcelessFrames = depth + 1;
        int stepsPerFrame = !useStepOver ? 1 : (!isGCC ? 6 : 3);
        for (int frame = numSourcelessFrames - 1; frame > 0; --frame) {
            for (int step = 0; step < stepsPerFrame; ++step) {
                Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
                if (((List)frames.first).size() > frame + 1) {
                    String function = ((CidrStackFrame)((List)frames.first).get(frame + 1)).getFrame().getFunction();
                    if (frame == numSourcelessFrames - 1 && step == stepsPerFrame - 1 && !function.matches("^main\\b.*")) continue;
                    if (frame != 1) {
                        CidrDebuggingGeneralTestCase.assertMatches(function, "^main\\b.*");
                    }
                } else if (stepsPerFrame == 3) {
                    stepsPerFrame = 4;
                }
                CidrDebuggingGeneralTestCase.assertNull((Object)((XStackFrame)((List)frames.first).get(0)).getSourcePosition());
                CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^sourceless_recurse.*");
                if (useStepOver) {
                    this.getSession().stepOver(false);
                } else {
                    this.getSession().stepOut();
                }
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
                CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
            }
        }
        Pair<List<XStackFrame>, XStackFrame> frames = XDebuggerAssertions.collectFramesWithSelected(this.getSession(), 25000L);
        CidrDebuggingGeneralTestCase.assertNull((Object)((XStackFrame)((List)frames.first).get(0)).getSourcePosition());
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^(_)?main_sourceless\\b.*");
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        this.checkIsInMainCppMain();
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (!this.steppingWorksWellWithLibcDebugInfo()) {
            return;
        }
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
    }

    @Test
    public void testJumpToLine() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_PRE_FUNC_CALL);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("func");
        Assume.assumeTrue((boolean)this.getDebugProcess().supportsJumpToLine());
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_PRE_FUNC_CALL);
        CidrStackFrame stack = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)stack);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)((CidrDebuggingFixture)this.myDebuggingFixture).myDebugProcess.jumpToLine(stack.getThread(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_FUNC_CALL));
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_FUNC_CALL);
    }

    @Test
    public void testConsoleCommandCompletionTopLevelCommand() throws Exception {
        Assume.assumeTrue((this.myBackend == DebuggerDriverKind.GDB || this.myBackend == DebuggerDriverKind.LLDB ? 1 : 0) != 0);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        if (this.myBackend == DebuggerDriverKind.GDB) {
            this.doTestCompleteConsoleCommand("inf", "info", "inferior");
            this.doTestCompleteConsoleCommand("bre", "break", "break-range");
            this.doTestCompleteConsoleCommand("break", "break", "break-range");
            this.doTestCompleteConsoleCommand("break-", "break-range");
        } else {
            this.doTestCompleteConsoleCommand("break", "breakpoint");
            this.doTestCompleteConsoleCommand("pr", "process");
            this.doTestCompleteConsoleCommand("disa", "disassemble");
        }
    }

    @Test
    public void testConsoleCommandCompletionCursorBeforeEndOfCommand() throws Exception {
        Assume.assumeTrue((this.myBackend == DebuggerDriverKind.GDB || this.myBackend == DebuggerDriverKind.LLDB ? 1 : 0) != 0);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        if (this.myBackend == DebuggerDriverKind.GDB) {
            this.doTestCompleteConsoleCommand("infer", 3, "info", "inferior");
            this.doTestCompleteConsoleCommand("break-", 3, "break", "break-range");
        } else {
            this.doTestCompleteConsoleCommand("breakpo", 5, "breakpoint");
            this.doTestCompleteConsoleCommand("proc", 2, "process");
            this.doTestCompleteConsoleCommand("disasse", 4, "disassemble");
        }
    }

    @Test
    public void testConsoleCommandCompletionSubcommand() throws Exception {
        Assume.assumeTrue((this.myBackend == DebuggerDriverKind.GDB || this.myBackend == DebuggerDriverKind.LLDB ? 1 : 0) != 0);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        if (this.myBackend == DebuggerDriverKind.GDB) {
            this.doTestCompleteConsoleCommand("info pr", "pretty-printer", "probes", "proc", "program");
        } else {
            this.doTestCompleteConsoleCommand("breakpoint l", "list");
        }
    }

    protected void doTestCompleteConsoleCommand(@NotNull String command, String ... expectedCompletions) {
        if (command == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(17);
        }
        if (expectedCompletions == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(18);
        }
        this.doTestCompleteConsoleCommand(command, command.length(), expectedCompletions);
    }

    protected void doTestCompleteConsoleCommand(@NotNull String command, int offset, String ... expectedCompletions) {
        if (command == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(19);
        }
        if (expectedCompletions == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(20);
        }
        CidrDebugProcess debugProcess = (CidrDebugProcess)this.getSession().getDebugProcess();
        EmptyProgressIndicator processIndicatorStub = new EmptyProgressIndicator();
        List completions = debugProcess.completeConsoleCommand((String)command, (int)offset, (ProgressIndicator)processIndicatorStub).list;
        CidrDebuggingGeneralTestCase.assertContainsElements(completions, Arrays.asList(expectedCompletions));
        completions = debugProcess.completeConsoleCommand((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{" \u0001"}, (String)command)), (int)(1 + offset), (ProgressIndicator)processIndicatorStub).list;
        CidrDebuggingGeneralTestCase.assertContainsElements(completions, Arrays.asList(expectedCompletions));
    }

    @NotNull
    private String getExpectedPromptValue() {
        String string = this.selectDriver("(gdb) ", "(lldb) ");
        if (string == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Test
    public void testConsolePromptHidingOnResume() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("loop");
        this.waitForDebuggerAndSwingEvents();
        CidrDebugProcess debugProcess = (CidrDebugProcess)this.getSession().getDebugProcess();
        Assume.assumeTrue((String)"Debug console is not supported", (debugProcess.getDebuggerConsole() != null ? 1 : 0) != 0);
        CidrDebuggingGeneralTestCase.assertEquals((String)this.getExpectedPromptValue(), (String)debugProcess.getDebuggerConsole().getPrompt());
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        this.waitForDebuggerAndSwingEvents();
        CidrDebuggingGeneralTestCase.assertEquals((String)"", (String)debugProcess.getDebuggerConsole().getPrompt());
    }

    @Test
    public void testConsolePromptOnBreak() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        this.waitForDebuggerAndSwingEvents();
        CidrDebugProcess debugProcess = (CidrDebugProcess)this.getSession().getDebugProcess();
        Assume.assumeTrue((String)"Debug console is not supported", (debugProcess.getDebuggerConsole() != null ? 1 : 0) != 0);
        CidrDebuggingGeneralTestCase.assertEquals((String)this.getExpectedPromptValue(), (String)debugProcess.getDebuggerConsole().getPrompt());
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        this.waitForDebuggerAndSwingEvents();
        CidrDebuggingGeneralTestCase.assertEquals((String)this.getExpectedPromptValue(), (String)debugProcess.getDebuggerConsole().getPrompt());
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
        this.waitForDebuggerAndSwingEvents();
        CidrDebuggingGeneralTestCase.assertEquals((String)"", (String)debugProcess.getDebuggerConsole().getPrompt());
    }

    @Test
    public void testDebuggerCrashNotification() throws Exception {
        this.doTestDebuggerCrash(false);
    }

    @Test
    public void testDebuggerCrashNotificationOnBreakpoint() throws Exception {
        this.doTestDebuggerCrash(true);
    }

    public void doTestDebuggerCrash(boolean useBreakpoint) throws Exception {
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state;
        this.assumeSystem().isUnix();
        SystemAssumption.assumeLocalSystem().isNotWindows();
        if (useBreakpoint) {
            XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
            state = this.startDebugSessionAndWaitForPause("loop");
        } else {
            state = ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSession("loop", new XDebugSessionListener[0]);
            CidrDebuggingUtilKt.waitForSessionToRun(this.getDebugProcess());
        }
        final FutureResult notificationFuture = new FutureResult();
        this.getProject().getMessageBus().connect(this.getTestRootDisposable()).subscribe(Notifications.TOPIC, (Object)new Notifications(){

            public void notify(@NotNull Notification notification) {
                String content;
                if (notification == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((content = notification.getContent()).contains("SIGKILL") && content.contains("<a href=\"Restart\">")) {
                    notificationFuture.set((Object)notification);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/cidr/execution/debugger/CidrDebuggingGeneralTestCase$3", "notify"));
            }
        });
        BaseProcessHandler processHandler = this.getDebugProcess().getDriverInTests().getProcessHandler();
        long pid = processHandler.getProcess().pid();
        UnixProcessManager.sendSignal((int)((int)pid), (int)9);
        CidrDebuggingGeneralTestCase.assertTrue((String)"Expected debugger process to terminate due to SIGKILL", (boolean)CidrDebuggingFixture.waitFor((ProcessHandler)processHandler));
        this.waitForDebuggerAndSwingEvents();
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
        CidrDebuggingGeneralTestCase.assertNotNull(CidrDebuggingFixture.waitFor(notificationFuture));
    }

    @Test
    public void testCollectingReturnValue() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_GET_STRUCT_POINTER);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("return_structs");
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrSuspendContext context2 = (CidrSuspendContext)((CidrDebuggingFixture)this.myDebuggingFixture).getSession().getSuspendContext();
        List<XStackFrame> frames = ((CidrDebuggingFixture)this.myDebuggingFixture).collectFrames((XExecutionStack)context2.getActiveExecutionStack());
        List<XValue> variables = XDebuggerAssertions.collectChildren((XValueContainer)frames.get(0));
        XDebuggerAssertions.assertVariablesContain(variables, CidrDebuggerBundle.message((String)"debug.function.return.value", (Object[])new Object[0]));
        for (int frameIndex = 1; frameIndex < frames.size(); ++frameIndex) {
            variables = XDebuggerAssertions.collectChildren((XValueContainer)frames.get(frameIndex));
            XDebuggerAssertions.assertVariablesDontContain(variables, CidrDebuggerBundle.message((String)"debug.function.return.value", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadRegisters() throws Exception {
        boolean showRegistersDefault = CidrDebuggerSettings.getInstance().isShowRegisters();
        CidrDebuggerSettings.getInstance().setShowRegisters(true);
        try {
            XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
            this.startDebugSessionAndWaitForPause();
            CidrSuspendContext context2 = (CidrSuspendContext)((CidrDebuggingFixture)this.myDebuggingFixture).getSession().getSuspendContext();
            CidrStackFrame frame = context2.getActiveExecutionStack().getTopFrame();
            List<XValue> registers = CidrDebuggingGeneralTestCase.getRegisters(frame);
            CidrDebuggingGeneralTestCase.assertNotEmpty(registers);
            if (this.myBackend == DebuggerDriverKind.GDB || this.myBackend == DebuggerDriverKind.LLDB) {
                for (XValue register2 : registers) {
                    XDebuggerAssertions.assertVariableValueMatches(register2, null, null, "0x[0-9a-f]+.*", null, null);
                }
            }
        }
        finally {
            CidrDebuggerSettings.getInstance().setShowRegisters(showRegistersDefault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteRegister() throws Exception {
        boolean showRegistersDefault = CidrDebuggerSettings.getInstance().isShowRegisters();
        CidrDebuggerSettings.getInstance().setShowRegisters(true);
        try {
            XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
            this.startDebugSessionAndWaitForPause();
            CidrSuspendContext context2 = (CidrSuspendContext)((CidrDebuggingFixture)this.myDebuggingFixture).getSession().getSuspendContext();
            CidrStackFrame frame = context2.getActiveExecutionStack().getTopFrame();
            List<XValue> registers = CidrDebuggingGeneralTestCase.getRegisters(frame);
            XValue register2 = (XValue)ContainerUtil.getFirstItem(registers);
            CidrDebuggingGeneralTestCase.assertNotNull((Object)register2);
            String registerName = ((XNamedValue)register2).getName();
            CidrModificationCallback callback = new CidrModificationCallback();
            register2.getModifier().setValue((XExpression)new XExpressionImpl("1", null, null, EvaluationMode.EXPRESSION), (XValueModifier.XModificationCallback)callback);
            CidrDebuggingGeneralTestCase.assertTrue((String)"Register modification takes too long", (boolean)callback.await());
            registers = CidrDebuggingGeneralTestCase.getRegisters(frame);
            XDebuggerAssertions.assertVariableValueMatches(registers, registerName, "0x0+1.*");
            callback = new CidrModificationCallback();
            register2.getModifier().setValue((XExpression)new XExpressionImpl("2", null, null, EvaluationMode.EXPRESSION), (XValueModifier.XModificationCallback)callback);
            CidrDebuggingGeneralTestCase.assertTrue((String)"Register modification takes too long", (boolean)callback.await());
            registers = CidrDebuggingGeneralTestCase.getRegisters(frame);
            XDebuggerAssertions.assertVariableValueMatches(registers, registerName, "0x0+2.*");
        }
        finally {
            CidrDebuggerSettings.getInstance().setShowRegisters(showRegistersDefault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvaluateRegister() throws Exception {
        boolean showRegistersDefault = CidrDebuggerSettings.getInstance().isShowRegisters();
        CidrDebuggerSettings.getInstance().setShowRegisters(true);
        try {
            XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
            this.startDebugSessionAndWaitForPause();
            CidrSuspendContext context2 = (CidrSuspendContext)((CidrDebuggingFixture)this.myDebuggingFixture).getSession().getSuspendContext();
            CidrDebuggingGeneralTestCase.assertNotNull((Object)context2);
            CidrStackFrame frame = context2.getActiveExecutionStack().getTopFrame();
            CidrDebuggingGeneralTestCase.assertNotNull((Object)frame);
            List<XValue> registers = CidrDebuggingGeneralTestCase.getRegisters(frame);
            CidrDebuggingGeneralTestCase.assertNotEmpty(registers);
            XValue register2 = registers.getFirst();
            Pair<XValue, String> evaluate2 = XDebuggerTestUtil.evaluate(this.getSession(), register2.getEvaluationExpression(), 25000L);
            String error = (String)evaluate2.second;
            CidrDebuggingGeneralTestCase.assertNull((String)"Register evaluation failed", (Object)error);
        }
        finally {
            CidrDebuggerSettings.getInstance().setShowRegisters(showRegistersDefault);
        }
    }

    @Test
    public void testFollowsChild() throws Exception {
        this.doTestForkedProcess(true);
    }

    @Test
    public void testFollowsParent() throws Exception {
        this.doTestForkedProcess(false);
    }

    private void doTestForkedProcess(boolean followChild) throws Exception {
        this.assumeSystem().isUnix();
        SystemAssumption.assumeLocalSystem().isNotMac();
        CidrDebuggerSettings.getInstance().setFollowChildOnFork(followChild);
        CidrDebuggerSettings.getInstance().setDetachOnFork(false);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_FORK_PARENT);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_FORK_CHILD);
        this.startDebugSessionAndWaitForPause("fork_process");
        Assume.assumeTrue((boolean)((CidrDebuggingFixture)this.myDebuggingFixture).getDebugProcess().supportsDebuggingForkedProcess());
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, followChild ? ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_FORK_CHILD : ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_FORK_PARENT);
        CidrDebuggingGeneralTestCase.assertSize((int)this.selectDriver(2, 1), XDebuggerAssertions.collectThreads(this.getSession()));
    }

    @Test
    public void testFrameVariablesOrder() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FRAME_VARS_ORDER);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("frame_vars_order");
        List<XValue> vars = this.collectVars(0);
        List names = ContainerUtil.mapNotNull(vars, it -> {
            String string;
            if (it instanceof XNamedValue) {
                XNamedValue named = (XNamedValue)it;
                string = named.getName();
            } else {
                string = null;
            }
            return string;
        });
        CidrDebuggingGeneralTestCase.assertEquals(List.of("this", "g", "f", "e", "d", "c", "b"), (Object)names);
    }

    @Test
    public void testMissingThisVariable() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_CLASS1, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CLASS1_SET_VALUE);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("class1");
        List<XValue> vars = this.collectVars(0);
        CidrDebuggingFixture.findVar(vars, "this");
    }

    @Test
    public void testAttachCallsConfigurators() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        final AtomicBoolean configureBeforeTargetLoaded = new AtomicBoolean(false);
        final AtomicBoolean configure = new AtomicBoolean(false);
        final AtomicBoolean configureAfterSessionCreated = new AtomicBoolean(false);
        CidrDebugProcessConfigurator.EP_NAME.getPoint().registerExtension((Object)new CidrDebugProcessConfigurator(){

            public void configureBeforeTargetLoaded(@NotNull CidrDebugProcess process) {
                if (process == null) {
                    4.$$$reportNull$$$0(0);
                }
                configureBeforeTargetLoaded.set(true);
            }

            public void configure(@NotNull CidrDebugProcess process) {
                if (process == null) {
                    4.$$$reportNull$$$0(1);
                }
                configure.set(true);
            }

            public void configureAfterSessionCreated(@NotNull CidrDebugProcess process) {
                if (process == null) {
                    4.$$$reportNull$$$0(2);
                }
                configureAfterSessionCreated.set(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "process";
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingGeneralTestCase$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "configureBeforeTargetLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "configure";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "configureAfterSessionCreated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.getTestRootDisposable());
        Pair<BaseProcessHandler<?>, Integer> handlerAndPid = this.launchApp("loop");
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).attachDebugSession(this.getProject(), info);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)configureBeforeTargetLoaded.get());
        CidrDebuggingGeneralTestCase.assertTrue((boolean)configure.get());
        CidrDebuggingGeneralTestCase.assertTrue((boolean)configureAfterSessionCreated.get());
    }

    @Test
    public void testDisasmExecutionPositionDuringAttach() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        Pair<BaseProcessHandler<?>, Integer> handlerAndPid = this.launchApp("loop");
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).attachDebugSession(this.getProject(), info);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)this.getSession().getDebugProcess().getAlternativeSourceHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStepIntoWithStepFilters() throws Exception {
        RegistryValue registryValue = Registry.get((String)"cidr.debugger.stepFilters");
        boolean oldValue = registryValue.asBoolean();
        try {
            registryValue.setValue(true);
            XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_STEP_FILTERS);
            BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("step_filters");
            this.getSession().stepInto();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
            XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_STEP_FILTERS + 1);
            this.getSession().stepInto();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
            XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_STEP_FILTERS + 2);
        }
        finally {
            registryValue.setValue(oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForceStepIntoWithStepFilters() throws Exception {
        RegistryValue registryValue = Registry.get((String)"cidr.debugger.stepFilters");
        boolean oldValue = registryValue.asBoolean();
        try {
            registryValue.setValue(true);
            XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_STEP_FILTERS);
            BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("step_filters");
            this.getSession().forceStepInto();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
            CidrDebuggingFixture.assertNotEquals((long)(((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_STEP_FILTERS + 1), (long)this.getSession().getCurrentPosition().getLine());
        }
        finally {
            registryValue.setValue(oldValue);
        }
    }

    @Test
    public void testProgramFramesHaveModule() throws Exception {
        String expectedProgramModule = Path.of(this.getTestExecutablePath(), new String[0]).getFileName().toString();
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        XExecutionStack thread = XDebuggerAssertions.getActiveThread(this.getSession());
        XStackFrame frame = thread.getTopFrame();
        String module2 = ((CidrStackFrame)frame).getFrame().getModule();
        CidrDebuggingGeneralTestCase.assertEquals((String)"Wrong program frame module", (String)expectedProgramModule, (String)module2);
    }

    @Test
    public void testBreakpointHitCountEqualTo() throws Exception {
        this.doTestBreakpointHitCount(CidrBreakpointHitCountMode.EqualTo, 3, List.of("2"));
    }

    @Test
    public void testBreakpointHitCountGreaterThanOrEqualTo() throws Exception {
        this.doTestBreakpointHitCount(CidrBreakpointHitCountMode.GreaterThanOrEqualTo, 7, List.of("6", "7", "8", "9"));
    }

    @Test
    public void testBreakpointHitCountMultipleOf() throws Exception {
        this.doTestBreakpointHitCount(CidrBreakpointHitCountMode.MultipleOf, 3, List.of("2", "5", "8"));
    }

    @Test
    public void testBreakpointHitCountMultipleOfZero() throws Exception {
        XLineBreakpoint breakpoint = XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_FOR_LOOP);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)breakpoint);
        CidrDebuggingGeneralTestCase.setBreakpointHitProperty(breakpoint, CidrBreakpointHitCountMode.MultipleOf, 0);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> stateQueue = ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSessionWithListener("forLoop");
        CidrDebuggingFixture.waitForEvent(stateQueue, this.STOPPED);
        XDebuggerTestUtil.waitForSwing();
    }

    private void doTestBreakpointHitCount(CidrBreakpointHitCountMode hitCountMode, int hitValue, List<String> expectedK) throws Exception {
        XLineBreakpoint breakpoint = XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_FOR_LOOP);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)breakpoint);
        CidrDebuggingGeneralTestCase.setBreakpointHitProperty(breakpoint, hitCountMode, hitValue);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("forLoop");
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_FOR_LOOP);
        int expectedIndex = 0;
        XDebuggerAssertions.assertVariableValue(this.collectVars(0), "k", expectedK.get(expectedIndex++));
        while (expectedIndex < expectedK.size()) {
            this.getSession().resume();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
            XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_FOR_LOOP);
            XDebuggerAssertions.assertVariableValue(this.collectVars(0), "k", expectedK.get(expectedIndex));
            ++expectedIndex;
        }
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
    }

    @Test
    public void testBreakpointHitCountWithCondition() throws Exception {
        XLineBreakpoint breakpoint = XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_FOR_LOOP);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)breakpoint);
        breakpoint.setCondition("k > 1");
        CidrDebuggingGeneralTestCase.setBreakpointHitProperty(breakpoint, CidrBreakpointHitCountMode.GreaterThanOrEqualTo, 3);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("forLoop");
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_FOR_LOOP);
        XDebuggerAssertions.assertVariableValue(this.collectVars(0), "k", "4");
        breakpoint.setCondition("k > 0");
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_FOR_LOOP);
        XDebuggerAssertions.assertVariableValue(this.collectVars(0), "k", "5");
        breakpoint.setCondition("k > 10000");
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.STOPPED);
    }

    @Test
    public void testStopStepOverOnFunctionFinish() throws Exception {
        this.testStopSteppingOnFunctionFinish(s -> s.stepOver(false));
    }

    @Test
    public void testStopStepInOnFunctionFinish() throws Exception {
        this.testStopSteppingOnFunctionFinish(s -> s.stepInto());
    }

    private void testStopSteppingOnFunctionFinish(@NotNull java.util.function.Consumer<XDebugSession> stepAction) throws Exception {
        if (stepAction == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(22);
        }
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NESTED_CALL1);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NESTED_CALL2);
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NESTED_CALL3);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSessionWithListener("nested_calls");
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        if (this.myBackend == DebuggerDriverKind.GDB) {
            Assume.assumeTrue((String)"Stop on function finish requires custom gdb/mi commands supported in gdb-14+", (boolean)((GDBDriver)this.getDebugProcess().getDriverInTests()).getGdbVersion().isOrGreaterThan(Integer.valueOf(14)));
        }
        XDebugSession session = this.getSession();
        XDebuggerAssertions.assertCurrentPosition(session, ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NESTED_CALL1);
        this.stepUntilTopFunctionChanges(session, state, stepAction);
        XDebuggerAssertions.assertCurrentPosition(session, ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NESTED_CALLS);
        session.resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(session, ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NESTED_CALL2);
        this.stepUntilTopFunctionChanges(session, state, stepAction);
        XDebuggerAssertions.assertCurrentPosition(session, ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NESTED_CALLS);
        session.resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        XDebuggerAssertions.assertCurrentPosition(session, ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NESTED_CALL3);
        this.stepUntilTopFunctionChanges(session, state, stepAction);
        XSourcePosition position = session.getCurrentPosition();
        int line = position.getLine();
        CidrDebuggingGeneralTestCase.assertTrue((line == ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NESTED_CALLS || line == ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_AFTER_NESTED_CALLS ? 1 : 0) != 0);
    }

    @Test
    public void testBreakpointOutsideCode() throws Exception {
        XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XLineBreakpoint breakpoint = XDebuggerAssertions.toggleBreakpoint(this.getProject(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_AFTER_CODE);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)breakpoint);
        Icon icon = (Icon)CidrDebuggingUtilKt.waitForNotNull(() -> {
            CustomizedBreakpointPresentation presentation = ((XDebugSessionImpl)this.getSession()).getBreakpointPresentation((XBreakpoint)breakpoint);
            return presentation != null ? presentation.getIcon() : null;
        });
        CidrDebuggingGeneralTestCase.assertEquals((Object)AllIcons.Debugger.Db_invalid_breakpoint, (Object)icon);
    }

    private void stepUntilTopFunctionChanges(@NotNull XDebugSession session, @NotNull BlockingQueue<CidrDebuggingFixture.DebuggerState> state, @NotNull java.util.function.Consumer<XDebugSession> stepAction) throws InterruptedException {
        if (session == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(23);
        }
        if (state == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(24);
        }
        if (stepAction == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(25);
        }
        String function = CidrDebuggingUtilKt.getTopFrameFunctionName(session);
        do {
            stepAction.accept(session);
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, this.PAUSED);
        } while (function.equals(CidrDebuggingUtilKt.getTopFrameFunctionName(session)));
    }

    private static void setBreakpointHitProperty(@NotNull XLineBreakpoint breakpoint, CidrBreakpointHitCountMode mode, int hitVale) {
        if (breakpoint == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(26);
        }
        CidrLineBreakpointType.Properties properties = CidrDebuggingGeneralTestCase.assertInstanceOf(breakpoint.getProperties(), CidrLineBreakpointType.Properties.class);
        properties.setHitCountEnabled(true);
        properties.setHitCountMode(mode);
        properties.setHitCountValue(hitVale);
    }

    @NotNull
    private static List<XValue> getRegisters(@NotNull CidrStackFrame frame) {
        if (frame == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(27);
        }
        XValue registersNode = CidrDebuggingGeneralTestCase.getRegistersNode(frame);
        List<XValue> list = XDebuggerAssertions.collectChildren((XValueContainer)registersNode);
        if (list == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static XValue getRegistersNode(@NotNull CidrStackFrame frame) {
        if (frame == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(29);
        }
        List<XValue> variables = XDebuggerAssertions.collectChildren((XValueContainer)frame);
        XValue result = CidrDebuggingFixture.findVar(variables, CidrDebuggerBundle.message((String)"debug.registers.value", (Object[])new Object[0]));
        CidrDebuggingGeneralTestCase.assertNotNull((Object)result);
        XValue xValue = result;
        if (xValue == null) {
            CidrDebuggingGeneralTestCase.$$$reportNull$$$0(30);
        }
        return xValue;
    }

    private void setShowLibraryStackFrames(boolean value2) {
        boolean origValue = XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().isShowLibraryStackFrames();
        this.disposeOnTearDown(() -> XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().setShowLibraryStackFrames(origValue));
        XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().setShowLibraryStackFrames(value2);
    }

    private void checkIsInMainCppMain() throws IOException {
        XDebuggerAssertions.assertCurrentPosition(this.getSession(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, -1);
        String functionName = ((CidrStackFrame)this.getSession().getCurrentStackFrame()).getFrame().getFunction();
        CidrDebuggingGeneralTestCase.assertMatches(functionName, "^main\\b.*");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 7, 8, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingGeneralTestCase";
                break;
            }
            case 2: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loggedErrors";
                break;
            }
            case 7: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedCompletions";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepAction";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestDataFixture";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createThrowingCommand";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingGeneralTestCase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "ns_breakpoints_frame";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "cpp_breakpoints_frame";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAndLoadDisasmPosition";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandsFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedPromptValue";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisters";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistersNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "catchErrorFromAsyncCommand";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withLoggedErrorsRecorded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertFrameOnSignal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkAndLoadDisasmPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doTestSteppingOutSkippingSourcelessFrames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doTestSteppingOverSkippingSourcelessFrames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doTestSteppingThroughSourcelessFramesForMSVCRuntime";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCommandsFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doTestSteppingThroughSourcelessFrames";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doTestCompleteConsoleCommand";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "testStopSteppingOnFunctionFinish";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "stepUntilTopFunctionChanges";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpointHitProperty";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRegisters";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRegistersNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 7, 8, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 29 -> new IllegalArgumentException(string);
        };
    }

    private static class CidrModificationCallback
    implements XValueModifier.XModificationCallback {
        private final CountDownLatch myLatch = new CountDownLatch(1);

        private CidrModificationCallback() {
        }

        public void valueModified() {
            this.myLatch.countDown();
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                CidrModificationCallback.$$$reportNull$$$0(0);
            }
            this.myLatch.countDown();
        }

        public boolean await() throws InterruptedException {
            return this.myLatch.await(25000L, TimeUnit.MILLISECONDS);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/jetbrains/cidr/execution/debugger/CidrDebuggingGeneralTestCase$CidrModificationCallback", "errorOccurred"));
        }
    }
}

