/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.console;

import com.jetbrains.cidr.execution.console.MarkerData;
import com.jetbrains.cidr.execution.console.ProcessedText;
import com.jetbrains.cidr.execution.console.TextMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/execution/console/ConsoleFilterTestBuilder;", "", "openMarker", "", "closeMarker", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "parse", "Lcom/jetbrains/cidr/execution/console/ProcessedText;", "input", "parseAttributes", "Lcom/jetbrains/cidr/execution/console/MarkerData;", "attributeString", "parseAttributeTokens", "", "Companion", "intellij.cidr.common.testFramework.core"})
@SourceDebugExtension(value={"SMAP\nConsoleFilterTestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleFilterTestBuilder.kt\ncom/jetbrains/cidr/execution/console/ConsoleFilterTestBuilder\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,214:1\n1104#2,3:215\n*S KotlinDebug\n*F\n+ 1 ConsoleFilterTestBuilder.kt\ncom/jetbrains/cidr/execution/console/ConsoleFilterTestBuilder\n*L\n104#1:215,3\n*E\n"})
public final class ConsoleFilterTestBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String openMarker;
    @NotNull
    private final String closeMarker;
    @NotNull
    public static final String STANDARD_OPEN_MARKER = "<marker>";
    @NotNull
    public static final String STANDARD_CLOSE_MARKER = "</marker>";

    public ConsoleFilterTestBuilder(@NotNull String openMarker, @NotNull String closeMarker) {
        Intrinsics.checkNotNullParameter((Object)openMarker, (String)"openMarker");
        Intrinsics.checkNotNullParameter((Object)closeMarker, (String)"closeMarker");
        this.openMarker = openMarker;
        this.closeMarker = closeMarker;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProcessedText parse(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List markers = new ArrayList();
        StringBuilder result = new StringBuilder();
        int currentPosition = 0;
        int lineNumber = 1;
        int searchStart = 0;
        while (true) {
            String markerContent;
            String tagContent;
            void $this$count$iv;
            String beforeMarker;
            int openIndex;
            if ((openIndex = StringsKt.indexOf$default((CharSequence)input, (String)"<marker", (int)searchStart, (boolean)false, (int)4, null)) == -1) {
                String string = input.substring(searchStart);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result.append(string);
                break;
            }
            int tagEndIndex = StringsKt.indexOf$default((CharSequence)input, (String)">", (int)openIndex, (boolean)false, (int)4, null);
            if (tagEndIndex == -1) {
                String string = input.substring(searchStart);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result.append(string);
                break;
            }
            int closeIndex = StringsKt.indexOf$default((CharSequence)input, (String)STANDARD_CLOSE_MARKER, (int)tagEndIndex, (boolean)false, (int)4, null);
            if (closeIndex == -1) {
                String string = input.substring(searchStart);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result.append(string);
                break;
            }
            Intrinsics.checkNotNullExpressionValue((Object)input.substring(searchStart, openIndex), (String)"substring(...)");
            result.append(beforeMarker);
            currentPosition += beforeMarker.length();
            CharSequence charSequence = beforeMarker;
            int n = lineNumber;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            int n2 = count$iv;
            lineNumber = n + n2;
            Intrinsics.checkNotNullExpressionValue((Object)input.substring(openIndex + 7, tagEndIndex), (String)"substring(...)");
            MarkerData markerData = this.parseAttributes(tagContent);
            Intrinsics.checkNotNullExpressionValue((Object)input.substring(tagEndIndex + 1, closeIndex), (String)"substring(...)");
            int startPos = currentPosition;
            int endPos = currentPosition + markerContent.length();
            markers.add(new TextMarker(markerContent, startPos, endPos, lineNumber, markerData));
            result.append(markerContent);
            currentPosition += markerContent.length();
            searchStart = closeIndex + 9;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new ProcessedText(string, markers);
    }

    private final MarkerData parseAttributes(String attributeString) {
        String trimmed = ((Object)StringsKt.trim((CharSequence)attributeString)).toString();
        if (((CharSequence)trimmed).length() == 0) {
            return new MarkerData(null, null, null);
        }
        Integer line = null;
        Integer column = null;
        String filePath = null;
        List<String> attributes = this.parseAttributeTokens(trimmed);
        block12: for (String attr : attributes) {
            int equalIndex = StringsKt.indexOf$default((CharSequence)attr, (String)"=", (int)0, (boolean)false, (int)6, null);
            if (equalIndex == -1) {
                throw new IllegalArgumentException("Invalid attribute format: " + attr);
            }
            String string = attr.substring(0, equalIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String name = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string2 = attr.substring(equalIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String value2 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            try {
                switch (name) {
                    case "line": {
                        line = Integer.parseInt(value2);
                        continue block12;
                    }
                    case "column": {
                        column = Integer.parseInt(value2);
                        continue block12;
                    }
                    case "filePath": {
                        if (StringsKt.startsWith$default((String)value2, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value2, (String)"\"", (boolean)false, (int)2, null) && value2.length() >= 2) {
                            Intrinsics.checkNotNullExpressionValue((Object)value2.substring(1, value2.length() - 1), (String)"substring(...)");
                            continue block12;
                        }
                        throw new IllegalArgumentException("filePath attribute must be quoted: " + value2);
                    }
                }
                throw new IllegalArgumentException("Unknown attribute: " + name);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid number format for attribute " + name + ": " + value2, e);
            }
        }
        return new MarkerData(line, column, filePath);
    }

    private final List<String> parseAttributeTokens(String attributeString) {
        List tokens = new ArrayList();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < attributeString.length(); ++i) {
            StringBuilder stringBuilder;
            char c = attributeString.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                stringBuilder = current.append(c);
                continue;
            }
            if (c == ' ' && !inQuotes) {
                if (((CharSequence)current).length() > 0) {
                    String string = current.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    tokens.add(string);
                    current = new StringBuilder();
                }
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            stringBuilder = current.append(c);
        }
        if (((CharSequence)current).length() > 0) {
            String string = current.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            tokens.add(string);
        }
        if (inQuotes) {
            throw new IllegalArgumentException("Unclosed quote in attribute string: " + attributeString);
        }
        return tokens;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/console/ConsoleFilterTestBuilder$Companion;", "", "<init>", "()V", "STANDARD_OPEN_MARKER", "", "STANDARD_CLOSE_MARKER", "createMarker", "text", "line", "", "column", "filePath", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/String;", "build", "Lcom/jetbrains/cidr/execution/console/ProcessedText;", "openMarker", "closeMarker", "intellij.cidr.common.testFramework.core"})
    @SourceDebugExtension(value={"SMAP\nConsoleFilterTestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleFilterTestBuilder.kt\ncom/jetbrains/cidr/execution/console/ConsoleFilterTestBuilder$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1#2:215\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String createMarker(@NotNull String text2, @Nullable Integer line, @Nullable Integer column, @Nullable String filePath) {
            int it;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List attributes = new ArrayList();
            Integer n = line;
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl = false;
                attributes.add("line=" + it);
            }
            Integer n2 = column;
            if (n2 != null) {
                it = ((Number)n2).intValue();
                boolean bl = false;
                attributes.add("column=" + it);
            }
            String string = filePath;
            if (string != null) {
                String it2 = string;
                boolean bl = false;
                attributes.add("filePath=\"" + it2 + "\"");
            }
            String attributeString = !((Collection)attributes).isEmpty() ? " " + CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) : "";
            return "<marker" + attributeString + ">" + text2 + ConsoleFilterTestBuilder.STANDARD_CLOSE_MARKER;
        }

        public static /* synthetic */ String createMarker$default(Companion companion, String string, Integer n, Integer n2, String string2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = null;
            }
            if ((n3 & 4) != 0) {
                n2 = null;
            }
            if ((n3 & 8) != 0) {
                string2 = null;
            }
            return companion.createMarker(string, n, n2, string2);
        }

        @NotNull
        public final ProcessedText build(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return this.build(text2, ConsoleFilterTestBuilder.STANDARD_OPEN_MARKER, ConsoleFilterTestBuilder.STANDARD_CLOSE_MARKER);
        }

        @NotNull
        public final ProcessedText build(@NotNull String text2, @NotNull String openMarker, @NotNull String closeMarker) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)openMarker, (String)"openMarker");
            Intrinsics.checkNotNullParameter((Object)closeMarker, (String)"closeMarker");
            return new ConsoleFilterTestBuilder(openMarker, closeMarker).parse(text2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

