/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.console;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.assumptions.SystemAssumption;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.console.CidrPathConsoleFilter;
import com.jetbrains.cidr.execution.console.ConsoleFilterTestBuilder;
import com.jetbrains.cidr.execution.console.MarkerData;
import com.jetbrains.cidr.execution.console.PathCandidate;
import com.jetbrains.cidr.execution.console.ProcessedText;
import com.jetbrains.cidr.execution.console.TestFileStructure;
import com.jetbrains.cidr.execution.console.TestFileStructureKt;
import com.jetbrains.cidr.execution.console.TextMarker;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectFixture;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b)\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u00002,\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0001:\u0001^B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\tJ\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\tJ\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\tJ\u0006\u0010\u0019\u001a\u00020\tJ\u0006\u0010\u001a\u001a\u00020\tJ\u0006\u0010\u001b\u001a\u00020\tJ\u0006\u0010\u001c\u001a\u00020\tJ\u0006\u0010\u001d\u001a\u00020\tJ\u0006\u0010\u001e\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\tJ\u0006\u0010 \u001a\u00020\tJ\u0006\u0010!\u001a\u00020\tJ\u0006\u0010\"\u001a\u00020\tJ\u0006\u0010#\u001a\u00020\tJ\u0006\u0010$\u001a\u00020\tJ\u0006\u0010%\u001a\u00020\tJ\u0006\u0010&\u001a\u00020\tJ\u0006\u0010'\u001a\u00020\tJ\u0006\u0010(\u001a\u00020\tJ\u0006\u0010)\u001a\u00020\tJ\u0006\u0010*\u001a\u00020\tJ\u0006\u0010+\u001a\u00020\tJ\u0006\u0010,\u001a\u00020\tJ\u0006\u0010-\u001a\u00020\tJ\u0006\u0010.\u001a\u00020\tJ\u0006\u0010/\u001a\u00020\tJ\u0006\u00100\u001a\u00020\tJ\u0006\u00101\u001a\u00020\tJ\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u00020\tJ\u0006\u00107\u001a\u00020\tJ\u0006\u00108\u001a\u00020\tJ\u0006\u00109\u001a\u00020\tJ\u0006\u0010:\u001a\u00020\tJ\u0006\u0010;\u001a\u00020\tJ\u0006\u0010<\u001a\u00020\tJ\u0006\u0010=\u001a\u00020\tJ\u0006\u0010>\u001a\u00020\tJ\u0006\u0010?\u001a\u00020\tJ\u0006\u0010@\u001a\u00020\tJ\b\u0010A\u001a\u00020BH\u0014J\n\u0010C\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010D\u001a\u00020EH\u0014J\b\u0010F\u001a\u00020\tH\u0014J\u001c\u0010G\u001a\u00020\t2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002030IH\u0004J\u001c\u0010J\u001a\u00020\t2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002030IH\u0004J:\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020M2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002030I2\u0014\b\u0002\u0010N\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020O0IH\u0004J\u0012\u0010P\u001a\u00020O2\n\b\u0002\u0010Q\u001a\u0004\u0018\u000105J(\u0010R\u001a\u00020O2\n\b\u0002\u0010Q\u001a\u0004\u0018\u0001052\u0014\u0010S\u001a\u0010\u0012\u0004\u0012\u00020T\u0012\u0006\u0012\u0004\u0018\u00010U0IJ\n\u0010V\u001a\u0004\u0018\u00010WH&J \u0010X\u001a\u00020T2\u0006\u0010Y\u001a\u00020T2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020[H\u0002J\n\u0010]\u001a\u00020T*\u000205\u00a8\u0006_"}, d2={"Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilterTest;", "Lcom/jetbrains/cidr/CidrTestCase;", "Lcom/jetbrains/cidr/lang/fixtures/OCMockProjectFixture;", "Lcom/jetbrains/cidr/execution/CidrExecutionFixture;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggingFixture;", "Lcom/jetbrains/cidr/CidrCodeInsightFixture;", "<init>", "()V", "test simple file", "", "test simple header", "test full path simple file", "test no file if there's no such file", "test simple file should be linked to correct path", "test simple file should be linked to correct line", "test simple file should be linked to correct column", "test unicode russian file", "test unicode chinese file", "test unicode korean file", "test unicode greek file", "test unicode full path russian file", "test unicode full path chinese file", "test unicode full path korean file", "test unicode full path greek file", "test windows backslash paths", "test mixed slash paths", "test relative path", "test relative path shouldn't be found with point", "test space before colons", "test spaces before colons", "test whitespaces before colons", "test whitespaces simple file position", "test whitespaces msvc file position", "test whitespaces msvc file position with only line", "test whitespaces msvc file position with space", "test with msvc file position inside filename", "test with msvc file position inside filename and line and column", "test with msvc half file position inside filename and line and column", "test just text is not matching", "test just text is not matching but priority is 0", "test just text with file position is matching", "test additional extensions matching", "test path with a lot of spaces", "test path with multiple matches at once", "test path inside quotes", "test path with punctuation - exclamation", "test path with punctuation - point", "test find correct file with two candidates", "test home path should be resolved correctly", "test emoji in name", "randomConsoleFiles", "Lcom/jetbrains/cidr/execution/console/ProcessedText;", "it", "Ljava/nio/file/Path;", "test recursive directory traversal with large tree", "test guess simple file", "test guess simple file with part of console", "test not guess file with two candidates", "test linux case insensitivity by path", "test linux case insensitivity by file name", "test windows case sensitivity by path", "test windows case sensitivity by file name", "test bunch of words should not even be tried to resolve", "test relative path with point", "test path with token separator", "createTestDataFixture", "Lcom/jetbrains/cidr/CidrTestDataFixture;", "createProjectFixture", "shouldCleanProject", "Lcom/jetbrains/cidr/CidrProjectFixture$CleanProjectOption;", "setUpFixtures", "doSimpleProjectTest", "processedTextLambda", "Lkotlin/Function1;", "doUnicodeProjectTest", "doTest", "testFileStructure", "Lcom/jetbrains/cidr/execution/console/TestFileStructure$FileStructure;", "createConsole", "Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter;", "createSimpleConsole", "baseDir", "createResolverConsole", "localPathStringResolver", "", "Lcom/intellij/execution/filters/Filter$ResultItem;", "getCidrToolEnvironment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "getTextContext", "text", "expectedPos", "", "actualPos", "systemIndependentPath", "FilterResultWithLine", "intellij.cidr.common.testFramework.core"})
@SourceDebugExtension(value={"SMAP\nCidrPathConsoleFilterTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrPathConsoleFilterTest.kt\ncom/jetbrains/cidr/execution/console/CidrPathConsoleFilterTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,817:1\n1869#2,2:818\n*S KotlinDebug\n*F\n+ 1 CidrPathConsoleFilterTest.kt\ncom/jetbrains/cidr/execution/console/CidrPathConsoleFilterTest\n*L\n686#1:818,2\n*E\n"})
public abstract class CidrPathConsoleFilterTest
extends CidrTestCase<OCMockProjectFixture, CidrExecutionFixture<OCMockProjectFixture>, CidrDebuggingFixture<CidrExecutionFixture<OCMockProjectFixture>>, CidrCodeInsightFixture> {
    public final void test simple file() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_simple_file$lambda$0));
    }

    public final void test simple header() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_simple_header$lambda$0)), CidrPathConsoleFilterTest::test_simple_header$lambda$1, null, 4, null);
    }

    public final void test full path simple file() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_full_path_simple_file$lambda$0(this, arg_0)));
    }

    public final void test no file if there's no such file() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_no_file_if_there_s_no_such_file$lambda$0));
    }

    public final void test simple file should be linked to correct path() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_simple_file_should_be_linked_to_correct_path$lambda$0(this, arg_0)));
    }

    public final void test simple file should be linked to correct line() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_simple_file_should_be_linked_to_correct_line$lambda$0));
    }

    public final void test simple file should be linked to correct column() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_simple_file_should_be_linked_to_correct_column$lambda$0));
    }

    public final void test unicode russian file() {
        this.doUnicodeProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_unicode_russian_file$lambda$0));
    }

    public final void test unicode chinese file() {
        this.doUnicodeProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_unicode_chinese_file$lambda$0));
    }

    public final void test unicode korean file() {
        this.doUnicodeProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_unicode_korean_file$lambda$0));
    }

    public final void test unicode greek file() {
        this.doUnicodeProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_unicode_greek_file$lambda$0));
    }

    public final void test unicode full path russian file() {
        this.doUnicodeProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_unicode_full_path_russian_file$lambda$0(this, arg_0)));
    }

    public final void test unicode full path chinese file() {
        this.doUnicodeProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_unicode_full_path_chinese_file$lambda$0(this, arg_0)));
    }

    public final void test unicode full path korean file() {
        this.doUnicodeProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_unicode_full_path_korean_file$lambda$0(this, arg_0)));
    }

    public final void test unicode full path greek file() {
        this.doUnicodeProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_unicode_full_path_greek_file$lambda$0(this, arg_0)));
    }

    public final void test windows backslash paths() {
        SystemAssumption.Companion.assumeLocalSystem().isWindows();
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_windows_backslash_paths$lambda$0(this, arg_0)));
    }

    public final void test mixed slash paths() {
        SystemAssumption.Companion.assumeLocalSystem().isWindows();
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_mixed_slash_paths$lambda$0(this, arg_0)));
    }

    public final void test relative path() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_relative_path$lambda$0(this, arg_0)));
    }

    public final void test relative path shouldn't be found with point() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_relative_path_shouldn_t_be_found_with_point$lambda$0(this, arg_0)));
    }

    public final void test space before colons() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_space_before_colons$lambda$0));
    }

    public final void test spaces before colons() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_spaces_before_colons$lambda$0));
    }

    public final void test whitespaces before colons() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_whitespaces_before_colons$lambda$0));
    }

    public final void test whitespaces simple file position() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_whitespaces_simple_file_position$lambda$0));
    }

    public final void test whitespaces msvc file position() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_whitespaces_msvc_file_position$lambda$0));
    }

    public final void test whitespaces msvc file position with only line() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_whitespaces_msvc_file_position_with_only_line$lambda$0));
    }

    public final void test whitespaces msvc file position with space() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_whitespaces_msvc_file_position_with_space$lambda$0));
    }

    public final void test with msvc file position inside filename() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_with_msvc_file_position_inside_filename$lambda$0)), CidrPathConsoleFilterTest::test_with_msvc_file_position_inside_filename$lambda$1, null, 4, null);
    }

    public final void test with msvc file position inside filename and line and column() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_with_msvc_file_position_inside_filename_and_line_and_column$lambda$0)), CidrPathConsoleFilterTest::test_with_msvc_file_position_inside_filename_and_line_and_column$lambda$1, null, 4, null);
    }

    public final void test with msvc half file position inside filename and line and column() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_with_msvc_half_file_position_inside_filename_and_line_and_column$lambda$0)), CidrPathConsoleFilterTest::test_with_msvc_half_file_position_inside_filename_and_line_and_column$lambda$1, null, 4, null);
    }

    public final void test just text is not matching() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_just_text_is_not_matching$lambda$0)), CidrPathConsoleFilterTest::test_just_text_is_not_matching$lambda$1, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void test just text is not matching but priority is 0() {
        int priority = CidrPathConsoleFilter.Companion.priorityLimit();
        try {
            CidrPathConsoleFilter.Companion.setPriority(-1);
            CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_just_text_is_not_matching_but_priority_is_0$lambda$0)), CidrPathConsoleFilterTest::test_just_text_is_not_matching_but_priority_is_0$lambda$1, null, 4, null);
        }
        finally {
            CidrPathConsoleFilter.Companion.setPriority(priority);
        }
    }

    public final void test just text with file position is matching() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_just_text_with_file_position_is_matching$lambda$0)), CidrPathConsoleFilterTest::test_just_text_with_file_position_is_matching$lambda$1, null, 4, null);
    }

    public final void test additional extensions matching() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_additional_extensions_matching$lambda$0)), CidrPathConsoleFilterTest::test_additional_extensions_matching$lambda$1, null, 4, null);
    }

    public final void test path with a lot of spaces() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_a_lot_of_spaces$lambda$0)), CidrPathConsoleFilterTest::test_path_with_a_lot_of_spaces$lambda$1, null, 4, null);
    }

    public final void test path with multiple matches at once() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_multiple_matches_at_once$lambda$0)), CidrPathConsoleFilterTest::test_path_with_multiple_matches_at_once$lambda$1, null, 4, null);
    }

    public final void test path inside quotes() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_path_inside_quotes$lambda$0));
    }

    public final void test path with punctuation - exclamation() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_path_with_punctuation___exclamation$lambda$0));
    }

    public final void test path with punctuation - point() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_path_with_punctuation___point$lambda$0));
    }

    public final void test find correct file with two candidates() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_find_correct_file_with_two_candidates$lambda$0)), arg_0 -> CidrPathConsoleFilterTest.test_find_correct_file_with_two_candidates$lambda$1(this, arg_0), null, 4, null);
    }

    public final void test home path should be resolved correctly() {
        SystemAssumption.Companion.assumeLocalSystem().isLinux();
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path nearHomePath = path.resolve("temporary-directory-a-03485764085");
        TestFileStructure.FileStructure insideFileImitation = TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_home_path_should_be_resolved_correctly$lambda$0));
        Intrinsics.checkNotNull((Object)nearHomePath);
        TestFileStructure.INSTANCE.withFileImitation(nearHomePath, insideFileImitation, (Function0<Unit>)((Function0)() -> CidrPathConsoleFilterTest.test_home_path_should_be_resolved_correctly$lambda$1(this, nearHomePath)));
    }

    public final void test emoji in name() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_emoji_in_name$lambda$0)), CidrPathConsoleFilterTest::test_emoji_in_name$lambda$1, null, 4, null);
    }

    @NotNull
    public final ProcessedText randomConsoleFiles(@NotNull Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "src/", null, null, null, 14, null);
        String string2 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "bean/", null, null, null, 14, null);
        String string3 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "grpc_bridge.cpp", null, null, null, 14, null);
        String string4 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "api.cpp", null, null, null, 14, null);
        String string5 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "network_handler.cpp", null, null, null, 14, null);
        String string6 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "domain/", null, null, null, 14, null);
        String string7 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "user_service.cpp", null, null, null, 14, null);
        String string8 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "order_service.cpp", null, null, null, 14, null);
        String string9 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "models/", null, null, null, 14, null);
        String string10 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "user.cpp", null, null, null, 14, null);
        String string11 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "order.cpp", null, null, null, 14, null);
        String string12 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "product.cpp", null, null, null, 14, null);
        String string13 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "models/", null, null, null, 14, null);
        String string14 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "domain/", null, null, null, 14, null);
        String string15 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "utils/", null, null, null, 14, null);
        String string16 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "string_utils.cpp", null, null, null, 14, null);
        String string17 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "math_utils.cpp", null, null, null, 14, null);
        String string18 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "crypto/", null, null, null, 14, null);
        String string19 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "hash.cpp", null, null, null, 14, null);
        String string20 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "encryption.cpp", null, null, null, 14, null);
        String string21 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "crypto/", null, null, null, 14, null);
        String string22 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "empty_folder/", null, null, null, 14, null);
        String string23 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "empty_folder/", null, null, null, 14, null);
        String string24 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "utils/", null, null, null, 14, null);
        String string25 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "tests/", null, null, null, 14, null);
        String string26 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "test_runner.cpp", null, null, null, 14, null);
        Path path = it.resolve("src").resolve("tests").resolve("main2.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String string27 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "main2.cpp", null, null, this.systemIndependentPath(path), 6, null);
        String string28 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "unit/", null, null, null, 14, null);
        String string29 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "bean_tests.cpp", null, null, null, 14, null);
        String string30 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "domain_tests.cpp", null, null, null, 14, null);
        String string31 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "unit/", null, null, null, 14, null);
        String string32 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "integration/", null, null, null, 14, null);
        String string33 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "api_tests.cpp", null, null, null, 14, null);
        String string34 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "empty_test_folder/", null, null, null, 14, null);
        String string35 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "empty_test_folder/", null, null, null, 14, null);
        String string36 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "integration/", null, null, null, 14, null);
        String string37 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "tests/", null, null, null, 14, null);
        String string38 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "bean/", null, null, null, 14, null);
        String string39 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "src/", null, null, null, 14, null);
        String string40 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "lib/", null, null, null, 14, null);
        String string41 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "external_lib.cpp", null, null, null, 14, null);
        String string42 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "third_party/", null, null, null, 14, null);
        String string43 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "json_parser.cpp", null, null, null, 14, null);
        String string44 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "http_client.cpp", null, null, null, 14, null);
        String string45 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "third_party/", null, null, null, 14, null);
        String string46 = ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "lib/", null, null, null, 14, null);
        Path path2 = it.resolve("main.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      = Enter directory " + string + "\n      == Enter directory " + string2 + "\n      === Compiling file " + string3 + "\n      === Compiling file " + string4 + "\n      === Compiling file " + string5 + "\n      == Enter directory " + string6 + "\n      === Compiling file " + string7 + "\n      === Compiling file " + string8 + "\n      ==== Enter directory " + string9 + "\n      ===== Compiling file " + string10 + "\n      ===== Compiling file " + string11 + "\n      ===== Compiling file " + string12 + "\n      ==== Exit directory " + string13 + "\n      === Exit directory " + string14 + "\n      == Enter directory " + string15 + "\n      === Compiling file " + string16 + "\n      === Compiling file " + string17 + "\n      ==== Enter directory " + string18 + "\n      ===== Compiling file " + string19 + "\n      ===== Compiling file " + string20 + "\n      ==== Exit directory " + string21 + "\n      ==== Enter directory " + string22 + "\n      ==== Exit directory " + string23 + "\n      === Exit directory " + string24 + "\n      == Enter directory " + string25 + "\n      === Compiling file " + string26 + "\n      === Compiling file " + string27 + "\n      ==== Enter directory " + string28 + "\n      ===== Compiling file " + string29 + "\n      ===== Compiling file " + string30 + "\n      ==== Exit directory " + string31 + "\n      ==== Enter directory " + string32 + "\n      ===== Compiling file " + string33 + "\n      ===== Enter directory " + string34 + "\n      ===== Exit directory " + string35 + "\n      ==== Exit directory " + string36 + "\n      === Exit directory " + string37 + "\n      == Exit directory " + string38 + "\n      = Exit directory " + string39 + "\n      = Enter directory " + string40 + "\n      == Compiling file " + string41 + "\n      == Enter directory " + string42 + "\n      === Compiling file " + string43 + "\n      === Compiling file " + string44 + "\n      == Exit directory " + string45 + "\n      = Exit directory " + string46 + "\n      = Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "main.cpp", null, null, this.systemIndependentPath(path2), 6, null) + "\n    ")));
    }

    public final void test recursive directory traversal with large tree() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructureKt.randomFiles(), (Function1)new Function1<Path, ProcessedText>((Object)this){

            public final ProcessedText invoke(Path p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((CidrPathConsoleFilterTest)this.receiver).randomConsoleFiles(p0);
            }
        }, null, 4, null);
    }

    public final void test guess simple file() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_guess_simple_file$lambda$0)), arg_0 -> CidrPathConsoleFilterTest.test_guess_simple_file$lambda$1(this, arg_0), null, 4, null);
    }

    public final void test guess simple file with part of console() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_guess_simple_file_with_part_of_console$lambda$0)), arg_0 -> CidrPathConsoleFilterTest.test_guess_simple_file_with_part_of_console$lambda$1(this, arg_0), null, 4, null);
    }

    public final void test not guess file with two candidates() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_not_guess_file_with_two_candidates$lambda$0)), CidrPathConsoleFilterTest::test_not_guess_file_with_two_candidates$lambda$1, null, 4, null);
    }

    public final void test linux case insensitivity by path() {
        SystemAssumption.Companion.assumeLocalSystem().isLinux();
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_linux_case_insensitivity_by_path$lambda$0(this, arg_0)));
    }

    public final void test linux case insensitivity by file name() {
        SystemAssumption.Companion.assumeLocalSystem().isLinux();
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_linux_case_insensitivity_by_file_name$lambda$0));
    }

    public final void test windows case sensitivity by path() {
        SystemAssumption.Companion.assumeLocalSystem().isWindows();
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_windows_case_sensitivity_by_path$lambda$0(this, arg_0)));
    }

    public final void test windows case sensitivity by file name() {
        SystemAssumption.Companion.assumeLocalSystem().isWindows();
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_windows_case_sensitivity_by_file_name$lambda$0));
    }

    public final void test bunch of words should not even be tried to resolve() {
        List words = new ArrayList();
        this.doTest(TestFileStructureKt.simpleProject(), (Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_bunch_of_words_should_not_even_be_tried_to_resolve$lambda$0), (Function1<? super Path, ? extends CidrPathConsoleFilter>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_bunch_of_words_should_not_even_be_tried_to_resolve$lambda$1(this, words, arg_0)));
        if (!((Collection)words).isEmpty()) {
            CidrTestCase.fail((String)("Should not even try to resolve any word, but got " + CollectionsKt.joinToString$default((Iterable)words, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)));
        }
    }

    public final void test relative path with point() {
        this.doSimpleProjectTest((Function1<? super Path, ProcessedText>)((Function1)CidrPathConsoleFilterTest::test_relative_path_with_point$lambda$0));
    }

    public final void test path with token separator() {
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_token_separator$lambda$0)), arg_0 -> CidrPathConsoleFilterTest.test_path_with_token_separator$lambda$1(this, arg_0), null, 4, null);
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrTestDataFixture(CidrTestDataFixture.getCLionTestData().toFile());
    }

    @Override
    @Nullable
    protected OCMockProjectFixture createProjectFixture() {
        CidrTestDataFixture cidrTestDataFixture = this.myTestDataFixture;
        Intrinsics.checkNotNullExpressionValue((Object)cidrTestDataFixture, (String)"myTestDataFixture");
        return new OCMockProjectFixture(cidrTestDataFixture, false, false, null, 14, null);
    }

    @Override
    @NotNull
    protected CidrProjectFixture.CleanProjectOption shouldCleanProject() {
        return CidrProjectFixture.CleanProjectOption.DO_NOT_CLEAN;
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        ((OCMockProjectFixture)this.myProjectFixture).initProject("empty-project");
    }

    protected final void doSimpleProjectTest(@NotNull Function1<? super Path, ProcessedText> processedTextLambda) {
        Intrinsics.checkNotNullParameter(processedTextLambda, (String)"processedTextLambda");
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructureKt.simpleProject(), processedTextLambda, null, 4, null);
    }

    protected final void doUnicodeProjectTest(@NotNull Function1<? super Path, ProcessedText> processedTextLambda) {
        Intrinsics.checkNotNullParameter(processedTextLambda, (String)"processedTextLambda");
        CidrPathConsoleFilterTest.doTest$default(this, TestFileStructureKt.unicodeProject(), processedTextLambda, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doTest(@NotNull TestFileStructure.FileStructure testFileStructure, @NotNull Function1<? super Path, ProcessedText> processedTextLambda, @NotNull Function1<? super Path, ? extends CidrPathConsoleFilter> createConsole) {
        Intrinsics.checkNotNullParameter((Object)testFileStructure, (String)"testFileStructure");
        Intrinsics.checkNotNullParameter(processedTextLambda, (String)"processedTextLambda");
        Intrinsics.checkNotNullParameter(createConsole, (String)"createConsole");
        Path path = ((OCMockProjectFixture)this.myProjectFixture).getProjectIODir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getProjectIODir(...)");
        Path tempDir2 = path;
        try {
            ProcessedText processedText = (ProcessedText)processedTextLambda.invoke((Object)tempDir2);
            TestFileStructure.INSTANCE.withFileImitation(tempDir2, testFileStructure, (Function0<Unit>)((Function0)() -> CidrPathConsoleFilterTest.doTest$lambda$1(tempDir2, createConsole, processedText, this)));
        }
        finally {
            PathsKt.deleteRecursively((Path)tempDir2);
        }
    }

    public static /* synthetic */ void doTest$default(CidrPathConsoleFilterTest cidrPathConsoleFilterTest, TestFileStructure.FileStructure fileStructure, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTest");
        }
        if ((n & 4) != 0) {
            function12 = arg_0 -> CidrPathConsoleFilterTest.doTest$lambda$0(cidrPathConsoleFilterTest, arg_0);
        }
        cidrPathConsoleFilterTest.doTest(fileStructure, (Function1<? super Path, ProcessedText>)function1, (Function1<? super Path, ? extends CidrPathConsoleFilter>)function12);
    }

    @NotNull
    public final CidrPathConsoleFilter createSimpleConsole(@Nullable Path baseDir) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new CidrPathConsoleFilter(project, this.getCidrToolEnvironment(), baseDir);
    }

    public static /* synthetic */ CidrPathConsoleFilter createSimpleConsole$default(CidrPathConsoleFilterTest cidrPathConsoleFilterTest, Path path, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSimpleConsole");
        }
        if ((n & 1) != 0) {
            path = null;
        }
        return cidrPathConsoleFilterTest.createSimpleConsole(path);
    }

    @NotNull
    public final CidrPathConsoleFilter createResolverConsole(@Nullable Path baseDir, @NotNull Function1<? super String, ? extends Filter.ResultItem> localPathStringResolver) {
        Intrinsics.checkNotNullParameter(localPathStringResolver, (String)"localPathStringResolver");
        Project project = this.getProject();
        CidrToolEnvironment cidrToolEnvironment = this.getCidrToolEnvironment();
        return new CidrPathConsoleFilter(baseDir, localPathStringResolver, project, cidrToolEnvironment){
            final /* synthetic */ Function1<String, Filter.ResultItem> $localPathStringResolver;
            {
                this.$localPathStringResolver = $localPathStringResolver;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $super_call_param$2, $baseDir);
            }

            public Filter.ResultItem getHyperlinkByPath(PathCandidate startCandidate, PathCandidate candidateWithPosition, String localPathString) {
                Intrinsics.checkNotNullParameter((Object)startCandidate, (String)"startCandidate");
                Intrinsics.checkNotNullParameter((Object)candidateWithPosition, (String)"candidateWithPosition");
                Intrinsics.checkNotNullParameter((Object)localPathString, (String)"localPathString");
                return (Filter.ResultItem)this.$localPathStringResolver.invoke((Object)localPathString);
            }
        };
    }

    public static /* synthetic */ CidrPathConsoleFilter createResolverConsole$default(CidrPathConsoleFilterTest cidrPathConsoleFilterTest, Path path, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createResolverConsole");
        }
        if ((n & 1) != 0) {
            path = null;
        }
        return cidrPathConsoleFilterTest.createResolverConsole(path, (Function1<? super String, ? extends Filter.ResultItem>)function1);
    }

    @Nullable
    public abstract CidrToolEnvironment getCidrToolEnvironment();

    private final String getTextContext(String text2, int expectedPos, int actualPos) {
        int contextRadius = 30;
        int minPos = Math.min(expectedPos, actualPos);
        int maxPos = Math.max(expectedPos, actualPos);
        int startPos = Math.max(0, minPos - contextRadius);
        int endPos = Math.min(text2.length(), maxPos + contextRadius);
        String string = text2.substring(startPos, endPos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String contextText = string;
        int expectedMarkerPos = expectedPos - startPos;
        int actualMarkerPos = actualPos - startPos;
        StringBuilder builder = new StringBuilder();
        builder.append("Text context:\n");
        int n = ((CharSequence)contextText).length();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            if (n2 == expectedMarkerPos) {
                builder.append("<expected>");
            } else if (n2 == actualMarkerPos) {
                builder.append("<actual>");
            }
            char c = contextText.charAt(i);
            builder.append(c);
        }
        if (expectedMarkerPos == contextText.length()) {
            builder.append("<expected>");
        }
        if (actualMarkerPos == contextText.length()) {
            builder.append("<actual>");
        }
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final String systemIndependentPath(@NotNull Path $this$systemIndependentPath) {
        Intrinsics.checkNotNullParameter((Object)$this$systemIndependentPath, (String)"<this>");
        String string = FileUtilRt.toSystemIndependentName((String)((Object)$this$systemIndependentPath).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return string;
    }

    private static final ProcessedText test_simple_file$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp", null, null, null, 14, null) + "\n      -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp", null, null, null, 14, null) + "\n    ")));
    }

    private static final Unit test_simple_header$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "source.h", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_simple_header$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.h", null, null, null, 14, null) + "\n      -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.h", null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_full_path_simple_file$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("src").resolve("source.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String fullPath = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, fullPath, null, null, null, 14, null) + "\n      -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, fullPath, null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_no_file_if_there_s_no_such_file$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("-- Trying to compile file sourc.cpp\n-- Compiling file source.cp");
    }

    private static final ProcessedText test_simple_file_should_be_linked_to_correct_path$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("src").resolve("source.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String mainFilePath = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp", null, null, mainFilePath, 6, null) + "\n    ")));
    }

    private static final ProcessedText test_simple_file_should_be_linked_to_correct_line$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp:38465", 38464, null, null, 12, null) + "\n    ")));
    }

    private static final ProcessedText test_simple_file_should_be_linked_to_correct_column$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp:12345:54321", null, 54321, null, 10, null) + "\n    ")));
    }

    private static final ProcessedText test_unicode_russian_file$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\u0430\u0445\u0430\u0445\u0430 \u0441\u043e\u0440\u0435\u0446 \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c.cpp", null, null, null, 14, null) + "\n      -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\u0430\u0445\u0430\u0445\u0430 \u0441\u043e\u0440\u0435\u0446 \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c.cpp", null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_unicode_chinese_file$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\u6587\u4ef6.cpp", null, null, null, 14, null) + "\n      -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\u6587\u4ef6.cpp", null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_unicode_korean_file$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\ud30c\uc77c.cpp", null, null, null, 14, null) + "\n      -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\ud30c\uc77c.cpp", null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_unicode_greek_file$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\u03b1\u03c1\u03c7\u03b5\u03af\u03bf.cpp", null, null, null, 14, null) + "\n      -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\u03b1\u03c1\u03c7\u03b5\u03af\u03bf.cpp", null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_unicode_full_path_russian_file$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("\u0440\u0443\u0441\u0441\u043a\u0438\u0439").resolve("\u0430\u0445\u0430\u0445\u0430 \u0441\u043e\u0440\u0435\u0446 \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String fullPath = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, fullPath, null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_unicode_full_path_chinese_file$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("\u4e2d\u6587").resolve("\u6587\u4ef6.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String fullPath = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, fullPath, null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_unicode_full_path_korean_file$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("\ud55c\uad6d\uc5b4").resolve("\ud30c\uc77c.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String fullPath = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, fullPath, null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_unicode_full_path_greek_file$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac").resolve("\u03b1\u03c1\u03c7\u03b5\u03af\u03bf.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String fullPath = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, fullPath, null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_windows_backslash_paths$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("src").resolve("source.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String windowsPath = StringsKt.replace$default((String)this$0.systemIndependentPath(path), (String)"/", (String)"\\", (boolean)false, (int)4, null);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, windowsPath, null, null, null, 14, null) + "\n        -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, windowsPath, null, null, null, 14, null) + "\n      ")));
    }

    private static final ProcessedText test_mixed_slash_paths$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("src").resolve("source.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String mixedPath = StringsKt.replace$default((String)this$0.systemIndependentPath(path), (String)"/src/", (String)"\\src/", (boolean)false, (int)4, null);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, mixedPath, null, null, null, 14, null) + "\n      ")));
    }

    private static final ProcessedText test_relative_path$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{"src", "source.cpp"};
        Path path = Path.of(".", stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        String relativePath = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, relativePath, null, null, null, 14, null) + "\n    ");
    }

    private static final ProcessedText test_relative_path_shouldn_t_be_found_with_point$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{"source.cpp"};
        Path path = Path.of(".", stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        String relativePath = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + relativePath + "\n    ")));
    }

    private static final ProcessedText test_space_before_colons$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp :12345", 12344, null, null, 12, null) + "\n    ");
    }

    private static final ProcessedText test_spaces_before_colons$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp     :12345", 12344, null, null, 12, null) + "\n    ");
    }

    private static final ProcessedText test_whitespaces_before_colons$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp\t:12345:54321", 12344, 54321, null, 8, null) + "\n    ");
    }

    private static final ProcessedText test_whitespaces_simple_file_position$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp:12345:54321", 12344, 54321, null, 8, null) + "\n    ");
    }

    private static final ProcessedText test_whitespaces_msvc_file_position$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp(12345,54321)", 12344, 54321, null, 8, null) + "\n    ");
    }

    private static final ProcessedText test_whitespaces_msvc_file_position_with_only_line$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp(12345)", 12344, null, null, 12, null) + "\n    ");
    }

    private static final ProcessedText test_whitespaces_msvc_file_position_with_space$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp (12345)", 12344, null, null, 12, null) + "\n    ");
    }

    private static final Unit test_with_msvc_file_position_inside_filename$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "source(12,12).cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_with_msvc_file_position_inside_filename$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source(12,12).cpp", null, null, null, 14, null) + "\n      ")));
    }

    private static final Unit test_with_msvc_file_position_inside_filename_and_line_and_column$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "source(12,12).cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_with_msvc_file_position_inside_filename_and_line_and_column$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source(12,12).cpp(4,4)", 3, 4, null, 8, null) + "\n      ")));
    }

    private static final Unit test_with_msvc_half_file_position_inside_filename_and_line_and_column$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "Untitled (1).cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_with_msvc_half_file_position_inside_filename_and_line_and_column$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "Untitled (1).cpp(4,4)", 3, 4, null, 8, null) + "\n      ")));
    }

    private static final Unit test_just_text_is_not_matching$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "main", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_just_text_is_not_matching$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("main main main main hehe main.cpp");
    }

    private static final Unit test_just_text_is_not_matching_but_priority_is_0$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "main", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_just_text_is_not_matching_but_priority_is_0$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n          " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "main", null, null, null, 14, null) + " " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "main", null, null, null, 14, null) + " " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "main", null, null, null, 14, null) + " hehe main.cpp\n        ")));
    }

    private static final Unit test_just_text_with_file_position_is_matching$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "main", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_just_text_with_file_position_is_matching$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        main main main " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "main(12,13)", 11, 13, null, 8, null) + " hehe main.cpp\n      ")));
    }

    private static final Unit test_additional_extensions_matching$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "runner.dll", null, 2, null);
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "runner.exe", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_additional_extensions_matching$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Trying to execute file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "runner.dll", null, null, null, 14, null) + "\n        -- Trying to execute file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "runner.exe", null, null, null, 14, null) + "\n      ")));
    }

    private static final Unit test_path_with_a_lot_of_spaces$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        $this$fileImitation.directory("a b c d e f g h i j k l m n o p q r s t u v w x y z", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_a_lot_of_spaces$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit test_path_with_a_lot_of_spaces$lambda$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "a b c d e f g h i j k l m n o p q r s t u v w x y z.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_path_with_a_lot_of_spaces$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("\n        -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "a b c d e f g h i j k l m n o p q r s t u v w x y z/a b c d e f g h i j k l m n o p q r s t u v w x y z.cpp", null, null, null, 14, null) + "\n      ");
    }

    private static final Unit test_path_with_multiple_matches_at_once$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "main.cpp", null, 2, null);
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "source.cpp", null, 2, null);
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "code.cpp", null, 2, null);
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "bunch of functions.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_path_with_multiple_matches_at_once$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        I am trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "main.cpp", null, null, null, 14, null) + " but I need files\n        " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp", null, null, null, 14, null) + " and " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "code.cpp", null, null, null, 14, null) + " and " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "bunch of functions.cpp", null, null, null, 14, null) + "\n        for this. Of course, it is just bunch of functions (not .cpp, it will create match for console), but I need them all. " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "main.cpp", null, null, null, 14, null) + "\n        " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp", null, null, null, 14, null) + " and " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "code.cpp", null, null, null, 14, null) + " and " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "bunch of functions.cpp", null, null, null, 14, null) + "\n      ")));
    }

    private static final ProcessedText test_path_inside_quotes$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\"source.cpp\"", null, null, null, 14, null) + "\n    ")));
    }

    private static final ProcessedText test_path_with_punctuation___exclamation$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp", null, null, null, 14, null) + "!!!\n    ");
    }

    private static final ProcessedText test_path_with_punctuation___point$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("\n      -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "source.cpp", null, null, null, 14, null) + ".\n    ");
    }

    private static final Unit test_find_correct_file_with_two_candidates$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        $this$fileImitation.directory("a", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_find_correct_file_with_two_candidates$lambda$0$0));
        $this$fileImitation.directory("b", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_find_correct_file_with_two_candidates$lambda$0$1));
        return Unit.INSTANCE;
    }

    private static final Unit test_find_correct_file_with_two_candidates$lambda$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit test_find_correct_file_with_two_candidates$lambda$0$1(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_find_correct_file_with_two_candidates$lambda$1(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("a").resolve("main.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String aFilePath = this$0.systemIndependentPath(path);
        Path path2 = it.resolve("b").resolve("main.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        String bFilePath = this$0.systemIndependentPath(path2);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "a/main.cpp", null, null, aFilePath, 6, null) + "\n        -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "b/main.cpp", null, null, bFilePath, 6, null) + "\n      ")));
    }

    private static final Unit test_home_path_should_be_resolved_correctly$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        $this$fileImitation.directory("a-9047654095764095475", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_home_path_should_be_resolved_correctly$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit test_home_path_should_be_resolved_correctly$lambda$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit test_home_path_should_be_resolved_correctly$lambda$1(CidrPathConsoleFilterTest this$0, Path $nearHomePath) {
        CidrPathConsoleFilterTest.doTest$default(this$0, TestFileStructure.INSTANCE.fileImitation((Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_home_path_should_be_resolved_correctly$lambda$1$0)), arg_0 -> CidrPathConsoleFilterTest.test_home_path_should_be_resolved_correctly$lambda$1$1(this$0, $nearHomePath, arg_0), null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit test_home_path_should_be_resolved_correctly$lambda$1$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_home_path_should_be_resolved_correctly$lambda$1$1(CidrPathConsoleFilterTest this$0, Path $nearHomePath, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = $nearHomePath.resolve("a-9047654095764095475").resolve("main.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String filePath = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n           -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "~/temporary-directory-a-03485764085/a-9047654095764095475/main.cpp", null, null, filePath, 6, null) + "\n         ")));
    }

    private static final Unit test_emoji_in_name$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        $this$fileImitation.directory("\ud83d\udcc1folder", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_emoji_in_name$lambda$0$0));
        $this$fileImitation.directory("\ud83d\ude80project", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_emoji_in_name$lambda$0$1));
        TestFileStructure.DirectoryBuilder.file$default($this$fileImitation, "\ud83c\udfaftarget.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit test_emoji_in_name$lambda$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "\ud83d\udd25source.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit test_emoji_in_name$lambda$0$1(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "\u2b50main.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_emoji_in_name$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Trying to compile file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\ud83d\udcc1folder/\ud83d\udd25source.cpp", null, null, null, 14, null) + "\n        -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\ud83d\ude80project/\u2b50main.cpp", null, null, null, 14, null) + "\n        -- Building file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "\ud83c\udfaftarget.cpp", null, null, null, 14, null) + "\n      ")));
    }

    private static final Unit test_guess_simple_file$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        $this$fileImitation.directory("src", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_guess_simple_file$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit test_guess_simple_file$lambda$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_guess_simple_file$lambda$1(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("src").resolve("main.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "main.cpp", null, null, this$0.systemIndependentPath(path), 6, null) + "\n      ")));
    }

    private static final Unit test_guess_simple_file_with_part_of_console$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        $this$fileImitation.directory("src", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_guess_simple_file_with_part_of_console$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit test_guess_simple_file_with_part_of_console$lambda$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        $this$directory.directory("impl1", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_guess_simple_file_with_part_of_console$lambda$0$0$0));
        $this$directory.directory("impl2", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_guess_simple_file_with_part_of_console$lambda$0$0$1));
        return Unit.INSTANCE;
    }

    private static final Unit test_guess_simple_file_with_part_of_console$lambda$0$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit test_guess_simple_file_with_part_of_console$lambda$0$0$1(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_guess_simple_file_with_part_of_console$lambda$1(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("src").resolve("impl1").resolve("main.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "impl1/main.cpp", null, null, this$0.systemIndependentPath(path), 6, null) + "\n      ")));
    }

    private static final Unit test_not_guess_file_with_two_candidates$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        $this$fileImitation.directory("src", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_not_guess_file_with_two_candidates$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit test_not_guess_file_with_two_candidates$lambda$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        $this$directory.directory("impl1", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_not_guess_file_with_two_candidates$lambda$0$0$0));
        $this$directory.directory("impl2", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_not_guess_file_with_two_candidates$lambda$0$0$1));
        return Unit.INSTANCE;
    }

    private static final Unit test_not_guess_file_with_two_candidates$lambda$0$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit test_not_guess_file_with_two_candidates$lambda$0$0$1(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_not_guess_file_with_two_candidates$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("-- Compiling file main.cpp");
    }

    private static final ProcessedText test_linux_case_insensitivity_by_path$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("src").resolve("Source.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String path2 = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Compiling file " + path2 + "\n      ")));
    }

    private static final ProcessedText test_linux_case_insensitivity_by_file_name$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("-- Compiling file Source.cpp");
    }

    private static final ProcessedText test_windows_case_sensitivity_by_path$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("src").resolve("Source.cpp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String path2 = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, path2, null, null, null, 14, null) + "\n      ")));
    }

    private static final ProcessedText test_windows_case_sensitivity_by_file_name$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "Source.cpp", null, null, null, 14, null) + "\n      ")));
    }

    private static final ProcessedText test_bunch_of_words_should_not_even_be_tried_to_resolve$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build("bunch of funny words without meaning");
    }

    private static final CidrPathConsoleFilter test_bunch_of_words_should_not_even_be_tried_to_resolve$lambda$1(CidrPathConsoleFilterTest this$0, List $words, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createResolverConsole(it, (Function1<? super String, ? extends Filter.ResultItem>)((Function1)arg_0 -> CidrPathConsoleFilterTest.test_bunch_of_words_should_not_even_be_tried_to_resolve$lambda$1$0($words, arg_0)));
    }

    private static final Filter.ResultItem test_bunch_of_words_should_not_even_be_tried_to_resolve$lambda$1$0(List $words, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $words.add(it);
        return null;
    }

    private static final ProcessedText test_relative_path_with_point$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n      -- Compiling file " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, "./src/source.cpp", null, null, null, 14, null) + "\n    ")));
    }

    private static final Unit test_path_with_token_separator$lambda$0(TestFileStructure.DirectoryBuilder $this$fileImitation) {
        Intrinsics.checkNotNullParameter((Object)$this$fileImitation, (String)"$this$fileImitation");
        $this$fileImitation.directory("username", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_token_separator$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit test_path_with_token_separator$lambda$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        $this$directory.directory("Projects", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_token_separator$lambda$0$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit test_path_with_token_separator$lambda$0$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        $this$directory.directory("C++", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_token_separator$lambda$0$0$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit test_path_with_token_separator$lambda$0$0$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        $this$directory.directory("university", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_token_separator$lambda$0$0$0$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit test_path_with_token_separator$lambda$0$0$0$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        $this$directory.directory("SimpleProject", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_token_separator$lambda$0$0$0$0$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit test_path_with_token_separator$lambda$0$0$0$0$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        $this$directory.directory("outputDir", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_token_separator$lambda$0$0$0$0$0$0$0));
        $this$directory.directory("src", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_token_separator$lambda$0$0$0$0$0$0$1));
        return Unit.INSTANCE;
    }

    private static final Unit test_path_with_token_separator$lambda$0$0$0$0$0$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        $this$directory.directory("build", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_token_separator$lambda$0$0$0$0$0$0$0$0));
        $this$directory.directory("build (1)", (Function1<? super TestFileStructure.DirectoryBuilder, Unit>)((Function1)CidrPathConsoleFilterTest::test_path_with_token_separator$lambda$0$0$0$0$0$0$0$1));
        return Unit.INSTANCE;
    }

    private static final Unit test_path_with_token_separator$lambda$0$0$0$0$0$0$0$0(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.outputExtension", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit test_path_with_token_separator$lambda$0$0$0$0$0$0$0$1(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.outputExtension", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit test_path_with_token_separator$lambda$0$0$0$0$0$0$1(TestFileStructure.DirectoryBuilder $this$directory) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        TestFileStructure.DirectoryBuilder.file$default($this$directory, "main.cpp", null, 2, null);
        return Unit.INSTANCE;
    }

    private static final ProcessedText test_path_with_token_separator$lambda$1(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.resolve("username").resolve("Projects").resolve("C++").resolve("university").resolve("SimpleProject").resolve("outputDir").resolve("build (1)").resolve("main.outputExtension");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String absolute = this$0.systemIndependentPath(path);
        return ConsoleFilterTestBuilder.Companion.build(StringsKt.trimIndent((String)("\n        -- Trying to compile file... result: " + ConsoleFilterTestBuilder.Companion.createMarker$default(ConsoleFilterTestBuilder.Companion, absolute, null, null, null, 14, null) + "\n      ")));
    }

    private static final CidrPathConsoleFilter doTest$lambda$0(CidrPathConsoleFilterTest this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createSimpleConsole(it);
    }

    private static final Unit doTest$lambda$1(Path $tempDir, Function1 $createConsole, ProcessedText $processedText, CidrPathConsoleFilterTest this$0) {
        int n;
        Function1[] filterResult;
        LocalFileSystem.getInstance().refreshNioFiles((Iterable)CollectionsKt.listOf((Object)$tempDir), false, true, null);
        CidrPathConsoleFilter consoleFilter = (CidrPathConsoleFilter)$createConsole.invoke((Object)$tempDir);
        List lines2 = StringsKt.lines((CharSequence)$processedText.getText());
        List allFilterResults = new ArrayList();
        int currentPosition = 0;
        int currentLineNumber = 0;
        currentLineNumber = 1;
        for (String line : lines2) {
            int entireLength;
            filterResult = consoleFilter.applyFilter(line, entireLength = currentPosition + line.length());
            if (filterResult != null) {
                Function1[] result = filterResult;
                boolean bl = false;
                List list = result.getResultItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResultItems(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Filter.ResultItem resultItem = (Filter.ResultItem)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)resultItem);
                    allFilterResults.add(new FilterResultWithLine(resultItem, currentLineNumber));
                }
            }
            currentPosition += line.length() + 1;
            n = currentLineNumber;
            currentLineNumber = n + 1;
        }
        List<TextMarker> expectedMarkers = $processedText.getMarkers();
        Assertions.assertEquals((int)expectedMarkers.size(), (int)allFilterResults.size(), (String)("Number of filter results (" + allFilterResults.size() + ") does not match number of expected markers (" + expectedMarkers.size() + ")"));
        Function1[] entireLength = new Function1[]{CidrPathConsoleFilterTest::doTest$lambda$1$1, CidrPathConsoleFilterTest::doTest$lambda$1$2};
        List sortedMarkers = CollectionsKt.sortedWith((Iterable)expectedMarkers, (Comparator)ComparisonsKt.compareBy((Function1[])entireLength));
        filterResult = new Function1[]{CidrPathConsoleFilterTest::doTest$lambda$1$3, CidrPathConsoleFilterTest::doTest$lambda$1$4};
        List sortedResults = CollectionsKt.sortedWith((Iterable)allFilterResults, (Comparator)ComparisonsKt.compareBy((Function1[])filterResult));
        n = ((Collection)sortedMarkers).size();
        for (int i = 0; i < n; ++i) {
            String context2;
            TextMarker marker = (TextMarker)sortedMarkers.get(i);
            FilterResultWithLine result = (FilterResultWithLine)sortedResults.get(i);
            int resultLineNumber = result.getLineNumber();
            Assertions.assertEquals((int)marker.getLineNumber(), (int)resultLineNumber, (String)("Line number mismatch for marker " + i + ": expected " + marker.getLineNumber() + ", got " + resultLineNumber + "\nText context:\n" + this$0.getTextContext($processedText.getText(), marker.getStartPosition(), result.getResult().getHighlightStartOffset())));
            if (marker.getStartPosition() != result.getResult().getHighlightStartOffset()) {
                context2 = this$0.getTextContext($processedText.getText(), marker.getStartPosition(), result.getResult().getHighlightStartOffset());
                Assertions.assertEquals((int)marker.getStartPosition(), (int)result.getResult().getHighlightStartOffset(), (String)("Start position mismatch for marker " + i + ": expected " + marker.getStartPosition() + ", got " + result.getResult().getHighlightStartOffset() + "\n" + context2));
            }
            if (marker.getEndPosition() != result.getResult().getHighlightEndOffset()) {
                context2 = this$0.getTextContext($processedText.getText(), marker.getEndPosition(), result.getResult().getHighlightEndOffset());
                Assertions.assertEquals((int)marker.getEndPosition(), (int)result.getResult().getHighlightEndOffset(), (String)("End position mismatch for marker " + i + ": expected " + marker.getEndPosition() + ", got " + result.getResult().getHighlightEndOffset() + "\n" + context2));
            }
            HyperlinkInfo hyperlinkInfo = result.getResult().getHyperlinkInfo();
            CidrTestCase.assertNotNull((String)("Hyperlink for marker " + i + " is null, but shouldn't"), (Object)hyperlinkInfo);
            if (!(hyperlinkInfo instanceof OpenFileHyperlinkInfo)) continue;
            MarkerData goldData = marker.getData();
            if (goldData.getFilePath() != null) {
                VirtualFile virtualFile = ((OpenFileHyperlinkInfo)hyperlinkInfo).getVirtualFile();
                CidrTestCase.assertEquals((String)("Hyperlink for marker " + i + " contains wrong file data"), (String)goldData.getFilePath(), (String)(virtualFile != null ? virtualFile.getPath() : null));
            }
            if (goldData.getLine() != null) {
                OpenFileDescriptor openFileDescriptor = ((OpenFileHyperlinkInfo)hyperlinkInfo).getDescriptor();
                CidrTestCase.assertEquals((String)("Hyperlink for marker " + i + " contains wrong line data"), (Object)goldData.getLine(), (Object)(openFileDescriptor != null ? Integer.valueOf(openFileDescriptor.getLine()) : null));
            }
            if (goldData.getColumn() == null) continue;
            OpenFileDescriptor openFileDescriptor = ((OpenFileHyperlinkInfo)hyperlinkInfo).getDescriptor();
            CidrTestCase.assertEquals((String)("Hyperlink for marker " + i + " contains wrong column data"), (Object)goldData.getColumn(), (Object)(openFileDescriptor != null ? Integer.valueOf(openFileDescriptor.getColumn()) : null));
        }
        return Unit.INSTANCE;
    }

    private static final Comparable doTest$lambda$1$1(TextMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getLineNumber());
    }

    private static final Comparable doTest$lambda$1$2(TextMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getStartPosition());
    }

    private static final Comparable doTest$lambda$1$3(FilterResultWithLine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getLineNumber());
    }

    private static final Comparable doTest$lambda$1$4(FilterResultWithLine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getResult().getHighlightStartOffset());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilterTest$FilterResultWithLine;", "", "result", "Lcom/intellij/execution/filters/Filter$ResultItem;", "lineNumber", "", "<init>", "(Lcom/intellij/execution/filters/Filter$ResultItem;I)V", "getResult", "()Lcom/intellij/execution/filters/Filter$ResultItem;", "getLineNumber", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.common.testFramework.core"})
    private static final class FilterResultWithLine {
        @NotNull
        private final Filter.ResultItem result;
        private final int lineNumber;

        public FilterResultWithLine(@NotNull Filter.ResultItem result, int lineNumber) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.result = result;
            this.lineNumber = lineNumber;
        }

        @NotNull
        public final Filter.ResultItem getResult() {
            return this.result;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        @NotNull
        public final Filter.ResultItem component1() {
            return this.result;
        }

        public final int component2() {
            return this.lineNumber;
        }

        @NotNull
        public final FilterResultWithLine copy(@NotNull Filter.ResultItem result, int lineNumber) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            return new FilterResultWithLine(result, lineNumber);
        }

        public static /* synthetic */ FilterResultWithLine copy$default(FilterResultWithLine filterResultWithLine, Filter.ResultItem resultItem, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                resultItem = filterResultWithLine.result;
            }
            if ((n2 & 2) != 0) {
                n = filterResultWithLine.lineNumber;
            }
            return filterResultWithLine.copy(resultItem, n);
        }

        @NotNull
        public String toString() {
            return "FilterResultWithLine(result=" + this.result + ", lineNumber=" + this.lineNumber + ")";
        }

        public int hashCode() {
            int result = this.result.hashCode();
            result = result * 31 + Integer.hashCode(this.lineNumber);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FilterResultWithLine)) {
                return false;
            }
            FilterResultWithLine filterResultWithLine = (FilterResultWithLine)other;
            if (!Intrinsics.areEqual((Object)this.result, (Object)filterResultWithLine.result)) {
                return false;
            }
            return this.lineNumber == filterResultWithLine.lineNumber;
        }
    }
}

