/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.msvc;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Version;
import com.jetbrains.cidr.cpp.CPPTestUtil;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSBuildVersionCache;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSVCToolchain;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000b\u001a\u00020\f\"\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"getTestMSBuildVersion", "Lcom/intellij/openapi/util/Version;", "VS_BASE_PATHS", "", "", "getVS_BASE_PATHS", "()Ljava/util/List;", "WINDOWS_KIT_BASE_PATHS", "getWINDOWS_KIT_BASE_PATHS", "findMSVCToolchain", "Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSVCToolchain;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "findWindowsKitDirectory", "Ljava/nio/file/Path;", "windowsKitBasePaths", "intellij.clion.testFramework.nolang"})
@SourceDebugExtension(value={"SMAP\nMSVCUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MSVCUtils.kt\ncom/jetbrains/cidr/cpp/toolchains/msvc/MSVCUtilsKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,97:1\n42#2,3:98\n*S KotlinDebug\n*F\n+ 1 MSVCUtils.kt\ncom/jetbrains/cidr/cpp/toolchains/msvc/MSVCUtilsKt\n*L\n21#1:98,3\n*E\n"})
public final class MSVCUtilsKt {
    @NotNull
    private static final List<String> VS_BASE_PATHS;
    @NotNull
    private static final List<String> WINDOWS_KIT_BASE_PATHS;

    @Nullable
    public static final Version getTestMSBuildVersion() {
        MSVC mSVC = CPPTestUtil.Companion.getTestMSVC();
        Intrinsics.checkNotNull((Object)mSVC);
        MSVC testMsvc = new MSVC(mSVC.getHome());
        testMsvc.setUseVcVars(true);
        GeneralCommandLine emptyCommandLine = new GeneralCommandLine();
        testMsvc.prepareEnvironment(emptyCommandLine, CidrToolEnvironment.PrepareFor.BUILD, CollectionsKt.emptyList());
        Object v = emptyCommandLine.getEnvironment().get("PATH");
        Intrinsics.checkNotNull(v);
        String msvcPath = (String)v;
        boolean $i$f$service = false;
        Class<MSBuildVersionCache> serviceClass$iv = MSBuildVersionCache.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Version version = ((MSBuildVersionCache)object).getMSBuildVersion(msvcPath);
        return version;
    }

    @NotNull
    public static final List<String> getVS_BASE_PATHS() {
        return VS_BASE_PATHS;
    }

    @NotNull
    public static final List<String> getWINDOWS_KIT_BASE_PATHS() {
        return WINDOWS_KIT_BASE_PATHS;
    }

    @NotNull
    public static final MSVCToolchain findMSVCToolchain(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        for (String vsBasePath : VS_BASE_PATHS) {
            Path vsBaseDir = Path.of(vsBasePath, new String[0]);
            if (!Files.exists(vsBaseDir, new LinkOption[0])) continue;
            try {
                Path msvcToolsPath = vsBaseDir.resolve("VC/Tools/MSVC");
                if (!Files.exists(msvcToolsPath, new LinkOption[0])) continue;
                List<Object> versionDirs = Files.list(msvcToolsPath).filter(arg_0 -> MSVCUtilsKt.findMSVCToolchain$lambda$1(MSVCUtilsKt::findMSVCToolchain$lambda$0, arg_0)).sorted(Comparator.reverseOrder()).toList();
                for (Path path : versionDirs) {
                    Path windowsKitDir;
                    if (!Files.exists(path, new LinkOption[0]) || (windowsKitDir = MSVCUtilsKt.findWindowsKitDirectory(WINDOWS_KIT_BASE_PATHS, logger)) == null) continue;
                    Intrinsics.checkNotNull((Object)path);
                    Intrinsics.checkNotNull((Object)vsBaseDir);
                    return new MSVCToolchain(path, windowsKitDir, vsBaseDir);
                }
            }
            catch (Exception e) {
                logger.info("Failed to find MSVC toolchain in " + vsBasePath + ". Will try next path.", (Throwable)e);
            }
        }
        throw new IllegalStateException("Could not find MSVC toolchain");
    }

    @Nullable
    public static final Path findWindowsKitDirectory(@NotNull List<String> windowsKitBasePaths, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(windowsKitBasePaths, (String)"windowsKitBasePaths");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        for (String basePath : windowsKitBasePaths) {
            Path baseDir = Path.of(basePath, new String[0]);
            if (!Files.exists(baseDir, new LinkOption[0])) continue;
            try {
                List<Object> versionDirs = Files.list(baseDir).filter(arg_0 -> MSVCUtilsKt.findWindowsKitDirectory$lambda$1(MSVCUtilsKt::findWindowsKitDirectory$lambda$0, arg_0)).filter(arg_0 -> MSVCUtilsKt.findWindowsKitDirectory$lambda$3(MSVCUtilsKt::findWindowsKitDirectory$lambda$2, arg_0)).sorted(Comparator.reverseOrder()).toList();
                for (Path path : versionDirs) {
                    Path ucrtDir = path.resolve("ucrt");
                    Path sharedDir = path.resolve("shared");
                    Path umDir = path.resolve("um");
                    if (!Files.exists(ucrtDir, new LinkOption[0]) || !Files.exists(sharedDir, new LinkOption[0]) || !Files.exists(umDir, new LinkOption[0])) continue;
                    return path;
                }
            }
            catch (Exception e) {
                logger.info("Failed to find Windows Kit in " + basePath + ". Will try next path.", (Throwable)e);
            }
        }
        return null;
    }

    private static final boolean findMSVCToolchain$lambda$0(Path it) {
        return Files.isDirectory(it, new LinkOption[0]);
    }

    private static final boolean findMSVCToolchain$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findWindowsKitDirectory$lambda$0(Path it) {
        return Files.isDirectory(it, new LinkOption[0]);
    }

    private static final boolean findWindowsKitDirectory$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findWindowsKitDirectory$lambda$2(Path it) {
        return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)"10.0.", (boolean)false, (int)2, null);
    }

    private static final boolean findWindowsKitDirectory$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"C:/Program Files/Microsoft Visual Studio/2022/Community", "C:/Program Files/Microsoft Visual Studio/2022/Professional", "C:/Program Files/Microsoft Visual Studio/2022/Enterprise", "C:/Program Files (x86)/Microsoft Visual Studio/2019/Community", "C:/Program Files (x86)/Microsoft Visual Studio/2019/Professional", "C:/Program Files (x86)/Microsoft Visual Studio/2019/Enterprise"};
        VS_BASE_PATHS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"C:/Program Files (x86)/Windows Kits/10/Include", "C:/Program Files/Windows Kits/10/Include"};
        WINDOWS_KIT_BASE_PATHS = CollectionsKt.listOf((Object[])objectArray);
    }
}

