/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.junit.rules;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.cidr.cpp.junit.api.CPPDisposableHolder;
import com.jetbrains.cidr.cpp.junit.rules.ExternalResourceEx;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.runner.Description;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\rH\u0014R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/junit/rules/CPPDisposableHoldingRule;", "Lcom/jetbrains/cidr/cpp/junit/rules/ExternalResourceEx;", "Lcom/jetbrains/cidr/cpp/junit/api/CPPDisposableHolder;", "<init>", "()V", "value", "Lcom/intellij/openapi/Disposable;", "rootDisposable", "getRootDisposable", "()Lcom/intellij/openapi/Disposable;", "setUpCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "before", "", "description", "Lorg/junit/runner/Description;", "after", "intellij.clion.testFramework.nolang"})
public final class CPPDisposableHoldingRule
extends ExternalResourceEx
implements CPPDisposableHolder {
    private volatile Disposable rootDisposable;
    @NotNull
    private final AtomicInteger setUpCount = new AtomicInteger();

    @Override
    @NotNull
    public Disposable getRootDisposable() {
        Disposable disposable = this.rootDisposable;
        if (disposable != null) {
            return disposable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rootDisposable");
        return null;
    }

    @Override
    protected void before(@NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        if (this.setUpCount.getAndIncrement() == 0) {
            Disposable disposable = Disposer.newDisposable((String)description.getDisplayName());
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            this.rootDisposable = disposable;
        }
    }

    @Override
    protected void after() {
        if (this.setUpCount.decrementAndGet() == 0) {
            Disposer.dispose((Disposable)this.getRootDisposable());
        }
    }
}

