/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.presets.FilePresetContent;
import com.jetbrains.cidr.cpp.cmake.presets.PresetContent;
import com.jetbrains.cidr.cpp.cmake.presets.Schema;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSetWithHome;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.cpp.toolchains.MinGW;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSVCArch;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.system.HostMachine;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AssertionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/cpp/CPPTestUtil;", "", "<init>", "()V", "Companion", "intellij.clion.testFramework.nolang"})
@SourceDebugExtension(value={"SMAP\nCPPTestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPPTestUtil.kt\ncom/jetbrains/cidr/cpp/CPPTestUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,512:1\n13#2:513\n*S KotlinDebug\n*F\n+ 1 CPPTestUtil.kt\ncom/jetbrains/cidr/cpp/CPPTestUtil\n*L\n40#1:513\n*E\n"})
public final class CPPTestUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Set<String> MSVC_ARCH_VALUE_X64;
    @NotNull
    private static final Set<String> MSVC_ARCH_VALUES_X86;

    @JvmStatic
    @NotNull
    public static final CPPEnvironment getTestCPPEnvironment() {
        return Companion.getTestCPPEnvironment();
    }

    @JvmStatic
    @NotNull
    public static final CPPToolchains.Toolchain getTestToolchain() {
        return Companion.getTestToolchain();
    }

    @JvmStatic
    @NotNull
    public static final CPPToolSet getTestToolSet() {
        return Companion.getTestToolSet();
    }

    @JvmStatic
    @Nullable
    public static final MinGW getTestMinGW() {
        return Companion.getTestMinGW();
    }

    @JvmStatic
    @Nullable
    public static final Cygwin getTestCygwin() {
        return Companion.getTestCygwin();
    }

    @JvmStatic
    @Nullable
    public static final WSL getTestWSL() {
        return Companion.getTestWSL();
    }

    @JvmStatic
    @Nullable
    public static final MSVC getTestMSVC() {
        return Companion.getTestMSVC();
    }

    @JvmStatic
    public static final void changeTestToolchain(@NotNull Consumer<CPPToolchains.Toolchain> changeFunction) {
        Companion.changeTestToolchain(changeFunction);
    }

    @JvmStatic
    public static final void changeToolchains(@NotNull Consumer<CPPToolchains> changeFunction) {
        Companion.changeToolchains(changeFunction);
    }

    @JvmStatic
    public static final void changeToolchains(@NotNull CPPToolchains toolchains, @NotNull Consumer<CPPToolchains> changeFunction) {
        Companion.changeToolchains(toolchains, changeFunction);
    }

    @JvmStatic
    @NotNull
    public static final ArchitectureType getTestMSVCTargetArch() {
        return Companion.getTestMSVCTargetArch();
    }

    @JvmStatic
    @Nullable
    public static final ArchitectureType getTestMinGWArchitecture() {
        return Companion.getTestMinGWArchitecture();
    }

    @JvmStatic
    @NotNull
    public static final String getTestCMakeVersion() {
        return Companion.getTestCMakeVersion();
    }

    @JvmStatic
    @NotNull
    public static final Version getTestCMakeParsedVersion() {
        return Companion.getTestCMakeParsedVersion();
    }

    @JvmStatic
    @NotNull
    public static final ToolVersion getTestCMakeParsedToolVersion() {
        return Companion.getTestCMakeParsedToolVersion();
    }

    @JvmStatic
    @NotNull
    public static final List<String> getCMakeOutput(String ... cmakeOptions) {
        return Companion.getCMakeOutput(cmakeOptions);
    }

    @JvmStatic
    @Nullable
    public static final File getTestGCC() {
        return Companion.getTestGCC();
    }

    @JvmStatic
    @Nullable
    public static final File getTestClang() {
        return Companion.getTestClang();
    }

    @JvmStatic
    @Nullable
    public static final File getTestClangCl() {
        return Companion.getTestClangCl();
    }

    @JvmStatic
    @Nullable
    public static final File getTestMSVCCompiler() {
        return Companion.getTestMSVCCompiler();
    }

    @JvmStatic
    @NotNull
    public static final List<Pair<OCCompilerKind, File>> getAvailableCompilers() {
        return Companion.getAvailableCompilers();
    }

    @JvmStatic
    public static final boolean isUnixLikeEnvironment() {
        return Companion.isUnixLikeEnvironment();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CPPTestUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"x64", "amd64", "x86_amd64"};
        MSVC_ARCH_VALUE_X64 = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"x86", "amd64_x86"};
        MSVC_ARCH_VALUES_X86 = SetsKt.setOf((Object[])objectArray);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004RSTUB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0007J\u0016\u0010\u001c\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0007J\u001e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0007J\b\u0010\u001f\u001a\u0004\u0018\u00010\bJ\b\u0010 \u001a\u00020!H\u0007J\n\u0010\"\u001a\u0004\u0018\u00010!H\u0007J\b\u0010#\u001a\u00020\bH\u0007J\b\u0010$\u001a\u00020%H\u0007J\b\u0010&\u001a\u00020'H\u0007J'\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0)2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0+\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010,J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\bH\u0002J\u0012\u00100\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u000202H\u0002J\u001a\u00103\u001a\u00020\u00192\b\u00104\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u000202H\u0002J\n\u00105\u001a\u0004\u0018\u00010.H\u0007J\u0012\u00106\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u000207H\u0002J\u001a\u00108\u001a\u00020\u00192\b\u00104\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u000207H\u0002J\n\u00109\u001a\u0004\u0018\u00010.H\u0007J\n\u0010:\u001a\u0004\u0018\u00010.H\u0007J\b\u0010;\u001a\u0004\u0018\u00010.J\n\u0010<\u001a\u0004\u0018\u00010.H\u0007J\u001a\u0010=\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020.0>0)H\u0007J*\u0010@\u001a\u0004\u0018\u0001HA\"\u0010\b\u0000\u0010A\u0018\u0001*\b\u0012\u0004\u0012\u0002HA0B2\u0006\u0010C\u001a\u0002HAH\u0082\b\u00a2\u0006\u0002\u0010DJ\b\u0010E\u001a\u00020FH\u0007J\"\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\b2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010\bJ\"\u0010M\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\b2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010\bJ\r\u0010N\u001a\u00020O\u00a2\u0006\u0004\bP\u0010QR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/jetbrains/cidr/cpp/CPPTestUtil$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MSVC_ARCH_VALUE_X64", "", "", "MSVC_ARCH_VALUES_X86", "getTestCPPEnvironment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "getTestToolchain", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "getTestToolSet", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet;", "getTestMinGW", "Lcom/jetbrains/cidr/cpp/toolchains/MinGW;", "getTestCygwin", "Lcom/jetbrains/cidr/cpp/toolchains/Cygwin;", "getTestWSL", "Lcom/jetbrains/cidr/cpp/toolchains/WSL;", "getTestMSVC", "Lcom/jetbrains/cidr/cpp/toolchains/MSVC;", "changeTestToolchain", "", "changeFunction", "Lcom/intellij/util/Consumer;", "changeToolchains", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains;", "toolchains", "getTestMSVCArchString", "getTestMSVCTargetArch", "Lcom/jetbrains/cidr/ArchitectureType;", "getTestMinGWArchitecture", "getTestCMakeVersion", "getTestCMakeParsedVersion", "Lcom/intellij/openapi/util/Version;", "getTestCMakeParsedToolVersion", "Lcom/jetbrains/cidr/ToolVersion;", "getCMakeOutput", "", "cmakeOptions", "", "([Ljava/lang/String;)Ljava/util/List;", "getCustomCompiler", "Ljava/io/File;", "compiler", "getGCC", "version", "Lcom/jetbrains/cidr/cpp/CPPTestUtil$Companion$GCCVersion;", "reportNoGCC", "file", "getTestGCC", "getClang", "Lcom/jetbrains/cidr/cpp/CPPTestUtil$Companion$ClangVersion;", "reportNoClang", "getTestClang", "getTestClangCl", "getTestNVCC", "getTestMSVCCompiler", "getAvailableCompilers", "Lcom/intellij/openapi/util/Pair;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "customizeForLocalRun", "E", "", "defaultValue", "(Ljava/lang/Enum;)Ljava/lang/Enum;", "isUnixLikeEnvironment", "", "parseCMakePresets", "Lcom/jetbrains/cidr/cpp/cmake/presets/Schema;", "path", "Ljava/nio/file/Path;", "globalContent", "userContent", "parseCMakePresetsUsingTmpFile", "getCMakeReadVersionTimeout", "Lkotlin/time/Duration;", "getCMakeReadVersionTimeout-UwyO8pc", "()J", "GCCVersion", "ClangVersion", "EmulatedPresetContent", "TmpFileBackedPresetContent", "intellij.clion.testFramework.nolang"})
    @SourceDebugExtension(value={"SMAP\nCPPTestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPPTestUtil.kt\ncom/jetbrains/cidr/cpp/CPPTestUtil$Companion\n*L\n1#1,512:1\n427#1,25:513\n427#1,25:538\n*S KotlinDebug\n*F\n+ 1 CPPTestUtil.kt\ncom/jetbrains/cidr/cpp/CPPTestUtil$Companion\n*L\n275#1:513,25\n331#1:538,25\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CPPEnvironment getTestCPPEnvironment() {
            return new CPPEnvironment(this.getTestToolchain());
        }

        @JvmStatic
        @NotNull
        public final CPPToolchains.Toolchain getTestToolchain() {
            CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
            Intrinsics.checkNotNull((Object)toolchain);
            return toolchain;
        }

        @JvmStatic
        @NotNull
        public final CPPToolSet getTestToolSet() {
            CPPToolSet cPPToolSet = this.getTestToolchain().getToolSet();
            Intrinsics.checkNotNullExpressionValue((Object)cPPToolSet, (String)"getToolSet(...)");
            return cPPToolSet;
        }

        @JvmStatic
        @Nullable
        public final MinGW getTestMinGW() {
            return this.getTestToolchain().getMinGW();
        }

        @JvmStatic
        @Nullable
        public final Cygwin getTestCygwin() {
            return this.getTestToolchain().getCygwin();
        }

        @JvmStatic
        @Nullable
        public final WSL getTestWSL() {
            return this.getTestToolchain().getWSL();
        }

        @JvmStatic
        @Nullable
        public final MSVC getTestMSVC() {
            return this.getTestToolchain().getMSVC();
        }

        @JvmStatic
        public final void changeTestToolchain(@NotNull Consumer<CPPToolchains.Toolchain> changeFunction) {
            Intrinsics.checkNotNullParameter(changeFunction, (String)"changeFunction");
            CPPToolchains cPPToolchains = CPPToolchains.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)cPPToolchains, (String)"getInstance(...)");
            this.changeToolchains(cPPToolchains, (Consumer<CPPToolchains>)((Consumer)arg_0 -> Companion.changeTestToolchain$lambda$0(changeFunction, arg_0)));
        }

        @JvmStatic
        public final void changeToolchains(@NotNull Consumer<CPPToolchains> changeFunction) {
            Intrinsics.checkNotNullParameter(changeFunction, (String)"changeFunction");
            CPPToolchains cPPToolchains = CPPToolchains.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)cPPToolchains, (String)"getInstance(...)");
            this.changeToolchains(cPPToolchains, changeFunction);
        }

        @JvmStatic
        public final void changeToolchains(@NotNull CPPToolchains toolchains, @NotNull Consumer<CPPToolchains> changeFunction) {
            Intrinsics.checkNotNullParameter((Object)toolchains, (String)"toolchains");
            Intrinsics.checkNotNullParameter(changeFunction, (String)"changeFunction");
            WriteAction.runAndWait(() -> Companion.changeToolchains$lambda$0(toolchains, changeFunction));
        }

        @Nullable
        public final String getTestMSVCArchString() {
            if (this.getTestMSVC() == null) {
                return null;
            }
            List list = this.getTestToolchain().getToolSetOptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getToolSetOptions(...)");
            List options = list;
            Triple triple = MSVC.getOptions((List)options);
            Intrinsics.checkNotNullExpressionValue((Object)triple, (String)"getOptions(...)");
            Triple versionTriple = triple;
            MSVC.Arch arch = (MSVC.Arch)versionTriple.component1();
            if (arch == null) {
                return null;
            }
            return arch.getValue();
        }

        @JvmStatic
        @NotNull
        public final ArchitectureType getTestMSVCTargetArch() {
            String archValue = this.getTestMSVCArchString();
            if (archValue == null) {
                return ArchitectureType.UNKNOWN;
            }
            if (MSVC_ARCH_VALUE_X64.contains(archValue)) {
                return ArchitectureType.X86_64;
            }
            if (MSVC_ARCH_VALUES_X86.contains(archValue)) {
                return ArchitectureType.I386;
            }
            return ArchitectureType.UNKNOWN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final ArchitectureType getTestMinGWArchitecture() {
            MinGW minGW = this.getTestMinGW();
            if (minGW == null) {
                return null;
            }
            if (!minGW.isMinGW64()) {
                return ArchitectureType.I386;
            }
            Function1 parseTarget = Companion::getTestMinGWArchitecture$lambda$0;
            Object object = new String[]{minGW.getSubFilePath("bin\\gcc.exe")};
            GeneralCommandLine commandLine = new GeneralCommandLine(object);
            commandLine.addParameter("-v");
            minGW.prepareEnvironment(commandLine, CidrToolEnvironment.PrepareFor.BUILD, (List)new ArrayList());
            try {
                object = new Scanner(commandLine.createProcess().getErrorStream());
                Throwable throwable = null;
                try {
                    Scanner scanner = (Scanner)object;
                    boolean bl = false;
                    while (scanner.hasNext()) {
                        if (scanner.findInLine("Target:") != null) {
                            ArchitectureType architectureType = (ArchitectureType)parseTarget.invoke((Object)scanner.next());
                            return architectureType;
                        }
                        scanner.nextLine();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (NoSuchElementException e) {
                CPPLog.LOG.error("Cannot parse gcc -v output", (Throwable)e);
            }
            catch (ExecutionException e) {
                CPPLog.LOG.error(e.getMessage());
            }
            return ArchitectureType.UNKNOWN;
        }

        @JvmStatic
        @NotNull
        public final String getTestCMakeVersion() {
            try {
                CMakeExecutableTool cMakeExecutableTool = this.getTestCPPEnvironment().getCMake();
                Intrinsics.checkNotNull((Object)cMakeExecutableTool);
                String string = cMakeExecutableTool.readVersion();
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Cannot read current cmake version", e);
            }
        }

        @JvmStatic
        @NotNull
        public final Version getTestCMakeParsedVersion() {
            Version version = Version.parseVersion((String)this.getTestCMakeVersion());
            Intrinsics.checkNotNull((Object)version);
            Version parsedVersion = version;
            AssertionsKt.assertNotNull((Object)parsedVersion);
            return parsedVersion;
        }

        @JvmStatic
        @NotNull
        public final ToolVersion getTestCMakeParsedToolVersion() {
            Version version = Version.parseVersion((String)this.getTestCMakeVersion());
            Intrinsics.checkNotNull((Object)version);
            Version parsedVersion = version;
            AssertionsKt.assertNotNull((Object)parsedVersion);
            return new ToolVersion(parsedVersion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final List<String> getCMakeOutput(String ... cmakeOptions) {
            ProcessOutput processOutput;
            Intrinsics.checkNotNullParameter((Object)cmakeOptions, (String)"cmakeOptions");
            CPPEnvironment env = this.getTestCPPEnvironment();
            File file = FileUtil.createTempDirectory((String)"cmake_output_dir", null);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
            File dir = file;
            try {
                GeneralCommandLine generalCommandLine = CMakeRunner.buildCommandLine((CPPEnvironment)env, (File)dir, (List)CollectionsKt.listOf((Object[])Arrays.copyOf(cmakeOptions, cmakeOptions.length)), (boolean)false, (Map)MapsKt.emptyMap());
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"buildCommandLine(...)");
                GeneralCommandLine cl = generalCommandLine;
                processOutput = env.getHostMachine().runProcess(cl, 0);
            }
            finally {
                FileUtil.delete((File)dir);
            }
            ProcessOutput processOutput2 = processOutput;
            Intrinsics.checkNotNull((Object)processOutput2);
            ProcessOutput cMakeOutput = processOutput2;
            List list = cMakeOutput.getStdoutLines();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
            return list;
        }

        private final File getCustomCompiler(String compiler) {
            String key = "oc.test.compiler.path." + compiler;
            String path = System.getProperty(key);
            if (path != null) {
                HostMachine hostMachine = this.getTestCPPEnvironment().getHostMachine();
                Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
                HostMachine hostMachine2 = hostMachine;
                File res = new File(path);
                if (!hostMachine2.isRemote() && !res.exists()) {
                    AssertionsKt.fail$default((String)(key + "=" + path + " doesn't exist"), null, (int)2, null);
                    throw new KotlinNothingValueException();
                }
                return res;
            }
            return null;
        }

        private final File getGCC(GCCVersion version) {
            File file = null;
            String gccVersion = version.fileSuffix();
            if (SystemInfo.isWindows) {
                CPPToolSetWithHome cPPToolSetWithHome;
                Cygwin cygwin = this.getTestCygwin();
                if (cygwin != null) {
                    cPPToolSetWithHome = (CPPToolSetWithHome)cygwin;
                } else {
                    MinGW minGW = this.getTestMinGW();
                    if (minGW != null) {
                        cPPToolSetWithHome = (CPPToolSetWithHome)minGW;
                    } else {
                        return null;
                    }
                }
                CPPToolSetWithHome env = cPPToolSetWithHome;
                file = env.getSubFile("bin/gcc.exe");
            } else if (SystemInfo.isMac) {
                file = new File("/opt/local/bin/gcc-mp" + gccVersion);
                if (!file.exists()) {
                    file = new File("/usr/local/bin/gcc" + gccVersion);
                }
            } else {
                file = new File("/usr/bin/gcc" + gccVersion);
            }
            return file;
        }

        private final void reportNoGCC(File file, GCCVersion version) {
            LOG.warn("GCC executable could be specified with -Doc.test.compiler.path.gcc");
            AssertionsKt.fail$default((String)("GCC not found: " + file), null, (int)2, null);
            throw new KotlinNothingValueException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        @Nullable
        public final File getTestGCC() {
            Enum enum_;
            File file;
            block15: {
                file = this.getCustomCompiler("gcc");
                if (file != null) {
                    return file;
                }
                Companion companion = this;
                Enum defaultValue$iv = GCCVersion.DEFAULT;
                boolean $i$f$customizeForLocalRun = false;
                if (PluginManagerCore.isRunningFromSources()) {
                    Object object = new String[]{"CPPTestCase_available_compilers.properties"};
                    Path customConfigPath$iv = Paths.get(System.getProperty("user.home"), object);
                    try {
                        object = Files.newBufferedReader(customConfigPath$iv);
                        Throwable throwable = null;
                        try {
                            BufferedReader reader$iv = (BufferedReader)object;
                            boolean bl = false;
                            Properties props$iv = new Properties();
                            props$iv.load(reader$iv);
                            String version$iv = props$iv.getProperty(Reflection.getOrCreateKotlinClass(GCCVersion.class).getSimpleName() + ".version", "");
                            Intrinsics.checkNotNull((Object)version$iv);
                            if (version$iv.contentEquals("NONE")) {
                                Object var13_15 = null;
                                enum_ = var13_15;
                                break block15;
                            }
                            T[] TArray = GCCVersion.class.getEnumConstants();
                            Intrinsics.checkNotNullExpressionValue(TArray, (String)"getEnumConstants(...)");
                            for (Enum value$iv : (Enum[])TArray) {
                                if (!version$iv.contentEquals(value$iv.name())) continue;
                                Enum enum_2 = value$iv;
                                enum_ = enum_2;
                                break block15;
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                enum_ = defaultValue$iv;
            }
            GCCVersion testVersion = (GCCVersion)enum_;
            if (testVersion == null) {
                return null;
            }
            file = this.getGCC(testVersion);
            if (file != null && !file.exists()) {
                this.reportNoGCC(file, testVersion);
            }
            return file;
        }

        private final File getClang(ClangVersion version) {
            File file = null;
            String clangVersion = version.getFileSuffix();
            if (SystemInfo.isWindows) {
                if (this.getTestWSL() != null) {
                    return new File("/usr/bin/clang");
                }
                return null;
            }
            if (SystemInfo.isMac) {
                file = new File("/opt/local/bin/clang-mp" + clangVersion);
                if (!file.exists()) {
                    file = new File("/usr/local/bin/clang" + clangVersion);
                }
                if (!file.exists()) {
                    file = new File("/usr/local/opt/llvm" + version.getBrewSuffix() + "/bin/clang" + clangVersion);
                }
            } else {
                file = new File("/usr/bin/clang" + clangVersion);
            }
            return file;
        }

        private final void reportNoClang(File file, ClangVersion version) {
            LOG.warn("Clang executable could be specified with -Doc.test.compiler.path.clang");
            AssertionsKt.fail$default((String)("Clang not found: " + file + ", version " + version), null, (int)2, null);
            throw new KotlinNothingValueException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        @Nullable
        public final File getTestClang() {
            Enum enum_;
            File file;
            block15: {
                file = this.getCustomCompiler("clang");
                if (file != null) {
                    return file;
                }
                Companion companion = this;
                Enum defaultValue$iv = ClangVersion.DEFAULT;
                boolean $i$f$customizeForLocalRun = false;
                if (PluginManagerCore.isRunningFromSources()) {
                    Object object = new String[]{"CPPTestCase_available_compilers.properties"};
                    Path customConfigPath$iv = Paths.get(System.getProperty("user.home"), object);
                    try {
                        object = Files.newBufferedReader(customConfigPath$iv);
                        Throwable throwable = null;
                        try {
                            BufferedReader reader$iv = (BufferedReader)object;
                            boolean bl = false;
                            Properties props$iv = new Properties();
                            props$iv.load(reader$iv);
                            String version$iv = props$iv.getProperty(Reflection.getOrCreateKotlinClass(ClangVersion.class).getSimpleName() + ".version", "");
                            Intrinsics.checkNotNull((Object)version$iv);
                            if (version$iv.contentEquals("NONE")) {
                                Object var13_15 = null;
                                enum_ = var13_15;
                                break block15;
                            }
                            T[] TArray = ClangVersion.class.getEnumConstants();
                            Intrinsics.checkNotNullExpressionValue(TArray, (String)"getEnumConstants(...)");
                            for (Enum value$iv : (Enum[])TArray) {
                                if (!version$iv.contentEquals(value$iv.name())) continue;
                                Enum enum_2 = value$iv;
                                enum_ = enum_2;
                                break block15;
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                enum_ = defaultValue$iv;
            }
            ClangVersion testVersion = (ClangVersion)enum_;
            if (testVersion == null) {
                return null;
            }
            file = this.getClang(testVersion);
            if (file != null && !file.exists() && !SystemInfo.isWindows) {
                this.reportNoClang(file, testVersion);
            }
            return file;
        }

        @JvmStatic
        @Nullable
        public final File getTestClangCl() {
            if (!SystemInfo.isWindows) {
                return null;
            }
            File customClangCl = this.getCustomCompiler("clang-cl");
            if (customClangCl != null) {
                return customClangCl;
            }
            File msvcCompiler = this.getTestMSVCCompiler();
            if (msvcCompiler == null) {
                return null;
            }
            File file = CPPToolchains.clangClDirFromRegistry();
            if (file != null) {
                return file;
            }
            CPPToolSet toolset = this.getTestToolSet();
            String toolsetPath = null;
            if (toolset.isMSVC()) {
                Intrinsics.checkNotNull((Object)toolset, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.toolchains.MSVC");
                MSVC msvcToolset = (MSVC)toolset;
                toolsetPath = msvcToolset.getHomePath();
            }
            file = CPPToolchains.clangClDirFromMSVC(toolsetPath);
            return file;
        }

        @Nullable
        public final File getTestNVCC() {
            return this.getCustomCompiler("nvcc");
        }

        @JvmStatic
        @Nullable
        public final File getTestMSVCCompiler() {
            File result = this.getCustomCompiler("msvc");
            if (result != null) {
                return result;
            }
            CPPToolSet toolset = this.getTestToolSet();
            if (!toolset.isMSVC()) {
                return null;
            }
            Intrinsics.checkNotNull((Object)toolset, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.toolchains.MSVC");
            MSVC msvcToolset = (MSVC)toolset;
            result = new File(msvcToolset.getHomePath(), "VC\\bin\\cl.exe");
            if (result.exists()) {
                return result;
            }
            File msvc = new File(msvcToolset.getHomePath(), "VC\\Tools\\MSVC");
            File[] versions = msvc.listFiles(Companion::getTestMSVCCompiler$lambda$0);
            if (versions != null) {
                String archString;
                Arrays.sort(versions, Comparator.reverseOrder());
                String string = archString = System.getProperty("cpp.test.msvc.arch");
                MSVCArch mSVCArch = string == null ? MSVC.Arch.getDefault().getArch() : MSVCArch.Companion.fromString(string);
                Intrinsics.checkNotNull((Object)mSVCArch);
                MSVCArch arch = mSVCArch;
                result = new File(versions[0], "bin\\Host" + MSVCArch.Companion.toMSVCString(arch.getSource(), true) + "\\" + MSVCArch.Companion.toMSVCString(arch.getTarget(), true) + "\\cl.exe");
                if (result.exists()) {
                    return result;
                }
            }
            throw new RuntimeException("Compiler executable not found for " + toolset);
        }

        @JvmStatic
        @NotNull
        public final List<Pair<OCCompilerKind, File>> getAvailableCompilers() {
            List list;
            List $this$getAvailableCompilers_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            File path = Companion.getTestGCC();
            if (path != null) {
                Pair pair = Pair.create((Object)GCCCompilerKind.INSTANCE, (Object)path);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                $this$getAvailableCompilers_u24lambda_u240.add(pair);
            }
            if ((path = Companion.getTestClang()) != null) {
                Pair pair = Pair.create((Object)ClangCompilerKind.INSTANCE, (Object)path);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                $this$getAvailableCompilers_u24lambda_u240.add(pair);
            }
            if ((path = Companion.getTestMSVCCompiler()) != null) {
                Pair pair = Pair.create((Object)MSVCCompilerKind.INSTANCE, (Object)path);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                $this$getAvailableCompilers_u24lambda_u240.add(pair);
            }
            if ((path = Companion.getTestClangCl()) != null) {
                Pair pair = Pair.create((Object)ClangClCompilerKind.INSTANCE, (Object)path);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                $this$getAvailableCompilers_u24lambda_u240.add(pair);
            }
            return CollectionsKt.build((List)list);
        }

        /*
         * Exception decompiling
         */
        private final /* synthetic */ <E extends Enum<E>> E customizeForLocalRun(E defaultValue) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[FORLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @JvmStatic
        public final boolean isUnixLikeEnvironment() {
            CPPToolSet.Kind kind = this.getTestToolSet().getKind();
            Intrinsics.checkNotNullExpressionValue((Object)kind, (String)"getKind(...)");
            CPPToolSet.Kind toolSetKind = kind;
            Object[] objectArray = new CPPToolSet.Kind[]{CPPToolSet.Kind.SYSTEM_UNIX_TOOLSET, CPPToolSet.Kind.SSH, CPPToolSet.Kind.DOCKER};
            return SetsKt.setOf((Object[])objectArray).contains(toolSetKind) || this.getTestCygwin() != null || this.getTestMinGW() != null || this.getTestWSL() != null;
        }

        @NotNull
        public final Schema parseCMakePresets(@NotNull Path path, @NotNull String globalContent, @Nullable String userContent) {
            List list;
            block0: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)globalContent, (String)"globalContent");
                list = new ArrayList();
                ((Collection)list).add(new EmulatedPresetContent(globalContent, path));
                String string = userContent;
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                ((Collection)list).add(new EmulatedPresetContent(userContent, path));
            }
            return Schema.Companion.loadFrom(path, list);
        }

        public static /* synthetic */ Schema parseCMakePresets$default(Companion companion, Path path, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.parseCMakePresets(path, string, string2);
        }

        @NotNull
        public final Schema parseCMakePresetsUsingTmpFile(@NotNull Path path, @NotNull String globalContent, @Nullable String userContent) {
            List list;
            block0: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)globalContent, (String)"globalContent");
                list = new ArrayList();
                ((Collection)list).add(new TmpFileBackedPresetContent(globalContent));
                String string = userContent;
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                ((Collection)list).add(new TmpFileBackedPresetContent(userContent));
            }
            return Schema.Companion.loadFrom(path, list);
        }

        public static /* synthetic */ Schema parseCMakePresetsUsingTmpFile$default(Companion companion, Path path, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.parseCMakePresetsUsingTmpFile(path, string, string2);
        }

        public final long getCMakeReadVersionTimeout-UwyO8pc() {
            OS oS = this.getTestCPPEnvironment().getHostMachine().getOS();
            Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"getOS(...)");
            OS os = oS;
            java.time.Duration duration = CidrRunProcessUtil.getReadVersionTimeout((OS)os);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getReadVersionTimeout(...)");
            java.time.Duration duration2 = duration;
            return Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration2.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration2.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
        }

        private static final void changeTestToolchain$lambda$0(Consumer $changeFunction, CPPToolchains cppToolchains) {
            Intrinsics.checkNotNullParameter((Object)cppToolchains, (String)"cppToolchains");
            $changeFunction.consume((Object)cppToolchains.getDefaultToolchain());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void changeToolchains$lambda$0(CPPToolchains $toolchains, Consumer $changeFunction) {
            $toolchains.beginUpdate();
            try {
                $changeFunction.consume((Object)$toolchains);
            }
            finally {
                $toolchains.endUpdate();
            }
        }

        private static final ArchitectureType getTestMinGWArchitecture$lambda$0(String s) {
            String string = s;
            return Intrinsics.areEqual((Object)string, (Object)"x86_64-w64-mingw32") ? ArchitectureType.X86_64 : (Intrinsics.areEqual((Object)string, (Object)"i686-w64-mingw32") ? ArchitectureType.I386 : ArchitectureType.UNKNOWN);
        }

        private static final boolean getTestMSVCCompiler$lambda$0(File it) {
            File file = it;
            Intrinsics.checkNotNull((Object)file);
            return file.isDirectory();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/CPPTestUtil$Companion$ClangVersion;", "", "fileSuffix", "", "brewSuffix", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getFileSuffix", "()Ljava/lang/String;", "getBrewSuffix", "DEFAULT", "FIVE", "SIX", "SEVEN", "intellij.clion.testFramework.nolang"})
        private static final class ClangVersion
        extends Enum<ClangVersion> {
            @NotNull
            private final String fileSuffix;
            @NotNull
            private final String brewSuffix;
            public static final /* enum */ ClangVersion DEFAULT = new ClangVersion("", "");
            public static final /* enum */ ClangVersion FIVE = new ClangVersion("-5.0", "@5");
            public static final /* enum */ ClangVersion SIX = new ClangVersion("-6.0", "@6");
            public static final /* enum */ ClangVersion SEVEN = new ClangVersion("-7.0", "@7");
            private static final /* synthetic */ ClangVersion[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private ClangVersion(String fileSuffix, String brewSuffix) {
                this.fileSuffix = fileSuffix;
                this.brewSuffix = brewSuffix;
            }

            @NotNull
            public final String getFileSuffix() {
                return this.fileSuffix;
            }

            @NotNull
            public final String getBrewSuffix() {
                return this.brewSuffix;
            }

            public static ClangVersion[] values() {
                return (ClangVersion[])$VALUES.clone();
            }

            public static ClangVersion valueOf(String value2) {
                return Enum.valueOf(ClangVersion.class, value2);
            }

            @NotNull
            public static EnumEntries<ClangVersion> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = clangVersionArray = new ClangVersion[]{ClangVersion.DEFAULT, ClangVersion.FIVE, ClangVersion.SIX, ClangVersion.SEVEN};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/cpp/CPPTestUtil$Companion$EmulatedPresetContent;", "Lcom/jetbrains/cidr/cpp/cmake/presets/PresetContent;", "data", "", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getData", "()Ljava/lang/String;", "getFile", "()Ljava/nio/file/Path;", "intellij.clion.testFramework.nolang"})
        private static final class EmulatedPresetContent
        implements PresetContent {
            @NotNull
            private final String data;
            @NotNull
            private final Path file;

            public EmulatedPresetContent(@NotNull String data, @NotNull Path file) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.data = data;
                this.file = file;
            }

            @NotNull
            public String getData() {
                return this.data;
            }

            @NotNull
            public Path getFile() {
                return this.file;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/CPPTestUtil$Companion$GCCVersion;", "", "suffix", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getSuffix", "()Ljava/lang/String;", "DEFAULT", "FIVE", "SIX", "SEVEN", "EIGHT", "fileSuffix", "intellij.clion.testFramework.nolang"})
        private static final class GCCVersion
        extends Enum<GCCVersion> {
            @NotNull
            private final String suffix;
            public static final /* enum */ GCCVersion DEFAULT = new GCCVersion("");
            public static final /* enum */ GCCVersion FIVE = new GCCVersion("5");
            public static final /* enum */ GCCVersion SIX = new GCCVersion("6");
            public static final /* enum */ GCCVersion SEVEN = new GCCVersion("7");
            public static final /* enum */ GCCVersion EIGHT = new GCCVersion("8");
            private static final /* synthetic */ GCCVersion[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private GCCVersion(String suffix) {
                this.suffix = suffix;
            }

            @NotNull
            public final String getSuffix() {
                return this.suffix;
            }

            @NotNull
            public final String fileSuffix() {
                return this == DEFAULT ? this.suffix : "-" + this.suffix;
            }

            public static GCCVersion[] values() {
                return (GCCVersion[])$VALUES.clone();
            }

            public static GCCVersion valueOf(String value2) {
                return Enum.valueOf(GCCVersion.class, value2);
            }

            @NotNull
            public static EnumEntries<GCCVersion> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = gCCVersionArray = new GCCVersion[]{GCCVersion.DEFAULT, GCCVersion.FIVE, GCCVersion.SIX, GCCVersion.SEVEN, GCCVersion.EIGHT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001b\u0010\u0006\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/cpp/CPPTestUtil$Companion$TmpFileBackedPresetContent;", "Lcom/jetbrains/cidr/cpp/cmake/presets/PresetContent;", "content", "", "<init>", "(Ljava/lang/String;)V", "data", "getData", "()Ljava/lang/String;", "data$delegate", "Lkotlin/Lazy;", "file", "Ljava/nio/file/Path;", "getFile", "()Ljava/nio/file/Path;", "intellij.clion.testFramework.nolang"})
        private static final class TmpFileBackedPresetContent
        implements PresetContent {
            @NotNull
            private final Lazy data$delegate;

            public TmpFileBackedPresetContent(@NotNull String content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                this.data$delegate = LazyKt.lazy(() -> TmpFileBackedPresetContent.data_delegate$lambda$0(content));
            }

            @NotNull
            public String getData() {
                Lazy lazy = this.data$delegate;
                return (String)lazy.getValue();
            }

            @NotNull
            public Path getFile() {
                Path path = Path.of("tmpfile", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                return path;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final String data_delegate$lambda$0(String $content) {
                String string;
                File file = null;
                try {
                    file = FileUtil.createTempFile((String)"clion-preset-test", null);
                    FileUtil.writeToFile((File)file, (String)$content);
                    Path path = file.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                    string = new FilePresetContent(path).getData();
                }
                finally {
                    if (file != null) {
                        FileUtil.delete((File)file);
                    }
                }
                return string;
            }
        }
    }
}

