/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.assumptions;

import com.jetbrains.cidr.cpp.CPPTestUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u000f\u001a\u00020\bJ\u0006\u0010\u0010\u001a\u00020\bJ\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/assumptions/ToolSetKindAssumption;", "", "myToolSetKindSupplier", "Lkotlin/Function0;", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "isWSL", "", "isCygwin", "isDocker", "isMSVC", "isMinGW", "isSsh", "isSystemWindows", "isSystemUnix", "isRemoteLike", "isNotWSL", "isNotCygwin", "isNotDocker", "isNotMSVC", "isNotMinGW", "isNotRemoteLike", "Companion", "intellij.clion.testFramework.nolang"})
public final class ToolSetKindAssumption {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<CPPToolSet.Kind> myToolSetKindSupplier;

    private ToolSetKindAssumption(Function0<? extends CPPToolSet.Kind> myToolSetKindSupplier) {
        this.myToolSetKindSupplier = myToolSetKindSupplier;
    }

    public final void isWSL() {
        Assume.assumeTrue((String)"WSL only", (this.myToolSetKindSupplier.invoke() == CPPToolSet.Kind.WSL ? 1 : 0) != 0);
    }

    public final void isCygwin() {
        Assume.assumeTrue((String)"Cygwin only", (this.myToolSetKindSupplier.invoke() == CPPToolSet.Kind.CYGWIN ? 1 : 0) != 0);
    }

    public final void isDocker() {
        Assume.assumeTrue((String)"Docker only", (this.myToolSetKindSupplier.invoke() == CPPToolSet.Kind.DOCKER ? 1 : 0) != 0);
    }

    public final void isMSVC() {
        Assume.assumeTrue((String)"MSVC only", (this.myToolSetKindSupplier.invoke() == CPPToolSet.Kind.MSVC ? 1 : 0) != 0);
    }

    public final void isMinGW() {
        Assume.assumeTrue((String)"MinGW only", (this.myToolSetKindSupplier.invoke() == CPPToolSet.Kind.MINGW ? 1 : 0) != 0);
    }

    public final void isSsh() {
        Assume.assumeTrue((String)"Ssh only", (this.myToolSetKindSupplier.invoke() == CPPToolSet.Kind.SSH ? 1 : 0) != 0);
    }

    public final void isSystemWindows() {
        Assume.assumeTrue((String)"SystemWindows only", (this.myToolSetKindSupplier.invoke() == CPPToolSet.Kind.SYSTEM_WINDOWS_TOOLSET ? 1 : 0) != 0);
    }

    public final void isSystemUnix() {
        Assume.assumeTrue((String)"SystemUnix only", (this.myToolSetKindSupplier.invoke() == CPPToolSet.Kind.SYSTEM_UNIX_TOOLSET ? 1 : 0) != 0);
    }

    public final void isRemoteLike() {
        Assume.assumeTrue((String)"remote-like only", (boolean)((CPPToolSet.Kind)this.myToolSetKindSupplier.invoke()).isRemoteLike());
    }

    public final void isNotWSL() {
        Assume.assumeTrue((String)"not for WSL", (this.myToolSetKindSupplier.invoke() != CPPToolSet.Kind.WSL ? 1 : 0) != 0);
    }

    public final void isNotCygwin() {
        Assume.assumeTrue((String)"not for Cygwin", (this.myToolSetKindSupplier.invoke() != CPPToolSet.Kind.CYGWIN ? 1 : 0) != 0);
    }

    public final void isNotDocker() {
        Assume.assumeTrue((String)"not for Docker", (this.myToolSetKindSupplier.invoke() != CPPToolSet.Kind.DOCKER ? 1 : 0) != 0);
    }

    public final void isNotMSVC() {
        Assume.assumeTrue((String)"not for MSVC", (this.myToolSetKindSupplier.invoke() != CPPToolSet.Kind.MSVC ? 1 : 0) != 0);
    }

    public final void isNotMinGW() {
        Assume.assumeTrue((String)"not for MinGW", (this.myToolSetKindSupplier.invoke() != CPPToolSet.Kind.MINGW ? 1 : 0) != 0);
    }

    public final void isNotRemoteLike() {
        Assume.assumeFalse((String)"not for remote-like", (boolean)((CPPToolSet.Kind)this.myToolSetKindSupplier.invoke()).isRemoteLike());
    }

    @JvmStatic
    @NotNull
    public static final ToolSetKindAssumption assumeToolSetKind() {
        return Companion.assumeToolSetKind();
    }

    public /* synthetic */ ToolSetKindAssumption(Function0 myToolSetKindSupplier, DefaultConstructorMarker $constructor_marker) {
        this((Function0<? extends CPPToolSet.Kind>)myToolSetKindSupplier);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/assumptions/ToolSetKindAssumption$Companion;", "", "<init>", "()V", "assumeToolSetKind", "Lcom/jetbrains/cidr/assumptions/ToolSetKindAssumption;", "intellij.clion.testFramework.nolang"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ToolSetKindAssumption assumeToolSetKind() {
            return new ToolSetKindAssumption(Companion::assumeToolSetKind$lambda$0, null);
        }

        private static final CPPToolSet.Kind assumeToolSetKind$lambda$0() {
            CPPToolSet.Kind kind = CPPTestUtil.Companion.getTestCPPEnvironment().getToolSet().getKind();
            Intrinsics.checkNotNullExpressionValue((Object)kind, (String)"getKind(...)");
            return kind;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

